/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.ResourceCollection;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.delegate.BidPurchaseExtendedDelegateState;
import games.strategy.triplea.delegate.PurchaseDelegate;
import games.strategy.util.IntegerMap;
import java.io.Serializable;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BidPurchaseDelegate
extends PurchaseDelegate {
    private int m_bid;
    private int m_spent;
    private boolean m_hasBid = false;

    private static int getBidAmount(GameData data, PlayerID currentPlayer) {
        String propertyName = currentPlayer.getName() + " bid";
        int bid = data.getProperties().get(propertyName, 0);
        return bid;
    }

    public static boolean doesPlayerHaveBid(GameData data, PlayerID player) {
        return BidPurchaseDelegate.getBidAmount(data, player) != 0;
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        if (!BidPurchaseDelegate.doesPlayerHaveBid(this.getData(), this.m_player)) {
            return false;
        }
        if (this.m_player.getProductionFrontier() == null || this.m_player.getProductionFrontier().getRules().isEmpty()) {
            return false;
        }
        return this.canWePurchaseOrRepair();
    }

    @Override
    protected boolean canAfford(IntegerMap<Resource> costs, PlayerID player) {
        ResourceCollection bidCollection = new ResourceCollection(this.getData());
        bidCollection.addResource(this.getData().getResourceList().getResource("PUs"), this.m_bid);
        return bidCollection.has(costs);
    }

    @Override
    public void start() {
        super.start();
        if (this.m_hasBid) {
            return;
        }
        this.m_bid = BidPurchaseDelegate.getBidAmount(this.m_bridge.getData(), this.m_bridge.getPlayerID());
        this.m_spent = 0;
    }

    @Override
    protected String removeFromPlayer(PlayerID player, IntegerMap<Resource> resources, CompositeChange change, Collection<Unit> units) {
        this.m_spent = resources.getInt(super.getData().getResourceList().getResource("PUs"));
        return this.m_bid - this.m_spent + " PU unused";
    }

    @Override
    public void end() {
        super.end();
        int unspent = this.m_bid - this.m_spent;
        if (unspent == 0) {
            return;
        }
        this.m_bridge.getHistoryWriter().startEvent(this.m_bridge.getPlayerID().getName() + " retains " + unspent + " PUS not spent in bid phase");
        Change unspentChange = ChangeFactory.changeResourcesChange(this.m_bridge.getPlayerID(), super.getData().getResourceList().getResource("PUs"), unspent);
        this.m_bridge.addChange(unspentChange);
        this.m_hasBid = false;
    }

    @Override
    public Serializable saveState() {
        BidPurchaseExtendedDelegateState state = new BidPurchaseExtendedDelegateState();
        state.superState = super.saveState();
        state.m_bid = this.m_bid;
        state.m_hasBid = this.m_hasBid;
        state.m_spent = this.m_spent;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        BidPurchaseExtendedDelegateState s = (BidPurchaseExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_bid = s.m_bid;
        this.m_spent = s.m_spent;
        this.m_hasBid = s.m_hasBid;
    }
}

