/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import java.io.Serializable;

public class Die
implements Serializable {
    private static final long serialVersionUID = 8766753280669636980L;
    private final DieType m_type;
    private final int m_value;
    private final int m_rolledAt;

    public Die(int value) {
        this(value, -1, DieType.MISS);
    }

    public Die(int value, int rolledAt, DieType type) {
        this.m_type = type;
        this.m_value = value;
        this.m_rolledAt = rolledAt;
    }

    public DieType getType() {
        return this.m_type;
    }

    public int getValue() {
        return this.m_value;
    }

    public int getRolledAt() {
        return this.m_rolledAt;
    }

    int getCompressedValue() {
        if (this.m_value > 255 || this.m_rolledAt > 255) {
            throw new IllegalStateException("too big to serialize");
        }
        return (this.m_rolledAt << 8) + (this.m_value << 16) + this.m_type.ordinal();
    }

    static Die getFromWriteValue(int value) {
        int rolledAt = (value & 0xFF00) >> 8;
        int roll = (value & 0xFF0000) >> 16;
        DieType type = DieType.values()[value & 0xF];
        return new Die(roll, rolledAt, type);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Die)) {
            return false;
        }
        Die other = (Die)o;
        return other.m_type == this.m_type && other.m_value == this.m_value && other.m_rolledAt == this.m_rolledAt;
    }

    public int hashCode() {
        return this.m_value + 37 * this.m_rolledAt;
    }

    public String toString() {
        if (this.m_rolledAt < 0) {
            return "Die roll:" + this.m_value + (this.m_type == DieType.IGNORED ? " type:" + (Object)((Object)this.m_type) : "");
        }
        return "Die roll:" + this.m_value + " rolled at:" + this.m_rolledAt + " type:" + (Object)((Object)this.m_type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DieType {
        MISS,
        HIT,
        IGNORED;

    }
}

