/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseEditDelegate;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipType;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.message.IRemote;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.EditValidator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveDelegate;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.remote.IEditDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditDelegate
extends BaseEditDelegate
implements IEditDelegate {
    @Override
    public void start() {
        super.start();
    }

    @Override
    public void end() {
    }

    @Override
    public String removeUnits(Territory territory, Collection<Unit> units) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        result = EditValidator.validateRemoveUnits(this.getData(), territory, units);
        if (null != result) {
            return result;
        }
        if (units == null || units.isEmpty()) {
            return null;
        }
        HashSet<PlayerID> owners = new HashSet<PlayerID>();
        for (Unit u : units) {
            owners.add(u.getOwner());
        }
        for (PlayerID p : owners) {
            List<Unit> unitsOwned = Match.getMatches(units, Matches.unitIsOwnedBy(p));
            this.logEvent("Removing units owned by " + p.getName() + " from " + territory.getName() + ": " + MyFormatter.unitsToTextNoOwner(unitsOwned), unitsOwned);
            this.m_bridge.addChange(ChangeFactory.removeUnits(territory, unitsOwned));
        }
        return null;
    }

    @Override
    public String addUnits(Territory territory, Collection<Unit> units) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        result = EditValidator.validateAddUnits(this.getData(), territory, units);
        if (null != result) {
            return result;
        }
        if (units == null || units.isEmpty()) {
            return null;
        }
        PlayerID player = units.iterator().next().getOwner();
        GameData data = this.getData();
        Map<Unit, Unit> mapLoading = null;
        if (territory.isWater() && !Match.allMatch(units, Matches.UnitIsSea) && Match.someMatch(units, Matches.UnitIsLand)) {
            if (!Match.allMatch(units, Matches.alliedUnit(player, data))) {
                return "Can't add mixed nationality units to water";
            }
            CompositeMatchAnd<Unit> friendlySeaTransports = new CompositeMatchAnd<Unit>(Matches.UnitIsTransport, Matches.UnitIsSea, Matches.alliedUnit(player, data));
            List<Unit> seaTransports = Match.getMatches(units, friendlySeaTransports);
            List<Unit> landUnitsToAdd = Match.getMatches(units, Matches.UnitIsLand);
            if (!Match.allMatch(landUnitsToAdd, Matches.UnitCanBeTransported)) {
                return "Can't add land units that can't be transported, to water";
            }
            seaTransports.addAll(territory.getUnits().getMatches(friendlySeaTransports));
            if (seaTransports.isEmpty()) {
                return "Can't add land units to water without enough transports";
            }
            mapLoading = MoveDelegate.mapTransports(null, landUnitsToAdd, seaTransports, true, player);
            if (!mapLoading.keySet().containsAll(landUnitsToAdd)) {
                return "Can't add land units to water without enough transports";
            }
        }
        this.logEvent("Adding units owned by " + units.iterator().next().getOwner().getName() + " to " + territory.getName() + ": " + MyFormatter.unitsToTextNoOwner(units), units);
        this.m_bridge.addChange(ChangeFactory.addUnits(territory, units));
        if (mapLoading != null && !mapLoading.isEmpty()) {
            TransportTracker transportTracker = new TransportTracker();
            for (Map.Entry entry : mapLoading.entrySet()) {
                this.m_bridge.addChange(transportTracker.loadTransportChange((TripleAUnit)entry.getValue(), (Unit)entry.getKey(), this.m_player));
            }
        }
        return null;
    }

    protected int getProduction(Territory territory) {
        TerritoryAttachment ta = TerritoryAttachment.get(territory);
        if (ta != null) {
            return ta.getProduction();
        }
        return 0;
    }

    @Override
    public String changeTerritoryOwner(Territory territory, PlayerID player) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        GameData data = this.getData();
        result = EditValidator.validateChangeTerritoryOwner(data, territory, player);
        if (null != result) {
            return result;
        }
        this.logEvent("Changing ownership of " + territory.getName() + " from " + territory.getOwner().getName() + " to " + player.getName(), territory);
        if (!data.getRelationshipTracker().isAtWar(territory.getOwner(), player)) {
            List<Unit> units = territory.getUnits().getMatches(Matches.UnitIsInfrastructure);
            for (Unit unit : units) {
                this.m_bridge.addChange(ChangeFactory.changeOwner(unit, player, territory));
            }
        } else {
            CompositeMatchAnd<Unit> enemyNonCom = new CompositeMatchAnd<Unit>(new Match[0]);
            enemyNonCom.add(Matches.UnitIsInfrastructure);
            enemyNonCom.add(Matches.enemyUnit(player, data));
            List<Unit> units = territory.getUnits().getMatches(enemyNonCom);
            this.m_bridge.addChange(ChangeFactory.markNoMovementChange(units));
            for (Unit unit : units) {
                this.m_bridge.addChange(ChangeFactory.changeOwner(unit, player, territory));
            }
        }
        this.m_bridge.addChange(ChangeFactory.changeOwner(territory, player));
        return null;
    }

    @Override
    public String changePUs(PlayerID player, int newTotal) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        Resource PUs = this.getData().getResourceList().getResource("PUs");
        int oldTotal = player.getResources().getQuantity(PUs);
        if (oldTotal == newTotal) {
            return "New PUs total is unchanged";
        }
        if (newTotal < 0) {
            return "New PUs total is invalid";
        }
        this.logEvent("Changing PUs for " + player.getName() + " from " + oldTotal + " to " + newTotal, null);
        this.m_bridge.addChange(ChangeFactory.changeResourcesChange(player, PUs, newTotal - oldTotal));
        return null;
    }

    @Override
    public String changeTechTokens(PlayerID player, int newTotal) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        Resource techTokens = this.getData().getResourceList().getResource("techTokens");
        int oldTotal = player.getResources().getQuantity(techTokens);
        if (oldTotal == newTotal) {
            return "New token total is unchanged";
        }
        if (newTotal < 0) {
            return "New token total is invalid";
        }
        this.logEvent("Changing tech tokens for " + player.getName() + " from " + oldTotal + " to " + newTotal, null);
        this.m_bridge.addChange(ChangeFactory.changeResourcesChange(player, techTokens, newTotal - oldTotal));
        return null;
    }

    @Override
    public String addTechAdvance(PlayerID player, Collection<TechAdvance> advances) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        result = EditValidator.validateAddTech(this.getData(), advances, player);
        if (null != result) {
            return result;
        }
        for (TechAdvance advance : advances) {
            this.logEvent("Adding Technology " + advance.getName() + " for " + player.getName(), null);
            TechTracker.addAdvance(player, this.m_bridge, advance);
        }
        return null;
    }

    @Override
    public String removeTechAdvance(PlayerID player, Collection<TechAdvance> advances) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        result = EditValidator.validateRemoveTech(this.getData(), advances, player);
        if (null != result) {
            return result;
        }
        for (TechAdvance advance : advances) {
            this.logEvent("Removing Technology " + advance.getName() + " for " + player.getName(), null);
            TechTracker.removeAdvance(player, this.m_bridge, advance);
        }
        return null;
    }

    @Override
    public String changeUnitHitDamage(IntegerMap<Unit> unitDamageMap, Territory territory) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        result = EditValidator.validateChangeHitDamage(this.getData(), unitDamageMap, territory);
        if (null != result) {
            return result;
        }
        ArrayList<Unit> units = new ArrayList<Unit>(unitDamageMap.keySet());
        for (Unit u : units) {
            int dmg = unitDamageMap.getInt(u);
            if (u.getHits() != dmg) continue;
            unitDamageMap.removeKey(u);
        }
        if (unitDamageMap.isEmpty()) {
            return null;
        }
        ArrayList<Unit> unitsFinal = new ArrayList<Unit>(unitDamageMap.keySet());
        this.logEvent("Changing unit hit damage for these " + ((Unit)unitsFinal.iterator().next()).getOwner().getName() + " owned units to: " + MyFormatter.integerUnitMapToString(unitDamageMap, ", ", " = ", false), unitsFinal);
        this.m_bridge.addChange(ChangeFactory.unitsHit(unitDamageMap));
        territory.notifyChanged();
        return null;
    }

    @Override
    public String changeUnitBombingDamage(IntegerMap<Unit> unitDamageMap, Territory territory) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        result = EditValidator.validateChangeBombingDamage(this.getData(), unitDamageMap, territory);
        if (null != result) {
            return result;
        }
        CompositeChange changes = new CompositeChange();
        IntegerMap<Unit> unitHitDamageMap = new IntegerMap<Unit>();
        TerritoryAttachment ta = TerritoryAttachment.get(territory);
        ArrayList<Unit> units = new ArrayList<Unit>(unitDamageMap.keySet());
        if (Properties.getSBRAffectsUnitProduction(this.getData())) {
            int damageToPut;
            int unitProduction;
            if (ta == null) {
                return null;
            }
            int production = ta.getProduction();
            int currentDamage = production - (unitProduction = ta.getUnitProduction());
            if (currentDamage == (damageToPut = unitDamageMap.highestValue())) {
                return null;
            }
            for (Unit u : units) {
                if (damageToPut == 0 && currentDamage > 0) {
                    unitHitDamageMap.put(u, 0);
                    continue;
                }
                if (currentDamage != 0 || damageToPut <= 0) continue;
                unitHitDamageMap.put(u, 1);
            }
        } else {
            for (Unit u : units) {
                int dmg = unitDamageMap.getInt(u);
                int currentDamage = ((TripleAUnit)u).getUnitDamage();
                if (currentDamage == dmg) {
                    unitDamageMap.removeKey(u);
                    continue;
                }
                if (dmg == 0 && currentDamage > 0) {
                    unitHitDamageMap.put(u, 0);
                    continue;
                }
                if (currentDamage != 0 || dmg <= 0) continue;
                unitHitDamageMap.put(u, 1);
            }
        }
        if (unitDamageMap.isEmpty()) {
            return null;
        }
        changes.add(ChangeFactory.unitsHit(unitHitDamageMap));
        if (Properties.getSBRAffectsUnitProduction(this.getData())) {
            changes.add(ChangeFactory.attachmentPropertyChange(ta, Integer.toString(ta.getProduction() - unitDamageMap.highestValue()), "unitProduction"));
        } else {
            for (Map.Entry<Unit, Integer> entry : unitDamageMap.entrySet()) {
                changes.add(ChangeFactory.unitPropertyChange(entry.getKey(), entry.getValue(), "unitDamage"));
            }
        }
        ArrayList<Unit> unitsFinal = new ArrayList<Unit>(unitDamageMap.keySet());
        this.logEvent("Changing unit bombing damage for these " + ((Unit)unitsFinal.iterator().next()).getOwner().getName() + " owned units to: " + MyFormatter.integerUnitMapToString(unitDamageMap, ", ", " = ", false), unitsFinal);
        this.m_bridge.addChange(changes);
        territory.notifyChanged();
        return null;
    }

    @Override
    public String changePoliticalRelationships(Collection<Triple<PlayerID, PlayerID, RelationshipType>> relationshipChanges) {
        String result = null;
        if (relationshipChanges == null || relationshipChanges.isEmpty()) {
            return result;
        }
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        result = EditValidator.validateChangePoliticalRelationships(this.getData(), relationshipChanges);
        if (null != result) {
            return result;
        }
        BattleTracker battleTracker = MoveDelegate.getBattleTracker(this.getData());
        for (Triple<PlayerID, PlayerID, RelationshipType> relationshipChange : relationshipChanges) {
            RelationshipType currentRelation = this.getData().getRelationshipTracker().getRelationshipType((PlayerID)relationshipChange.getFirst(), (PlayerID)relationshipChange.getSecond());
            if (currentRelation.equals(relationshipChange.getThird())) continue;
            this.logEvent("Editing Political Relationship for " + ((PlayerID)relationshipChange.getFirst()).getName() + " and " + ((PlayerID)relationshipChange.getSecond()).getName() + " from " + currentRelation.getName() + " to " + relationshipChange.getThird().getName(), null);
            this.m_bridge.addChange(ChangeFactory.relationshipChange((PlayerID)relationshipChange.getFirst(), (PlayerID)relationshipChange.getSecond(), currentRelation, relationshipChange.getThird()));
            battleTracker.addRelationshipChangesThisTurn((PlayerID)relationshipChange.getFirst(), (PlayerID)relationshipChange.getSecond(), currentRelation, relationshipChange.getThird());
        }
        return null;
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IEditDelegate.class;
    }
}

