/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipType;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.AirMovementValidator;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveDelegate;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.triplea.delegate.TechnologyDelegate;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.UndoableMove;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditValidator {
    private static String validateTerritoryBasic(GameData data, Territory territory) {
        return EditValidator.validateTerritoryBasic(data, territory, null);
    }

    private static String validateTerritoryBasic(GameData data, Territory territory, PlayerID player) {
        String result = null;
        List<UndoableMove> moves = DelegateFinder.moveDelegate(data).getMovesMade();
        for (UndoableMove move : moves) {
            if (move.getRoute().getStart() != territory && move.getRoute().getEnd() != territory) continue;
            return "Territory is start or end of a pending move";
        }
        return result;
    }

    public static String validateChangeTerritoryOwner(GameData data, Territory territory, PlayerID player) {
        String result = null;
        if (Matches.TerritoryIsWater.match(territory) && territory.getOwner().equals(PlayerID.NULL_PLAYERID) && TerritoryAttachment.get(territory) == null) {
            return "Territory is water and has no attachment";
        }
        result = EditValidator.validateTerritoryBasic(data, territory, player);
        if (result != null) {
            return result;
        }
        return result;
    }

    public static String validateAddUnits(GameData data, Territory territory, Collection<Unit> units) {
        String result = null;
        if (units.isEmpty()) {
            return "No units selected";
        }
        PlayerID player = units.iterator().next().getOwner();
        if (territory.isWater()) {
            if (!Match.allMatch(units, Matches.UnitIsSea)) {
                if (Match.someMatch(units, Matches.UnitIsLand)) {
                    if (!Match.allMatch(units, Matches.alliedUnit(player, data))) {
                        return "Can't add mixed nationality units to water";
                    }
                    CompositeMatchAnd<Unit> friendlySeaTransports = new CompositeMatchAnd<Unit>(Matches.UnitIsTransport, Matches.UnitIsSea, Matches.alliedUnit(player, data));
                    List<Unit> seaTransports = Match.getMatches(units, friendlySeaTransports);
                    List<Unit> landUnitsToAdd = Match.getMatches(units, Matches.UnitIsLand);
                    if (!Match.allMatch(landUnitsToAdd, Matches.UnitCanBeTransported)) {
                        return "Can't add land units that can't be transported, to water";
                    }
                    seaTransports.addAll(territory.getUnits().getMatches(friendlySeaTransports));
                    if (seaTransports.isEmpty()) {
                        return "Can't add land units to water without enough transports";
                    }
                    Map<Unit, Unit> mapLoading = MoveDelegate.mapTransports(null, landUnitsToAdd, seaTransports, true, player);
                    if (!mapLoading.keySet().containsAll(landUnitsToAdd)) {
                        return "Can't add land units to water without enough transports";
                    }
                }
                if (Match.someMatch(units, Matches.UnitIsAir)) {
                    int carrierCost;
                    if (Match.someMatch(units, new CompositeMatchAnd(Matches.UnitIsAir, Matches.UnitCanLandOnCarrier.invert()))) {
                        return "Can not add air to water unless it can land on carriers";
                    }
                    CompositeMatchAnd<Unit> friendlyCarriers = new CompositeMatchAnd<Unit>(Matches.UnitIsCarrier, Matches.alliedUnit(player, data));
                    CompositeMatchAnd<Unit> friendlyAirUnits = new CompositeMatchAnd<Unit>(Matches.UnitIsAir, Matches.alliedUnit(player, data));
                    int carrierCapacityTotal = AirMovementValidator.carrierCapacity(territory.getUnits().getMatches(friendlyCarriers), territory) + AirMovementValidator.carrierCapacity(units, territory);
                    if (carrierCapacityTotal < (carrierCost = AirMovementValidator.carrierCost(territory.getUnits().getMatches(friendlyAirUnits)) + AirMovementValidator.carrierCost(units))) {
                        return "Can't add more air units to water without sufficient space";
                    }
                }
            }
        } else if (Match.someMatch(units, Matches.UnitIsSea)) {
            return "Can't add sea units to land";
        }
        if ((result = EditValidator.validateTerritoryBasic(data, territory, player)) != null) {
            return result;
        }
        return result;
    }

    public static String validateRemoveUnits(GameData data, Territory territory, Collection<Unit> units) {
        String result = null;
        if (units.isEmpty()) {
            return "No units selected";
        }
        PlayerID player = units.iterator().next().getOwner();
        result = EditValidator.validateTerritoryBasic(data, territory, player);
        if (result != null) {
            return result;
        }
        TransportTracker transportTracker = new TransportTracker();
        for (Unit unit : Match.getMatches(units, Matches.UnitCanTransport)) {
            if (units.containsAll(transportTracker.transporting(unit))) continue;
            return "Can't remove transport without removing transported units";
        }
        for (Unit unit : Match.getMatches(units, Matches.UnitCanBeTransported)) {
            Unit transport = transportTracker.transportedBy(unit);
            if (transport == null || units.contains(transport)) continue;
            return "Can't remove transported units without removing transport";
        }
        return result;
    }

    public static String validateAddTech(GameData data, Collection<TechAdvance> techs, PlayerID player) {
        String result = null;
        if (techs == null) {
            return "No tech selected";
        }
        if (player == null) {
            return "No player selected";
        }
        if (!Properties.getTechDevelopment(data)) {
            return "Technology not enabled";
        }
        if (player.getAttachment("techAttatchment") == null) {
            return "Player has no Tech Attachment";
        }
        for (TechAdvance tech : techs) {
            if (tech == null) {
                return "No tech selected";
            }
            if (TechnologyDelegate.getAvailableTechs(player, data).contains(tech)) continue;
            return "Technology not available for this player";
        }
        return result;
    }

    public static String validateRemoveTech(GameData data, Collection<TechAdvance> techs, PlayerID player) {
        String result = null;
        if (techs == null) {
            return "No tech selected";
        }
        if (player == null) {
            return "No player selected";
        }
        if (!Properties.getTechDevelopment(data)) {
            return "Technology not enabled";
        }
        for (TechAdvance tech : techs) {
            if (tech == null) {
                return "No tech selected";
            }
            if (!TechTracker.getCurrentTechAdvances(player, data).contains(tech)) {
                return "Player does not have this tech";
            }
            if (tech.getProperty().equals("industrialTechnology")) {
                return "Can not remove Industrial Technology";
            }
            if (!tech.getProperty().equals("shipyards")) continue;
            return "Can not remove Shipyards";
        }
        return result;
    }

    public static String validateChangeHitDamage(GameData data, IntegerMap<Unit> unitDamageMap, Territory territory) {
        String result = null;
        if (unitDamageMap == null || unitDamageMap.isEmpty()) {
            return "Damage map is empty";
        }
        result = EditValidator.validateTerritoryBasic(data, territory);
        if (result != null) {
            return result;
        }
        ArrayList<Unit> units = new ArrayList<Unit>(unitDamageMap.keySet());
        if (!territory.getUnits().getUnits().containsAll(units)) {
            return "Selected Territory does not contain all of the selected units";
        }
        PlayerID player = ((Unit)units.iterator().next()).getOwner();
        if (!Match.allMatch(units, Matches.unitIsOwnedBy(player))) {
            return "Not all units have the same owner";
        }
        if (!Match.allMatch(units, Matches.UnitIsTwoHit)) {
            return "Not all units have more than one total hitpoints";
        }
        for (Unit u : units) {
            int dmg = unitDamageMap.getInt(u);
            if (dmg >= 0 && dmg <= 1) continue;
            return "Damage can not be less than zero or greater than one (if you want to kill the unit, use remove unit)";
        }
        return result;
    }

    public static String validateChangeBombingDamage(GameData data, IntegerMap<Unit> unitDamageMap, Territory territory) {
        String result = null;
        if (unitDamageMap == null || unitDamageMap.isEmpty()) {
            return "Damage map is empty";
        }
        result = EditValidator.validateTerritoryBasic(data, territory);
        if (result != null) {
            return result;
        }
        if (!Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data) && !Properties.getSBRAffectsUnitProduction(data)) {
            return "Game does not allow bombing damage";
        }
        ArrayList<Unit> units = new ArrayList<Unit>(unitDamageMap.keySet());
        if (!territory.getUnits().getUnits().containsAll(units)) {
            return "Selected Territory does not contain all of the selected units";
        }
        PlayerID player = ((Unit)units.iterator().next()).getOwner();
        if (!Match.allMatch(units, Matches.unitIsOwnedBy(player))) {
            return "Not all units have the same owner";
        }
        if (!Match.allMatch(units, Matches.UnitCanBeDamaged)) {
            return "Not all units can take bombing damage";
        }
        for (Unit u : units) {
            int dmg = unitDamageMap.getInt(u);
            if (dmg >= 0 && dmg <= ((TripleAUnit)u).getHowMuchDamageCanThisUnitTakeTotal(u, territory)) continue;
            return "Damage can not be less than zero or greater than the max damage of the unit";
        }
        if (Properties.getSBRAffectsUnitProduction(data)) {
            if (TerritoryAttachment.get(territory) == null) {
                return "Territory does not have attachment, can not damage this territory.";
            }
            if (!unitDamageMap.allValuesAreSame()) {
                return "For this map damage is done to the territory not the unit, therefore all units in this territory must have same damage.";
            }
        }
        return result;
    }

    public static String validateChangePoliticalRelationships(GameData data, Collection<Triple<PlayerID, PlayerID, RelationshipType>> relationshipChanges) {
        String result = null;
        if (relationshipChanges == null || relationshipChanges.isEmpty()) {
            return "Relationship Changes are empty";
        }
        for (Triple<PlayerID, PlayerID, RelationshipType> relationshipChange : relationshipChanges) {
            if (relationshipChange.getFirst() == null || relationshipChange.getSecond() == null) {
                return "Players are null";
            }
            if (relationshipChange.getThird() != null) continue;
            return "New Relationship is null";
        }
        return result;
    }
}

