/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseTripleADelegate;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.PlayerList;
import games.strategy.engine.data.Territory;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.framework.HeadlessGameServer;
import games.strategy.engine.message.IRemote;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.TriggerAttachment;
import games.strategy.triplea.delegate.EndRoundExtendedDelegateState;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.CountDownLatchHandler;
import games.strategy.util.EventThreadJOptionPane;
import games.strategy.util.Match;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndRoundDelegate
extends BaseTripleADelegate {
    private boolean m_gameOver = false;
    private Collection<PlayerID> m_winners = new ArrayList<PlayerID>();

    @Override
    public void start() {
        HashSet<PlayerID> winners;
        PlayerID japanese;
        PlayerAttachment pa;
        super.start();
        if (this.m_gameOver) {
            return;
        }
        String victoryMessage = null;
        GameData data = this.getData();
        if (this.isPacificTheater() && (pa = PlayerAttachment.get(japanese = data.getPlayerList().getPlayerID("Japanese"))) != null && pa.getVps() >= 22) {
            victoryMessage = "Axis achieve VP victory";
            this.m_bridge.getHistoryWriter().startEvent(victoryMessage);
            HashSet<PlayerID> winners2 = data.getAllianceTracker().getPlayersInAlliance(data.getAllianceTracker().getAlliancesPlayerIsIn(japanese).iterator().next());
            this.signalGameOver(victoryMessage, winners2, this.m_bridge);
        }
        if (this.isTotalVictory()) {
            victoryMessage = " achieve TOTAL VICTORY with ";
            this.checkVictoryCities(this.m_bridge, victoryMessage, " Total Victory VCs");
        }
        if (this.isHonorableSurrender()) {
            victoryMessage = " achieve an HONORABLE VICTORY with ";
            this.checkVictoryCities(this.m_bridge, victoryMessage, " Honorable Victory VCs");
        }
        if (this.isProjectionOfPower()) {
            victoryMessage = " achieve victory through a PROJECTION OF POWER with ";
            this.checkVictoryCities(this.m_bridge, victoryMessage, " Projection of Power VCs");
        }
        if (this.isEconomicVictory()) {
            Iterator<String> allianceIter = data.getAllianceTracker().getAlliances().iterator();
            String allianceName = null;
            while (allianceIter.hasNext()) {
                allianceName = allianceIter.next();
                int victoryAmount = this.getEconomicVictoryAmount(data, allianceName);
                HashSet<PlayerID> teamMembers = data.getAllianceTracker().getPlayersInAlliance(allianceName);
                Iterator teamIter = teamMembers.iterator();
                int teamProd = 0;
                while (teamIter.hasNext()) {
                    PlayerID player = (PlayerID)teamIter.next();
                    if ((teamProd += this.getProduction(player)) < victoryAmount) continue;
                    victoryMessage = allianceName + " achieve economic victory";
                    this.m_bridge.getHistoryWriter().startEvent(victoryMessage);
                    HashSet<PlayerID> winners3 = data.getAllianceTracker().getPlayersInAlliance(allianceName);
                    this.signalGameOver(victoryMessage, winners3, this.m_bridge);
                }
            }
        }
        if (this.isTriggeredVictory()) {
            CompositeMatchAnd<TriggerAttachment> endRoundDelegateTriggerMatch = new CompositeMatchAnd<TriggerAttachment>(TriggerAttachment.availableUses, TriggerAttachment.whenOrDefaultMatch(null, null), new CompositeMatchOr(TriggerAttachment.activateTriggerMatch(), TriggerAttachment.victoryMatch()));
            HashSet<TriggerAttachment> toFirePossible = TriggerAttachment.collectForAllTriggersMatching(new HashSet<PlayerID>(data.getPlayerList().getPlayers()), endRoundDelegateTriggerMatch, this.m_bridge);
            if (!toFirePossible.isEmpty()) {
                HashMap<ICondition, Boolean> testedConditions = TriggerAttachment.collectTestsForAllTriggers(toFirePossible, this.m_bridge);
                HashSet<TriggerAttachment> toFireTestedAndSatisfied = new HashSet<TriggerAttachment>(Match.getMatches(toFirePossible, TriggerAttachment.isSatisfiedMatch(testedConditions)));
                TriggerAttachment.triggerActivateTriggerOther(testedConditions, toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
                TriggerAttachment.triggerVictory(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
            }
        }
        if (this.isWW2V2() || this.isWW2V3()) {
            return;
        }
        PlayerList playerList = data.getPlayerList();
        PlayerID russians = playerList.getPlayerID("Russians");
        PlayerID germans = playerList.getPlayerID("Germans");
        PlayerID british = playerList.getPlayerID("British");
        PlayerID japanese2 = playerList.getPlayerID("Japanese");
        PlayerID americans = playerList.getPlayerID("Americans");
        if (germans == null || russians == null || british == null || japanese2 == null || americans == null || playerList.size() > 5) {
            return;
        }
        boolean russia = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(russians, data).getOwner().equals(russians);
        boolean germany = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(germans, data).getOwner().equals(germans);
        boolean britain = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(british, data).getOwner().equals(british);
        boolean japan = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(japanese2, data).getOwner().equals(japanese2);
        boolean america = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(americans, data).getOwner().equals(americans);
        int count = 0;
        if (!russia) {
            ++count;
        }
        if (!britain) {
            ++count;
        }
        if (!america) {
            ++count;
        }
        victoryMessage = " achieve a military victory";
        if (germany && japan && count >= 2) {
            this.m_bridge.getHistoryWriter().startEvent("Axis" + victoryMessage);
            winners = data.getAllianceTracker().getPlayersInAlliance("Axis");
            this.signalGameOver("Axis" + victoryMessage, winners, this.m_bridge);
        }
        if (russia && !germany && britain && !japan && america) {
            this.m_bridge.getHistoryWriter().startEvent("Allies" + victoryMessage);
            winners = data.getAllianceTracker().getPlayersInAlliance("Allies");
            this.signalGameOver("Allies" + victoryMessage, winners, this.m_bridge);
        }
    }

    @Override
    public void end() {
        super.end();
        GameData data = this.getData();
        if (Properties.getTriggers(data)) {
            CompositeChange change = new CompositeChange();
            for (PlayerID player : data.getPlayerList().getPlayers()) {
                change.add(TriggerAttachment.triggerSetUsedForThisRound(player, this.m_bridge));
            }
            if (!change.isEmpty()) {
                this.m_bridge.getHistoryWriter().startEvent("Setting uses for triggers used this round.");
                this.m_bridge.addChange(change);
            }
        }
    }

    @Override
    public Serializable saveState() {
        EndRoundExtendedDelegateState state = new EndRoundExtendedDelegateState();
        state.superState = super.saveState();
        state.m_gameOver = this.m_gameOver;
        state.m_winners = this.m_winners;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        EndRoundExtendedDelegateState s = (EndRoundExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_gameOver = s.m_gameOver;
        this.m_winners = s.m_winners;
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return false;
    }

    private void checkVictoryCities(IDelegateBridge aBridge, String victoryMessage, String victoryType) {
        GameData data = aBridge.getData();
        Iterator<String> allianceIter = data.getAllianceTracker().getAlliances().iterator();
        String allianceName = null;
        List<Territory> territories = data.getMap().getTerritories();
        while (allianceIter.hasNext()) {
            allianceName = allianceIter.next();
            int vcAmount = this.getVCAmount(data, allianceName, victoryType);
            HashSet<PlayerID> teamMembers = data.getAllianceTracker().getPlayersInAlliance(allianceName);
            int teamVCs = 0;
            for (Territory t : territories) {
                TerritoryAttachment ta;
                if (!Matches.isTerritoryOwnedBy(teamMembers).match(t) || (ta = TerritoryAttachment.get(t)) == null) continue;
                teamVCs += ta.getVictoryCity();
            }
            if (teamVCs < vcAmount) continue;
            aBridge.getHistoryWriter().startEvent(allianceName + victoryMessage + vcAmount + " Victory Cities!");
            HashSet<PlayerID> winners = data.getAllianceTracker().getPlayersInAlliance(allianceName);
            this.signalGameOver(allianceName + victoryMessage + vcAmount + " Victory Cities!", winners, aBridge);
        }
    }

    private int getEconomicVictoryAmount(GameData data, String alliance) {
        return data.getProperties().get(alliance + " Economic Victory", 200);
    }

    private int getVCAmount(GameData data, String alliance, String type) {
        int defaultVC = 20;
        if (type.equals(" Total Victory VCs")) {
            defaultVC = 18;
        } else if (type.equals(" Honorable Victory VCs")) {
            defaultVC = 15;
        } else if (type.equals(" Projection of Power VCs")) {
            defaultVC = 13;
        }
        return data.getProperties().get(alliance + type, defaultVC);
    }

    public void signalGameOver(String status, Collection<PlayerID> winners, IDelegateBridge aBridge) {
        if (!this.m_gameOver) {
            boolean stopGame;
            this.m_gameOver = true;
            this.m_winners = winners;
            this.m_bridge.getSoundChannelBroadcaster().playSoundForAll("game_won", this.m_winners != null && !this.m_winners.isEmpty() ? this.m_winners.iterator().next().getName() : PlayerID.NULL_PLAYERID.getName());
            EndRoundDelegate.getDisplay(aBridge).reportMessageToAll(status, status, true, false, true);
            if (HeadlessGameServer.headless()) {
                stopGame = true;
            } else {
                boolean bl = stopGame = 0 != EventThreadJOptionPane.showConfirmDialog(null, status + "\nDo you want to continue?", "Continue", 0, new CountDownLatchHandler(true));
            }
            if (stopGame) {
                aBridge.stopGameSequence();
            }
        }
    }

    public Collection<PlayerID> getWinners() {
        if (!this.m_gameOver) {
            return null;
        }
        return this.m_winners;
    }

    private boolean isWW2V2() {
        return Properties.getWW2V2(this.getData());
    }

    private boolean isWW2V3() {
        return Properties.getWW2V3(this.getData());
    }

    private boolean isPacificTheater() {
        return Properties.getPacificTheater(this.getData());
    }

    private boolean isTotalVictory() {
        return Properties.getTotalVictory(this.getData());
    }

    private boolean isHonorableSurrender() {
        return Properties.getHonorableSurrender(this.getData());
    }

    private boolean isProjectionOfPower() {
        return Properties.getProjectionOfPower(this.getData());
    }

    private boolean isEconomicVictory() {
        return Properties.getEconomicVictory(this.getData());
    }

    private boolean isTriggeredVictory() {
        return Properties.getTriggeredVictory(this.getData());
    }

    public int getProduction(PlayerID id) {
        int sum = 0;
        for (Territory current : this.getData().getMap()) {
            if (!current.getOwner().equals(id)) continue;
            TerritoryAttachment ta = TerritoryAttachment.get(current);
            sum += ta.getProduction();
        }
        return sum;
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return null;
    }
}

