/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.delegate.TechAdvance;

public class GenericTechAdvance
extends TechAdvance {
    private static final long serialVersionUID = -5985281030083508185L;
    private final TechAdvance m_advance;

    public GenericTechAdvance(String name, TechAdvance techAdvance, GameData data) {
        super(name, data);
        this.m_advance = techAdvance;
    }

    public String getProperty() {
        if (this.m_advance != null) {
            return this.m_advance.getProperty();
        }
        return this.getName();
    }

    public void perform(PlayerID id, IDelegateBridge bridge) {
        if (this.m_advance != null) {
            this.m_advance.perform(id, bridge);
        }
    }

    public TechAdvance getAdvance() {
        return this.m_advance;
    }

    public boolean hasTech(TechAttachment ta) {
        if (this.m_advance != null) {
            return this.m_advance.hasTech(ta);
        }
        Boolean has = ta.hasGenericTech(this.getName());
        return has == null ? false : has;
    }
}

