/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseTripleADelegate;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameStep;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.message.IRemote;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.BidPlaceDelegate;
import games.strategy.triplea.delegate.BidPurchaseDelegate;
import games.strategy.triplea.delegate.InitializationExtendedDelegateState;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.OriginalOwnerTracker;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.util.IntegerMap;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializationDelegate
extends BaseTripleADelegate {
    @Override
    public void initialize(String name, String displayName) {
        this.m_name = name;
        this.m_displayName = displayName;
    }

    @Override
    public void start() {
        super.start();
        this.init(this.m_bridge);
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public Serializable saveState() {
        InitializationExtendedDelegateState state = new InitializationExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        InitializationExtendedDelegateState s = (InitializationExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return false;
    }

    protected void init(IDelegateBridge aBridge) {
        this.initDestroyerArtillery(aBridge);
        this.initShipyards(aBridge);
        this.initTwoHitBattleship(aBridge);
        this.initOriginalOwner(aBridge);
        this.initTech(aBridge);
        this.initSkipUnusedBids(aBridge.getData());
    }

    private void initSkipUnusedBids(GameData data) {
        for (GameStep step : data.getSequence()) {
            if (!(step.getDelegate() instanceof BidPlaceDelegate) && !(step.getDelegate() instanceof BidPurchaseDelegate) || BidPurchaseDelegate.doesPlayerHaveBid(data, step.getPlayerID())) continue;
            step.setMaxRunCount(0);
        }
    }

    private void initTech(IDelegateBridge bridge) {
        GameData data = bridge.getData();
        for (PlayerID player : data.getPlayerList().getPlayers()) {
            Iterator<TechAdvance> advances = TechTracker.getCurrentTechAdvances(player, data).iterator();
            if (!advances.hasNext()) continue;
            bridge.getHistoryWriter().startEvent("Initializing " + player.getName() + " with tech advances");
            while (advances.hasNext()) {
                TechAdvance advance = advances.next();
                advance.perform(player, bridge);
            }
        }
    }

    private void initDestroyerArtillery(IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        boolean addArtilleryAndDestroyers = Properties.getUse_Destroyers_And_Artillery(data);
        if (!this.isWW2V2(data) && addArtilleryAndDestroyers) {
            CompositeChange change = new CompositeChange();
            ProductionRule artillery = data.getProductionRuleList().getProductionRule("buyArtillery");
            ProductionRule destroyer = data.getProductionRuleList().getProductionRule("buyDestroyer");
            ProductionFrontier frontier = data.getProductionFrontierList().getProductionFrontier("production");
            change.add(ChangeFactory.addProductionRule(artillery, frontier));
            change.add(ChangeFactory.addProductionRule(destroyer, frontier));
            ProductionRule artilleryIT = data.getProductionRuleList().getProductionRule("buyArtilleryIndustrialTechnology");
            ProductionRule destroyerIT = data.getProductionRuleList().getProductionRule("buyDestroyerIndustrialTechnology");
            ProductionFrontier frontierIT = data.getProductionFrontierList().getProductionFrontier("productionIndustrialTechnology");
            change.add(ChangeFactory.addProductionRule(artilleryIT, frontierIT));
            change.add(ChangeFactory.addProductionRule(destroyerIT, frontierIT));
            aBridge.getHistoryWriter().startEvent("Adding destroyers and artillery production rules");
            aBridge.addChange(change);
        }
    }

    private void initShipyards(IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        boolean useShipyards = Properties.getUse_Shipyards(data);
        if (useShipyards) {
            CompositeChange change = new CompositeChange();
            ProductionFrontier frontierShipyards = data.getProductionFrontierList().getProductionFrontier("productionShipyards");
            ProductionFrontier frontierNONShipyards = data.getProductionFrontierList().getProductionFrontier("production");
            List<ProductionRule> rules = frontierNONShipyards.getRules();
            for (ProductionRule rule : rules) {
                String ruleName = rule.getName();
                IntegerMap<NamedAttachable> ruleResults = rule.getResults();
                String unitName = ruleResults.keySet().iterator().next().getName();
                UnitType unit = data.getUnitTypeList().getUnitType(unitName);
                boolean isSea = UnitAttachment.get(unit).getIsSea();
                if (isSea) continue;
                ProductionRule prodRule = data.getProductionRuleList().getProductionRule(ruleName);
                change.add(ChangeFactory.addProductionRule(prodRule, frontierShipyards));
            }
            aBridge.getHistoryWriter().startEvent("Adding shipyard production rules - land/air units");
            aBridge.addChange(change);
        }
    }

    private boolean isWW2V2(GameData data) {
        return Properties.getWW2V2(data);
    }

    private void initTwoHitBattleship(IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        boolean userEnabled = Properties.getTwoHitBattleships(data);
        UnitType battleShipUnit = data.getUnitTypeList().getUnitType("battleship");
        if (battleShipUnit == null) {
            return;
        }
        UnitAttachment battleShipAttachment = UnitAttachment.get(battleShipUnit);
        boolean defaultEnabled = battleShipAttachment.getIsTwoHit();
        if (userEnabled != defaultEnabled) {
            aBridge.getHistoryWriter().startEvent("TwoHitBattleships:" + userEnabled);
            aBridge.addChange(ChangeFactory.attachmentPropertyChange(battleShipAttachment, "" + userEnabled, "isTwoHit"));
        }
    }

    private void initOriginalOwner(IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        CompositeChange changes = new CompositeChange();
        for (Territory current : data.getMap()) {
            TerritoryAttachment territoryAttachment;
            if (!current.getOwner().isNull()) {
                territoryAttachment = TerritoryAttachment.get(current);
                if (territoryAttachment == null) {
                    throw new IllegalStateException("No territory attachment for " + current);
                }
                if (territoryAttachment.getOriginalOwner() == null && current.getOwner() != null) {
                    changes.add(OriginalOwnerTracker.addOriginalOwnerChange(current, current.getOwner()));
                }
                List<Unit> factoryAndInfrastructure = current.getUnits().getMatches(Matches.UnitIsInfrastructure);
                changes.add(OriginalOwnerTracker.addOriginalOwnerChange(factoryAndInfrastructure, current.getOwner()));
                continue;
            }
            if (current.isWater() || (territoryAttachment = TerritoryAttachment.get(current)) != null) continue;
            throw new IllegalStateException("No territory attachment for " + current);
        }
        aBridge.getHistoryWriter().startEvent("Adding original owners");
        aBridge.addChange(changes);
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return null;
    }
}

