/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.GameOverException;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.message.ConnectionLostException;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.TechAbilityAttachment;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AbstractBattle;
import games.strategy.triplea.delegate.AirMovementValidator;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.BattleStepStrings;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.ExecutionStack;
import games.strategy.triplea.delegate.Fire;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.IExecutable;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveDelegate;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.UnitComparator;
import games.strategy.triplea.delegate.dataObjects.BattleRecord;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import games.strategy.triplea.ui.display.ITripleaDisplay;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.InverseMatch;
import games.strategy.util.Match;
import games.strategy.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MustFightBattle
extends AbstractBattle
implements BattleStepStrings {
    private static final long serialVersionUID = 5879502298361231540L;
    private Map<Territory, Collection<Unit>> m_attackingFromMap = new HashMap<Territory, Collection<Unit>>();
    private final Collection<Unit> m_attackingWaitingToDie = new ArrayList<Unit>();
    private Set<Territory> m_attackingFrom = new HashSet<Territory>();
    private final Collection<Territory> m_amphibiousAttackFrom = new ArrayList<Territory>();
    private final Collection<Unit> m_defendingWaitingToDie = new ArrayList<Unit>();
    private Collection<Unit> m_defendingAir = new ArrayList<Unit>();
    private final Collection<Unit> m_killed = new ArrayList<Unit>();
    private final ExecutionStack m_stack = new ExecutionStack();
    private List<String> m_stepStrings;
    protected List<Unit> m_defendingAA;
    protected List<Unit> m_offensiveAA;
    protected List<String> m_defendingAAtypes;
    protected List<String> m_offensiveAAtypes;
    private final List<Unit> m_attackingUnitsRetreated = new ArrayList<Unit>();
    private final List<Unit> m_defendingUnitsRetreated = new ArrayList<Unit>();
    private final int m_maxRounds;

    public MustFightBattle(Territory battleSite, PlayerID attacker, GameData data, BattleTracker battleTracker) {
        super(battleSite, attacker, battleTracker, false, IBattle.BattleType.NORMAL, data);
        this.m_defendingUnits.addAll(this.m_battleSite.getUnits().getMatches(Matches.enemyUnit(attacker, data)));
        this.m_maxRounds = Properties.getBattleRounds(data);
    }

    public void resetDefendingUnits(Territory battleSite, PlayerID attacker, GameData data) {
        this.m_defendingUnits.clear();
        this.m_defendingUnits.addAll(this.m_battleSite.getUnits().getMatches(Matches.enemyUnit(attacker, data)));
    }

    public void setUnits(Collection<Unit> defending, Collection<Unit> attacking, Collection<Unit> bombarding, Collection<Unit> amphibious, PlayerID defender, Collection<TerritoryEffect> territoryEffects) {
        this.m_defendingUnits = new ArrayList<Unit>(defending);
        this.m_attackingUnits = new ArrayList<Unit>(attacking);
        this.m_bombardingUnits = new ArrayList<Unit>(bombarding);
        this.m_amphibiousLandAttackers = new ArrayList<Unit>(amphibious);
        this.m_isAmphibious = this.m_amphibiousLandAttackers.size() > 0;
        this.m_defender = defender;
        this.m_territoryEffects = territoryEffects;
    }

    public boolean shouldEndBattleDueToMaxRounds() {
        return this.m_maxRounds > 0 && this.m_maxRounds <= this.m_round;
    }

    private boolean canSubsSubmerge() {
        return Properties.getSubmersible_Subs(this.m_data);
    }

    @Override
    public void removeAttack(Route route, Collection<Unit> units) {
        this.m_attackingUnits.removeAll(units);
        if (route == null) {
            return;
        }
        Territory attackingFrom = route.getTerritoryBeforeEnd();
        Collection<Unit> attackingFromMapUnits = this.m_attackingFromMap.get(attackingFrom);
        if (attackingFromMapUnits == null) {
            attackingFromMapUnits = new ArrayList<Unit>();
        }
        attackingFromMapUnits.removeAll(units);
        if (attackingFromMapUnits.isEmpty()) {
            this.m_attackingFrom.remove(attackingFrom);
        }
        if (attackingFrom.isWater()) {
            if (route.getEnd() != null && !route.getEnd().isWater() && Match.someMatch(units, Matches.UnitIsLand)) {
                this.m_amphibiousLandAttackers.removeAll(Match.getMatches(units, Matches.UnitIsLand));
            }
            if (Match.noneMatch(attackingFromMapUnits, Matches.UnitIsLand)) {
                this.m_amphibiousAttackFrom.remove(attackingFrom);
                this.m_isAmphibious = !this.m_amphibiousAttackFrom.isEmpty();
            }
        }
        for (Unit holder : this.m_dependentUnits.keySet()) {
            Collection dependents = (Collection)this.m_dependentUnits.get(holder);
            dependents.removeAll(units);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.m_attackingUnits.isEmpty() && this.m_attackingWaitingToDie.isEmpty();
    }

    @Override
    public Change addAttackChange(Route route, Collection<Unit> units, HashMap<Unit, HashSet<Unit>> targets) {
        CompositeChange change = new CompositeChange();
        Match<Unit> ownedBy = Matches.unitIsOwnedBy(this.m_attacker);
        Collection<Unit> attackingUnits = this.isWW2V2() ? Match.getMatches(units, ownedBy) : units;
        Territory attackingFrom = route.getTerritoryBeforeEnd();
        this.m_attackingFrom.add(attackingFrom);
        this.m_attackingUnits.addAll(attackingUnits);
        if (this.m_attackingFromMap.get(attackingFrom) == null) {
            this.m_attackingFromMap.put(attackingFrom, new ArrayList());
        }
        Collection<Unit> attackingFromMapUnits = this.m_attackingFromMap.get(attackingFrom);
        attackingFromMapUnits.addAll(attackingUnits);
        if (route.getStart().isWater() && route.getEnd() != null && !route.getEnd().isWater() && Match.someMatch(attackingUnits, Matches.UnitIsLand)) {
            this.m_amphibiousAttackFrom.add(this.getAttackFrom(route));
            this.m_amphibiousLandAttackers.addAll(Match.getMatches(attackingUnits, Matches.UnitIsLand));
            this.m_isAmphibious = true;
        }
        Map<Unit, Collection<Unit>> dependencies = this.transporting(units);
        if (this.isAlliedAirDependents()) {
            dependencies.putAll(MoveValidator.carrierMustMoveWith(units, units, this.m_data, this.m_attacker));
            for (Unit carrier : dependencies.keySet()) {
                UnitAttachment ua = UnitAttachment.get(carrier.getUnitType());
                if (ua.getCarrierCapacity() == -1) continue;
                Collection<Unit> fighters = dependencies.get(carrier);
                fighters.retainAll(Match.getMatches(fighters, Matches.UnitIsAir));
                for (Unit fighter : fighters) {
                    change.add(ChangeFactory.unitPropertyChange(fighter, carrier, "transportedBy"));
                }
                this.m_attackingUnits.removeAll(fighters);
            }
        }
        if (this.isParatroopers(this.m_attacker)) {
            List<Unit> airTransports = Match.getMatches(units, Matches.UnitIsAirTransport);
            List<Unit> paratroops = Match.getMatches(units, Matches.UnitIsAirTransportable);
            if (!airTransports.isEmpty() && !paratroops.isEmpty()) {
                Map<Unit, Unit> unitsToCapableAirTransports = MoveDelegate.mapAirTransports(route, paratroops, airTransports, true, this.m_attacker);
                HashMap<Unit, Collection<Unit>> dependentUnits = new HashMap<Unit, Collection<Unit>>();
                ArrayList<Unit> singleCollection = new ArrayList<Unit>();
                for (Unit unit : unitsToCapableAirTransports.keySet()) {
                    ArrayList<Unit> unitList = new ArrayList<Unit>();
                    unitList.add(unit);
                    Unit bomber = unitsToCapableAirTransports.get(unit);
                    singleCollection.add(unit);
                    change.add(ChangeFactory.unitPropertyChange(unit, bomber, "transportedBy"));
                    if (dependentUnits.get(bomber) != null) {
                        dependentUnits.get(bomber).addAll(unitList);
                        continue;
                    }
                    dependentUnits.put(bomber, unitList);
                }
                dependencies.putAll(dependentUnits);
                UnitSeperator.categorize(airTransports, dependentUnits, false, false);
            }
        }
        this.addDependentUnits(dependencies);
        List<Unit> nonAir = Match.getMatches(attackingUnits, Matches.UnitIsNotAir);
        if (this.m_battleSite.isWater()) {
            nonAir = Match.getMatches(nonAir, Matches.UnitIsNotLand);
        }
        if (MoveValidator.onlyIgnoredUnitsOnPath(route, this.m_attacker, this.m_data, false)) {
            return change;
        }
        change.add(ChangeFactory.markNoMovementChange(nonAir));
        return change;
    }

    public void addDependentUnits(Map<Unit, Collection<Unit>> dependencies) {
        for (Unit holder : dependencies.keySet()) {
            Collection<Unit> transporting = dependencies.get(holder);
            if (this.m_dependentUnits.get(holder) != null) {
                ((Collection)this.m_dependentUnits.get(holder)).addAll(transporting);
                continue;
            }
            this.m_dependentUnits.put(holder, new LinkedHashSet<Unit>(transporting));
        }
    }

    @Deprecated
    private Territory getAttackFrom(Route route) {
        return route.getTerritoryBeforeEnd();
    }

    private String getBattleTitle() {
        return this.m_attacker.getName() + " attack " + this.m_defender.getName() + " in " + this.m_battleSite.getName();
    }

    private void removeUnitsThatNoLongerExist() {
        if (this.m_headless) {
            return;
        }
        this.m_defendingUnits.retainAll(this.m_battleSite.getUnits().getUnits());
        this.m_attackingUnits.retainAll(this.m_battleSite.getUnits().getUnits());
    }

    public void updateDefendingAAUnits() {
        ArrayList<Unit> canFire = new ArrayList<Unit>(this.m_defendingUnits.size() + this.m_defendingWaitingToDie.size());
        canFire.addAll(this.m_defendingUnits);
        canFire.addAll(this.m_defendingWaitingToDie);
        HashMap<String, HashSet<UnitType>> airborneTechTargetsAllowed = TechAbilityAttachment.getAirborneTargettedByAA(this.m_attacker, this.m_data);
        this.m_defendingAA = Match.getMatches(canFire, Matches.UnitIsAAthatCanFire(this.m_attackingUnits, airborneTechTargetsAllowed, this.m_attacker, Matches.UnitIsAAforCombatOnly, this.m_round, true, this.m_data));
        this.m_defendingAAtypes = UnitAttachment.getAllOfTypeAAs(this.m_defendingAA);
        Collections.reverse(this.m_defendingAAtypes);
    }

    public void updateOffensiveAAUnits() {
        ArrayList<Unit> canFire = new ArrayList<Unit>(this.m_attackingUnits.size() + this.m_attackingWaitingToDie.size());
        canFire.addAll(this.m_attackingUnits);
        canFire.addAll(this.m_attackingWaitingToDie);
        this.m_offensiveAA = Match.getMatches(canFire, Matches.UnitIsAAthatCanFire(this.m_defendingUnits, new HashMap<String, HashSet<UnitType>>(), this.m_defender, Matches.UnitIsAAforCombatOnly, this.m_round, false, this.m_data));
        this.m_offensiveAAtypes = UnitAttachment.getAllOfTypeAAs(this.m_offensiveAA);
        Collections.reverse(this.m_offensiveAAtypes);
    }

    @Override
    public void fight(IDelegateBridge bridge) {
        this.removeUnitsThatNoLongerExist();
        if (this.m_stack.isExecuting()) {
            ITripleaDisplay display = MustFightBattle.getDisplay(bridge);
            display.showBattle(this.m_battleID, this.m_battleSite, this.getBattleTitle(), this.removeNonCombatants(this.m_attackingUnits, true, this.m_attacker, false, false, false), this.removeNonCombatants(this.m_defendingUnits, false, this.m_defender, false, false, false), this.m_killed, this.m_attackingWaitingToDie, this.m_defendingWaitingToDie, this.m_dependentUnits, this.m_attacker, this.m_defender, this.isAmphibious(), this.getBattleType(), this.m_amphibiousLandAttackers);
            display.listBattleSteps(this.m_battleID, this.m_stepStrings);
            this.m_stack.execute(bridge);
            return;
        }
        bridge.getHistoryWriter().startEvent("Battle in " + this.m_battleSite, this.m_battleSite);
        this.removeAirNoLongerInTerritory();
        this.writeUnitsToHistory(bridge);
        if (Match.getMatches(this.m_attackingUnits, Matches.UnitIsNotInfrastructure).size() == 0) {
            this.endBattle(bridge);
            this.defenderWins(bridge);
            return;
        }
        if (Match.getMatches(this.m_defendingUnits, Matches.UnitIsNotInfrastructure).size() == 0) {
            this.endBattle(bridge);
            this.attackerWins(bridge);
            return;
        }
        this.addDependentUnits(this.transporting(this.m_defendingUnits));
        this.addDependentUnits(this.transporting(this.m_attackingUnits));
        this.updateOffensiveAAUnits();
        this.updateDefendingAAUnits();
        this.m_stepStrings = this.determineStepStrings(true, bridge);
        ITripleaDisplay display = MustFightBattle.getDisplay(bridge);
        display.showBattle(this.m_battleID, this.m_battleSite, this.getBattleTitle(), this.removeNonCombatants(this.m_attackingUnits, true, this.m_attacker, false, false, false), this.removeNonCombatants(this.m_defendingUnits, false, this.m_defender, false, false, false), this.m_killed, this.m_attackingWaitingToDie, this.m_defendingWaitingToDie, this.m_dependentUnits, this.m_attacker, this.m_defender, this.isAmphibious(), this.getBattleType(), this.m_amphibiousLandAttackers);
        display.listBattleSteps(this.m_battleID, this.m_stepStrings);
        if (!this.m_headless) {
            if (this.isAmphibious()) {
                this.sortAmphib(this.m_attackingUnits, this.m_data);
            } else {
                BattleCalculator.sortPreBattle(this.m_attackingUnits, this.m_data);
            }
            BattleCalculator.sortPreBattle(this.m_defendingUnits, this.m_data);
            if (Match.someMatch(this.m_attackingUnits, Matches.UnitIsSea) || Match.someMatch(this.m_defendingUnits, Matches.UnitIsSea)) {
                if (Match.allMatch(this.m_attackingUnits, Matches.UnitIsSub) || Match.someMatch(this.m_attackingUnits, Matches.UnitIsSub) && Match.someMatch(this.m_defendingUnits, Matches.UnitIsSub)) {
                    bridge.getSoundChannelBroadcaster().playSoundForAll("battle_sea_subs", this.m_attacker.getName());
                } else {
                    bridge.getSoundChannelBroadcaster().playSoundForAll("battle_sea_normal", this.m_attacker.getName());
                }
            } else if (Match.allMatch(this.m_attackingUnits, Matches.UnitIsAir) && Match.allMatch(this.m_defendingUnits, Matches.UnitIsAir)) {
                bridge.getSoundChannelBroadcaster().playSoundForAll("battle_air", this.m_attacker.getName());
            } else {
                bridge.getSoundChannelBroadcaster().playSoundForAll("battle_land", this.m_attacker.getName());
            }
        }
        this.pushFightLoopOnStack(true, bridge);
        this.m_stack.execute(bridge);
    }

    private void writeUnitsToHistory(IDelegateBridge bridge) {
        if (this.m_headless) {
            return;
        }
        Set<PlayerID> playerSet = this.m_battleSite.getUnits().getPlayersWithUnits();
        ArrayList<PlayerID> attackers = new ArrayList<PlayerID>();
        ArrayList<Unit> allAttackingUnits = new ArrayList<Unit>();
        String transcriptText = "";
        for (PlayerID current : playerSet) {
            if (!this.m_data.getRelationshipTracker().isAllied(this.m_attacker, current) && !current.equals(this.m_attacker)) continue;
            attackers.add(current);
        }
        Iterator attackersIter = attackers.iterator();
        while (attackersIter.hasNext()) {
            PlayerID current;
            current = (PlayerID)attackersIter.next();
            String delim = attackersIter.hasNext() ? "; " : "";
            List<Unit> attackingUnits = Match.getMatches(this.m_attackingUnits, Matches.unitIsOwnedBy(current));
            String verb = current.equals(this.m_attacker) ? "attack" : "loiter and taunt";
            transcriptText = transcriptText + current.getName() + " " + verb + " with " + MyFormatter.unitsToTextNoOwner(attackingUnits) + delim;
            allAttackingUnits.addAll(attackingUnits);
            if (!current.equals(this.m_attacker)) continue;
            CompositeChange change = new CompositeChange();
            List<Unit> transports = Match.getMatches(attackingUnits, Matches.UnitCanTransport);
            Iterator attackTranIter = transports.iterator();
            while (attackTranIter.hasNext()) {
                change.add(ChangeFactory.unitPropertyChange((Unit)attackTranIter.next(), true, "wasInCombat"));
            }
            bridge.addChange(change);
        }
        if (this.m_attackingUnits.size() > 0) {
            bridge.getHistoryWriter().addChildToEvent(transcriptText, allAttackingUnits);
        }
        ArrayList<PlayerID> defenders = new ArrayList<PlayerID>();
        ArrayList<Unit> allDefendingUnits = new ArrayList<Unit>();
        transcriptText = "";
        for (PlayerID current : playerSet) {
            if (!this.m_data.getRelationshipTracker().isAllied(this.m_defender, current) && !current.equals(this.m_defender)) continue;
            defenders.add(current);
        }
        Iterator defendersIter = defenders.iterator();
        while (defendersIter.hasNext()) {
            PlayerID current;
            current = (PlayerID)defendersIter.next();
            String delim = defendersIter.hasNext() ? "; " : "";
            List<Unit> defendingUnits = Match.getMatches(this.m_defendingUnits, Matches.unitIsOwnedBy(current));
            transcriptText = transcriptText + current.getName() + " defend with " + MyFormatter.unitsToTextNoOwner(defendingUnits) + delim;
            allDefendingUnits.addAll(defendingUnits);
        }
        if (this.m_defendingUnits.size() > 0) {
            bridge.getHistoryWriter().addChildToEvent(transcriptText, allDefendingUnits);
        }
    }

    private void removeAirNoLongerInTerritory() {
        if (this.m_headless) {
            return;
        }
        CompositeMatchAnd<Unit> airNotInTerritory = new CompositeMatchAnd<Unit>(new Match[0]);
        airNotInTerritory.add(new InverseMatch<Unit>(Matches.unitIsInTerritory(this.m_battleSite)));
        this.m_attackingUnits.removeAll(Match.getMatches(this.m_attackingUnits, airNotInTerritory));
    }

    public List<String> determineStepStrings(boolean showFirstRun, IDelegateBridge bridge) {
        boolean someAirAtSea;
        ArrayList<Unit> units;
        boolean defendingSubsFireWithAllDefendersAlways;
        boolean onlyAttackerSneakAttack;
        boolean defenderSubsFireFirst;
        ArrayList<String> steps = new ArrayList<String>();
        if (this.canFireOffensiveAA()) {
            for (String typeAA : UnitAttachment.getAllOfTypeAAs(this.m_offensiveAA)) {
                steps.add(this.m_attacker.getName() + " " + typeAA + " fire");
                steps.add(this.m_defender.getName() + " select " + typeAA + " casualties");
                steps.add(this.m_defender.getName() + " remove " + typeAA + " casualties");
            }
        }
        if (this.canFireDefendingAA()) {
            for (String typeAA : UnitAttachment.getAllOfTypeAAs(this.m_defendingAA)) {
                steps.add(this.m_defender.getName() + " " + typeAA + " fire");
                steps.add(this.m_attacker.getName() + " select " + typeAA + " casualties");
                steps.add(this.m_attacker.getName() + " remove " + typeAA + " casualties");
            }
        }
        if (showFirstRun) {
            Collection<Unit> dependents;
            List<Unit> bombers;
            if (!this.m_battleSite.isWater() && !this.getBombardingUnits().isEmpty()) {
                steps.add("Naval bombardment");
                steps.add("Select naval bombardment casualties");
            }
            if (Match.someMatch(this.m_attackingUnits, Matches.UnitIsSuicide)) {
                steps.add("Suicide and Munition units Attack");
                steps.add(this.m_defender.getName() + " select suicide casualties");
            }
            if (Match.someMatch(this.m_defendingUnits, Matches.UnitIsSuicide) && !this.isDefendingSuicideAndMunitionUnitsDoNotFire()) {
                steps.add("Suicide and Munition units Defend");
                steps.add(this.m_attacker.getName() + " select suicide casualties");
            }
            if (!this.m_battleSite.isWater() && this.isParatroopers(this.m_attacker) && !(bombers = Match.getMatches(this.m_battleSite.getUnits().getUnits(), Matches.UnitIsAirTransport)).isEmpty() && !(dependents = this.getDependentUnits(bombers)).isEmpty()) {
                steps.add("Land Paratroopers");
            }
        }
        if (this.isSubRetreatBeforeBattle()) {
            if (!Match.someMatch(this.m_defendingUnits, Matches.UnitIsDestroyer) && Match.someMatch(this.m_attackingUnits, Matches.UnitIsSub)) {
                steps.add(this.m_attacker.getName() + " submerge subs?");
            }
            if (!Match.someMatch(this.m_attackingUnits, Matches.UnitIsDestroyer) && Match.someMatch(this.m_defendingUnits, Matches.UnitIsSub)) {
                steps.add(this.m_defender.getName() + " submerge subs?");
            }
        }
        if (this.m_battleSite.isWater() && this.isTransportCasualtiesRestricted() && (Match.someMatch(this.m_attackingUnits, Matches.UnitIsTransport) || Match.someMatch(this.m_defendingUnits, Matches.UnitIsTransport))) {
            steps.add("Remove unescorted transports");
        }
        if ((defenderSubsFireFirst = this.defenderSubsFireFirst()) && Match.someMatch(this.m_defendingUnits, Matches.UnitIsSub)) {
            steps.add(this.m_defender.getName() + " subs fire");
            steps.add(this.m_attacker.getName() + " select sub casualties");
            steps.add("Remove sneak attack casualties");
        }
        if (this.m_battleSite.isWater() && Match.someMatch(this.m_attackingUnits, Matches.UnitIsSub)) {
            steps.add(this.m_attacker.getName() + " subs fire");
            steps.add(this.m_defender.getName() + " select sub casualties");
        }
        boolean bl = onlyAttackerSneakAttack = !defenderSubsFireFirst && this.returnFireAgainstAttackingSubs() == ReturnFire.NONE && this.returnFireAgainstDefendingSubs() == ReturnFire.ALL;
        if (onlyAttackerSneakAttack) {
            steps.add("Remove sneak attack casualties");
        }
        boolean bl2 = defendingSubsFireWithAllDefendersAlways = !this.defendingSubsSneakAttack3();
        if (this.m_battleSite.isWater() && !defendingSubsFireWithAllDefendersAlways && !defenderSubsFireFirst && Match.someMatch(this.m_defendingUnits, Matches.UnitIsSub)) {
            steps.add(this.m_defender.getName() + " subs fire");
            steps.add(this.m_attacker.getName() + " select sub casualties");
        }
        if (!(!this.m_battleSite.isWater() || defenderSubsFireFirst || onlyAttackerSneakAttack || this.returnFireAgainstDefendingSubs() == ReturnFire.ALL && this.returnFireAgainstAttackingSubs() == ReturnFire.ALL)) {
            steps.add("Remove sneak attack casualties");
        }
        if (this.isAirAttackSubRestricted()) {
            units = new ArrayList<Unit>(this.m_attackingUnits.size() + this.m_attackingWaitingToDie.size());
            units.addAll(this.m_attackingUnits);
            if (Match.someMatch(this.m_attackingUnits, Matches.UnitIsAir) && !this.canAirAttackSubs(this.m_defendingUnits, units)) {
                steps.add("Submerge subs against only air units");
            }
        }
        if (this.m_battleSite.isWater() && this.isAirAttackSubRestricted()) {
            units = new ArrayList(this.m_attackingUnits.size() + this.m_attackingWaitingToDie.size());
            units.addAll(this.m_attackingUnits);
            if (Match.someMatch(this.m_attackingUnits, Matches.UnitIsAir) && !this.canAirAttackSubs(this.m_defendingUnits, units)) {
                steps.add("Air attack non subs");
            }
        }
        if (Match.someMatch(this.m_attackingUnits, Matches.UnitIsNotSub)) {
            steps.add(this.m_attacker.getName() + " fire");
            steps.add(this.m_defender.getName() + " select casualties");
        }
        if (this.m_battleSite.isWater()) {
            units = new ArrayList(this.m_defendingUnits.size() + this.m_defendingWaitingToDie.size());
            units.addAll(this.m_defendingUnits);
            units.addAll(this.m_defendingWaitingToDie);
            if (defendingSubsFireWithAllDefendersAlways && !defenderSubsFireFirst && Match.someMatch(units, Matches.UnitIsSub)) {
                steps.add(this.m_defender.getName() + " subs fire");
                steps.add(this.m_attacker.getName() + " select sub casualties");
            }
        }
        if (this.m_battleSite.isWater() && this.isAirAttackSubRestricted()) {
            units = new ArrayList(this.m_defendingUnits.size() + this.m_defendingWaitingToDie.size());
            units.addAll(this.m_defendingUnits);
            units.addAll(this.m_defendingWaitingToDie);
            if (Match.someMatch(this.m_defendingUnits, Matches.UnitIsAir) && !this.canAirAttackSubs(this.m_attackingUnits, units)) {
                steps.add("Air defend non subs");
            }
        }
        if (Match.someMatch(this.m_defendingUnits, Matches.UnitIsNotSub)) {
            steps.add(this.m_defender.getName() + " fire");
            steps.add(this.m_attacker.getName() + " select casualties");
        }
        steps.add("Remove casualties");
        if (this.m_battleSite.isWater()) {
            if (this.canSubsSubmerge()) {
                if (!this.isSubRetreatBeforeBattle()) {
                    if (Match.someMatch(this.m_attackingUnits, Matches.UnitIsSub)) {
                        steps.add(this.m_attacker.getName() + " submerge subs?");
                    }
                    if (Match.someMatch(this.m_defendingUnits, Matches.UnitIsSub)) {
                        steps.add(this.m_defender.getName() + " submerge subs?");
                    }
                }
            } else {
                if (this.canAttackerRetreatSubs() && Match.someMatch(this.m_attackingUnits, Matches.UnitIsSub)) {
                    steps.add(this.m_attacker.getName() + " withdraw subs?");
                }
                if (this.canDefenderRetreatSubs() && Match.someMatch(this.m_defendingUnits, Matches.UnitIsSub)) {
                    steps.add(this.m_defender.getName() + " withdraw subs?");
                }
            }
        }
        boolean bl3 = someAirAtSea = this.m_battleSite.isWater() && Match.someMatch(this.m_attackingUnits, Matches.UnitIsAir);
        if (this.canAttackerRetreat() || someAirAtSea) {
            steps.add(this.m_attacker.getName() + " withdraw?");
        } else if (this.canAttackerRetreatPartialAmphib()) {
            steps.add(this.m_attacker.getName() + " withdraw non-amphibious units?");
        } else if (this.canAttackerRetreatPlanes()) {
            steps.add(this.m_attacker.getName() + " withdraw planes?");
        }
        return steps;
    }

    private boolean defenderSubsFireFirst() {
        return this.returnFireAgainstAttackingSubs() == ReturnFire.ALL && this.returnFireAgainstDefendingSubs() == ReturnFire.NONE;
    }

    private void addFightStartToStack(boolean firstRun, List<IExecutable> steps) {
        boolean offensiveAA = this.canFireOffensiveAA();
        boolean defendingAA = this.canFireDefendingAA();
        if (offensiveAA) {
            steps.add(new IExecutable(){
                private static final long serialVersionUID = 3802352588499530533L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.fireOffensiveAAGuns(bridge);
                }
            });
        }
        if (defendingAA) {
            steps.add(new IExecutable(){
                private static final long serialVersionUID = -1370090785540214199L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.fireDefensiveAAGuns(bridge);
                }
            });
        }
        if (offensiveAA || defendingAA) {
            steps.add(new IExecutable(){
                private static final long serialVersionUID = 8762796262264296436L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.clearWaitingToDie(bridge);
                }
            });
        }
        if (this.m_round > 1) {
            steps.add(new IExecutable(){
                private static final long serialVersionUID = 2781652892457063082L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.removeNonCombatants(bridge, false, false, true);
                }
            });
        }
        if (firstRun) {
            steps.add(new IExecutable(){
                private static final long serialVersionUID = -2255284529092427441L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.fireNavalBombardment(bridge);
                }
            });
            steps.add(new IExecutable(){
                private static final long serialVersionUID = 6578267830066963474L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.fireSuicideUnitsAttack(bridge);
                }
            });
            steps.add(new IExecutable(){
                private static final long serialVersionUID = 2731652892447063082L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.fireSuicideUnitsDefend(bridge);
                }
            });
            steps.add(new IExecutable(){
                private static final long serialVersionUID = 3389635558184415797L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.removeNonCombatants(bridge, false, false, true);
                }
            });
            steps.add(new IExecutable(){
                private static final long serialVersionUID = 7193353768857658286L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.landParatroops(bridge);
                }
            });
            steps.add(new IExecutable(){
                private static final long serialVersionUID = -6676316363537467594L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.markNoMovementLeft(bridge);
                }
            });
        }
    }

    private void pushFightLoopOnStack(boolean firstRun, IDelegateBridge bridge) {
        if (this.m_isOver) {
            return;
        }
        List<IExecutable> steps = this.getBattleExecutables(firstRun);
        Collections.reverse(steps);
        for (IExecutable step : steps) {
            this.m_stack.push(step);
        }
    }

    List<IExecutable> getBattleExecutables(boolean firstRun) {
        ArrayList<IExecutable> steps = new ArrayList<IExecutable>();
        this.addFightStartToStack(firstRun, steps);
        this.addFightStepsNonEditMode(steps);
        steps.add(new IExecutable(){
            private static final long serialVersionUID = 8611067962952500496L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                MustFightBattle.this.clearWaitingToDie(bridge);
            }
        });
        steps.add(new IExecutable(){
            private static final long serialVersionUID = 6387198382888361848L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                MustFightBattle.this.checkSuicideUnits(bridge);
            }
        });
        steps.add(new IExecutable(){
            private static final long serialVersionUID = 5259103822937067667L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                if (Match.getMatches(MustFightBattle.this.m_attackingUnits, Matches.UnitIsNotInfrastructure).size() == 0) {
                    if (!MustFightBattle.this.isTransportCasualtiesRestricted()) {
                        MustFightBattle.this.endBattle(bridge);
                        MustFightBattle.this.defenderWins(bridge);
                    } else {
                        CompositeMatchAnd<Unit> matchAllied = new CompositeMatchAnd<Unit>(new Match[0]);
                        matchAllied.add(Matches.UnitIsTransport);
                        matchAllied.add(Matches.UnitIsNotCombatTransport);
                        matchAllied.add(Matches.isUnitAllied(MustFightBattle.this.m_attacker, MustFightBattle.this.m_data));
                        List<Unit> alliedTransports = Match.getMatches(MustFightBattle.this.m_battleSite.getUnits().getUnits(), matchAllied);
                        if (alliedTransports.isEmpty()) {
                            MustFightBattle.this.endBattle(bridge);
                            MustFightBattle.this.defenderWins(bridge);
                        } else if (MustFightBattle.this.m_round <= 1) {
                            MustFightBattle.this.m_attackingUnits = Match.getMatches(MustFightBattle.this.m_battleSite.getUnits().getUnits(), Matches.unitIsOwnedBy(MustFightBattle.this.m_attacker));
                        } else {
                            MustFightBattle.this.endBattle(bridge);
                            MustFightBattle.this.defenderWins(bridge);
                        }
                    }
                } else if (Match.getMatches(MustFightBattle.this.m_defendingUnits, Matches.UnitIsNotInfrastructure).size() == 0) {
                    if (MustFightBattle.this.isTransportCasualtiesRestricted()) {
                        MustFightBattle.this.checkUndefendedTransports(bridge, MustFightBattle.this.m_defender);
                    }
                    MustFightBattle.this.checkForUnitsThatCanRollLeft(bridge, false);
                    MustFightBattle.this.endBattle(bridge);
                    MustFightBattle.this.attackerWins(bridge);
                } else if (MustFightBattle.this.shouldEndBattleDueToMaxRounds() || Match.allMatch(MustFightBattle.this.m_attackingUnits, Matches.unitHasAttackValueOfAtLeast(1).invert()) && Match.allMatch(MustFightBattle.this.m_defendingUnits, Matches.unitHasDefendValueOfAtLeast(1).invert())) {
                    MustFightBattle.this.endBattle(bridge);
                    MustFightBattle.this.nobodyWins(bridge);
                }
            }
        });
        steps.add(new IExecutable(){
            private static final long serialVersionUID = 6775880082912594489L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                if (!MustFightBattle.this.m_isOver && MustFightBattle.this.canAttackerRetreatSubs() && !MustFightBattle.this.isSubRetreatBeforeBattle()) {
                    MustFightBattle.this.attackerRetreatSubs(bridge);
                }
            }
        });
        steps.add(new IExecutable(){
            private static final long serialVersionUID = -1544916305666912480L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                if (!MustFightBattle.this.m_isOver) {
                    if (MustFightBattle.this.canDefenderRetreatSubs() && !MustFightBattle.this.isSubRetreatBeforeBattle()) {
                        MustFightBattle.this.defenderRetreatSubs(bridge);
                    }
                    if (MustFightBattle.this.m_defendingUnits.isEmpty()) {
                        MustFightBattle.this.endBattle(bridge);
                        MustFightBattle.this.attackerWins(bridge);
                    }
                }
            }
        });
        steps.add(new IExecutable(){
            private static final long serialVersionUID = -1150863964807721395L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                if (!MustFightBattle.this.m_isOver && MustFightBattle.this.canAttackerRetreatPlanes() && !MustFightBattle.this.canAttackerRetreatPartialAmphib()) {
                    MustFightBattle.this.attackerRetreatPlanes(bridge);
                }
            }
        });
        steps.add(new IExecutable(){
            private static final long serialVersionUID = -1150863964807721395L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                if (!MustFightBattle.this.m_isOver && MustFightBattle.this.canAttackerRetreatPartialAmphib()) {
                    MustFightBattle.this.attackerRetreatNonAmphibUnits(bridge);
                }
            }
        });
        steps.add(new IExecutable(){
            private static final long serialVersionUID = 669349383898975048L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                if (!MustFightBattle.this.m_isOver) {
                    MustFightBattle.this.attackerRetreat(bridge);
                }
            }
        });
        final IExecutable loop = new IExecutable(){
            private static final long serialVersionUID = 3118458517320468680L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                MustFightBattle.this.pushFightLoopOnStack(false, bridge);
            }
        };
        steps.add(new IExecutable(){
            private static final long serialVersionUID = -3993599528368570254L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                if (!MustFightBattle.this.m_isOver) {
                    ++MustFightBattle.this.m_round;
                    MustFightBattle.this.updateOffensiveAAUnits();
                    MustFightBattle.this.updateDefendingAAUnits();
                    MustFightBattle.this.m_stepStrings = MustFightBattle.this.determineStepStrings(false, bridge);
                    ITripleaDisplay display = AbstractBattle.getDisplay(bridge);
                    display.listBattleSteps(MustFightBattle.this.m_battleID, MustFightBattle.this.m_stepStrings);
                    if (!MustFightBattle.this.m_stack.isEmpty()) {
                        throw new IllegalStateException("Stack not empty:" + MustFightBattle.this.m_stack);
                    }
                    MustFightBattle.this.m_stack.push(loop);
                }
            }
        });
        return steps;
    }

    private void addFightStepsNonEditMode(List<IExecutable> steps) {
        if (this.isSubRetreatBeforeBattle()) {
            steps.add(new IExecutable(){
                private static final long serialVersionUID = 6775880082912594489L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    if (!MustFightBattle.this.m_isOver) {
                        MustFightBattle.this.attackerRetreatSubs(bridge);
                    }
                }
            });
            steps.add(new IExecutable(){
                private static final long serialVersionUID = 7056448091800764539L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    if (!MustFightBattle.this.m_isOver) {
                        MustFightBattle.this.defenderRetreatSubs(bridge);
                    }
                }
            });
        }
        steps.add(new IExecutable(){
            private static final long serialVersionUID = 99988L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                MustFightBattle.this.checkSuicideUnits(bridge);
            }
        });
        if (this.isTransportCasualtiesRestricted()) {
            steps.add(new IExecutable(){
                private static final long serialVersionUID = 99989L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.checkUndefendedTransports(bridge, MustFightBattle.this.m_defender);
                    MustFightBattle.this.checkUndefendedTransports(bridge, MustFightBattle.this.m_attacker);
                    MustFightBattle.this.checkForUnitsThatCanRollLeft(bridge, true);
                    MustFightBattle.this.checkForUnitsThatCanRollLeft(bridge, false);
                }
            });
        }
        if (this.isAirAttackSubRestricted()) {
            steps.add(new IExecutable(){
                private static final long serialVersionUID = 99990L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.submergeSubsVsOnlyAir(bridge);
                }
            });
        }
        final ReturnFire returnFireAgainstAttackingSubs = this.returnFireAgainstAttackingSubs();
        final ReturnFire returnFireAgainstDefendingSubs = this.returnFireAgainstDefendingSubs();
        if (this.defenderSubsFireFirst()) {
            steps.add(new DefendSubs(){
                private static final long serialVersionUID = 99992L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.defendSubs(bridge, returnFireAgainstDefendingSubs);
                }
            });
        }
        steps.add(new AttackSubs(){
            private static final long serialVersionUID = 99991L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                MustFightBattle.this.attackSubs(bridge, returnFireAgainstAttackingSubs);
            }
        });
        if (this.defendingSubsSneakAttack3() && !this.defenderSubsFireFirst()) {
            steps.add(new DefendSubs(){
                private static final long serialVersionUID = 99992L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.defendSubs(bridge, returnFireAgainstDefendingSubs);
                }
            });
        }
        if (this.isAirAttackSubRestricted()) {
            steps.add(new IExecutable(){
                private static final long serialVersionUID = 99993L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.attackAirOnNonSubs(bridge);
                }
            });
        }
        steps.add(new IExecutable(){
            private static final long serialVersionUID = 99994L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                MustFightBattle.this.attackNonSubs(bridge);
            }
        });
        if (!this.defendingSubsSneakAttack3() && !this.defenderSubsFireFirst()) {
            steps.add(new DefendSubs(){
                private static final long serialVersionUID = 999921L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.defendSubs(bridge, returnFireAgainstDefendingSubs);
                }
            });
        }
        if (this.isAirAttackSubRestricted()) {
            steps.add(new IExecutable(){
                private static final long serialVersionUID = 1560702114917865123L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    MustFightBattle.this.defendAirOnNonSubs(bridge);
                }
            });
        }
        steps.add(new IExecutable(){
            private static final long serialVersionUID = 1560702114917865290L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                MustFightBattle.this.defendNonSubs(bridge);
            }
        });
    }

    private ReturnFire returnFireAgainstAttackingSubs() {
        boolean attackingSubsSneakAttack = !Match.someMatch(this.m_defendingUnits, Matches.UnitIsDestroyer);
        boolean defendingSubsSneakAttack = this.defendingSubsSneakAttack2();
        ReturnFire returnFireAgainstAttackingSubs = !attackingSubsSneakAttack ? ReturnFire.ALL : (defendingSubsSneakAttack || this.isWW2V2() ? ReturnFire.SUBS : ReturnFire.NONE);
        return returnFireAgainstAttackingSubs;
    }

    private ReturnFire returnFireAgainstDefendingSubs() {
        boolean attackingSubsSneakAttack = !Match.someMatch(this.m_defendingUnits, Matches.UnitIsDestroyer);
        boolean defendingSubsSneakAttack = this.defendingSubsSneakAttack2();
        ReturnFire returnFireAgainstDefendingSubs = !defendingSubsSneakAttack ? ReturnFire.ALL : (attackingSubsSneakAttack || this.isWW2V2() ? ReturnFire.SUBS : ReturnFire.NONE);
        return returnFireAgainstDefendingSubs;
    }

    private boolean defendingSubsSneakAttack2() {
        return !Match.someMatch(this.m_attackingUnits, Matches.UnitIsDestroyer) && this.defendingSubsSneakAttack3();
    }

    private boolean defendingSubsSneakAttack3() {
        return this.isWW2V2() || this.isDefendingSubsSneakAttack();
    }

    private boolean canAttackerRetreatPlanes() {
        return (this.isWW2V2() || this.isAttackerRetreatPlanes() || this.isPartialAmphibiousRetreat()) && this.m_isAmphibious && Match.someMatch(this.m_attackingUnits, Matches.UnitIsAir);
    }

    private boolean canAttackerRetreatPartialAmphib() {
        if (this.m_isAmphibious && this.isPartialAmphibiousRetreat()) {
            List<Unit> landUnits = Match.getMatches(this.m_attackingUnits, Matches.UnitIsLand);
            for (Unit unit : landUnits) {
                TripleAUnit taUnit = (TripleAUnit)unit;
                if (taUnit.getWasAmphibious()) continue;
                return true;
            }
        }
        return false;
    }

    Collection<Territory> getAttackerRetreatTerritories() {
        if (this.m_headless || Match.allMatch(this.m_attackingUnits, Matches.UnitIsAir)) {
            ArrayList<Territory> oneTerritory = new ArrayList<Territory>(2);
            oneTerritory.add(this.m_battleSite);
            return oneTerritory;
        }
        CompositeMatchAnd<Unit> enemyUnitsThatPreventRetreat = new CompositeMatchAnd<Unit>(Matches.enemyUnit(this.m_attacker, this.m_data), Matches.UnitIsNotInfrastructure, Matches.unitIsBeingTransported().invert(), Matches.unitIsNotSubmerged(this.m_data));
        if (Properties.getIgnoreSubInMovement(this.m_data)) {
            enemyUnitsThatPreventRetreat.add(Matches.UnitIsNotSub);
        }
        if (Properties.getIgnoreTransportInMovement(this.m_data)) {
            enemyUnitsThatPreventRetreat.add(Matches.UnitIsNotTransportButCouldBeCombatTransport);
        }
        List<Territory> possible = Match.getMatches(this.m_attackingFrom, Matches.territoryHasUnitsThatMatch(enemyUnitsThatPreventRetreat).invert());
        if (this.isWW2V2() || this.isWW2V3()) {
            possible = Match.getMatches(possible, new Match<Territory>(){

                @Override
                public boolean match(Territory t) {
                    Collection units = (Collection)MustFightBattle.this.m_attackingFromMap.get(t);
                    return !Match.allMatch(units, Matches.UnitIsAir);
                }
            });
        }
        CompositeMatchOr conqueuredOrEnemy = new CompositeMatchOr(Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(this.m_attacker, this.m_data), new CompositeMatchAnd(Matches.TerritoryIsWater, Matches.territoryWasFoughOver(this.m_battleTracker)));
        possible.removeAll(Match.getMatches(possible, conqueuredOrEnemy));
        possible.remove(this.m_battleSite);
        if (Match.someMatch(this.m_attackingUnits, Matches.UnitIsLand) && !this.m_battleSite.isWater()) {
            possible = Match.getMatches(possible, Matches.TerritoryIsLand);
        }
        if (Match.someMatch(this.m_attackingUnits, Matches.UnitIsSea)) {
            possible = Match.getMatches(possible, Matches.TerritoryIsWater);
        }
        return possible;
    }

    private boolean canAttackerRetreat() {
        if (this.onlyDefenselessDefendingTransportsLeft()) {
            return false;
        }
        if (this.m_isAmphibious) {
            return false;
        }
        Collection<Territory> options = this.getAttackerRetreatTerritories();
        return options.size() != 0;
    }

    private boolean onlyDefenselessDefendingTransportsLeft() {
        if (!this.isTransportCasualtiesRestricted()) {
            return false;
        }
        return Match.allMatch(this.m_defendingUnits, Matches.UnitIsTransportButNotCombatTransport);
    }

    private boolean canAttackerRetreatSubs() {
        if (Match.someMatch(this.m_defendingUnits, Matches.UnitIsDestroyer)) {
            return false;
        }
        if (Match.someMatch(this.m_defendingWaitingToDie, Matches.UnitIsDestroyer)) {
            return false;
        }
        return this.canAttackerRetreat() || this.canSubsSubmerge();
    }

    void externalRetreat(Collection<Unit> retreaters, Territory retreatTo, Boolean defender, IDelegateBridge bridge) {
        this.m_isOver = true;
        this.retreatUnits(retreaters, retreatTo, defender, bridge);
    }

    private void attackerRetreat(IDelegateBridge bridge) {
        if (!this.canAttackerRetreat()) {
            return;
        }
        Collection<Territory> possible = this.getAttackerRetreatTerritories();
        if (!this.m_isOver) {
            if (this.m_isAmphibious) {
                this.queryRetreat(false, RetreatType.PARTIAL_AMPHIB, bridge, possible);
            } else {
                this.queryRetreat(false, RetreatType.DEFAULT, bridge, possible);
            }
        }
    }

    private void attackerRetreatPlanes(IDelegateBridge bridge) {
        ArrayList<Territory> possible = new ArrayList<Territory>(2);
        possible.add(this.m_battleSite);
        if (Match.someMatch(this.m_attackingUnits, Matches.UnitIsAir)) {
            this.queryRetreat(false, RetreatType.PLANES, bridge, possible);
        }
    }

    private void attackerRetreatNonAmphibUnits(IDelegateBridge bridge) {
        Collection<Territory> possible = this.getAttackerRetreatTerritories();
        this.queryRetreat(false, RetreatType.PARTIAL_AMPHIB, bridge, possible);
    }

    private boolean canDefenderRetreatSubs() {
        if (Match.someMatch(this.m_attackingUnits, Matches.UnitIsDestroyer)) {
            return false;
        }
        if (Match.someMatch(this.m_attackingWaitingToDie, Matches.UnitIsDestroyer)) {
            return false;
        }
        return this.getEmptyOrFriendlySeaNeighbors(this.m_defender, Match.getMatches(this.m_defendingUnits, Matches.UnitIsSub)).size() != 0 || this.canSubsSubmerge();
    }

    private void attackerRetreatSubs(IDelegateBridge bridge) {
        if (!this.canAttackerRetreatSubs()) {
            return;
        }
        if (Match.someMatch(this.m_attackingUnits, Matches.UnitIsSub)) {
            this.queryRetreat(false, RetreatType.SUBS, bridge, this.getAttackerRetreatTerritories());
        }
    }

    private void defenderRetreatSubs(IDelegateBridge bridge) {
        if (!this.canDefenderRetreatSubs()) {
            return;
        }
        if (!this.m_isOver && Match.someMatch(this.m_defendingUnits, Matches.UnitIsSub)) {
            this.queryRetreat(true, RetreatType.SUBS, bridge, this.getEmptyOrFriendlySeaNeighbors(this.m_defender, Match.getMatches(this.m_defendingUnits, Matches.UnitIsSub)));
        }
    }

    private Collection<Territory> getEmptyOrFriendlySeaNeighbors(PlayerID player, final Collection<Unit> unitsToRetreat) {
        Collection<Territory> possible = this.m_data.getMap().getNeighbors(this.m_battleSite);
        if (this.m_headless) {
            return possible;
        }
        CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, Matches.territoryHasNoEnemyUnits(player, this.m_data));
        Match<Territory> canalMatch = new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                Route r = new Route();
                r.setStart(MustFightBattle.this.m_battleSite);
                r.add(t);
                return MoveValidator.validateCanal(r, unitsToRetreat, MustFightBattle.this.m_defender, MustFightBattle.this.m_data) == null;
            }
        };
        match.add(canalMatch);
        possible = Match.getMatches(possible, match);
        return possible;
    }

    private void queryRetreat(boolean defender, RetreatType retreatType, IDelegateBridge bridge, Collection<Territory> availableTerritories) {
        PlayerID retreatingPlayer;
        List<Unit> units;
        boolean partialAmphib;
        boolean planes = retreatType == RetreatType.PLANES;
        boolean subs = retreatType == RetreatType.SUBS;
        boolean canSubsSubmerge = this.canSubsSubmerge();
        boolean submerge = subs && canSubsSubmerge;
        boolean canDefendingSubsSubmergeOrRetreat = subs && defender && Properties.getSubmarinesDefendingMaySubmergeOrRetreat(this.m_data);
        boolean bl = partialAmphib = retreatType == RetreatType.PARTIAL_AMPHIB;
        if (availableTerritories.isEmpty() && !submerge && !canDefendingSubsSubmergeOrRetreat) {
            return;
        }
        List<Unit> list = units = defender ? this.m_defendingUnits : this.m_attackingUnits;
        if (subs) {
            units = Match.getMatches(units, Matches.UnitIsSub);
        } else if (planes) {
            units = Match.getMatches(units, Matches.UnitIsAir);
        } else if (partialAmphib) {
            units = Match.getMatches(units, Matches.UnitWasNotAmphibious);
        }
        if (Match.someMatch(units, Matches.UnitIsSea)) {
            availableTerritories = Match.getMatches(availableTerritories, Matches.TerritoryIsWater);
        }
        if (canDefendingSubsSubmergeOrRetreat) {
            availableTerritories.add(this.m_battleSite);
        } else if (submerge) {
            availableTerritories.clear();
            availableTerritories.add(this.m_battleSite);
        }
        if (planes) {
            availableTerritories.clear();
            availableTerritories.add(this.m_battleSite);
        }
        if (units.size() == 0) {
            return;
        }
        PlayerID playerID = retreatingPlayer = defender ? this.m_defender : this.m_attacker;
        String text = subs ? retreatingPlayer.getName() + " retreat subs?" : (planes ? retreatingPlayer.getName() + " retreat planes?" : (partialAmphib ? retreatingPlayer.getName() + " retreat non-amphibious units?" : retreatingPlayer.getName() + " retreat?"));
        String step = defender ? this.m_defender.getName() + (canSubsSubmerge ? " submerge subs?" : " withdraw subs?") : (subs ? this.m_attacker.getName() + (canSubsSubmerge ? " submerge subs?" : " withdraw subs?") : (planes ? this.m_attacker.getName() + " withdraw planes?" : (partialAmphib ? this.m_attacker.getName() + " withdraw non-amphibious units?" : this.m_attacker.getName() + " withdraw?")));
        MustFightBattle.getDisplay(bridge).gotoBattleStep(this.m_battleID, step);
        Territory retreatTo = MustFightBattle.getRemote(retreatingPlayer, bridge).retreatQuery(this.m_battleID, submerge || canDefendingSubsSubmergeOrRetreat, this.m_battleSite, availableTerritories, text);
        if (retreatTo != null && !availableTerritories.contains(retreatTo) && !subs) {
            System.err.println("Invalid retreat selection :" + retreatTo + " not in " + MyFormatter.defaultNamedToTextList(availableTerritories));
            Thread.dumpStack();
            return;
        }
        if (retreatTo != null) {
            if (!(defender || subs || planes || partialAmphib)) {
                this.m_isOver = true;
            }
            if (subs && this.m_battleSite.equals(retreatTo) && (submerge || canDefendingSubsSubmergeOrRetreat)) {
                if (!this.m_headless) {
                    bridge.getSoundChannelBroadcaster().playSoundForAll("battle_retreat_submerge", this.m_attacker.getName());
                }
                this.submergeUnits(units, defender, bridge);
                String messageShort = retreatingPlayer.getName() + " submerges subs";
                MustFightBattle.getDisplay(bridge).notifyRetreat(messageShort, messageShort, step, retreatingPlayer);
            } else if (planes) {
                if (!this.m_headless) {
                    bridge.getSoundChannelBroadcaster().playSoundForAll("battle_retreat_air", this.m_attacker.getName());
                }
                this.retreatPlanes(units, defender, bridge);
                String messageShort = retreatingPlayer.getName() + " retreats planes";
                MustFightBattle.getDisplay(bridge).notifyRetreat(messageShort, messageShort, step, retreatingPlayer);
            } else if (partialAmphib) {
                if (!this.m_headless) {
                    if (Match.someMatch(units, Matches.UnitIsSea)) {
                        bridge.getSoundChannelBroadcaster().playSoundForAll("battle_retreat_sea", this.m_attacker.getName());
                    } else if (Match.someMatch(units, Matches.UnitIsLand)) {
                        bridge.getSoundChannelBroadcaster().playSoundForAll("battle_retreat_land", this.m_attacker.getName());
                    } else {
                        bridge.getSoundChannelBroadcaster().playSoundForAll("battle_retreat_air", this.m_attacker.getName());
                    }
                }
                units = Match.getMatches(units, Matches.UnitWasNotAmphibious);
                this.retreatUnitsAndPlanes(units, retreatTo, defender, bridge);
                String messageShort = retreatingPlayer.getName() + " retreats non-amphibious units";
                MustFightBattle.getDisplay(bridge).notifyRetreat(messageShort, messageShort, step, retreatingPlayer);
            } else {
                if (!this.m_headless) {
                    if (Match.someMatch(units, Matches.UnitIsSea)) {
                        bridge.getSoundChannelBroadcaster().playSoundForAll("battle_retreat_sea", this.m_attacker.getName());
                    } else if (Match.someMatch(units, Matches.UnitIsLand)) {
                        bridge.getSoundChannelBroadcaster().playSoundForAll("battle_retreat_land", this.m_attacker.getName());
                    } else {
                        bridge.getSoundChannelBroadcaster().playSoundForAll("battle_retreat_air", this.m_attacker.getName());
                    }
                }
                this.retreatUnits(units, retreatTo, defender, bridge);
                String messageShort = retreatingPlayer.getName() + " retreats";
                String messageLong = subs ? retreatingPlayer.getName() + " retreats subs to " + retreatTo.getName() : (planes ? retreatingPlayer.getName() + " retreats planes to " + retreatTo.getName() : (partialAmphib ? retreatingPlayer.getName() + " retreats non-amphibious units to " + retreatTo.getName() : retreatingPlayer.getName() + " retreats all units to " + retreatTo.getName()));
                MustFightBattle.getDisplay(bridge).notifyRetreat(messageShort, messageLong, step, retreatingPlayer);
            }
        }
    }

    @Override
    public List<Unit> getRemainingAttackingUnits() {
        ArrayList<Unit> remaining = new ArrayList<Unit>(this.m_attackingUnits);
        remaining.addAll(this.m_attackingUnitsRetreated);
        return remaining;
    }

    @Override
    public List<Unit> getRemainingDefendingUnits() {
        ArrayList<Unit> remaining = new ArrayList<Unit>(this.m_defendingUnits);
        remaining.addAll(this.m_defendingUnitsRetreated);
        return remaining;
    }

    private Change retreatFromDependents(Collection<Unit> units, IDelegateBridge bridge, Territory retreatTo, Collection<IBattle> dependentBattles) {
        CompositeChange change = new CompositeChange();
        for (IBattle dependent : dependentBattles) {
            Route route = new Route();
            route.setStart(this.m_battleSite);
            route.add(dependent.getTerritory());
            Collection<Unit> retreatedUnits = dependent.getDependentUnits(units);
            dependent.removeAttack(route, retreatedUnits);
            this.reLoadTransports(units, change);
            change.add(ChangeFactory.moveUnits(dependent.getTerritory(), retreatTo, retreatedUnits));
        }
        return change;
    }

    private Change retreatFromNonCombat(Collection<Unit> units, IDelegateBridge bridge, Territory retreatTo) {
        CompositeChange change = new CompositeChange();
        Collection<Unit> retreated = this.getTransportDependents(units = Match.getMatches(units, Matches.UnitIsTransport), this.m_data);
        if (!retreated.isEmpty()) {
            Territory retreatedFrom = null;
            for (Unit unit : units) {
                retreatedFrom = MustFightBattle.getTransportTracker().getTerritoryTransportHasUnloadedTo(unit);
                if (retreatedFrom == null) continue;
                this.reLoadTransports(units, change);
                change.add(ChangeFactory.moveUnits(retreatedFrom, retreatTo, retreated));
            }
        }
        return change;
    }

    public void reLoadTransports(Collection<Unit> units, CompositeChange change) {
        List<Unit> transports = Match.getMatches(units, Matches.UnitCanTransport);
        for (Unit transport : transports) {
            Collection<Unit> unloaded = MustFightBattle.getTransportTracker().unloaded(transport);
            for (Unit load : unloaded) {
                Change loadChange = MustFightBattle.getTransportTracker().loadTransportChange((TripleAUnit)transport, load, this.m_attacker);
                change.add(loadChange);
            }
        }
    }

    private void retreatPlanes(Collection<Unit> retreating, boolean defender, IDelegateBridge bridge) {
        String transcriptText = MyFormatter.unitsToText(retreating) + " retreated";
        List units = defender ? this.m_defendingUnits : this.m_attackingUnits;
        List<Unit> unitsRetreated = defender ? this.m_defendingUnitsRetreated : this.m_attackingUnitsRetreated;
        units.removeAll(retreating);
        unitsRetreated.removeAll(retreating);
        if (units.isEmpty() || this.m_isOver) {
            this.endBattle(bridge);
            if (defender) {
                this.attackerWins(bridge);
            } else {
                this.defenderWins(bridge);
            }
        } else {
            MustFightBattle.getDisplay(bridge).notifyRetreat(this.m_battleID, retreating);
        }
        bridge.getHistoryWriter().addChildToEvent(transcriptText, retreating);
    }

    private void submergeUnits(Collection<Unit> submerging, boolean defender, IDelegateBridge bridge) {
        String transcriptText = MyFormatter.unitsToText(submerging) + " Submerged";
        List units = defender ? this.m_defendingUnits : this.m_attackingUnits;
        List<Unit> unitsRetreated = defender ? this.m_defendingUnitsRetreated : this.m_attackingUnitsRetreated;
        CompositeChange change = new CompositeChange();
        for (Unit u : submerging) {
            change.add(ChangeFactory.unitPropertyChange(u, true, "submerged"));
        }
        bridge.addChange(change);
        units.removeAll(submerging);
        unitsRetreated.addAll(submerging);
        if (!units.isEmpty() && !this.m_isOver) {
            MustFightBattle.getDisplay(bridge).notifyRetreat(this.m_battleID, submerging);
        }
        bridge.getHistoryWriter().addChildToEvent(transcriptText, submerging);
    }

    private void retreatUnits(Collection<Unit> retreating, Territory to, boolean defender, IDelegateBridge bridge) {
        retreating.addAll(this.getDependentUnits(retreating));
        CompositeMatchOr notMyAir = new CompositeMatchOr(Matches.UnitIsNotAir, new InverseMatch<Unit>(Matches.unitIsOwnedBy(this.m_attacker)));
        retreating = Match.getMatches(retreating, notMyAir);
        String transcriptText = this.isWW2V2() ? MyFormatter.unitsToTextNoOwner(retreating) + " retreated to " + to.getName() : MyFormatter.unitsToText(retreating) + " retreated to " + to.getName();
        bridge.getHistoryWriter().addChildToEvent(transcriptText, new ArrayList<Unit>(retreating));
        CompositeChange change = new CompositeChange();
        change.add(ChangeFactory.moveUnits(this.m_battleSite, to, retreating));
        if (this.m_isOver) {
            Collection<IBattle> dependentBattles = this.m_battleTracker.getBlocked(this);
            if (dependentBattles.isEmpty()) {
                change.add(this.retreatFromNonCombat(retreating, bridge, to));
            } else {
                change.add(this.retreatFromDependents(retreating, bridge, to, dependentBattles));
            }
        }
        bridge.addChange(change);
        List units = defender ? this.m_defendingUnits : this.m_attackingUnits;
        List<Unit> unitsRetreated = defender ? this.m_defendingUnitsRetreated : this.m_attackingUnitsRetreated;
        units.removeAll(retreating);
        unitsRetreated.addAll(retreating);
        if (units.isEmpty() || this.m_isOver) {
            this.endBattle(bridge);
            if (defender) {
                this.attackerWins(bridge);
            } else {
                this.defenderWins(bridge);
            }
        } else {
            MustFightBattle.getDisplay(bridge).notifyRetreat(this.m_battleID, retreating);
        }
    }

    private void retreatUnitsAndPlanes(Collection<Unit> retreating, Territory to, boolean defender, IDelegateBridge bridge) {
        List units = defender ? this.m_defendingUnits : this.m_attackingUnits;
        List<Unit> unitsRetreated = defender ? this.m_defendingUnitsRetreated : this.m_attackingUnitsRetreated;
        units.removeAll(Match.getMatches(units, Matches.UnitIsAir));
        retreating.addAll(this.getDependentUnits(units));
        CompositeMatchOr notMyAir = new CompositeMatchOr(Matches.UnitIsNotAir, new InverseMatch<Unit>(Matches.unitIsOwnedBy(this.m_attacker)));
        List<Unit> nonAirRetreating = Match.getMatches(retreating, notMyAir);
        String transcriptText = MyFormatter.unitsToTextNoOwner(nonAirRetreating) + " retreated to " + to.getName();
        bridge.getHistoryWriter().addChildToEvent(transcriptText, new ArrayList<Unit>(nonAirRetreating));
        CompositeChange change = new CompositeChange();
        change.add(ChangeFactory.moveUnits(this.m_battleSite, to, nonAirRetreating));
        if (this.m_isOver) {
            Collection<IBattle> dependentBattles = this.m_battleTracker.getBlocked(this);
            if (dependentBattles.isEmpty()) {
                change.add(this.retreatFromNonCombat(nonAirRetreating, bridge, to));
            } else {
                change.add(this.retreatFromDependents(nonAirRetreating, bridge, to, dependentBattles));
            }
        }
        bridge.addChange(change);
        units.removeAll(nonAirRetreating);
        unitsRetreated.addAll(nonAirRetreating);
        if (units.isEmpty() || this.m_isOver) {
            this.endBattle(bridge);
            if (defender) {
                this.attackerWins(bridge);
            } else {
                this.defenderWins(bridge);
            }
        } else {
            MustFightBattle.getDisplay(bridge).notifyRetreat(this.m_battleID, retreating);
        }
    }

    private void fire(String stepName, Collection<Unit> firingUnits, Collection<Unit> attackableUnits, List<Unit> allEnemyUnitsAliveOrWaitingToDie, boolean defender, ReturnFire returnFire, IDelegateBridge bridge, String text) {
        PlayerID defending;
        PlayerID firing = defender ? this.m_defender : this.m_attacker;
        PlayerID playerID = defending = !defender ? this.m_defender : this.m_attacker;
        if (firingUnits.isEmpty()) {
            return;
        }
        this.m_stack.push(new Fire(attackableUnits, returnFire, firing, defending, firingUnits, stepName, text, this, defender, this.m_dependentUnits, this.m_stack, this.m_headless, this.m_battleSite, this.m_territoryEffects, allEnemyUnitsAliveOrWaitingToDie));
    }

    private void checkSuicideUnits(IDelegateBridge bridge) {
        if (this.isDefendingSuicideAndMunitionUnitsDoNotFire()) {
            List<Unit> deadUnits = Match.getMatches(this.m_attackingUnits, Matches.UnitIsSuicide);
            MustFightBattle.getDisplay(bridge).deadUnitNotification(this.m_battleID, this.m_attacker, deadUnits, this.m_dependentUnits);
            this.remove(deadUnits, bridge, this.m_battleSite, false, false);
        } else {
            ArrayList<Unit> deadUnits = new ArrayList<Unit>();
            deadUnits.addAll(Match.getMatches(this.m_defendingUnits, Matches.UnitIsSuicide));
            deadUnits.addAll(Match.getMatches(this.m_attackingUnits, Matches.UnitIsSuicide));
            MustFightBattle.getDisplay(bridge).deadUnitNotification(this.m_battleID, this.m_attacker, deadUnits, this.m_dependentUnits);
            MustFightBattle.getDisplay(bridge).deadUnitNotification(this.m_battleID, this.m_defender, deadUnits, this.m_dependentUnits);
            this.remove(deadUnits, bridge, this.m_battleSite, false, null);
        }
    }

    private void checkUndefendedTransports(IDelegateBridge bridge, PlayerID player) {
        if (player.equals(this.m_attacker) && (!this.getAttackerRetreatTerritories().isEmpty() || Match.someMatch(this.m_attackingUnits, Matches.UnitIsAir))) {
            return;
        }
        CompositeMatchAnd<Unit> matchAllied = new CompositeMatchAnd<Unit>(new Match[0]);
        matchAllied.add(Matches.UnitIsTransport);
        matchAllied.add(Matches.UnitIsNotCombatTransport);
        matchAllied.add(Matches.isUnitAllied(player, this.m_data));
        matchAllied.add(Matches.UnitIsSea);
        List<Unit> alliedTransports = Match.getMatches(this.m_battleSite.getUnits().getUnits(), matchAllied);
        if (alliedTransports.isEmpty()) {
            return;
        }
        CompositeMatchAnd<Unit> alliedUnitsMatch = new CompositeMatchAnd<Unit>(new Match[0]);
        alliedUnitsMatch.add(Matches.isUnitAllied(player, this.m_data));
        alliedUnitsMatch.add(Matches.UnitIsNotLand);
        alliedUnitsMatch.add(new InverseMatch<Unit>(Matches.unitIsSubmerged(this.m_data)));
        List<Unit> alliedUnits = Match.getMatches(this.m_battleSite.getUnits().getUnits(), alliedUnitsMatch);
        if (alliedTransports.size() == alliedUnits.size()) {
            CompositeMatchAnd<Unit> enemyUnitsMatch = new CompositeMatchAnd<Unit>(new Match[0]);
            enemyUnitsMatch.add(Matches.UnitIsNotLand);
            enemyUnitsMatch.add(Matches.unitIsNotSubmerged(this.m_data));
            enemyUnitsMatch.add(Matches.unitCanAttack(player));
            List<Unit> enemyUnits = Match.getMatches(this.m_battleSite.getUnits().getUnits(), enemyUnitsMatch);
            if (enemyUnits.size() > 0) {
                Change change = ChangeFactory.markNoMovementChange(Match.getMatches(enemyUnits, Matches.UnitIsSea));
                bridge.addChange(change);
                boolean defender = player.equals(this.m_defender);
                this.remove(alliedTransports, bridge, this.m_battleSite, false, defender);
            }
        }
    }

    private void checkForUnitsThatCanRollLeft(IDelegateBridge bridge, boolean attacker) {
        List<Unit> unitsToKill;
        boolean hasUnitsThatCanRollLeft;
        if (attacker && (!this.getAttackerRetreatTerritories().isEmpty() || Match.someMatch(this.m_attackingUnits, Matches.UnitIsAir))) {
            return;
        }
        if (this.m_attackingUnits.isEmpty() || this.m_defendingUnits.isEmpty()) {
            return;
        }
        CompositeMatchAnd<Unit> notSubmergedAndType = new CompositeMatchAnd<Unit>(Matches.unitIsNotSubmerged(this.m_data));
        if (Matches.TerritoryIsLand.match(this.m_battleSite)) {
            notSubmergedAndType.add(Matches.UnitIsSea.invert());
        } else {
            notSubmergedAndType.add(Matches.UnitIsLand.invert());
        }
        if (attacker) {
            hasUnitsThatCanRollLeft = Match.someMatch(this.m_attackingUnits, new CompositeMatchAnd(notSubmergedAndType, Matches.UnitIsSupporterOrHasCombatAbility(attacker, this.m_data)));
            unitsToKill = Match.getMatches(this.m_attackingUnits, new CompositeMatchAnd(notSubmergedAndType, Matches.UnitIsNotInfrastructure));
        } else {
            hasUnitsThatCanRollLeft = Match.someMatch(this.m_defendingUnits, new CompositeMatchAnd(notSubmergedAndType, Matches.UnitIsSupporterOrHasCombatAbility(attacker, this.m_data)));
            unitsToKill = Match.getMatches(this.m_defendingUnits, new CompositeMatchAnd(notSubmergedAndType, Matches.UnitIsNotInfrastructure));
        }
        boolean enemy = !attacker;
        boolean enemyHasUnitsThatCanRollLeft = enemy ? Match.someMatch(this.m_attackingUnits, new CompositeMatchAnd(notSubmergedAndType, Matches.UnitIsSupporterOrHasCombatAbility(enemy, this.m_data))) : Match.someMatch(this.m_defendingUnits, new CompositeMatchAnd(notSubmergedAndType, Matches.UnitIsSupporterOrHasCombatAbility(enemy, this.m_data)));
        if (!hasUnitsThatCanRollLeft && enemyHasUnitsThatCanRollLeft) {
            this.remove(unitsToKill, bridge, this.m_battleSite, false, !attacker);
        }
    }

    private void submergeSubsVsOnlyAir(IDelegateBridge bridge) {
        if (Match.allMatch(this.m_attackingUnits, Matches.UnitIsAir) && Match.someMatch(this.m_defendingUnits, Matches.UnitIsSub)) {
            List<Unit> defendingSubs = Match.getMatches(this.m_defendingUnits, Matches.UnitIsSub);
            this.submergeUnits(defendingSubs, true, bridge);
        } else if (Match.allMatch(this.m_defendingUnits, Matches.UnitIsAir) && Match.someMatch(this.m_attackingUnits, Matches.UnitIsSub)) {
            List<Unit> attackingSubs = Match.getMatches(this.m_attackingUnits, Matches.UnitIsSub);
            this.submergeUnits(attackingSubs, false, bridge);
        }
    }

    private void defendNonSubs(IDelegateBridge bridge) {
        if (this.m_attackingUnits.size() == 0) {
            return;
        }
        List<Object> units = new ArrayList<Unit>(this.m_defendingUnits.size() + this.m_defendingWaitingToDie.size());
        units.addAll(this.m_defendingUnits);
        units.addAll(this.m_defendingWaitingToDie);
        units = Match.getMatches(units, Matches.UnitIsNotSub);
        if (this.isAirAttackSubRestricted() && !this.canAirAttackSubs(this.m_attackingUnits, units)) {
            units.removeAll(Match.getMatches(units, Matches.UnitIsAir));
        }
        if (units.isEmpty()) {
            return;
        }
        ArrayList<Unit> allEnemyUnitsAliveOrWaitingToDie = new ArrayList<Unit>();
        allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_attackingUnits);
        allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_attackingWaitingToDie);
        this.fire(this.m_attacker.getName() + " select casualties", units, this.m_attackingUnits, allEnemyUnitsAliveOrWaitingToDie, true, ReturnFire.ALL, bridge, "Defenders fire, ");
    }

    private void attackAirOnNonSubs(IDelegateBridge bridge) {
        if (this.m_defendingUnits.size() == 0) {
            return;
        }
        List<Unit> units = new ArrayList<Unit>(this.m_attackingUnits.size() + this.m_attackingWaitingToDie.size());
        units.addAll(this.m_attackingUnits);
        units.addAll(this.m_attackingWaitingToDie);
        if (this.isAlliedAirDependents()) {
            units = Match.getMatches(units, Matches.unitIsOwnedBy(this.m_attacker));
        }
        if (!this.canAirAttackSubs(this.m_defendingUnits, units)) {
            units = Match.getMatches(units, Matches.UnitIsAir);
            List<Unit> enemyUnitsNotSubs = Match.getMatches(this.m_defendingUnits, Matches.UnitIsNotSub);
            ArrayList<Unit> allEnemyUnitsAliveOrWaitingToDie = new ArrayList<Unit>();
            allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_defendingUnits);
            allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_defendingWaitingToDie);
            this.fire(this.m_defender.getName() + " select casualties", units, enemyUnitsNotSubs, allEnemyUnitsAliveOrWaitingToDie, false, ReturnFire.ALL, bridge, "Attacker's aircraft fire,");
        }
    }

    private boolean canAirAttackSubs(Collection<Unit> firedAt, Collection<Unit> firing) {
        return !this.m_battleSite.isWater() || !Match.someMatch(firedAt, Matches.UnitIsSub) || !Match.noneMatch(firing, Matches.UnitIsDestroyer);
    }

    private void defendAirOnNonSubs(IDelegateBridge bridge) {
        if (this.m_attackingUnits.size() == 0) {
            return;
        }
        List<Unit> units = new ArrayList<Unit>(this.m_defendingUnits.size() + this.m_defendingWaitingToDie.size());
        units.addAll(this.m_defendingUnits);
        units.addAll(this.m_defendingWaitingToDie);
        if (!this.canAirAttackSubs(this.m_attackingUnits, units)) {
            units = Match.getMatches(units, Matches.UnitIsAir);
            List<Unit> enemyUnitsNotSubs = Match.getMatches(this.m_attackingUnits, Matches.UnitIsNotSub);
            if (enemyUnitsNotSubs.isEmpty()) {
                return;
            }
            ArrayList<Unit> allEnemyUnitsAliveOrWaitingToDie = new ArrayList<Unit>();
            allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_attackingUnits);
            allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_attackingWaitingToDie);
            this.fire(this.m_attacker.getName() + " select casualties", units, enemyUnitsNotSubs, allEnemyUnitsAliveOrWaitingToDie, true, ReturnFire.ALL, bridge, "Defender's aircraft fire,");
        }
    }

    private void attackNonSubs(IDelegateBridge bridge) {
        if (this.m_defendingUnits.size() == 0) {
            return;
        }
        List<Unit> units = Match.getMatches(this.m_attackingUnits, Matches.UnitIsNotSub);
        units.addAll(Match.getMatches(this.m_attackingWaitingToDie, Matches.UnitIsNotSub));
        if (this.isAlliedAirDependents()) {
            units = Match.getMatches(units, Matches.unitIsOwnedBy(this.m_attacker));
        }
        if (this.isAirAttackSubRestricted() && !this.canAirAttackSubs(this.m_defendingUnits, units)) {
            units.removeAll(Match.getMatches(units, Matches.UnitIsAir));
        }
        if (units.isEmpty()) {
            return;
        }
        ArrayList<Unit> allEnemyUnitsAliveOrWaitingToDie = new ArrayList<Unit>();
        allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_defendingUnits);
        allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_defendingWaitingToDie);
        this.fire(this.m_defender.getName() + " select casualties", units, this.m_defendingUnits, allEnemyUnitsAliveOrWaitingToDie, false, ReturnFire.ALL, bridge, "Attackers fire,");
    }

    private void attackSubs(IDelegateBridge bridge, ReturnFire returnFire) {
        List<Unit> firing = Match.getMatches(this.m_attackingUnits, Matches.UnitIsSub);
        if (firing.isEmpty()) {
            return;
        }
        List<Unit> attacked = Match.getMatches(this.m_defendingUnits, Matches.UnitIsNotAir);
        ArrayList<Unit> allEnemyUnitsAliveOrWaitingToDie = new ArrayList<Unit>();
        allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_defendingUnits);
        allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_defendingWaitingToDie);
        this.fire(this.m_defender.getName() + " select sub casualties", firing, attacked, allEnemyUnitsAliveOrWaitingToDie, false, returnFire, bridge, "Subs fire,");
    }

    private void defendSubs(IDelegateBridge bridge, ReturnFire returnFire) {
        if (this.m_attackingUnits.size() == 0) {
            return;
        }
        List<Object> firing = new ArrayList<Unit>(this.m_defendingUnits.size() + this.m_defendingWaitingToDie.size());
        firing.addAll(this.m_defendingUnits);
        firing.addAll(this.m_defendingWaitingToDie);
        firing = Match.getMatches(firing, Matches.UnitIsSub);
        if (firing.isEmpty()) {
            return;
        }
        List<Unit> attacked = Match.getMatches(this.m_attackingUnits, Matches.UnitIsNotAir);
        if (attacked.isEmpty()) {
            return;
        }
        ArrayList<Unit> allEnemyUnitsAliveOrWaitingToDie = new ArrayList<Unit>();
        allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_attackingUnits);
        allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_attackingWaitingToDie);
        this.fire(this.m_attacker.getName() + " select sub casualties", firing, attacked, allEnemyUnitsAliveOrWaitingToDie, true, returnFire, bridge, "Subs defend, ");
    }

    void removeCasualties(Collection<Unit> killed, ReturnFire returnFire, boolean defender, IDelegateBridge bridge, boolean isAA) {
        if (killed.isEmpty()) {
            return;
        }
        if (returnFire == ReturnFire.ALL) {
            if (defender) {
                this.m_defendingWaitingToDie.addAll(killed);
            } else {
                this.m_attackingWaitingToDie.addAll(killed);
            }
        } else if (returnFire == ReturnFire.SUBS) {
            if (defender) {
                this.m_defendingWaitingToDie.addAll(Match.getMatches(killed, Matches.UnitIsSub));
            } else {
                this.m_attackingWaitingToDie.addAll(Match.getMatches(killed, Matches.UnitIsSub));
            }
            this.remove(Match.getMatches(killed, Matches.UnitIsNotSub), bridge, this.m_battleSite, isAA, defender);
        } else if (returnFire == ReturnFire.NONE) {
            this.remove(killed, bridge, this.m_battleSite, isAA, defender);
        }
        if (defender) {
            this.m_defendingUnits.removeAll(killed);
        } else {
            this.m_attackingUnits.removeAll(killed);
        }
    }

    private void fireNavalBombardment(IDelegateBridge bridge) {
        Collection<Unit> bombard = this.getBombardingUnits();
        List<Unit> attacked = Match.getMatches(this.m_defendingUnits, Matches.UnitIsNotInfrastructureAndNotCapturedOnEntering(this.m_attacker, this.m_battleSite, this.m_data));
        if (!this.m_headless) {
            Change change = ChangeFactory.markNoMovementChange(bombard);
            bridge.addChange(change);
        }
        boolean canReturnFire = this.isNavalBombardCasualtiesReturnFire();
        if (bombard.size() > 0 && attacked.size() > 0) {
            if (!this.m_headless) {
                bridge.getSoundChannelBroadcaster().playSoundForAll("battle_bombard", this.m_attacker.getName());
            }
            ArrayList<Unit> allEnemyUnitsAliveOrWaitingToDie = new ArrayList<Unit>();
            allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_defendingUnits);
            allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_defendingWaitingToDie);
            this.fire("Select naval bombardment casualties", bombard, attacked, allEnemyUnitsAliveOrWaitingToDie, false, canReturnFire ? ReturnFire.ALL : ReturnFire.NONE, bridge, "Bombard");
        }
    }

    private void fireSuicideUnitsAttack(IDelegateBridge bridge) {
        CompositeMatchAnd attackableUnits = new CompositeMatchAnd(Matches.UnitIsNotInfrastructureAndNotCapturedOnEntering(this.m_attacker, this.m_battleSite, this.m_data), Matches.UnitIsSuicide.invert(), Matches.unitIsBeingTransported().invert());
        List<Unit> suicideAttackers = Match.getMatches(this.m_attackingUnits, Matches.UnitIsSuicide);
        List<Unit> attackedDefenders = Match.getMatches(this.m_defendingUnits, attackableUnits);
        if (this.isAirAttackSubRestricted() && !Match.someMatch(this.m_attackingUnits, Matches.UnitIsDestroyer) && Match.someMatch(attackedDefenders, Matches.UnitIsSub)) {
            attackedDefenders.removeAll(Match.getMatches(attackedDefenders, Matches.UnitIsSub));
        }
        if (Match.allMatch(suicideAttackers, Matches.UnitIsSub)) {
            attackedDefenders.removeAll(Match.getMatches(attackedDefenders, Matches.UnitIsAir));
        }
        if (suicideAttackers.size() == 0 || attackedDefenders.size() == 0) {
            return;
        }
        boolean canReturnFire = !this.isSuicideAndMunitionCasualtiesRestricted();
        ArrayList<Unit> allEnemyUnitsAliveOrWaitingToDie = new ArrayList<Unit>();
        allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_defendingUnits);
        allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_defendingWaitingToDie);
        this.fire(this.m_defender.getName() + " select suicide casualties", suicideAttackers, attackedDefenders, allEnemyUnitsAliveOrWaitingToDie, false, canReturnFire ? ReturnFire.ALL : ReturnFire.NONE, bridge, "Suicide and Munition units Attack");
    }

    private void fireSuicideUnitsDefend(IDelegateBridge bridge) {
        if (this.isDefendingSuicideAndMunitionUnitsDoNotFire()) {
            return;
        }
        CompositeMatchAnd attackableUnits = new CompositeMatchAnd(Matches.UnitIsNotInfrastructure, Matches.UnitIsSuicide.invert(), Matches.unitIsBeingTransported().invert());
        List<Unit> suicideDefenders = Match.getMatches(this.m_defendingUnits, Matches.UnitIsSuicide);
        List<Unit> attackedAttackers = Match.getMatches(this.m_attackingUnits, attackableUnits);
        if (this.isAirAttackSubRestricted() && !Match.someMatch(this.m_defendingUnits, Matches.UnitIsDestroyer) && Match.someMatch(attackedAttackers, Matches.UnitIsSub)) {
            attackedAttackers.removeAll(Match.getMatches(attackedAttackers, Matches.UnitIsSub));
        }
        if (Match.allMatch(suicideDefenders, Matches.UnitIsSub)) {
            suicideDefenders.removeAll(Match.getMatches(suicideDefenders, Matches.UnitIsAir));
        }
        if (suicideDefenders.size() == 0 || attackedAttackers.size() == 0) {
            return;
        }
        boolean canReturnFire = !this.isSuicideAndMunitionCasualtiesRestricted();
        ArrayList<Unit> allEnemyUnitsAliveOrWaitingToDie = new ArrayList<Unit>();
        allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_attackingUnits);
        allEnemyUnitsAliveOrWaitingToDie.addAll(this.m_attackingWaitingToDie);
        this.fire(this.m_attacker.getName() + " select suicide casualties", suicideDefenders, attackedAttackers, allEnemyUnitsAliveOrWaitingToDie, true, canReturnFire ? ReturnFire.ALL : ReturnFire.NONE, bridge, "Suicide and Munition units Defend");
    }

    private boolean isWW2V2() {
        return Properties.getWW2V2(this.m_data);
    }

    private boolean isWW2V3() {
        return Properties.getWW2V3(this.m_data);
    }

    private boolean isPartialAmphibiousRetreat() {
        return Properties.getPartialAmphibiousRetreat(this.m_data);
    }

    private boolean isParatroopers(PlayerID player) {
        TechAttachment ta = (TechAttachment)player.getAttachment("techAttatchment");
        if (ta == null) {
            return false;
        }
        return ta.getParatroopers();
    }

    private boolean isAlliedAirDependents() {
        return Properties.getAlliedAirDependents(this.m_data);
    }

    private boolean isDefendingSubsSneakAttack() {
        return Properties.getDefendingSubsSneakAttack(this.m_data);
    }

    private boolean isAttackerRetreatPlanes() {
        return Properties.getAttackerRetreatPlanes(this.m_data);
    }

    private boolean isNavalBombardCasualtiesReturnFire() {
        return Properties.getNavalBombardCasualtiesReturnFireRestricted(this.m_data);
    }

    private boolean isSuicideAndMunitionCasualtiesRestricted() {
        return Properties.getSuicideAndMunitionCasualtiesRestricted(this.m_data);
    }

    private boolean isDefendingSuicideAndMunitionUnitsDoNotFire() {
        return Properties.getDefendingSuicideAndMunitionUnitsDoNotFire(this.m_data);
    }

    private boolean isAirAttackSubRestricted() {
        return Properties.getAirAttackSubRestricted(this.m_data);
    }

    private boolean isSubRetreatBeforeBattle() {
        return Properties.getSubRetreatBeforeBattle(this.m_data);
    }

    private boolean isTransportCasualtiesRestricted() {
        return Properties.getTransportCasualtiesRestricted(this.m_data);
    }

    public Collection<Territory> getAmphibiousAttackTerritories() {
        return this.m_amphibiousAttackFrom;
    }

    private void fireOffensiveAAGuns(IDelegateBridge bridge) {
        this.m_stack.push(new FireAA(false));
    }

    private void fireDefensiveAAGuns(IDelegateBridge bridge) {
        this.m_stack.push(new FireAA(true));
    }

    private boolean canFireDefendingAA() {
        if (this.m_defendingAA == null) {
            this.updateDefendingAAUnits();
        }
        return this.m_defendingAA.size() > 0;
    }

    private boolean canFireOffensiveAA() {
        if (this.m_offensiveAA == null) {
            this.updateOffensiveAAUnits();
        }
        return this.m_offensiveAA.size() > 0;
    }

    private List<Unit> removeNonCombatants(Collection<Unit> units, boolean attacking, PlayerID player, boolean doNotIncludeAA, boolean doNotIncludeSeaBombardmentUnits, boolean removeForNextRound) {
        ArrayList<Unit> unitList = new ArrayList<Unit>(units);
        if (this.m_battleSite.isWater()) {
            unitList.removeAll(Match.getMatches(unitList, Matches.UnitIsLand));
        }
        unitList.removeAll(Match.getMatches(unitList, Matches.UnitCanBeInBattle(attacking, !this.m_battleSite.isWater(), this.m_data, removeForNextRound ? this.m_round + 1 : this.m_round, true, doNotIncludeAA, doNotIncludeSeaBombardmentUnits).invert()));
        unitList.removeAll(Match.getMatches(unitList, Matches.UnitIsDisabled()));
        unitList.removeAll(Match.getMatches(unitList, Matches.UnitCanBeCapturedOnEnteringToInThisTerritory(this.m_attacker, this.m_battleSite, this.m_data)));
        unitList.removeAll(Match.getMatches(unitList, new CompositeMatchAnd(Matches.unitIsBeingTransported(), Matches.UnitIsAir, Matches.UnitCanLandOnCarrier)));
        unitList.removeAll(Match.getMatches(unitList, Matches.UnitWasInAirBattle));
        return unitList;
    }

    private void removeNonCombatants(IDelegateBridge bridge, boolean doNotIncludeAA, boolean doNotIncludeSeaBombardmentUnits, boolean removeForNextRound) {
        List<Unit> notRemovedDefending = this.removeNonCombatants(this.m_defendingUnits, false, this.m_defender, doNotIncludeAA, doNotIncludeSeaBombardmentUnits, removeForNextRound);
        List<Unit> notRemovedAttacking = this.removeNonCombatants(this.m_attackingUnits, true, this.m_attacker, doNotIncludeAA, doNotIncludeSeaBombardmentUnits, removeForNextRound);
        List<Unit> toRemoveDefending = Util.difference(this.m_defendingUnits, notRemovedDefending);
        List<Unit> toRemoveAttacking = Util.difference(this.m_attackingUnits, notRemovedAttacking);
        this.m_defendingUnits = notRemovedDefending;
        this.m_attackingUnits = notRemovedAttacking;
        if (!this.m_headless) {
            if (!toRemoveDefending.isEmpty()) {
                MustFightBattle.getDisplay(bridge).changedUnitsNotification(this.m_battleID, this.m_defender, toRemoveDefending, null, null);
            }
            if (!toRemoveAttacking.isEmpty()) {
                MustFightBattle.getDisplay(bridge).changedUnitsNotification(this.m_battleID, this.m_attacker, toRemoveAttacking, null, null);
            }
        }
    }

    private void landParatroops(IDelegateBridge bridge) {
        Collection<Unit> dependents;
        List<Unit> airTransports;
        if (this.isParatroopers(this.m_attacker) && !(airTransports = Match.getMatches(this.m_battleSite.getUnits().getUnits(), Matches.UnitIsAirTransport)).isEmpty() && !(dependents = this.getDependentUnits(airTransports)).isEmpty()) {
            Iterator<Unit> dependentsIter = dependents.iterator();
            CompositeChange change = new CompositeChange();
            while (dependentsIter.hasNext()) {
                Unit unit = dependentsIter.next();
                change.add(DelegateFinder.moveDelegate(this.m_data).getTransportTracker().unloadAirTransportChange((TripleAUnit)unit, this.m_battleSite, this.m_attacker, false));
            }
            bridge.addChange(change);
            for (Unit unit : airTransports) {
                this.m_dependentUnits.remove(unit);
            }
        }
    }

    private void markNoMovementLeft(IDelegateBridge bridge) {
        if (this.m_headless) {
            return;
        }
        List<Unit> attackingNonAir = Match.getMatches(this.m_attackingUnits, Matches.UnitIsAir.invert());
        Change noMovementChange = ChangeFactory.markNoMovementChange(attackingNonAir);
        if (!noMovementChange.isEmpty()) {
            bridge.addChange(noMovementChange);
        }
    }

    public Collection<Unit> getTransportDependents(Collection<Unit> targets, GameData data) {
        if (this.m_headless) {
            return Collections.emptyList();
        }
        ArrayList<Unit> dependents = new ArrayList<Unit>();
        if (Match.someMatch(targets, Matches.UnitCanTransport)) {
            TransportTracker tracker = DelegateFinder.moveDelegate(data).getTransportTracker();
            for (Unit target : targets) {
                dependents.addAll(tracker.transportingAndUnloaded(target));
            }
        }
        return dependents;
    }

    private void remove(Collection<Unit> killed, IDelegateBridge bridge, Territory battleSite, boolean isAA, Boolean defenderDying) {
        if (killed.size() == 0) {
            return;
        }
        Collection<Unit> dependent = this.getDependentUnits(killed);
        killed.addAll(dependent);
        Change killedChange = ChangeFactory.removeUnits(battleSite, killed);
        this.m_killed.addAll(killed);
        String transcriptText = MyFormatter.unitsToText(killed) + " lost in " + battleSite.getName();
        bridge.getHistoryWriter().addChildToEvent(transcriptText, killed);
        bridge.addChange(killedChange);
        Collection<IBattle> dependentBattles = this.m_battleTracker.getBlocked(this);
        if (dependentBattles.isEmpty()) {
            this.removeFromNonCombatLandings(killed, bridge);
        } else {
            this.removeFromDependents(killed, bridge, dependentBattles);
        }
        if (defenderDying == null || defenderDying.booleanValue()) {
            this.m_defendingUnits.removeAll(killed);
        }
        if (defenderDying == null || !defenderDying.booleanValue()) {
            this.m_attackingUnits.removeAll(killed);
        }
    }

    private void removeFromDependents(Collection<Unit> units, IDelegateBridge bridge, Collection<IBattle> dependents) {
        for (IBattle dependent : dependents) {
            dependent.unitsLostInPrecedingBattle(this, units, bridge, false);
        }
    }

    private void removeFromNonCombatLandings(Collection<Unit> units, IDelegateBridge bridge) {
        for (Unit transport : Match.getMatches(units, Matches.UnitIsTransport)) {
            Collection<Unit> lost = this.getTransportDependents(Collections.singleton(transport), this.m_data);
            if (lost.isEmpty()) continue;
            Territory landedTerritory = MustFightBattle.getTransportTracker().getTerritoryTransportHasUnloadedTo(transport);
            if (landedTerritory == null) {
                throw new IllegalStateException("not unloaded?:" + units);
            }
            this.remove(lost, bridge, landedTerritory, false, false);
        }
    }

    private void clearWaitingToDie(IDelegateBridge bridge) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        units.addAll(this.m_attackingWaitingToDie);
        units.addAll(this.m_defendingWaitingToDie);
        this.remove(units, bridge, this.m_battleSite, false, null);
        this.m_defendingWaitingToDie.clear();
        this.m_attackingWaitingToDie.clear();
    }

    private void defenderWins(IDelegateBridge bridge) {
        this.m_whoWon = IBattle.WhoWon.DEFENDER;
        MustFightBattle.getDisplay(bridge).battleEnd(this.m_battleID, this.m_defender.getName() + " win");
        bridge.getHistoryWriter().addChildToEvent(this.m_defender.getName() + " win", this.m_defendingUnits);
        this.m_battleResultDescription = BattleRecord.BattleResultDescription.LOST;
        this.showCasualties(bridge);
        if (!this.m_headless) {
            this.m_battleTracker.getBattleRecords(this.m_data).addResultToBattle(this.m_attacker, this.m_battleID, this.m_defender, this.m_attackerLostTUV, this.m_defenderLostTUV, this.m_battleResultDescription, new BattleResults(this, this.m_data), 0);
        }
        this.checkDefendingPlanesCanLand(bridge, this.m_defender);
        BattleTracker.captureOrDestroyUnits(this.m_battleSite, this.m_defender, this.m_defender, bridge, null, this.m_defendingUnits);
        if (!this.m_headless) {
            bridge.getSoundChannelBroadcaster().playSoundForAll("battle_failure", this.m_attacker.getName());
        }
    }

    private void nobodyWins(IDelegateBridge bridge) {
        this.m_whoWon = IBattle.WhoWon.DRAW;
        MustFightBattle.getDisplay(bridge).battleEnd(this.m_battleID, "Stalemate");
        bridge.getHistoryWriter().addChildToEvent(this.m_defender.getName() + " and " + this.m_attacker.getName() + " reach a stalemate");
        this.m_battleResultDescription = BattleRecord.BattleResultDescription.STALEMATE;
        this.showCasualties(bridge);
        if (!this.m_headless) {
            this.m_battleTracker.getBattleRecords(this.m_data).addResultToBattle(this.m_attacker, this.m_battleID, this.m_defender, this.m_attackerLostTUV, this.m_defenderLostTUV, this.m_battleResultDescription, new BattleResults(this, this.m_data), 0);
            bridge.getSoundChannelBroadcaster().playSoundForAll("battle_stalemate", this.m_attacker.getName());
        }
    }

    private void checkDefendingPlanesCanLand(IDelegateBridge bridge, PlayerID defender) {
        if (this.m_headless) {
            return;
        }
        if (!this.m_battleSite.isWater()) {
            return;
        }
        CompositeMatchAnd alliedDefendingAir = new CompositeMatchAnd(Matches.UnitIsAir, Matches.UnitWasScrambled.invert());
        this.m_defendingAir = Match.getMatches(this.m_defendingUnits, alliedDefendingAir);
        if (this.m_defendingAir.isEmpty()) {
            return;
        }
        int carrierCost = AirMovementValidator.carrierCost(this.m_defendingAir);
        int carrierCapacity = AirMovementValidator.carrierCapacity(this.m_defendingUnits, this.m_battleSite);
        if (carrierCapacity >= (carrierCost += AirMovementValidator.carrierCost(Match.getMatches(this.getDependentUnits(this.m_defendingUnits), alliedDefendingAir)))) {
            return;
        }
        carrierCost = 0;
        carrierCost += AirMovementValidator.carrierCost(Match.getMatches(this.getDependentUnits(this.m_defendingUnits), alliedDefendingAir));
        for (Unit currentUnit : new ArrayList<Unit>(this.m_defendingAir)) {
            if (!Matches.UnitCanLandOnCarrier.match(currentUnit)) {
                this.m_defendingAir.remove(currentUnit);
                continue;
            }
            if (carrierCapacity < (carrierCost += UnitAttachment.get(currentUnit.getType()).getCarrierCost())) continue;
            this.m_defendingAir.remove(currentUnit);
        }
        this.m_battleTracker.addToDefendingAirThatCanNotLand(this.m_defendingAir, this.m_battleSite);
    }

    private void attackerWins(IDelegateBridge bridge) {
        CompositeChange clearAlliedAir;
        this.m_whoWon = IBattle.WhoWon.ATTACKER;
        MustFightBattle.getDisplay(bridge).battleEnd(this.m_battleID, this.m_attacker.getName() + " win");
        if (this.m_headless) {
            return;
        }
        if (Match.someMatch(this.m_attackingUnits, Matches.UnitIsNotAir)) {
            this.m_battleTracker.addToConquered(this.m_battleSite);
            this.m_battleTracker.takeOver(this.m_battleSite, this.m_attacker, bridge, null, this.m_attackingUnits);
            this.m_battleResultDescription = BattleRecord.BattleResultDescription.CONQUERED;
        } else {
            this.m_battleResultDescription = BattleRecord.BattleResultDescription.WON_WITHOUT_CONQUERING;
        }
        List<Unit> transports = Match.getMatches(this.m_attackingUnits, Matches.UnitIsTransport);
        if (!transports.isEmpty()) {
            CompositeChange change = new CompositeChange();
            Collection<Unit> dependents = this.getTransportDependents(transports, this.m_data);
            if (!dependents.isEmpty()) {
                for (Unit unit : dependents) {
                    if (!Matches.UnitWasUnloadedThisTurn.match(unit)) continue;
                    change.add(ChangeFactory.unitPropertyChange(unit, null, "transportedBy"));
                }
                bridge.addChange(change);
            }
        }
        if (!(clearAlliedAir = MustFightBattle.clearTransportedByForAlliedAirOnCarrier(this.m_attackingUnits, this.m_battleSite, this.m_attacker, this.m_data)).isEmpty()) {
            bridge.addChange(clearAlliedAir);
        }
        bridge.getHistoryWriter().addChildToEvent(this.m_attacker.getName() + " win", this.m_attackingUnits);
        this.showCasualties(bridge);
        if (!this.m_headless) {
            this.m_battleTracker.getBattleRecords(this.m_data).addResultToBattle(this.m_attacker, this.m_battleID, this.m_defender, this.m_attackerLostTUV, this.m_defenderLostTUV, this.m_battleResultDescription, new BattleResults(this, this.m_data), 0);
        }
        if (!this.m_headless) {
            if (Matches.TerritoryIsWater.match(this.m_battleSite)) {
                if (Match.allMatch(this.m_attackingUnits, Matches.UnitIsAir)) {
                    bridge.getSoundChannelBroadcaster().playSoundForAll("battle_air_successful", this.m_attacker.getName());
                } else {
                    bridge.getSoundChannelBroadcaster().playSoundForAll("battle_sea_successful", this.m_attacker.getName());
                }
            } else if (Match.allMatch(this.m_attackingUnits, Matches.UnitIsAir)) {
                bridge.getSoundChannelBroadcaster().playSoundForAll("battle_air_successful", this.m_attacker.getName());
            }
        }
    }

    public static CompositeChange clearTransportedByForAlliedAirOnCarrier(Collection<Unit> attackingUnits, Territory battleSite, PlayerID attacker, GameData data) {
        CompositeChange change = new CompositeChange();
        List<Unit> carriers = Match.getMatches(attackingUnits, Matches.UnitIsCarrier);
        if (!carriers.isEmpty() && Properties.getAlliedAirDependents(data)) {
            CompositeMatchAnd alliedFighters = new CompositeMatchAnd(Matches.isUnitAllied(attacker, data), Matches.unitIsOwnedBy(attacker).invert(), Matches.UnitIsAir, Matches.UnitCanLandOnCarrier);
            List<Unit> alliedAirInTerr = Match.getMatches(battleSite.getUnits().getUnits(), alliedFighters);
            for (Unit fighter : alliedAirInTerr) {
                TripleAUnit taUnit = (TripleAUnit)fighter;
                if (taUnit.getTransportedBy() == null) continue;
                Unit carrierTransportingThisUnit = taUnit.getTransportedBy();
                if (Matches.UnitHasWhenCombatDamagedEffect("unitsMayNotLeaveAlliedCarrier").match(carrierTransportingThisUnit)) continue;
                change.add(ChangeFactory.unitPropertyChange(fighter, null, "transportedBy"));
            }
        }
        return change;
    }

    private void showCasualties(IDelegateBridge bridge) {
        if (this.m_killed.isEmpty()) {
            return;
        }
        IntegerMap<UnitType> costs = BattleCalculator.getCostsForTUV(this.m_attacker, this.m_data);
        int tuvLostAttacker = BattleCalculator.getTUV(this.m_killed, this.m_attacker, costs, this.m_data);
        costs = BattleCalculator.getCostsForTUV(this.m_defender, this.m_data);
        int tuvLostDefender = BattleCalculator.getTUV(this.m_killed, this.m_defender, costs, this.m_data);
        int tuvChange = tuvLostDefender - tuvLostAttacker;
        bridge.getHistoryWriter().addChildToEvent("Battle casualty summary: Battle score (TUV change) for attacker is " + tuvChange, this.m_killed);
        this.m_attackerLostTUV += tuvLostAttacker;
        this.m_defenderLostTUV += tuvLostDefender;
    }

    private void endBattle(IDelegateBridge bridge) {
        this.clearWaitingToDie(bridge);
        this.m_isOver = true;
        this.m_battleTracker.removeBattle(this);
    }

    @Override
    public String toString() {
        return "Battle in:" + this.m_battleSite + " battle type:" + (Object)((Object)this.m_battleType) + " defender:" + this.m_defender.getName() + " attacked by:" + this.m_attacker.getName() + " from:" + this.m_attackingFrom + " attacking with: " + this.m_attackingUnits;
    }

    public void sortAmphib(List<Unit> units, GameData data) {
        final Comparator<Unit> decreasingMovement = UnitComparator.getLowestToHighestMovementComparator();
        Comparator<Unit> comparator = new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                int amphibComp = 0;
                if (u1.getUnitType().equals(u2.getUnitType())) {
                    UnitAttachment ua = UnitAttachment.get(u1.getType());
                    UnitAttachment ua2 = UnitAttachment.get(u2.getType());
                    if (ua.getIsMarine() != 0 && ua2.getIsMarine() != 0) {
                        amphibComp = MustFightBattle.this.compareAccordingToAmphibious(u1, u2);
                    }
                    if (amphibComp == 0) {
                        return decreasingMovement.compare(u1, u2);
                    }
                    return amphibComp;
                }
                return u1.getUnitType().getName().compareTo(u2.getUnitType().getName());
            }
        };
        Collections.sort(units, comparator);
    }

    private int compareAccordingToAmphibious(Unit u1, Unit u2) {
        if (this.m_amphibiousLandAttackers.contains(u1) && !this.m_amphibiousLandAttackers.contains(u2)) {
            return -1;
        }
        if (this.m_amphibiousLandAttackers.contains(u2) && !this.m_amphibiousLandAttackers.contains(u1)) {
            return 1;
        }
        int m1 = UnitAttachment.get(u1.getType()).getIsMarine();
        int m2 = UnitAttachment.get(u2.getType()).getIsMarine();
        return m2 - m1;
    }

    public Collection<Territory> getAttackingFrom() {
        return this.m_attackingFrom;
    }

    public Map<Territory, Collection<Unit>> getAttackingFromMap() {
        return this.m_attackingFromMap;
    }

    public void setAttackingFromAndMap(Map<Territory, Collection<Unit>> attackingFromMap) {
        this.m_attackingFromMap = attackingFromMap;
        this.m_attackingFrom = new HashSet<Territory>(attackingFromMap.keySet());
    }

    @Override
    public void unitsLostInPrecedingBattle(IBattle battle, Collection<Unit> units, IDelegateBridge bridge, boolean withdrawn) {
        Collection<Unit> lost = this.getDependentUnits(units);
        lost.addAll(Util.intersection(units, this.m_attackingUnits));
        this.m_amphibiousLandAttackers.removeAll(lost);
        if (this.m_amphibiousLandAttackers.isEmpty()) {
            this.m_isAmphibious = false;
            this.m_bombardingUnits.clear();
        }
        this.m_attackingUnits.removeAll(lost);
        lost = Match.getMatches(lost, Matches.unitIsInTerritory(this.m_battleSite));
        if (!withdrawn) {
            this.remove(lost, bridge, this.m_battleSite, false, false);
        }
        if (this.m_attackingUnits.isEmpty()) {
            IntegerMap<UnitType> costs = BattleCalculator.getCostsForTUV(this.m_attacker, this.m_data);
            int tuvLostAttacker = withdrawn ? 0 : BattleCalculator.getTUV(lost, this.m_attacker, costs, this.m_data);
            this.m_attackerLostTUV += tuvLostAttacker;
            this.m_whoWon = IBattle.WhoWon.DEFENDER;
            if (!this.m_headless) {
                this.m_battleTracker.getBattleRecords(this.m_data).addResultToBattle(this.m_attacker, this.m_battleID, this.m_defender, this.m_attackerLostTUV, this.m_defenderLostTUV, BattleRecord.BattleResultDescription.LOST, new BattleResults(this, this.m_data), 0);
            }
            this.m_battleTracker.removeBattle(this);
        }
    }

    private Map<Unit, Collection<Unit>> transporting(Collection<Unit> units) {
        return MustFightBattle.getTransportTracker().transporting(units);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FireAA
    implements IExecutable {
        private static final long serialVersionUID = -6406659798754841382L;
        private final boolean m_defending;
        private DiceRoll m_dice;
        private CasualtyDetails m_casualties;
        Collection<Unit> m_casualtiesSoFar = new ArrayList<Unit>();

        private FireAA(boolean defending) {
            this.m_defending = defending;
        }

        @Override
        public void execute(ExecutionStack stack, IDelegateBridge bridge) {
            if (this.m_defending && !MustFightBattle.this.canFireDefendingAA() || !this.m_defending && !MustFightBattle.this.canFireOffensiveAA()) {
                return;
            }
            for (final String currentTypeAA : this.m_defending ? MustFightBattle.this.m_defendingAAtypes : MustFightBattle.this.m_offensiveAAtypes) {
                final List<Unit> currentPossibleAA = Match.getMatches(this.m_defending ? MustFightBattle.this.m_defendingAA : MustFightBattle.this.m_offensiveAA, Matches.UnitIsAAofTypeAA(currentTypeAA));
                HashSet<UnitType> targetUnitTypesForThisTypeAA = UnitAttachment.get(((Unit)currentPossibleAA.iterator().next()).getType()).getTargetsAA(MustFightBattle.this.m_data);
                HashSet<UnitType> airborneTypesTargettedToo = this.m_defending ? TechAbilityAttachment.getAirborneTargettedByAA(MustFightBattle.this.m_attacker, MustFightBattle.this.m_data).get(currentTypeAA) : new HashSet<UnitType>();
                final List validAttackingUnitsForThisRoll = Match.getMatches(this.m_defending ? MustFightBattle.this.m_attackingUnits : MustFightBattle.this.m_defendingUnits, new CompositeMatchOr(Matches.unitIsOfTypes(targetUnitTypesForThisTypeAA), new CompositeMatchAnd(Matches.UnitIsAirborne, Matches.unitIsOfTypes(airborneTypesTargettedToo))));
                IExecutable rollDice = new IExecutable(){
                    private static final long serialVersionUID = 6435935558879109347L;

                    public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                        validAttackingUnitsForThisRoll.removeAll(FireAA.this.m_casualtiesSoFar);
                        if (!validAttackingUnitsForThisRoll.isEmpty()) {
                            FireAA.this.m_dice = DiceRoll.rollAA(validAttackingUnitsForThisRoll, currentPossibleAA, bridge, MustFightBattle.this.m_battleSite, FireAA.this.m_defending);
                            if (!MustFightBattle.this.m_headless) {
                                if (currentTypeAA.equals("AA")) {
                                    if (FireAA.this.m_dice.getHits() > 0) {
                                        bridge.getSoundChannelBroadcaster().playSoundForAll("battle_aa_hit", FireAA.this.m_defending ? MustFightBattle.this.m_defender.getName() : MustFightBattle.this.m_attacker.getName());
                                    } else {
                                        bridge.getSoundChannelBroadcaster().playSoundForAll("battle_aa_miss", FireAA.this.m_defending ? MustFightBattle.this.m_defender.getName() : MustFightBattle.this.m_attacker.getName());
                                    }
                                } else if (FireAA.this.m_dice.getHits() > 0) {
                                    bridge.getSoundChannelBroadcaster().playSoundForAll("battle_" + currentTypeAA.toLowerCase() + "_hit", FireAA.this.m_defending ? MustFightBattle.this.m_defender.getName() : MustFightBattle.this.m_attacker.getName());
                                } else {
                                    bridge.getSoundChannelBroadcaster().playSoundForAll("battle_" + currentTypeAA.toLowerCase() + "_miss", FireAA.this.m_defending ? MustFightBattle.this.m_defender.getName() : MustFightBattle.this.m_attacker.getName());
                                }
                            }
                        }
                    }
                };
                IExecutable selectCasualties = new IExecutable(){
                    private static final long serialVersionUID = 7943295620796835166L;

                    public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                        if (!validAttackingUnitsForThisRoll.isEmpty()) {
                            CasualtyDetails details = FireAA.this.selectCasualties(validAttackingUnitsForThisRoll, currentPossibleAA, bridge, currentTypeAA);
                            MustFightBattle.this.markDamaged(details.getDamaged(), bridge);
                            FireAA.this.m_casualties = details;
                            FireAA.this.m_casualtiesSoFar.addAll(details.getKilled());
                        }
                    }
                };
                IExecutable notifyCasualties = new IExecutable(){
                    private static final long serialVersionUID = -6759782085212899725L;

                    public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                        if (!validAttackingUnitsForThisRoll.isEmpty()) {
                            FireAA.this.notifyCasualtiesAA(bridge, currentTypeAA);
                            MustFightBattle.this.removeCasualties(FireAA.this.m_casualties.getKilled(), ReturnFire.ALL, !FireAA.this.m_defending, bridge, FireAA.this.m_defending);
                        }
                    }
                };
                stack.push(notifyCasualties);
                stack.push(selectCasualties);
                stack.push(rollDice);
            }
        }

        private CasualtyDetails selectCasualties(Collection<Unit> validAttackingUnitsForThisRoll, Collection<Unit> defendingAA, IDelegateBridge bridge, String currentTypeAA) {
            AbstractBattle.getDisplay(bridge).notifyDice(MustFightBattle.this.m_battleID, this.m_dice, (this.m_defending ? MustFightBattle.this.m_attacker.getName() : MustFightBattle.this.m_defender.getName()) + " select " + currentTypeAA + " casualties");
            return BattleCalculator.getAACasualties(!this.m_defending, validAttackingUnitsForThisRoll, defendingAA, this.m_dice, bridge, this.m_defending ? MustFightBattle.this.m_defender : MustFightBattle.this.m_attacker, this.m_defending ? MustFightBattle.this.m_attacker : MustFightBattle.this.m_defender, MustFightBattle.this.m_battleID, MustFightBattle.this.m_battleSite, MustFightBattle.this.m_territoryEffects);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyCasualtiesAA(final IDelegateBridge bridge, String currentTypeAA) {
            if (MustFightBattle.this.m_headless) {
                return;
            }
            AbstractBattle.getDisplay(bridge).casualtyNotification(MustFightBattle.this.m_battleID, (this.m_defending ? MustFightBattle.this.m_attacker.getName() : MustFightBattle.this.m_defender.getName()) + " remove " + currentTypeAA + " casualties", this.m_dice, this.m_defending ? MustFightBattle.this.m_attacker : MustFightBattle.this.m_defender, new ArrayList<Unit>(this.m_casualties.getKilled()), new ArrayList<Unit>(this.m_casualties.getDamaged()), MustFightBattle.this.m_dependentUnits);
            AbstractBattle.getRemote(this.m_defending ? MustFightBattle.this.m_attacker : MustFightBattle.this.m_defender, bridge).confirmOwnCasualties(MustFightBattle.this.m_battleID, "Press space to continue");
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        AbstractBattle.getRemote(FireAA.this.m_defending ? MustFightBattle.this.m_defender : MustFightBattle.this.m_attacker, bridge).confirmEnemyCasualties(MustFightBattle.this.m_battleID, "Press space to continue", FireAA.this.m_defending ? MustFightBattle.this.m_attacker : MustFightBattle.this.m_defender);
                    }
                    catch (ConnectionLostException cle) {
                    }
                    catch (GameOverException e) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            Thread t = new Thread(r, "click to continue waiter");
            t.start();
            try {
                bridge.leaveDelegateExecution();
                t.join();
            }
            catch (InterruptedException e) {
            }
            finally {
                bridge.enterDelegateExecution();
            }
        }
    }

    public static abstract class DefendSubs
    implements IExecutable {
        private static final long serialVersionUID = 3768066729336520095L;
    }

    public static abstract class AttackSubs
    implements IExecutable {
        private static final long serialVersionUID = 4872551667582174716L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RetreatType {
        DEFAULT,
        SUBS,
        PLANES,
        PARTIAL_AMPHIB;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReturnFire {
        ALL,
        SUBS,
        NONE;

    }
}

