/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.TechnologyFrontier;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.delegate.AARadarAdvance;
import games.strategy.triplea.delegate.DestroyerBombardTechAdvance;
import games.strategy.triplea.delegate.HeavyBomberAdvance;
import games.strategy.triplea.delegate.ImprovedArtillerySupportAdvance;
import games.strategy.triplea.delegate.ImprovedShipyardsAdvance;
import games.strategy.triplea.delegate.IncreasedFactoryProductionAdvance;
import games.strategy.triplea.delegate.IndustrialTechnologyAdvance;
import games.strategy.triplea.delegate.JetPowerAdvance;
import games.strategy.triplea.delegate.LongRangeAircraftAdvance;
import games.strategy.triplea.delegate.MechanizedInfantryAdvance;
import games.strategy.triplea.delegate.ParatroopersAdvance;
import games.strategy.triplea.delegate.RocketsAdvance;
import games.strategy.triplea.delegate.SuperSubsAdvance;
import games.strategy.triplea.delegate.WarBondsAdvance;
import games.strategy.util.Tuple;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TechAdvance
extends NamedAttachable
implements Serializable {
    private static final long serialVersionUID = -1076712297024403156L;
    private static final Class[] preDefinedTechConstructorParameter = new Class[]{GameData.class};
    public static final String TECH_NAME_SUPER_SUBS = "Super subs";
    public static final String TECH_PROPERTY_SUPER_SUBS = "superSub";
    public static final String TECH_NAME_JET_POWER = "Jet Power";
    public static final String TECH_PROPERTY_JET_POWER = "jetPower";
    public static final String TECH_NAME_IMPROVED_SHIPYARDS = "Shipyards";
    public static final String TECH_PROPERTY_IMPROVED_SHIPYARDS = "shipyards";
    public static final String TECH_NAME_AA_RADAR = "AA Radar";
    public static final String TECH_PROPERTY_AA_RADAR = "aARadar";
    public static final String TECH_NAME_LONG_RANGE_AIRCRAFT = "Long Range Aircraft";
    public static final String TECH_PROPERTY_LONG_RANGE_AIRCRAFT = "longRangeAir";
    public static final String TECH_NAME_HEAVY_BOMBER = "Heavy Bomber";
    public static final String TECH_PROPERTY_HEAVY_BOMBER = "heavyBomber";
    public static final String TECH_NAME_IMPROVED_ARTILLERY_SUPPORT = "Improved Artillery Support";
    public static final String TECH_PROPERTY_IMPROVED_ARTILLERY_SUPPORT = "improvedArtillerySupport";
    public static final String TECH_NAME_ROCKETS = "Rockets Advance";
    public static final String TECH_PROPERTY_ROCKETS = "rocket";
    public static final String TECH_NAME_PARATROOPERS = "Paratroopers";
    public static final String TECH_PROPERTY_PARATROOPERS = "paratroopers";
    public static final String TECH_NAME_INCREASED_FACTORY_PRODUCTION = "Increased Factory Production";
    public static final String TECH_PROPERTY_INCREASED_FACTORY_PRODUCTION = "increasedFactoryProduction";
    public static final String TECH_NAME_WAR_BONDS = "War Bonds";
    public static final String TECH_PROPERTY_WAR_BONDS = "warBonds";
    public static final String TECH_NAME_MECHANIZED_INFANTRY = "Mechanized Infantry";
    public static final String TECH_PROPERTY_MECHANIZED_INFANTRY = "mechanizedInfantry";
    public static final String TECH_NAME_INDUSTRIAL_TECHNOLOGY = "Industrial Technology";
    public static final String TECH_PROPERTY_INDUSTRIAL_TECHNOLOGY = "industrialTechnology";
    public static final String TECH_NAME_DESTROYER_BOMBARD = "Destroyer Bombard";
    public static final String TECH_PROPERTY_DESTROYER_BOMBARD = "destroyerBombard";
    public static final List<String> s_allPreDefinedTechnologyNames = Collections.unmodifiableList(Arrays.asList("Super subs", "Jet Power", "Shipyards", "AA Radar", "Long Range Aircraft", "Heavy Bomber", "Improved Artillery Support", "Rockets Advance", "Paratroopers", "Increased Factory Production", "War Bonds", "Mechanized Infantry", "Industrial Technology", "Destroyer Bombard"));
    private static final Map<String, Class<? extends TechAdvance>> s_allPreDefinedTechnologies = TechAdvance.createPreDefinedTechnologyMap();

    private static final Map<String, Class<? extends TechAdvance>> createPreDefinedTechnologyMap() {
        HashMap<String, Class> preDefinedTechMap = new HashMap<String, Class>();
        preDefinedTechMap.put(TECH_PROPERTY_SUPER_SUBS, SuperSubsAdvance.class);
        preDefinedTechMap.put(TECH_PROPERTY_JET_POWER, JetPowerAdvance.class);
        preDefinedTechMap.put(TECH_PROPERTY_IMPROVED_SHIPYARDS, ImprovedShipyardsAdvance.class);
        preDefinedTechMap.put(TECH_PROPERTY_AA_RADAR, AARadarAdvance.class);
        preDefinedTechMap.put(TECH_PROPERTY_LONG_RANGE_AIRCRAFT, LongRangeAircraftAdvance.class);
        preDefinedTechMap.put(TECH_PROPERTY_HEAVY_BOMBER, HeavyBomberAdvance.class);
        preDefinedTechMap.put(TECH_PROPERTY_IMPROVED_ARTILLERY_SUPPORT, ImprovedArtillerySupportAdvance.class);
        preDefinedTechMap.put(TECH_PROPERTY_ROCKETS, RocketsAdvance.class);
        preDefinedTechMap.put(TECH_PROPERTY_PARATROOPERS, ParatroopersAdvance.class);
        preDefinedTechMap.put(TECH_PROPERTY_INCREASED_FACTORY_PRODUCTION, IncreasedFactoryProductionAdvance.class);
        preDefinedTechMap.put(TECH_PROPERTY_WAR_BONDS, WarBondsAdvance.class);
        preDefinedTechMap.put(TECH_PROPERTY_MECHANIZED_INFANTRY, MechanizedInfantryAdvance.class);
        preDefinedTechMap.put(TECH_PROPERTY_INDUSTRIAL_TECHNOLOGY, IndustrialTechnologyAdvance.class);
        preDefinedTechMap.put(TECH_PROPERTY_DESTROYER_BOMBARD, DestroyerBombardTechAdvance.class);
        return Collections.unmodifiableMap(preDefinedTechMap);
    }

    public TechAdvance(String name, GameData data) {
        super(name, data);
    }

    public abstract String getProperty();

    public abstract void perform(PlayerID var1, IDelegateBridge var2);

    public abstract boolean hasTech(TechAttachment var1);

    private static void createWW2V1Advances(TechnologyFrontier tf) {
        tf.addAdvance(new JetPowerAdvance(tf.getData()));
        tf.addAdvance(new SuperSubsAdvance(tf.getData()));
        tf.addAdvance(new LongRangeAircraftAdvance(tf.getData()));
        tf.addAdvance(new RocketsAdvance(tf.getData()));
        tf.addAdvance(new IndustrialTechnologyAdvance(tf.getData()));
        tf.addAdvance(new HeavyBomberAdvance(tf.getData()));
    }

    private static void createWW2V2Advances(TechnologyFrontier tf) {
        tf.addAdvance(new JetPowerAdvance(tf.getData()));
        tf.addAdvance(new SuperSubsAdvance(tf.getData()));
        tf.addAdvance(new LongRangeAircraftAdvance(tf.getData()));
        tf.addAdvance(new RocketsAdvance(tf.getData()));
        tf.addAdvance(new DestroyerBombardTechAdvance(tf.getData()));
        tf.addAdvance(new HeavyBomberAdvance(tf.getData()));
    }

    private static void createWW2V3Advances(TechnologyFrontier tf) {
        tf.addAdvance(new SuperSubsAdvance(tf.getData()));
        tf.addAdvance(new JetPowerAdvance(tf.getData()));
        tf.addAdvance(new ImprovedShipyardsAdvance(tf.getData()));
        tf.addAdvance(new AARadarAdvance(tf.getData()));
        tf.addAdvance(new LongRangeAircraftAdvance(tf.getData()));
        tf.addAdvance(new HeavyBomberAdvance(tf.getData()));
        tf.addAdvance(new ImprovedArtillerySupportAdvance(tf.getData()));
        tf.addAdvance(new RocketsAdvance(tf.getData()));
        tf.addAdvance(new ParatroopersAdvance(tf.getData()));
        tf.addAdvance(new IncreasedFactoryProductionAdvance(tf.getData()));
        tf.addAdvance(new WarBondsAdvance(tf.getData()));
        tf.addAdvance(new MechanizedInfantryAdvance(tf.getData()));
    }

    public static void createDefaultTechAdvances(GameData data) {
        TechnologyFrontier tf = data.getTechnologyFrontier();
        boolean ww2v2 = Properties.getWW2V2(data);
        boolean ww2v3 = Properties.getWW2V3(data);
        if (ww2v2) {
            TechAdvance.createWW2V2Advances(tf);
        } else if (ww2v3) {
            TechAdvance.createWW2V3Advances(tf);
        } else {
            TechAdvance.createWW2V1Advances(tf);
        }
        ArrayList<TechnologyFrontier> frontiers = new ArrayList<TechnologyFrontier>();
        if (ww2v3) {
            TechnologyFrontier an = new TechnologyFrontier("Air and Naval Advances", data);
            TechnologyFrontier lp = new TechnologyFrontier("Land and Production Advances", data);
            Tuple<List<TechAdvance>, List<TechAdvance>> ww2v3advances = TechAdvance.getWW2v3CategoriesWithTheirAdvances(data);
            an.addAdvance(ww2v3advances.getFirst());
            lp.addAdvance(ww2v3advances.getSecond());
            frontiers.add(an);
            frontiers.add(lp);
        } else {
            TechnologyFrontier tas = new TechnologyFrontier("Technology Advances", data);
            tas.addAdvance(new ArrayList<TechAdvance>(tf.getTechs()));
            frontiers.add(tas);
        }
        for (PlayerID player : data.getPlayerList().getPlayers()) {
            for (TechnologyFrontier frontier : frontiers) {
                player.getTechnologyFrontierList().addTechnologyFrontier(new TechnologyFrontier(frontier));
            }
        }
    }

    public static TechAdvance findDefinedAdvanceAndCreateAdvance(String s, GameData data) {
        TechAdvance ta;
        Class<? extends TechAdvance> clazz = s_allPreDefinedTechnologies.get(s);
        if (clazz == null) {
            throw new IllegalArgumentException(s + " is not a valid technology");
        }
        try {
            Constructor<? extends TechAdvance> constructor = clazz.getConstructor(preDefinedTechConstructorParameter);
            ta = constructor.newInstance(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(s + " is not a valid technology or could not be instantiated");
        }
        if (ta == null) {
            throw new IllegalStateException(s + " is not a valid technology or could not be instantiated");
        }
        return ta;
    }

    public static TechAdvance findAdvance(String propertyString, GameData data, PlayerID player) {
        for (TechAdvance t : TechAdvance.getTechAdvances(data, player)) {
            if (!t.getProperty().equals(propertyString)) continue;
            return t;
        }
        throw new IllegalArgumentException(propertyString + " is not a valid technology");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TechAdvance findTechnologyFromAllTechs(String name, GameData data, boolean mustFind) {
        TechAdvance type;
        data.acquireReadLock();
        try {
            type = data.getTechnologyFrontier().getAdvanceByName(name);
            if (type == null) {
                type = data.getTechnologyFrontier().getAdvanceByProperty(name);
            }
            if (type == null && mustFind) {
                throw new IllegalStateException("Could not find technology. name:" + name);
            }
        }
        finally {
            data.releaseReadLock();
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tuple<List<TechAdvance>, List<TechAdvance>> getWW2v3CategoriesWithTheirAdvances(GameData data) {
        ArrayList<TechAdvance> allAdvances;
        data.acquireReadLock();
        try {
            allAdvances = new ArrayList<TechAdvance>(data.getTechnologyFrontier().getTechs());
        }
        finally {
            data.releaseReadLock();
        }
        ArrayList<TechAdvance> airAndNaval = new ArrayList<TechAdvance>();
        ArrayList<TechAdvance> landAndProduction = new ArrayList<TechAdvance>();
        for (TechAdvance ta : allAdvances) {
            String propertyString = ta.getProperty();
            if (propertyString.equals(TECH_PROPERTY_SUPER_SUBS) || propertyString.equals(TECH_PROPERTY_JET_POWER) || propertyString.equals(TECH_PROPERTY_IMPROVED_SHIPYARDS) || propertyString.equals(TECH_PROPERTY_AA_RADAR) || propertyString.equals(TECH_PROPERTY_LONG_RANGE_AIRCRAFT) || propertyString.equals(TECH_PROPERTY_HEAVY_BOMBER)) {
                airAndNaval.add(ta);
                continue;
            }
            if (propertyString.equals(TECH_PROPERTY_IMPROVED_ARTILLERY_SUPPORT) || propertyString.equals(TECH_PROPERTY_ROCKETS) || propertyString.equals(TECH_PROPERTY_PARATROOPERS) || propertyString.equals(TECH_PROPERTY_INCREASED_FACTORY_PRODUCTION) || propertyString.equals(TECH_PROPERTY_WAR_BONDS) || propertyString.equals(TECH_PROPERTY_MECHANIZED_INFANTRY)) {
                landAndProduction.add(ta);
                continue;
            }
            throw new IllegalStateException("We should not be using ww2v3 categories if we have custom techs: " + propertyString);
        }
        return new Tuple<List<TechAdvance>, List<TechAdvance>>(airAndNaval, landAndProduction);
    }

    public static List<TechAdvance> getTechAdvances(GameData data) {
        return TechAdvance.getTechAdvances(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TechAdvance> getTechAdvances(GameData data, PlayerID player) {
        TechnologyFrontier technologyFrontier;
        data.acquireReadLock();
        try {
            technologyFrontier = data.getTechnologyFrontier();
        }
        finally {
            data.releaseReadLock();
        }
        if (technologyFrontier != null && !technologyFrontier.isEmpty()) {
            if (player != null) {
                return player.getTechnologyFrontierList().getAdvances();
            }
            return technologyFrontier.getTechs();
        }
        return new ArrayList<TechAdvance>();
    }

    public static List<TechnologyFrontier> getPlayerTechCategories(GameData data, PlayerID player) {
        if (player != null) {
            return player.getTechnologyFrontierList().getFrontiers();
        }
        throw new IllegalStateException("Player can not be null");
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof TechAdvance)) {
            return false;
        }
        TechAdvance other = (TechAdvance)o;
        if (other.getName() == null || this.getName() == null) {
            return false;
        }
        return this.getName().equals(other.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

