/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.IntegerMap;
import java.util.Collection;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitBattleComparator
implements Comparator<Unit> {
    private final boolean m_defending;
    private final IntegerMap<UnitType> m_costs;
    private final GameData m_data;
    private final boolean m_bonus;
    private final Collection<TerritoryEffect> m_territoryEffects;

    public UnitBattleComparator(boolean defending, IntegerMap<UnitType> costs, Collection<TerritoryEffect> territoryEffects, GameData data, boolean bonus) {
        this.m_defending = defending;
        this.m_costs = costs;
        this.m_data = data;
        this.m_bonus = bonus;
        this.m_territoryEffects = territoryEffects;
    }

    @Override
    public int compare(Unit u1, Unit u2) {
        int cost2;
        UnitAttachment ua2;
        if (u1.equals(u2)) {
            return 0;
        }
        boolean transporting1 = Matches.transportIsTransporting().match(u1);
        boolean transporting2 = Matches.transportIsTransporting().match(u2);
        UnitAttachment ua1 = UnitAttachment.get(u1.getType());
        if (ua1 == (ua2 = UnitAttachment.get(u2.getType()))) {
            if (transporting1 && !transporting2) {
                return 1;
            }
            if (!transporting1 && transporting2) {
                return -1;
            }
            return 0;
        }
        boolean airOrCarrierOrTwoHitOrTransport1 = Matches.UnitIsAir.match(u1) || Matches.UnitIsTwoHit.match(u1) || Matches.UnitIsCarrier.match(u1) || !transporting1 && Matches.UnitIsTransport.match(u1);
        boolean airOrCarrierOrTwoHitOrTransport2 = Matches.UnitIsAir.match(u2) || Matches.UnitIsTwoHit.match(u2) || Matches.UnitIsCarrier.match(u2) || !transporting2 && Matches.UnitIsTransport.match(u2);
        boolean subDestroyer1 = Matches.UnitIsSub.match(u1) || Matches.UnitIsDestroyer.match(u1);
        boolean subDestroyer2 = Matches.UnitIsSub.match(u2) || Matches.UnitIsDestroyer.match(u2);
        int power1 = 5 * BattleCalculator.getUnitPowerForSorting(u1, this.m_defending, this.m_data, this.m_territoryEffects);
        int power2 = 5 * BattleCalculator.getUnitPowerForSorting(u2, this.m_defending, this.m_data, this.m_territoryEffects);
        if (this.m_bonus) {
            if (subDestroyer1 && !subDestroyer2) {
                power1 += 3;
            } else if (!subDestroyer1 && subDestroyer2) {
                power2 += 3;
            }
            if (transporting1 && !transporting2) {
                ++power1;
            } else if (!transporting1 && transporting2) {
                ++power2;
            }
            if (airOrCarrierOrTwoHitOrTransport1 && !airOrCarrierOrTwoHitOrTransport2) {
                ++power1;
            } else if (!airOrCarrierOrTwoHitOrTransport1 && airOrCarrierOrTwoHitOrTransport2) {
                ++power2;
            }
        }
        if (power1 != power2) {
            return power1 - power2;
        }
        int cost1 = this.m_costs.getInt(u1.getType());
        if (cost1 != (cost2 = this.m_costs.getInt(u2.getType()))) {
            return cost1 - cost2;
        }
        int power1reverse = 5 * BattleCalculator.getUnitPowerForSorting(u1, !this.m_defending, this.m_data, this.m_territoryEffects);
        int power2reverse = 5 * BattleCalculator.getUnitPowerForSorting(u2, !this.m_defending, this.m_data, this.m_territoryEffects);
        if (this.m_bonus) {
            if (subDestroyer1 && !subDestroyer2) {
                power1reverse += 3;
            } else if (!subDestroyer1 && subDestroyer2) {
                power2reverse += 3;
            }
            if (transporting1 && !transporting2) {
                ++power1reverse;
            } else if (!transporting1 && transporting2) {
                ++power2reverse;
            }
            if (airOrCarrierOrTwoHitOrTransport1 && !airOrCarrierOrTwoHitOrTransport2) {
                ++power1reverse;
            } else if (!airOrCarrierOrTwoHitOrTransport1 && airOrCarrierOrTwoHitOrTransport2) {
                ++power2reverse;
            }
        }
        if (power1reverse != power2reverse) {
            return power1reverse - power2reverse;
        }
        if (transporting1 && !transporting2) {
            return 1;
        }
        if (!transporting1 && transporting2) {
            return -1;
        }
        return 0;
    }
}

