/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.image;

import games.strategy.triplea.ResourceLoader;
import games.strategy.ui.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;

public class MapImage {
    private BufferedImage m_smallMapImage;
    private static Font PROPERTY_MAP_FONT = null;
    private static Color PROPERTY_TERRITORY_NAME_AND_PU_AND_COMMENT_COLOR = null;
    private static Color PROPERTY_UNIT_COUNT_COLOR = null;
    private static Color PROPERTY_UNIT_FACTORY_DAMAGE_COLOR = null;
    private static final String PROPERTY_MAP_FONT_SIZE_STRING = "PROPERTY_MAP_FONT_SIZE";
    private static final String PROPERTY_TERRITORY_NAME_AND_PU_AND_COMMENT_COLOR_STRING = "PROPERTY_TERRITORY_NAME_AND_PU_AND_COMMENT_COLOR";
    private static final String PROPERTY_UNIT_COUNT_COLOR_STRING = "PROPERTY_UNIT_COUNT_COLOR";
    private static final String PROPERTY_UNIT_FACTORY_DAMAGE_COLOR_STRING = "PROPERTY_UNIT_FACTORY_DAMAGE_COLOR";

    private static Image loadImage(ResourceLoader loader, String name) {
        URL mapFileUrl = loader.getResource(name);
        if (mapFileUrl == null) {
            throw new IllegalStateException("resource not found:" + name);
        }
        try {
            return ImageIO.read(mapFileUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static Font getPropertyMapFont() {
        if (PROPERTY_MAP_FONT == null) {
            Preferences pref = Preferences.userNodeForPackage(MapImage.class);
            PROPERTY_MAP_FONT = new Font("Ariel", 1, pref.getInt(PROPERTY_MAP_FONT_SIZE_STRING, 12));
        }
        return PROPERTY_MAP_FONT;
    }

    public static Color getPropertyTerritoryNameAndPUAndCommentcolor() {
        if (PROPERTY_TERRITORY_NAME_AND_PU_AND_COMMENT_COLOR == null) {
            Preferences pref = Preferences.userNodeForPackage(MapImage.class);
            PROPERTY_TERRITORY_NAME_AND_PU_AND_COMMENT_COLOR = new Color(pref.getInt(PROPERTY_TERRITORY_NAME_AND_PU_AND_COMMENT_COLOR_STRING, Color.black.getRGB()));
        }
        return PROPERTY_TERRITORY_NAME_AND_PU_AND_COMMENT_COLOR;
    }

    public static Color getPropertyUnitCountColor() {
        if (PROPERTY_UNIT_COUNT_COLOR == null) {
            Preferences pref = Preferences.userNodeForPackage(MapImage.class);
            PROPERTY_UNIT_COUNT_COLOR = new Color(pref.getInt(PROPERTY_UNIT_COUNT_COLOR_STRING, Color.white.getRGB()));
        }
        return PROPERTY_UNIT_COUNT_COLOR;
    }

    public static Color getPropertyUnitFactoryDamageColor() {
        if (PROPERTY_UNIT_FACTORY_DAMAGE_COLOR == null) {
            Preferences pref = Preferences.userNodeForPackage(MapImage.class);
            PROPERTY_UNIT_FACTORY_DAMAGE_COLOR = new Color(pref.getInt(PROPERTY_UNIT_FACTORY_DAMAGE_COLOR_STRING, Color.black.getRGB()));
        }
        return PROPERTY_UNIT_FACTORY_DAMAGE_COLOR;
    }

    public static void setPropertyMapFont(Font font) {
        Preferences pref = Preferences.userNodeForPackage(MapImage.class);
        pref.putInt(PROPERTY_MAP_FONT_SIZE_STRING, font.getSize());
        PROPERTY_MAP_FONT = font;
    }

    public static void setPropertyTerritoryNameAndPUAndCommentcolor(Color color) {
        Preferences pref = Preferences.userNodeForPackage(MapImage.class);
        pref.putInt(PROPERTY_TERRITORY_NAME_AND_PU_AND_COMMENT_COLOR_STRING, color.getRGB());
        PROPERTY_TERRITORY_NAME_AND_PU_AND_COMMENT_COLOR = color;
    }

    public static void setPropertyUnitCountColor(Color color) {
        Preferences pref = Preferences.userNodeForPackage(MapImage.class);
        pref.putInt(PROPERTY_UNIT_COUNT_COLOR_STRING, color.getRGB());
        PROPERTY_UNIT_COUNT_COLOR = color;
    }

    public static void setPropertyUnitFactoryDamageColor(Color color) {
        Preferences pref = Preferences.userNodeForPackage(MapImage.class);
        pref.putInt(PROPERTY_UNIT_FACTORY_DAMAGE_COLOR_STRING, color.getRGB());
        PROPERTY_UNIT_FACTORY_DAMAGE_COLOR = color;
    }

    public static void resetPropertyMapFont() {
        Preferences pref = Preferences.userNodeForPackage(MapImage.class);
        pref.remove(PROPERTY_MAP_FONT_SIZE_STRING);
        PROPERTY_MAP_FONT = new Font("Ariel", 1, 12);
    }

    public static void resetPropertyTerritoryNameAndPUAndCommentcolor() {
        Preferences pref = Preferences.userNodeForPackage(MapImage.class);
        pref.remove(PROPERTY_TERRITORY_NAME_AND_PU_AND_COMMENT_COLOR_STRING);
        PROPERTY_TERRITORY_NAME_AND_PU_AND_COMMENT_COLOR = Color.black;
    }

    public static void resetPropertyUnitCountColor() {
        Preferences pref = Preferences.userNodeForPackage(MapImage.class);
        pref.remove(PROPERTY_UNIT_COUNT_COLOR_STRING);
        PROPERTY_UNIT_COUNT_COLOR = Color.white;
    }

    public static void resetPropertyUnitFactoryDamageColor() {
        Preferences pref = Preferences.userNodeForPackage(MapImage.class);
        pref.remove(PROPERTY_UNIT_FACTORY_DAMAGE_COLOR_STRING);
        PROPERTY_UNIT_FACTORY_DAMAGE_COLOR = Color.black;
    }

    public BufferedImage getSmallMapImage() {
        return this.m_smallMapImage;
    }

    public void loadMaps(ResourceLoader loader) {
        Image smallFromFile = MapImage.loadImage(loader, "smallMap.jpeg");
        this.m_smallMapImage = Util.createImage(smallFromFile.getWidth(null), smallFromFile.getHeight(null), false);
        Graphics g = this.m_smallMapImage.getGraphics();
        g.drawImage(smallFromFile, 0, 0, null);
        g.dispose();
        smallFromFile.flush();
    }
}

