/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.oddsCalculator.ta.OddsCalculator;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.util.UnitCategory;
import java.awt.Color;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OrderOfLossesInputPanel
extends JPanel {
    private static final long serialVersionUID = 8815617685388156219L;
    private final GameData m_data;
    private final IUIContext m_context;
    private final List<UnitCategory> m_attackerCategories;
    private final List<UnitCategory> m_defenderCategories;
    private final JTextField m_attackerTextField;
    private final JTextField m_defenderTextField;
    private final JLabel m_attackerLabel = new JLabel("Attacker Units:");
    private final JLabel m_defenderLabel = new JLabel("Defender Units:");
    private final JButton m_clear;
    private final boolean m_land;

    public OrderOfLossesInputPanel(String attackerOrder, String defenderOrder, List<UnitCategory> attackerCategories, List<UnitCategory> defenderCategories, boolean land, IUIContext context, GameData data) {
        this.m_data = data;
        this.m_context = context;
        this.m_land = land;
        this.m_attackerCategories = attackerCategories;
        this.m_defenderCategories = defenderCategories;
        this.m_attackerTextField = new JTextField(attackerOrder == null ? "" : attackerOrder);
        this.m_attackerTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                if (!OddsCalculator.isValidOOL(OrderOfLossesInputPanel.this.m_attackerTextField.getText(), OrderOfLossesInputPanel.this.m_data)) {
                    OrderOfLossesInputPanel.this.m_attackerLabel.setForeground(Color.red);
                } else {
                    OrderOfLossesInputPanel.this.m_attackerLabel.setForeground(null);
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if (!OddsCalculator.isValidOOL(OrderOfLossesInputPanel.this.m_attackerTextField.getText(), OrderOfLossesInputPanel.this.m_data)) {
                    OrderOfLossesInputPanel.this.m_attackerLabel.setForeground(Color.red);
                } else {
                    OrderOfLossesInputPanel.this.m_attackerLabel.setForeground(null);
                }
            }

            public void changedUpdate(DocumentEvent e) {
                if (!OddsCalculator.isValidOOL(OrderOfLossesInputPanel.this.m_attackerTextField.getText(), OrderOfLossesInputPanel.this.m_data)) {
                    OrderOfLossesInputPanel.this.m_attackerLabel.setForeground(Color.red);
                } else {
                    OrderOfLossesInputPanel.this.m_attackerLabel.setForeground(null);
                }
            }
        });
        this.m_defenderTextField = new JTextField(defenderOrder == null ? "" : defenderOrder);
        this.m_defenderTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                if (!OddsCalculator.isValidOOL(OrderOfLossesInputPanel.this.m_defenderTextField.getText(), OrderOfLossesInputPanel.this.m_data)) {
                    OrderOfLossesInputPanel.this.m_defenderLabel.setForeground(Color.red);
                } else {
                    OrderOfLossesInputPanel.this.m_defenderLabel.setForeground(null);
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if (!OddsCalculator.isValidOOL(OrderOfLossesInputPanel.this.m_defenderTextField.getText(), OrderOfLossesInputPanel.this.m_data)) {
                    OrderOfLossesInputPanel.this.m_defenderLabel.setForeground(Color.red);
                } else {
                    OrderOfLossesInputPanel.this.m_defenderLabel.setForeground(null);
                }
            }

            public void changedUpdate(DocumentEvent e) {
                if (!OddsCalculator.isValidOOL(OrderOfLossesInputPanel.this.m_defenderTextField.getText(), OrderOfLossesInputPanel.this.m_data)) {
                    OrderOfLossesInputPanel.this.m_defenderLabel.setForeground(Color.red);
                } else {
                    OrderOfLossesInputPanel.this.m_defenderLabel.setForeground(null);
                }
            }
        });
        this.m_clear = new JButton("Clear");
        this.m_clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OrderOfLossesInputPanel.this.m_attackerTextField.setText("");
                OrderOfLossesInputPanel.this.m_defenderTextField.setText("");
            }
        });
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new BoxLayout(this, 1));
        JLabel instructions = new JLabel("<html>Here you can specify the 'Order of Losses' (OOL) for each side.<br />Damageable units will be damanged first always. If the player label is red, your OOL is invalid.<br />The engine will take your input and add all units to a list starting on the RIGHT side of your text line.<br />Then, during combat, casualties will be chosen starting on the LEFT side of your OOL.<br />; separates unit types.<br />^ is in front of the unit type and describes the number of units.<br />* means all units of that type.<br />Examples:<br />*^infantry;*^artillery;*^fighter<br />The above will take all infantry, then all artillery, then all fighters, then all other units as casualty.<br /><br />1^infantry;2^artillery;6^fighter<br />The above will take 1 infantry, then 2 artillery, then 6 fighters, then all other units as casualty.<br /><br />*^infantry;*^fighter;1^infantry<br />The above will take all except 1 infantry casualty, then all fighters, then the last infantry, then all other units casualty.</html>");
        instructions.setAlignmentX(0.5f);
        this.add(instructions);
        this.add(Box.createVerticalStrut(30));
        this.m_attackerLabel.setAlignmentX(0.5f);
        this.add(this.m_attackerLabel);
        JPanel attackerUnits = this.getUnitButtonPanel(this.m_attackerCategories, this.m_attackerTextField);
        attackerUnits.setAlignmentX(0.5f);
        this.add(attackerUnits);
        this.m_attackerTextField.setAlignmentX(0.5f);
        this.add(this.m_attackerTextField);
        this.add(Box.createVerticalStrut(30));
        this.m_defenderLabel.setAlignmentX(0.5f);
        this.add(this.m_defenderLabel);
        JPanel defenderUnits = this.getUnitButtonPanel(this.m_defenderCategories, this.m_defenderTextField);
        defenderUnits.setAlignmentX(0.5f);
        this.add(defenderUnits);
        this.m_defenderTextField.setAlignmentX(0.5f);
        this.add(this.m_defenderTextField);
        this.add(Box.createVerticalStrut(10));
        this.m_clear.setAlignmentX(0.5f);
        this.add(this.m_clear);
    }

    private JPanel getUnitButtonPanel(List<UnitCategory> categories, final JTextField textField) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        if (categories != null) {
            HashSet<UnitType> typesUsed = new HashSet<UnitType>();
            for (UnitCategory category : categories) {
                if (typesUsed.contains(category.getType()) || Matches.UnitTypeIsInfrastructure.match(category.getType()) || this.m_land && Matches.UnitTypeIsSea.match(category.getType()) || !this.m_land && Matches.UnitTypeIsLand.match(category.getType())) continue;
                Image img = this.m_context.getUnitImageFactory().getImage(category.getType(), category.getOwner(), this.m_data, category.getDamaged(), category.getDisabled());
                final String unitName = "*^" + category.getType().getName();
                String toolTipText = "<html>" + category.getType().getName() + ":  " + category.getType().getTooltip(category.getOwner(), true) + "</html>";
                JButton button = new JButton(new ImageIcon(img));
                button.setToolTipText(toolTipText);
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        textField.setText((textField.getText().length() > 0 ? textField.getText() + ";" : "") + unitName);
                    }
                });
                panel.add(button);
                typesUsed.add(category.getType());
            }
        }
        return panel;
    }

    public String getAttackerOrder() {
        return this.m_attackerTextField.getText();
    }

    public String getDefenderOrder() {
        return this.m_defenderTextField.getText();
    }
}

