/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.ui.ScrollableTextField;
import games.strategy.ui.ScrollableTextFieldListener;
import games.strategy.ui.WidgetChangedListener;
import games.strategy.util.IntegerMap;
import games.strategy.util.ListenerList;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnitPanel
extends JPanel {
    private static final long serialVersionUID = 1509643150038705671L;
    private final IUIContext m_context;
    private final UnitCategory m_category;
    private final ScrollableTextField m_textField;
    private final GameData m_data;
    private final ListenerList<WidgetChangedListener> m_listeners = new ListenerList();
    private final ScrollableTextFieldListener m_listenerTextField = new ScrollableTextFieldListener(){

        public void changedValue(ScrollableTextField field) {
            UnitPanel.this.notifyListeners();
        }
    };

    public UnitPanel(GameData data, IUIContext context, UnitCategory category, IntegerMap<UnitType> costs) {
        this.m_category = category;
        this.m_context = context;
        this.m_data = data;
        this.m_textField = new ScrollableTextField(0, 512);
        this.m_textField.setShowMaxAndMin(false);
        this.m_textField.addChangeListener(this.m_listenerTextField);
        Image img = this.m_context.getUnitImageFactory().getImage(this.m_category.getType(), this.m_category.getOwner(), this.m_data, this.m_category.getDamaged(), this.m_category.getDisabled());
        String toolTipText = "<html>" + this.m_category.getType().getName() + ":  " + costs.getInt(this.m_category.getType()) + " cost, <br /> &nbsp;&nbsp;&nbsp;&nbsp; " + this.m_category.getType().getTooltip(this.m_category.getOwner(), true) + "</html>";
        this.setCount(this.m_category.getUnits().size());
        this.setLayout(new GridBagLayout());
        JLabel label = new JLabel(new ImageIcon(img));
        label.setToolTipText(toolTipText);
        this.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.m_textField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public List<Unit> getUnits() {
        List<Unit> units = this.m_category.getType().create(this.m_textField.getValue(), this.m_category.getOwner(), true);
        if (!units.isEmpty()) {
            if (this.m_category.isTwoHit() && this.m_category.getDamaged()) {
                for (Unit u : units) {
                    u.setHits(1);
                }
            }
            if (this.m_category.getDisabled() && Matches.UnitTypeCanBeDamaged.match(this.m_category.getType())) {
                int uDamage = Math.max(0, 1 + UnitAttachment.get(this.m_category.getType()).getMaxOperationalDamage());
                for (Unit u : units) {
                    ((TripleAUnit)u).setUnitDamage(uDamage);
                }
            }
        }
        return units;
    }

    public int getCount() {
        return this.m_textField.getValue();
    }

    public void setCount(int value) {
        this.m_textField.setValue(value);
    }

    public UnitCategory getCategory() {
        return this.m_category;
    }

    public void addChangeListener(WidgetChangedListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeChangeListener(WidgetChangedListener listener) {
        this.m_listeners.remove(listener);
    }

    private void notifyListeners() {
        for (WidgetChangedListener listener : this.m_listeners) {
            listener.widgetChanged();
        }
    }
}

