/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.printgenerator;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.triplea.printgenerator.PrintGenerationData;
import games.strategy.util.IntegerMap;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;

class PUChart {
    private final GameData m_data;
    private final Iterator<PlayerID> m_playerIterator;
    private final IntegerMap<PlayerID> m_moneyMap;
    private final int m_numPlayers;
    private final PlayerID[] m_playerArray;
    private final Integer[] m_moneyArray;
    private final Map<Integer, Integer> m_avoidMap;
    private final int X_DIMENSION = 7;
    private final int Y_DIMENSION = 6;
    private final Font CHART_FONT = new Font("Serif", 0, 12);
    private final BufferedImage m_PUImage;
    private final Graphics2D m_g2d;
    private final File m_outDir;

    PUChart(PrintGenerationData printData) {
        this.m_data = printData.getData();
        this.m_playerIterator = this.m_data.getPlayerList().iterator();
        this.m_moneyMap = new IntegerMap();
        this.m_numPlayers = this.m_data.getPlayerList().size();
        this.m_playerArray = new PlayerID[this.m_numPlayers];
        this.m_moneyArray = new Integer[this.m_numPlayers];
        this.m_avoidMap = new HashMap<Integer, Integer>();
        this.m_PUImage = new BufferedImage(600, 600, 2);
        this.m_g2d = this.m_PUImage.createGraphics();
        this.m_outDir = printData.getOutDir();
    }

    private void initializeMap() {
        int count = 0;
        while (this.m_playerIterator.hasNext()) {
            PlayerID currentPlayer = this.m_playerIterator.next();
            this.m_moneyMap.put(currentPlayer, currentPlayer.getResources().getQuantity("PUs"));
            this.m_playerArray[count] = currentPlayer;
            this.m_moneyArray[count] = currentPlayer.getResources().getQuantity("PUs");
            ++count;
        }
    }

    private void initializeAvoidMap() {
        for (int i = 0; i < this.m_numPlayers - 1; ++i) {
            for (int j = i + 1; j < this.m_numPlayers; ++j) {
                if (!this.m_moneyArray[i].equals(this.m_moneyArray[j])) continue;
                this.m_avoidMap.put(i, j);
            }
        }
    }

    private void drawEllipseAndString(int x, int y, String string) {
        this.m_g2d.setFont(this.CHART_FONT);
        this.m_g2d.draw(new Ellipse2D.Double(5 + 87 * x, 5 + 87 * y, 72.0, 72.0));
        FontMetrics metrics = this.m_g2d.getFontMetrics();
        int h = metrics.stringWidth(string) / 2;
        int k = metrics.getHeight() / 2;
        this.m_g2d.drawString(string, 42 + 87 * x - h, 39 + 87 * y + k);
    }

    protected void saveToFile() throws IOException {
        this.initializeMap();
        this.initializeAvoidMap();
        int numChartsNeeded = (int)Math.ceil((double)this.m_moneyMap.totalValues() / 42.0);
        for (int i = 0; i < numChartsNeeded; ++i) {
            this.m_g2d.setColor(Color.black);
            for (int z = 0; z < this.m_playerArray.length; ++z) {
                int width;
                FontMetrics metrics;
                int valMod42 = this.m_moneyArray[z] % 42;
                int valModXDim = valMod42 % 7;
                int valFloorXDim = valMod42 / 7;
                if (this.m_avoidMap.containsKey(z) && this.m_moneyArray[z] / 42 == i) {
                    metrics = this.m_g2d.getFontMetrics();
                    width = metrics.stringWidth(this.m_playerArray[z].getName()) / 2;
                    this.m_g2d.drawString(this.m_playerArray[z].getName(), 42 + 87 * valModXDim - width, 63 + 87 * valFloorXDim);
                    continue;
                }
                if (this.m_avoidMap.containsValue(z) && this.m_moneyArray[z] / 42 == i) {
                    metrics = this.m_g2d.getFontMetrics();
                    width = metrics.stringWidth(this.m_playerArray[z].getName()) / 2;
                    this.m_g2d.drawString(this.m_playerArray[z].getName(), 42 + 87 * valModXDim - width, 30 + 87 * valFloorXDim);
                    continue;
                }
                if (this.m_moneyArray[z] / 42 != i) continue;
                metrics = this.m_g2d.getFontMetrics();
                width = metrics.stringWidth(this.m_playerArray[z].getName()) / 2;
                this.m_g2d.drawString(this.m_playerArray[z].getName(), 42 + 87 * valModXDim - width, 60 + 87 * valFloorXDim);
            }
            for (int j = 0; j < 6; ++j) {
                for (int k = 0; k < 7; ++k) {
                    int numberincircle = 42 * i + 7 * j + k;
                    String string = "" + numberincircle;
                    this.drawEllipseAndString(k, j, string);
                }
            }
            int firstnum = 42 * i;
            int secondnum = 42 * (i + 1) - 1;
            File outputfile = new File(this.m_outDir, "PUchart" + firstnum + "-" + secondnum + ".png");
            ImageIO.write((RenderedImage)this.m_PUImage, "png", outputfile);
            Color transparent = new Color(0, 0, 0, 0);
            this.m_g2d.setColor(transparent);
            this.m_g2d.setComposite(AlphaComposite.Src);
            this.m_g2d.fill(new Rectangle2D.Float(0.0f, 0.0f, 600.0f, 600.0f));
        }
    }
}

