/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.ui.TableData;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BattleModel
extends DefaultTableModel {
    private static final long serialVersionUID = 6913324191512043963L;
    private final IUIContext m_uiContext;
    private final GameData m_data;
    private final boolean m_attack;
    private final Collection<Unit> m_units;
    private final Territory m_location;
    private final IBattle.BattleType m_battleType;
    private final Collection<TerritoryEffect> m_territoryEffects;
    private final boolean m_isAmphibious;
    private final Collection<Unit> m_amphibiousLandAttackers;
    private final PlayerID m_player;
    private BattleModel m_enemyBattleModel = null;

    private static String[] varDiceArray(GameData data) {
        String[] diceColumns = new String[data.getDiceSides() + 1];
        Integer i = 0;
        while (i < diceColumns.length) {
            diceColumns[i.intValue()] = i == 0 ? " " : i.toString();
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return diceColumns;
    }

    BattleModel(Collection<Unit> units, boolean attack, IBattle.BattleType battleType, PlayerID player, GameData data, Territory battleLocation, Collection<TerritoryEffect> territoryEffects, boolean isAmphibious, Collection<Unit> amphibiousLandAttackers, IUIContext uiContext) {
        super(new Object[0][0], BattleModel.varDiceArray(data));
        this.m_uiContext = uiContext;
        this.m_data = data;
        this.m_player = player;
        this.m_attack = attack;
        this.m_units = new ArrayList<Unit>(units);
        this.m_location = battleLocation;
        this.m_battleType = battleType;
        this.m_territoryEffects = territoryEffects;
        this.m_isAmphibious = isAmphibious;
        this.m_amphibiousLandAttackers = amphibiousLandAttackers;
    }

    public void setEnemyBattleModel(BattleModel enemyBattleModel) {
        this.m_enemyBattleModel = enemyBattleModel;
    }

    public void notifyRetreat(Collection<Unit> retreating) {
        this.m_units.removeAll(retreating);
        this.refresh();
    }

    public void removeCasualties(Collection<Unit> killed) {
        this.m_units.removeAll(killed);
        this.refresh();
    }

    public void addUnits(Collection<Unit> units) {
        this.m_units.addAll(units);
        this.refresh();
    }

    Collection<Unit> getUnits() {
        return this.m_units;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Map<Unit, Tuple<Integer, Integer>> unitPowerAndRollsMap;
        List[] columns = new List[this.m_data.getDiceSides() + 1];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = new ArrayList();
        }
        ArrayList<Unit> units = new ArrayList<Unit>(this.m_units);
        DiceRoll.sortByStrength(units, !this.m_attack);
        this.m_data.acquireReadLock();
        try {
            unitPowerAndRollsMap = this.m_battleType.isAirPreBattleOrPreRaid() ? null : DiceRoll.getUnitPowerAndRollsForNormalBattles(units, units, new ArrayList<Unit>(this.m_enemyBattleModel.getUnits()), !this.m_attack, this.m_player, this.m_data, this.m_location, this.m_territoryEffects, this.m_isAmphibious, this.m_amphibiousLandAttackers);
        }
        finally {
            this.m_data.releaseReadLock();
        }
        int diceSides = this.m_data.getDiceSides();
        Set<UnitCategory> unitCategories = UnitSeperator.categorize(units, null, false, false, false);
        for (UnitCategory category : unitCategories) {
            UnitAttachment attachment = UnitAttachment.get(category.getType());
            int[] shift = new int[this.m_data.getDiceSides() + 1];
            for (Unit current : category.getUnits()) {
                int strength = this.m_battleType.isAirPreBattleOrPreRaid() ? (this.m_attack ? attachment.getAirAttack(category.getOwner()) : attachment.getAirDefense(category.getOwner())) : unitPowerAndRollsMap.get(current).getFirst();
                int n = strength = Math.min(Math.max(strength, 0), diceSides);
                shift[n] = shift[n] + 1;
            }
            for (int i = 0; i <= this.m_data.getDiceSides(); ++i) {
                if (shift[i] <= 0) continue;
                columns[i].add(new TableData(category.getOwner(), shift[i], category.getType(), this.m_data, category.getDamaged(), category.getDisabled(), this.m_uiContext));
            }
        }
        int rowCount = 1;
        for (int i = 0; i < columns.length; ++i) {
            rowCount = Math.max(rowCount, columns[i].size());
        }
        this.setNumRows(rowCount);
        for (int row = 0; row < rowCount; ++row) {
            for (int column = 0; column < columns.length; ++column) {
                if (columns[column].size() > row) {
                    this.setValueAt(columns[column].get(row), row, column);
                    continue;
                }
                this.setValueAt(TableData.NULL, row, column);
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

