/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.triplea.ui.Active;
import games.strategy.triplea.ui.MyListSelectionModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BattleStepsPanel
extends JPanel
implements Active {
    private static final long serialVersionUID = 911638924664810435L;
    private static final Logger log = Logger.getLogger(BattleStepsPanel.class.getName());
    private static final String LAST_STEP = "NULL MARKER FOR LAST STEP";
    private final DefaultListModel m_listModel = new DefaultListModel();
    private final JList m_list = new JList(this.m_listModel);
    private final MyListSelectionModel m_listSelectionModel = new MyListSelectionModel();
    private String m_targetStep = null;
    private final Object m_mutex = new Object();
    private final List<CountDownLatch> m_waiters = new ArrayList<CountDownLatch>();
    private boolean m_hasWalkThread = false;

    BattleStepsPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_list, "Center");
        this.m_list.setBackground(this.getBackground());
        this.m_list.setSelectionModel(this.m_listSelectionModel);
    }

    @Override
    public void deactivate() {
        this.wakeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeAll() {
        Object object = this.m_mutex;
        synchronized (object) {
            for (CountDownLatch l : this.m_waiters) {
                l.countDown();
            }
            this.m_waiters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listBattle(List<String> steps) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Not in dispatch thread");
        }
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_listModel.removeAllElements();
            Iterator<String> iter = steps.iterator();
            while (iter.hasNext()) {
                this.m_listModel.addElement(iter.next());
            }
            this.m_listSelectionModel.hiddenSetSelectionInterval(0);
            if (!steps.contains(this.m_targetStep)) {
                this.m_targetStep = null;
            }
        }
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTargetStep() {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_targetStep = null;
        }
        this.wakeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doneWalkingSteps() {
        Object object = this.m_mutex;
        synchronized (object) {
            if (this.m_targetStep == null) {
                return true;
            }
            if (!this.m_targetStep.equals(LAST_STEP) && this.m_listModel.lastIndexOf(this.m_targetStep) == -1) {
                new IllegalStateException("Step not found:" + this.m_targetStep + " in:" + this.m_listModel).printStackTrace();
                this.clearTargetStep();
                return true;
            }
            if (this.m_targetStep.equals(LAST_STEP) && this.m_list.getSelectedIndex() == this.m_listModel.getSize() - 1) {
                return true;
            }
            if (this.m_targetStep.equals(this.m_list.getSelectedValue())) {
                return true;
            }
        }
        return false;
    }

    private void walkStep() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Wrong thread");
        }
        if (this.doneWalkingSteps()) {
            this.wakeAll();
            return;
        }
        int index = this.m_list.getSelectedIndex() + 1;
        if (index >= this.m_list.getModel().getSize()) {
            index = 0;
        }
        this.m_listSelectionModel.hiddenSetSelectionInterval(index);
        this.waitThenWalk();
    }

    private void waitThenWalk() {
        Thread t = new Thread("Walk single step started at:" + new Date()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = BattleStepsPanel.this.m_mutex;
                synchronized (object) {
                    if (BattleStepsPanel.this.m_hasWalkThread) {
                        return;
                    }
                    BattleStepsPanel.this.m_hasWalkThread = true;
                }
                try {
                    try {
                        1.sleep(330L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BattleStepsPanel.this.walkStep();
                        }
                    });
                }
                finally {
                    object = BattleStepsPanel.this.m_mutex;
                    synchronized (object) {
                        BattleStepsPanel.this.m_hasWalkThread = false;
                    }
                }
            }
        };
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walkToLastStep() {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_targetStep = LAST_STEP;
        }
        this.goToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStep(String step) {
        Object object = this.m_mutex;
        synchronized (object) {
            if (this.m_listModel.indexOf(step) != -1) {
                this.m_targetStep = step;
            } else {
                log.info("Could not find step name:" + step);
            }
        }
        this.goToTarget();
    }

    private void goToTarget() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Not swing event thread");
        }
        this.waitThenWalk();
    }
}

