/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.ui.DicePanel;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitOwner;
import games.strategy.triplea.util.UnitSeperator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CasualtyNotificationPanel
extends JPanel {
    private static final long serialVersionUID = -8254027929090027450L;
    private final DicePanel m_dice;
    private final JPanel m_killed = new JPanel();
    private final JPanel m_damaged = new JPanel();
    private final GameData m_data;
    private final IUIContext m_uiContext;

    public CasualtyNotificationPanel(GameData data, IUIContext uiContext) {
        this.m_data = data;
        this.m_uiContext = uiContext;
        this.m_dice = new DicePanel(uiContext, data);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.m_dice);
        this.add(this.m_killed);
        this.add(this.m_damaged);
    }

    public void setNotication(DiceRoll dice, PlayerID player, Collection<Unit> killed, Collection<Unit> damaged, Map<Unit, Collection<Unit>> dependents) {
        boolean isEditMode;
        boolean bl = isEditMode = dice == null;
        if (!isEditMode) {
            this.m_dice.setDiceRoll(dice);
        }
        this.m_killed.removeAll();
        this.m_damaged.removeAll();
        if (!killed.isEmpty()) {
            this.m_killed.add(new JLabel("Killed"));
        }
        Iterator<UnitCategory> killedIter = UnitSeperator.categorize(killed, dependents, false, false).iterator();
        this.categorizeUnits(killedIter, false, false);
        damaged.removeAll(killed);
        if (!damaged.isEmpty()) {
            this.m_damaged.add(new JLabel("Damaged"));
        }
        boolean disabled = false;
        Iterator<UnitCategory> damagedIter = UnitSeperator.categorize(damaged, dependents, false, false).iterator();
        this.categorizeUnits(damagedIter, true, false);
        this.invalidate();
        this.validate();
    }

    public void setNoticationShort(PlayerID player, Collection<Unit> killed, Map<Unit, Collection<Unit>> dependents) {
        this.m_killed.removeAll();
        if (!killed.isEmpty()) {
            this.m_killed.add(new JLabel("Killed"));
        }
        Iterator<UnitCategory> killedIter = UnitSeperator.categorize(killed, dependents, false, false).iterator();
        this.categorizeUnits(killedIter, false, false);
        this.invalidate();
        this.validate();
    }

    private void categorizeUnits(Iterator<UnitCategory> categoryIter, boolean damaged, boolean disabled) {
        while (categoryIter.hasNext()) {
            UnitCategory category = categoryIter.next();
            JPanel panel = new JPanel();
            JLabel unit = new JLabel(this.m_uiContext.getUnitImageFactory().getIcon(category.getType(), category.getOwner(), this.m_data, category.getDamaged(), category.getDisabled()));
            panel.add(unit);
            for (UnitOwner owner : category.getDependents()) {
                unit.add(new JLabel(this.m_uiContext.getUnitImageFactory().getIcon(owner.getType(), owner.getOwner(), this.m_data, false, false)));
            }
            panel.add(new JLabel("x " + category.getUnits().size()));
            if (damaged) {
                this.m_damaged.add(panel);
                continue;
            }
            this.m_killed.add(panel);
        }
    }
}

