/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Die;
import games.strategy.triplea.ui.IUIContext;
import java.awt.Dimension;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DicePanel
extends JPanel {
    private static final long serialVersionUID = -7544999867518263506L;
    private final IUIContext m_uiContext;
    private final GameData m_data;

    public DicePanel(IUIContext uiContext, GameData data) {
        this.m_uiContext = uiContext;
        this.m_data = data;
        this.setLayout(new BoxLayout(this, 1));
    }

    public void clear() {
        this.removeAll();
    }

    public void setDiceRollForBombing(List<Die> dice, int cost) {
        this.removeAll();
        this.add(this.create(dice, -1));
        this.add(Box.createVerticalGlue());
        this.add(new JLabel("Cost:" + cost));
        this.invalidate();
    }

    public void setDiceRoll(final DiceRoll diceRoll) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DicePanel.this.setDiceRoll(diceRoll);
                }
            });
            return;
        }
        this.removeAll();
        for (int i = 1; i <= this.m_data.getDiceSides(); ++i) {
            List<Die> dice = diceRoll.getRolls(i);
            if (dice.isEmpty()) continue;
            this.add(new JLabel("Rolled at " + i + ":"));
            this.add(this.create(diceRoll.getRolls(i), i));
        }
        this.add(Box.createVerticalGlue());
        this.add(new JLabel("Total hits:" + diceRoll.getHits()));
        this.validate();
        this.invalidate();
        this.repaint();
    }

    private JComponent create(List<Die> dice, int rollAt) {
        JPanel dicePanel = new JPanel();
        dicePanel.setLayout(new BoxLayout(dicePanel, 0));
        dicePanel.add(Box.createHorizontalStrut(20));
        for (Die die : dice) {
            int roll = die.getValue() + 1;
            dicePanel.add(new JLabel(this.m_uiContext.getDiceImageFactory().getDieIcon(roll, die.getType())));
            dicePanel.add(Box.createHorizontalStrut(2));
        }
        JScrollPane scroll = new JScrollPane(dicePanel);
        scroll.setBorder(null);
        scroll.setVerticalScrollBarPolicy(21);
        scroll.setMinimumSize(new Dimension(scroll.getMinimumSize().width, this.m_uiContext.getDiceImageFactory().DIE_HEIGHT + 17));
        scroll.setMaximumSize(new Dimension(scroll.getMaximumSize().width, this.m_uiContext.getDiceImageFactory().DIE_HEIGHT + 17));
        scroll.setPreferredSize(new Dimension(scroll.getPreferredSize().width, this.m_uiContext.getDiceImageFactory().DIE_HEIGHT + 17));
        return scroll;
    }
}

