/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.ResourceLoader;
import games.strategy.util.PointFileReaderWriter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapData {
    public static final String PROPERTY_COLOR_PREFIX = "color.";
    public static final String PROPERTY_UNITS_SCALE = "units.scale";
    public static final String PROPERTY_UNITS_WIDTH = "units.width";
    public static final String PROPERTY_UNITS_HEIGHT = "units.height";
    public static final String PROPERTY_UNITS_COUNTER_OFFSET_WIDTH = "units.counter.offset.width";
    public static final String PROPERTY_UNITS_COUNTER_OFFSET_HEIGHT = "units.counter.offset.height";
    public static final String PROPERTY_UNITS_STACK_SIZE = "units.stack.size";
    public static final String PROPERTY_MAP_WIDTH = "map.width";
    public static final String PROPERTY_MAP_HEIGHT = "map.height";
    public static final String PROPERTY_MAP_SCROLLWRAPX = "map.scrollWrapX";
    public static final String PROPERTY_MAP_SCROLLWRAPY = "map.scrollWrapY";
    public static final String PROPERTY_MAP_HASRELIEF = "map.hasRelief";
    public static final String PROPERTY_MAP_CURSOR_HOTSPOT_X = "map.cursor.hotspot.x";
    public static final String PROPERTY_MAP_CURSOR_HOTSPOT_Y = "map.cursor.hotspot.y";
    public static final String PROPERTY_MAP_SHOWCAPITOLMARKERS = "map.showCapitolMarkers";
    public static final String PROPERTY_MAP_USETERRITORYEFFECTMARKERS = "map.useTerritoryEffectMarkers";
    public static final String PROPERTY_MAP_SHOWTERRITORYNAMES = "map.showTerritoryNames";
    public static final String PROPERTY_MAP_SHOWRESOURCES = "map.showResources";
    public static final String PROPERTY_MAP_SHOWCOMMENTS = "map.showComments";
    public static final String PROPERTY_MAP_SHOWCONVOYNAMES = "map.showConvoyNames";
    public static final String PROPERTY_MAP_SHOWSEAZONENAMES = "map.showSeaZoneNames";
    public static final String PROPERTY_MAP_DRAWNAMESFROMTOPLEFT = "map.drawNamesFromTopLeft";
    public static final String PROPERTY_MAP_USENATION_CONVOYFLAGS = "map.useNation_convoyFlags";
    public static final String PROPERTY_DONT_DRAW_TERRITORY_NAMES = "dont_draw_territory_names";
    public static final String PROPERTY_MAP_MAPBLENDS = "map.mapBlends";
    public static final String PROPERTY_MAP_MAPBLENDMODE = "map.mapBlendMode";
    public static final String PROPERTY_MAP_MAPBLENDALPHA = "map.mapBlendAlpha";
    public static final String PROPERTY_SCREENSHOT_TITLE_ENABLED = "screenshot.title.enabled";
    public static final String PROPERTY_SCREENSHOT_TITLE_X = "screenshot.title.x";
    public static final String PROPERTY_SCREENSHOT_TITLE_Y = "screenshot.title.y";
    public static final String PROPERTY_SCREENSHOT_TITLE_COLOR = "screenshot.title.color";
    public static final String PROPERTY_SCREENSHOT_TITLE_FONT_SIZE = "screenshot.title.font.size";
    public static final String PROPERTY_SCREENSHOT_STATS_ENABLED = "screenshot.stats.enabled";
    public static final String PROPERTY_SCREENSHOT_STATS_X = "screenshot.stats.x";
    public static final String PROPERTY_SCREENSHOT_STATS_Y = "screenshot.stats.y";
    public static final String PROPERTY_SCREENSHOT_STATS_TEXT_COLOR = "screenshot.stats.text.color";
    public static final String PROPERTY_SCREENSHOT_STATS_BORDER_COLOR = "screenshot.stats.border.color";
    public static final String CENTERS_FILE = "centers.txt";
    public static final String POLYGON_FILE = "polygons.txt";
    public static final String PLACEMENT_FILE = "place.txt";
    public static final String TERRITORY_EFFECT_FILE = "territory_effects.txt";
    public static final String MAP_PROPERTIES = "map.properties";
    public static final String CAPITAL_MARKERS = "capitols.txt";
    public static final String CONVOY_MARKERS = "convoy.txt";
    public static final String COMMENT_MARKERS = "comments.txt";
    public static final String VC_MARKERS = "vc.txt";
    public static final String BLOCKADE_MARKERS = "blockade.txt";
    public static final String IMPASSIBLE = "Impassible";
    public static final String PU_PLACE_FILE = "pu_place.txt";
    public static final String TERRITORY_NAME_PLACE_FILE = "name_place.txt";
    public static final String KAMIKAZE_FILE = "kamikaze_place.txt";
    public static final String DECORATIONS_FILE = "decorations.txt";
    private final List<Color> m_defaultColours = new ArrayList<Color>(Arrays.asList(Color.RED, Color.MAGENTA, Color.YELLOW, Color.ORANGE, Color.CYAN, Color.GREEN, Color.PINK, Color.GRAY));
    private final Map<String, Color> m_playerColors = new HashMap<String, Color>();
    private Map<String, List<Point>> m_place;
    private Map<String, List<Polygon>> m_polys;
    private Map<String, Point> m_centers;
    private Map<String, Point> m_vcPlace;
    private Map<String, Point> m_blockadePlace;
    private Map<String, Point> m_convoyPlace;
    private Map<String, Point> m_commentPlace;
    private Map<String, Point> m_PUPlace;
    private Map<String, Point> m_namePlace;
    private Map<String, Point> m_kamikazePlace;
    private Map<String, Point> m_capitolPlace;
    private Map<String, List<String>> m_contains;
    private Properties m_mapProperties;
    private Map<String, List<Point>> m_territoryEffects;
    private Set<String> m_undrawnTerritoriesNames;
    private Map<Image, List<Point>> m_decorations;
    private Map<String, Image> m_territoryNameImages;
    private final Map<String, Image> m_effectImages = new HashMap<String, Image>();
    private final ResourceLoader m_resourceLoader;
    private BufferedImage m_vcImage;
    private BufferedImage m_blockadeImage;
    private BufferedImage m_errorImage = null;
    private BufferedImage m_warningImage = null;
    private BufferedImage m_infoImage = null;
    private BufferedImage m_helpImage = null;

    public boolean scrollWrapX() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(PROPERTY_MAP_SCROLLWRAPX, "true"));
    }

    public boolean scrollWrapY() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(PROPERTY_MAP_SCROLLWRAPY, "false"));
    }

    public MapData(String mapNameDir) {
        this(ResourceLoader.getMapResourceLoader(mapNameDir, false));
    }

    public MapData(ResourceLoader loader) {
        this.m_resourceLoader = loader;
        try {
            String prefix = "";
            this.m_place = PointFileReaderWriter.readOneToMany(loader.getResourceAsStream(PLACEMENT_FILE));
            this.m_territoryEffects = PointFileReaderWriter.readOneToMany(loader.getResourceAsStream(TERRITORY_EFFECT_FILE));
            this.m_polys = PointFileReaderWriter.readOneToManyPolygons(loader.getResourceAsStream(POLYGON_FILE));
            this.m_centers = PointFileReaderWriter.readOneToOneCenters(loader.getResourceAsStream(CENTERS_FILE));
            this.m_vcPlace = PointFileReaderWriter.readOneToOne(loader.getResourceAsStream(VC_MARKERS));
            this.m_convoyPlace = PointFileReaderWriter.readOneToOne(loader.getResourceAsStream(CONVOY_MARKERS));
            this.m_commentPlace = PointFileReaderWriter.readOneToOne(loader.getResourceAsStream(COMMENT_MARKERS));
            this.m_blockadePlace = PointFileReaderWriter.readOneToOne(loader.getResourceAsStream(BLOCKADE_MARKERS));
            this.m_capitolPlace = PointFileReaderWriter.readOneToOne(loader.getResourceAsStream(CAPITAL_MARKERS));
            this.m_PUPlace = PointFileReaderWriter.readOneToOne(loader.getResourceAsStream(PU_PLACE_FILE));
            this.m_namePlace = PointFileReaderWriter.readOneToOne(loader.getResourceAsStream(TERRITORY_NAME_PLACE_FILE));
            this.m_kamikazePlace = PointFileReaderWriter.readOneToOne(loader.getResourceAsStream(KAMIKAZE_FILE));
            this.m_mapProperties = new Properties();
            this.loadDecorations();
            this.loadTerritoryNames();
            try {
                URL url = loader.getResource(MAP_PROPERTIES);
                if (url == null) {
                    throw new IllegalStateException("No map.properties file defined");
                }
                this.m_mapProperties.load(url.openStream());
            }
            catch (Exception e) {
                System.out.println("Error reading map.properties:" + e);
            }
            this.initializeContains();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void close() {
        this.m_resourceLoader.close();
    }

    private void loadTerritoryNames() {
        this.m_territoryNameImages = new HashMap<String, Image>();
        if (!this.m_resourceLoader.hasPath("territoryNames/")) {
            return;
        }
        for (String name : this.m_centers.keySet()) {
            try {
                BufferedImage img = this.loadImage("territoryNames/" + name + ".png");
                if (img == null) continue;
                this.m_territoryNameImages.put(name, img);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDecorations() throws IOException {
        URL decorations = this.m_resourceLoader.getResource(DECORATIONS_FILE);
        if (decorations == null) {
            this.m_decorations = Collections.emptyMap();
            return;
        }
        this.m_decorations = new HashMap<Image, List<Point>>();
        InputStream stream = null;
        try {
            stream = decorations.openStream();
            Map<String, List<Point>> points = PointFileReaderWriter.readOneToMany(stream);
            for (String name : points.keySet()) {
                BufferedImage img = this.loadImage("misc/" + name);
                this.m_decorations.put(img, points.get(name));
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public double getDefaultUnitScale() {
        if (this.m_mapProperties.getProperty(PROPERTY_UNITS_SCALE) == null) {
            return 1.0;
        }
        try {
            return Double.parseDouble(this.m_mapProperties.getProperty(PROPERTY_UNITS_SCALE));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 1.0;
        }
    }

    public int getDefaultUnitWidth() {
        if (this.m_mapProperties.getProperty(PROPERTY_UNITS_WIDTH) == null) {
            return 48;
        }
        try {
            return Integer.parseInt(this.m_mapProperties.getProperty(PROPERTY_UNITS_WIDTH));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 48;
        }
    }

    public int getDefaultUnitHeight() {
        if (this.m_mapProperties.getProperty(PROPERTY_UNITS_HEIGHT) == null) {
            return 48;
        }
        try {
            return Integer.parseInt(this.m_mapProperties.getProperty(PROPERTY_UNITS_HEIGHT));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 48;
        }
    }

    public int getDefaultUnitCounterOffsetWidth() {
        if (this.m_mapProperties.getProperty(PROPERTY_UNITS_COUNTER_OFFSET_WIDTH) == null) {
            return this.getDefaultUnitWidth() / 4;
        }
        try {
            return Integer.parseInt(this.m_mapProperties.getProperty(PROPERTY_UNITS_COUNTER_OFFSET_WIDTH));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return this.getDefaultUnitWidth() / 4;
        }
    }

    public int getDefaultUnitCounterOffsetHeight() {
        if (this.m_mapProperties.getProperty(PROPERTY_UNITS_COUNTER_OFFSET_HEIGHT) == null) {
            return this.getDefaultUnitHeight();
        }
        try {
            return Integer.parseInt(this.m_mapProperties.getProperty(PROPERTY_UNITS_COUNTER_OFFSET_HEIGHT));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return this.getDefaultUnitHeight();
        }
    }

    public int getDefaultUnitsStackSize() {
        String stack = this.m_mapProperties.getProperty(PROPERTY_UNITS_STACK_SIZE, "0");
        return Math.max(0, Integer.parseInt(stack));
    }

    public boolean shouldDrawTerritoryName(String territoryName) {
        if (this.m_undrawnTerritoriesNames == null) {
            String property = this.m_mapProperties.getProperty(PROPERTY_DONT_DRAW_TERRITORY_NAMES, "");
            this.m_undrawnTerritoriesNames = new HashSet<String>(Arrays.asList(property.split(",")));
        }
        return !this.m_undrawnTerritoriesNames.contains(territoryName);
    }

    public boolean getHasRelief() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(PROPERTY_MAP_HASRELIEF, "true"));
    }

    public int getMapCursorHotspotX() {
        return Math.max(0, Math.min(256, Integer.parseInt(this.m_mapProperties.getProperty(PROPERTY_MAP_CURSOR_HOTSPOT_X, "0"))));
    }

    public int getMapCursorHotspotY() {
        return Math.max(0, Math.min(256, Integer.parseInt(this.m_mapProperties.getProperty(PROPERTY_MAP_CURSOR_HOTSPOT_Y, "0"))));
    }

    public boolean getHasMapBlends() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(PROPERTY_MAP_MAPBLENDS, "false"));
    }

    public String getMapBlendMode() {
        return String.valueOf(this.m_mapProperties.getProperty(PROPERTY_MAP_MAPBLENDMODE, "normal")).toString();
    }

    public float getMapBlendAlpha() {
        return Float.valueOf(this.m_mapProperties.getProperty(PROPERTY_MAP_MAPBLENDALPHA, "0.5f")).floatValue();
    }

    public boolean drawCapitolMarkers() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(PROPERTY_MAP_SHOWCAPITOLMARKERS, "true"));
    }

    public boolean drawTerritoryNames() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(PROPERTY_MAP_SHOWTERRITORYNAMES, "true"));
    }

    public boolean drawResources() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(PROPERTY_MAP_SHOWRESOURCES, "true"));
    }

    public boolean drawComments() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(PROPERTY_MAP_SHOWCOMMENTS, "true"));
    }

    public boolean drawSeaZoneNames() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(PROPERTY_MAP_SHOWSEAZONENAMES, "false"));
    }

    public boolean drawNamesFromTopLeft() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(PROPERTY_MAP_DRAWNAMESFROMTOPLEFT, "false"));
    }

    public boolean useNation_convoyFlags() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(PROPERTY_MAP_USENATION_CONVOYFLAGS, "false"));
    }

    public boolean useTerritoryEffectMarkers() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(PROPERTY_MAP_USETERRITORYEFFECTMARKERS, "false"));
    }

    private void initializeContains() {
        this.m_contains = new HashMap<String, List<String>>();
        Iterator<String> seaIter = this.getTerritories().iterator();
        while (seaIter.hasNext()) {
            ArrayList<String> contained = new ArrayList<String>();
            String seaTerritory = seaIter.next();
            if (!seaTerritory.endsWith("Sea Zone") && !seaTerritory.startsWith("Sea Zone")) continue;
            for (String landTerritory : this.getTerritories()) {
                if (landTerritory.endsWith("Sea Zone") || landTerritory.startsWith("Sea Zone")) continue;
                Polygon landPoly = this.getPolygons(landTerritory).iterator().next();
                Polygon seaPoly = this.getPolygons(seaTerritory).iterator().next();
                if (!seaPoly.contains(landPoly.getBounds())) continue;
                contained.add(landTerritory);
            }
            if (contained.isEmpty()) continue;
            this.m_contains.put(seaTerritory, contained);
        }
    }

    public boolean getBooleanProperty(String propertiesKey) {
        return Boolean.valueOf(this.m_mapProperties.getProperty(propertiesKey, "true"));
    }

    public Color getColorProperty(String propertiesKey) throws IllegalStateException {
        if (this.m_mapProperties.getProperty(propertiesKey) != null) {
            String colorString = this.m_mapProperties.getProperty(propertiesKey);
            if (colorString.length() != 6) {
                throw new IllegalStateException("Colors must be a 6 digit hex number, eg FF0011, not:" + colorString);
            }
            try {
                Integer colorInt = Integer.decode("0x" + colorString);
                Color color = new Color(colorInt);
                return color;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalStateException("Player colors must be a 6 digit hex number, eg FF0011");
            }
        }
        return null;
    }

    public Color getPlayerColor(String playerName) {
        if (this.m_playerColors.containsKey(playerName)) {
            return this.m_playerColors.get(playerName);
        }
        String propertiesKey = PROPERTY_COLOR_PREFIX + playerName;
        Color color = null;
        try {
            color = this.getColorProperty(propertiesKey);
        }
        catch (Exception e) {
            throw new IllegalStateException("Player colors must be a 6 digit hex number, eg FF0011");
        }
        if (color == null) {
            System.out.println("No color defined for " + playerName + ".  Edit map.properties in the map folder to set it");
            color = this.m_defaultColours.remove(0);
        }
        this.m_playerColors.put(playerName, color);
        return color;
    }

    public String getProperty(String propertiesKey) {
        return this.m_mapProperties.getProperty(propertiesKey);
    }

    public Color impassibleColor() {
        return this.getPlayerColor(IMPASSIBLE);
    }

    public Set<String> getTerritories() {
        return this.m_polys.keySet();
    }

    public boolean hasContainedTerritory(String territoryName) {
        return this.m_contains.containsKey(territoryName);
    }

    public List<String> getContainedTerritory(String territoryName) {
        return this.m_contains.get(territoryName);
    }

    public void verify(GameData data) {
        this.verifyKeys(data, this.m_centers, "centers");
        this.verifyKeys(data, this.m_polys, "polygons");
        this.verifyKeys(data, this.m_place, "place");
    }

    private void verifyKeys(GameData data, Map<String, ?> aMap, String dataTypeForErrorMessage) throws IllegalStateException {
        StringBuilder errors = new StringBuilder();
        Iterator<String> iter = aMap.keySet().iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            Territory terr = data.getMap().getTerritory(name);
            if (terr != null) continue;
            iter.remove();
        }
        Iterator<Territory> territories = data.getMap().getTerritories().iterator();
        Set<String> keySet = aMap.keySet();
        while (territories.hasNext()) {
            Territory terr = territories.next();
            if (keySet.contains(terr.getName())) continue;
            errors.append("No data of type " + dataTypeForErrorMessage + " for territory:" + terr.getName() + "\n");
        }
        if (errors.length() > 0) {
            throw new IllegalStateException(errors.toString());
        }
    }

    public List<Point> getPlacementPoints(Territory terr) {
        return this.m_place.get(terr.getName());
    }

    public List<Polygon> getPolygons(String terr) {
        return this.m_polys.get(terr);
    }

    public List<Polygon> getPolygons(Territory terr) {
        return this.getPolygons(terr.getName());
    }

    public Point getCenter(String terr) {
        if (this.m_centers.get(terr) == null) {
            throw new IllegalStateException("Missing centers.txt data for " + terr);
        }
        return new Point(this.m_centers.get(terr));
    }

    public Point getCenter(Territory terr) {
        return this.getCenter(terr.getName());
    }

    public Point getCapitolMarkerLocation(Territory terr) {
        if (this.m_capitolPlace.containsKey(terr.getName())) {
            return this.m_capitolPlace.get(terr.getName());
        }
        return this.getCenter(terr);
    }

    public Point getConvoyMarkerLocation(Territory terr) {
        if (this.m_convoyPlace.containsKey(terr.getName())) {
            return this.m_convoyPlace.get(terr.getName());
        }
        return this.getCenter(terr);
    }

    public Point getCommentMarkerLocation(Territory terr) {
        if (this.m_commentPlace.containsKey(terr.getName())) {
            return this.m_commentPlace.get(terr.getName());
        }
        return null;
    }

    public Point getKamikazeMarkerLocation(Territory terr) {
        if (this.m_kamikazePlace.containsKey(terr.getName())) {
            return this.m_kamikazePlace.get(terr.getName());
        }
        return this.getCenter(terr);
    }

    public Point getVCPlacementPoint(Territory terr) {
        if (this.m_vcPlace.containsKey(terr.getName())) {
            return this.m_vcPlace.get(terr.getName());
        }
        return this.getCenter(terr);
    }

    public Point getBlockadePlacementPoint(Territory terr) {
        if (this.m_blockadePlace.containsKey(terr.getName())) {
            return this.m_blockadePlace.get(terr.getName());
        }
        return this.getCenter(terr);
    }

    public Point getPUPlacementPoint(Territory terr) {
        if (this.m_PUPlace.containsKey(terr.getName())) {
            return this.m_PUPlace.get(terr.getName());
        }
        return null;
    }

    public Point getNamePlacementPoint(Territory terr) {
        if (this.m_namePlace.containsKey(terr.getName())) {
            return this.m_namePlace.get(terr.getName());
        }
        return null;
    }

    public String getTerritoryAt(double x, double y) {
        String seaName = null;
        for (String name : this.m_polys.keySet()) {
            Collection polygons = this.m_polys.get(name);
            for (Polygon poly : polygons) {
                if (!poly.contains(x, y)) continue;
                if (name.endsWith("Sea Zone") || name.startsWith("Sea Zone")) {
                    seaName = name;
                    continue;
                }
                return name;
            }
        }
        return seaName;
    }

    public Dimension getMapDimensions() {
        String widthProperty = this.m_mapProperties.getProperty(PROPERTY_MAP_WIDTH);
        String heightProperty = this.m_mapProperties.getProperty(PROPERTY_MAP_HEIGHT);
        if (widthProperty == null || heightProperty == null) {
            throw new IllegalStateException("Missing map.width or map.height in map.properties");
        }
        int width = Integer.parseInt(widthProperty.trim());
        int height = Integer.parseInt(heightProperty.trim());
        return new Dimension(width, height);
    }

    public Rectangle getBoundingRect(Territory terr) {
        String name = terr.getName();
        return this.getBoundingRect(name);
    }

    public Rectangle getBoundingRect(String name) {
        List<Polygon> polys = this.m_polys.get(name);
        if (polys == null) {
            throw new IllegalStateException("No polygons found for:" + name + " All territories:" + this.m_polys.keySet());
        }
        Iterator<Polygon> polyIter = polys.iterator();
        Rectangle bounds = polyIter.next().getBounds();
        while (polyIter.hasNext()) {
            bounds.add(polyIter.next().getBounds());
        }
        Dimension mapDimensions = this.getMapDimensions();
        if (this.scrollWrapX() && bounds.width > 1800 && (double)bounds.width > (double)mapDimensions.width * 0.9 || this.scrollWrapY() && bounds.height > 1200 && (double)bounds.height > (double)mapDimensions.height * 0.9) {
            return this.getBoundingRectWithTranslate(polys, mapDimensions);
        }
        return bounds;
    }

    private Rectangle getBoundingRectWithTranslate(List<Polygon> polys, Dimension mapDimensions) {
        RectangularShape boundingRect = null;
        int mapWidth = mapDimensions.width;
        int mapHeight = mapDimensions.height;
        int closeToMapWidth = (int)((double)mapWidth * 0.9);
        int closeToMapHeight = (int)((double)mapHeight * 0.9);
        boolean scrollWrapX = this.scrollWrapX();
        boolean scrollWrapY = this.scrollWrapY();
        for (Polygon item : polys) {
            Rectangle itemRect = item.getBounds();
            if (scrollWrapX && itemRect.getMaxX() >= (double)closeToMapWidth) {
                itemRect.translate(-mapWidth, 0);
            }
            if (scrollWrapY && itemRect.getMaxY() >= (double)closeToMapHeight) {
                itemRect.translate(0, -mapHeight);
            }
            if (boundingRect == null) {
                boundingRect = itemRect;
                continue;
            }
            ((Rectangle)boundingRect).add(itemRect);
        }
        if (((Rectangle)boundingRect).x < 0 && boundingRect.getMaxX() <= 0.0) {
            ((Rectangle)boundingRect).translate(mapWidth, 0);
        }
        if (((Rectangle)boundingRect).y < 0 && boundingRect.getMaxY() <= 0.0) {
            ((Rectangle)boundingRect).translate(0, mapHeight);
        }
        return boundingRect;
    }

    public List<String> territoriesThatOverlap(Rectangle2D bounds) {
        ArrayList<String> rVal = null;
        block0: for (String terr : this.getTerritories()) {
            List<Polygon> polygons = this.getPolygons(terr);
            for (int i = 0; i < polygons.size(); ++i) {
                Polygon item = polygons.get(i);
                if (!item.intersects(bounds) && !item.contains(bounds) && !bounds.contains(item.getBounds2D())) continue;
                if (rVal == null) {
                    rVal = new ArrayList<String>(4);
                }
                rVal.add(terr);
                continue block0;
            }
        }
        if (rVal == null) {
            return Collections.emptyList();
        }
        return rVal;
    }

    public Image getVCImage() {
        if (this.m_vcImage != null) {
            return this.m_vcImage;
        }
        this.m_vcImage = this.loadImage("misc/vc.png");
        return this.m_vcImage;
    }

    public Image getBlockadeImage() {
        if (this.m_blockadeImage != null) {
            return this.m_blockadeImage;
        }
        this.m_blockadeImage = this.loadImage("misc/blockade.png");
        return this.m_blockadeImage;
    }

    public Image getErrorImage() {
        if (this.m_errorImage != null) {
            return this.m_errorImage;
        }
        this.m_errorImage = this.loadImage("misc/error.gif");
        return this.m_errorImage;
    }

    public Image getWarningImage() {
        if (this.m_warningImage != null) {
            return this.m_warningImage;
        }
        this.m_warningImage = this.loadImage("misc/warning.gif");
        return this.m_warningImage;
    }

    public Image getInfoImage() {
        if (this.m_infoImage != null) {
            return this.m_infoImage;
        }
        this.m_infoImage = this.loadImage("misc/information.gif");
        return this.m_infoImage;
    }

    public Image getHelpImage() {
        if (this.m_helpImage != null) {
            return this.m_helpImage;
        }
        this.m_helpImage = this.loadImage("misc/help.gif");
        return this.m_helpImage;
    }

    private BufferedImage loadImage(String imageName) {
        URL url = this.m_resourceLoader.getResource(imageName);
        if (url == null) {
            throw new IllegalStateException("Could not load " + imageName);
        }
        try {
            return ImageIO.read(url);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Map<String, Image> getTerritoryNameImages() {
        return Collections.unmodifiableMap(this.m_territoryNameImages);
    }

    public Map<Image, List<Point>> getDecorations() {
        return Collections.unmodifiableMap(this.m_decorations);
    }

    public List<Point> getTerritoryEffectPoints(Territory territory) {
        if (this.m_territoryEffects.get(territory.getName()) == null) {
            return Arrays.asList(this.getCenter(territory));
        }
        return this.m_territoryEffects.get(territory.getName());
    }

    public Image getTerritoryEffectImage(String m_effectName) {
        if (this.m_effectImages.get(m_effectName) != null) {
            return this.m_effectImages.get(m_effectName);
        }
        BufferedImage effectImage = this.loadImage("territoryEffects/" + m_effectName + ".png");
        this.m_effectImages.put(m_effectName, effectImage);
        return effectImage;
    }
}

