/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.common.delegate.BaseEditDelegate;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AbstractMoveDelegate;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveDelegate;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.UnitComparator;
import games.strategy.triplea.delegate.dataObjects.MoveDescription;
import games.strategy.triplea.delegate.dataObjects.MoveValidationResult;
import games.strategy.triplea.delegate.dataObjects.MustMoveWithDetails;
import games.strategy.triplea.ui.AbstractMovePanel;
import games.strategy.triplea.ui.DefaultMapSelectionListener;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.MapSelectionListener;
import games.strategy.triplea.ui.MouseDetails;
import games.strategy.triplea.ui.MouseOverUnitListener;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.triplea.ui.UndoableMovesPanel;
import games.strategy.triplea.ui.UnitChooser;
import games.strategy.triplea.ui.UnitSelectionListener;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.util.CompositeMatch;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.InverseMatch;
import games.strategy.util.Match;
import games.strategy.util.Util;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovePanel
extends AbstractMovePanel {
    private static final long serialVersionUID = 5004515340964828564L;
    private static final int s_defaultMinTransportCost = 5;
    private static final int s_deselectNumber = 10;
    private Territory m_firstSelectedTerritory;
    private Territory m_selectedEndpointTerritory;
    private Territory m_mouseCurrentTerritory;
    private Territory m_lastFocusedTerritory;
    private List<Territory> m_forced;
    private boolean m_nonCombat;
    private Point m_mouseSelectedPoint;
    private Point m_mouseCurrentPoint;
    private Point m_mouseLastUpdatePoint;
    private final Set<Unit> m_selectedUnits = new LinkedHashSet<Unit>();
    private static Map<Unit, Collection<Unit>> s_dependentUnits = new HashMap<Unit, Collection<Unit>>();
    private MustMoveWithDetails m_mustMoveWithDetails = null;
    private List<Unit> m_unitsThatCanMoveOnRoute;
    private Image m_currentCursorImage;
    private TransportTracker m_transportTracker = null;
    private Route m_routeCached = null;
    private String m_displayText = "Combat Move";
    private AbstractMoveDelegate.MoveType m_moveType = AbstractMoveDelegate.MoveType.DEFAULT;
    private final UnitSelectionListener m_UNIT_SELECTION_LISTENER = new UnitSelectionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unitsSelected(List<Unit> units, Territory t, MouseDetails me) {
            if (!MovePanel.this.getListening()) {
                return;
            }
            if (!MovePanel.this.getActive()) {
                return;
            }
            if (t == null) {
                return;
            }
            boolean rightMouse = me.isRightButton();
            boolean noSelectedTerritory = MovePanel.this.m_firstSelectedTerritory == null;
            boolean isFirstSelectedTerritory = MovePanel.this.m_firstSelectedTerritory == t;
            GameData data = MovePanel.this.getData();
            data.acquireReadLock();
            try {
                if (rightMouse && !noSelectedTerritory) {
                    this.deselectUnits(units, t, me);
                } else if (!rightMouse && (noSelectedTerritory || isFirstSelectedTerritory)) {
                    this.selectUnitsToMove(units, t, me);
                } else if (!rightMouse && me.isControlDown() && !isFirstSelectedTerritory) {
                    this.selectWayPoint(t);
                } else if (!(rightMouse || noSelectedTerritory || isFirstSelectedTerritory)) {
                    this.selectEndPoint(t);
                }
            }
            finally {
                data.releaseReadLock();
            }
            MovePanel.this.getMap().requestFocusInWindow();
        }

        private void selectUnitsToMove(List<Unit> units, Territory t, MouseDetails me) {
            List<Unit> unitsToMove;
            if (!BaseEditDelegate.getEditMode(MovePanel.this.getData()) || !MovePanel.this.m_selectedUnits.isEmpty()) {
                for (Unit unit : units) {
                    if (unit.getOwner().equals(MovePanel.this.getUnitOwner(MovePanel.this.m_selectedUnits))) continue;
                    return;
                }
            }
            CompositeMatch unitsToMoveMatch = MovePanel.this.getMovableMatch(null, null);
            Match<Collection<Unit>> ownerMatch = new Match<Collection<Unit>>(){

                @Override
                public boolean match(Collection<Unit> unitsToCheck) {
                    PlayerID owner = unitsToCheck.iterator().next().getOwner();
                    for (Unit unit : unitsToCheck) {
                        if (owner.equals(unit.getOwner())) continue;
                        return false;
                    }
                    return true;
                }
            };
            if (units.isEmpty() && MovePanel.this.m_selectedUnits.isEmpty() && !me.isShiftDown()) {
                unitsToMove = t.getUnits().getMatches(unitsToMoveMatch);
                if (unitsToMove.isEmpty()) {
                    return;
                }
                String text = "Select units to move from " + t.getName();
                UnitChooser chooser = BaseEditDelegate.getEditMode(MovePanel.this.getData()) && !Match.getMatches(unitsToMove, Matches.unitIsOwnedBy(MovePanel.this.getUnitOwner(unitsToMove))).containsAll(unitsToMove) ? new UnitChooser(unitsToMove, MovePanel.this.m_selectedUnits, null, false, false, MovePanel.this.getData(), false, MovePanel.this.getMap().getUIContext(), ownerMatch) : new UnitChooser(unitsToMove, MovePanel.this.m_selectedUnits, null, false, false, MovePanel.this.getData(), false, MovePanel.this.getMap().getUIContext());
                int option = JOptionPane.showOptionDialog(MovePanel.this.getTopLevelAncestor(), chooser, text, 2, -1, null, null, null);
                if (option != 0) {
                    return;
                }
                if (chooser.getSelected(false).isEmpty()) {
                    return;
                }
                MovePanel.this.m_selectedUnits.addAll(chooser.getSelected(false));
            }
            if (MovePanel.this.getFirstSelectedTerritory() == null) {
                MovePanel.this.setFirstSelectedTerritory(t);
                MovePanel.this.m_mouseSelectedPoint = me.getMapPoint();
                MovePanel.this.m_mouseCurrentPoint = me.getMapPoint();
                MovePanel.this.enableCancelButton();
            }
            if (!MovePanel.this.getFirstSelectedTerritory().equals(t)) {
                throw new IllegalStateException("Wrong selected territory");
            }
            if (me.isShiftDown()) {
                CompositeMatchAnd<Unit> ownedNotFactory = new CompositeMatchAnd<Unit>(new Match[0]);
                if (!BaseEditDelegate.getEditMode(MovePanel.this.getData())) {
                    ownedNotFactory.add(unitsToMoveMatch);
                } else if (!MovePanel.this.m_selectedUnits.isEmpty()) {
                    ownedNotFactory.add(unitsToMoveMatch);
                    ownedNotFactory.add(Matches.unitIsOwnedBy(MovePanel.this.getUnitOwner(MovePanel.this.m_selectedUnits)));
                } else {
                    ownedNotFactory.add(unitsToMoveMatch);
                    ownedNotFactory.add(Matches.unitIsOwnedBy(MovePanel.this.getUnitOwner(t.getUnits().getUnits())));
                }
                MovePanel.this.m_selectedUnits.addAll(t.getUnits().getMatches(ownedNotFactory));
            } else if (me.isControlDown()) {
                MovePanel.this.m_selectedUnits.addAll(Match.getMatches(units, unitsToMoveMatch));
            } else {
                unitsToMove = Match.getMatches(units, unitsToMoveMatch);
                Collections.sort(unitsToMove, UnitComparator.getHighestToLowestMovementComparator());
                int iterCount = me.isAltDown() ? 10 : 1;
                int addCount = 0;
                for (Unit unit : unitsToMove) {
                    if (MovePanel.this.m_selectedUnits.contains(unit)) continue;
                    MovePanel.this.m_selectedUnits.add(unit);
                    if (++addCount < iterCount) continue;
                    break;
                }
            }
            if (!MovePanel.this.m_selectedUnits.isEmpty()) {
                MovePanel.this.m_mouseLastUpdatePoint = me.getMapPoint();
                Route route = MovePanel.this.getRoute(MovePanel.this.getFirstSelectedTerritory(), t, MovePanel.this.m_selectedUnits);
                if ((!MovePanel.this.m_nonCombat || MovePanel.IsParatroopersCanMoveDuringNonCombat(MovePanel.this.getData())) && MovePanel.isParatroopers(MovePanel.this.getCurrentPlayer()) && Match.someMatch(MovePanel.this.m_selectedUnits, new CompositeMatchAnd(Matches.UnitIsAirTransport, Matches.unitHasNotMoved))) {
                    PlayerID player = MovePanel.this.getCurrentPlayer();
                    CompositeMatchAnd<Unit> unitsToLoadMatch = new CompositeMatchAnd<Unit>(new Match[0]);
                    unitsToLoadMatch.add(Matches.UnitIsAirTransportable);
                    unitsToLoadMatch.add(Matches.unitIsOwnedBy(player));
                    unitsToLoadMatch.add(Matches.unitHasNotMoved);
                    List<Unit> unitsToLoad = Match.getMatches(route.getStart().getUnits().getUnits(), unitsToLoadMatch);
                    unitsToLoad.removeAll(MovePanel.this.m_selectedUnits);
                    for (Unit u : s_dependentUnits.keySet()) {
                        unitsToLoad.removeAll((Collection)s_dependentUnits.get(u));
                    }
                    CompositeMatchAnd<Unit> candidateAirTransportsMatch = new CompositeMatchAnd<Unit>(new Match[0]);
                    candidateAirTransportsMatch.add(Matches.UnitIsAirTransport);
                    candidateAirTransportsMatch.add(Matches.unitIsOwnedBy(player));
                    candidateAirTransportsMatch.add(Matches.unitHasNotMoved);
                    candidateAirTransportsMatch.add(Matches.transportIsNotTransporting());
                    List<Unit> candidateAirTransports = Match.getMatches(t.getUnits().getMatches(unitsToMoveMatch), candidateAirTransportsMatch);
                    candidateAirTransports.removeAll(s_dependentUnits.keySet());
                    if (unitsToLoad.size() > 0 && candidateAirTransports.size() > 0) {
                        Collection<Unit> airTransportsToLoad = this.getAirTransportsToLoad(candidateAirTransports);
                        MovePanel.this.m_selectedUnits.addAll(airTransportsToLoad);
                        if (!airTransportsToLoad.isEmpty()) {
                            Collection<Unit> loadedAirTransports = this.getLoadedAirTransports(route, unitsToLoad, airTransportsToLoad, player);
                            MovePanel.this.m_selectedUnits.addAll(loadedAirTransports);
                            MoveDescription message = new MoveDescription(loadedAirTransports, route, airTransportsToLoad, s_dependentUnits);
                            MovePanel.this.setMoveMessage(message);
                        }
                    }
                }
                MovePanel.this.updateUnitsThatCanMoveOnRoute(MovePanel.this.m_selectedUnits, route);
                MovePanel.this.updateRouteAndMouseShadowUnits(route);
            } else {
                MovePanel.this.setFirstSelectedTerritory(null);
            }
        }

        public Collection<Unit> getAirTransportsToLoad(final Collection<Unit> candidateAirTransports) {
            HashSet<Unit> defaultSelections = new HashSet<Unit>();
            Match<Collection<Unit>> transportsToLoadMatch = new Match<Collection<Unit>>(){

                @Override
                public boolean match(Collection<Unit> units) {
                    List<Unit> airTransports = Match.getMatches(units, Matches.UnitIsAirTransport);
                    return airTransports.size() <= candidateAirTransports.size();
                }
            };
            UnitChooser chooser = new UnitChooser(candidateAirTransports, defaultSelections, s_dependentUnits, true, false, MovePanel.this.getGameData(), false, MovePanel.this.getMap().getUIContext(), transportsToLoadMatch);
            chooser.setTitle("Select air transports to load");
            int option = JOptionPane.showOptionDialog(MovePanel.this.getTopLevelAncestor(), chooser, "What transports do you want to load", 2, -1, null, null, null);
            if (option != 0) {
                return Collections.emptyList();
            }
            return chooser.getSelected(true);
        }

        public Collection<Unit> getLoadedAirTransports(final Route route, Collection<Unit> capableUnitsToLoad, Collection<Unit> capableTransportsToLoad, final PlayerID player) {
            int minTransportCost = Integer.MAX_VALUE;
            for (Unit unit : capableUnitsToLoad) {
                minTransportCost = Math.min(minTransportCost, UnitAttachment.get(unit.getType()).getTransportCost());
            }
            final ArrayList<Unit> airTransportsToLoad = new ArrayList<Unit>();
            int ttlCapacity = 0;
            for (Unit bomber : capableTransportsToLoad) {
                int capacity = MovePanel.this.getTransportTracker().getAvailableCapacity(bomber);
                if (capacity < minTransportCost) continue;
                airTransportsToLoad.add(bomber);
                ttlCapacity += capacity;
            }
            if (airTransportsToLoad.isEmpty()) {
                return airTransportsToLoad;
            }
            HashSet<Unit> defaultSelections = new HashSet<Unit>();
            Match<Collection<Unit>> unitsToLoadMatch = new Match<Collection<Unit>>(){

                @Override
                public boolean match(Collection<Unit> units) {
                    List<Unit> unitsToLoad = Match.getMatches(units, Matches.UnitIsAirTransportable);
                    Map<Unit, Unit> unitMap = MoveDelegate.mapTransports(route, unitsToLoad, airTransportsToLoad, true, player);
                    boolean ableToLoad = true;
                    for (Unit unit : unitsToLoad) {
                        if (unitMap.keySet().contains(unit)) continue;
                        ableToLoad = false;
                    }
                    return ableToLoad;
                }
            };
            List<Unit> loadedUnits = new ArrayList<Unit>(capableUnitsToLoad);
            if (!airTransportsToLoad.isEmpty()) {
                List<Unit> unitsToLoad = MoveDelegate.mapAirTransportPossibilities(route, capableUnitsToLoad, airTransportsToLoad, true, player);
                String title = "Load air transports";
                String action = "load";
                loadedUnits = MovePanel.this.UserChooseUnits(defaultSelections, unitsToLoadMatch, unitsToLoad, "Load air transports", "load");
                Map<Unit, Unit> mapping = MoveDelegate.mapTransports(route, loadedUnits, airTransportsToLoad, true, player);
                for (Unit unit : mapping.keySet()) {
                    ArrayList<Unit> unitsColl = new ArrayList<Unit>();
                    unitsColl.add(unit);
                    Unit airTransport = mapping.get(unit);
                    if (s_dependentUnits.containsKey(airTransport)) {
                        unitsColl.addAll((Collection)s_dependentUnits.get(airTransport));
                    }
                    s_dependentUnits.put(airTransport, unitsColl);
                    MovePanel.this.m_mustMoveWithDetails = MoveValidator.getMustMoveWith(route.getStart(), route.getStart().getUnits().getUnits(), s_dependentUnits, MovePanel.this.getData(), player);
                }
            }
            return loadedUnits;
        }

        private void deselectUnits(List<Unit> units, Territory t, MouseDetails me) {
            ArrayList unitsToRemove = new ArrayList(MovePanel.this.m_selectedUnits.size());
            if (!MovePanel.this.getFirstSelectedTerritory().equals(t)) {
                units = Collections.emptyList();
            }
            ArrayList unitsWithoutDependents = new ArrayList(MovePanel.this.m_selectedUnits);
            for (Unit unit : MovePanel.this.m_selectedUnits) {
                Collection<Unit> forced = MovePanel.this.m_mustMoveWithDetails.getMustMoveWith().get(unit);
                if (forced == null) continue;
                unitsWithoutDependents.removeAll(forced);
            }
            if (units.isEmpty()) {
                if (me.isControlDown()) {
                    MovePanel.this.m_selectedUnits.clear();
                    if (!s_dependentUnits.isEmpty()) {
                        s_dependentUnits.clear();
                    }
                } else if (!unitsWithoutDependents.isEmpty()) {
                    int iterCount = me.isAltDown() ? 10 : 1;
                    for (int i = 0; i < iterCount; ++i) {
                        unitsToRemove.add(unitsWithoutDependents.get(unitsWithoutDependents.size() - 1));
                        if (s_dependentUnits.isEmpty()) continue;
                        for (Unit airTransport : unitsWithoutDependents) {
                            if (!s_dependentUnits.containsKey(airTransport)) continue;
                            unitsToRemove.addAll((Collection)s_dependentUnits.get(airTransport));
                            s_dependentUnits.remove(airTransport);
                        }
                    }
                }
            } else if (me.isControlDown()) {
                unitsToRemove.addAll(units);
                if (!s_dependentUnits.isEmpty()) {
                    for (Unit airTransport : unitsWithoutDependents) {
                        if (!s_dependentUnits.containsKey(airTransport)) continue;
                        unitsToRemove.addAll((Collection)s_dependentUnits.get(airTransport));
                        s_dependentUnits.remove(airTransport);
                    }
                }
            } else {
                if (!MovePanel.this.getFirstSelectedTerritory().equals(t)) {
                    throw new IllegalStateException("Wrong selected territory");
                }
                int iterCount = me.isAltDown() ? 10 : 1;
                int remCount = 0;
                for (Unit unit : units) {
                    if (!MovePanel.this.m_selectedUnits.contains(unit) || unitsToRemove.contains(unit)) continue;
                    unitsToRemove.add(unit);
                    if (!s_dependentUnits.isEmpty()) {
                        for (Unit airTransport : unitsWithoutDependents) {
                            if (!s_dependentUnits.containsKey(airTransport)) continue;
                            ((Collection)s_dependentUnits.get(airTransport)).remove(unit);
                        }
                    }
                    if (++remCount < iterCount) continue;
                    break;
                }
            }
            MovePanel.this.m_selectedUnits.removeAll(unitsToRemove);
            if (MovePanel.this.m_selectedUnits.isEmpty()) {
                MovePanel.this.cancelMove();
            } else {
                MovePanel.this.m_mouseLastUpdatePoint = me.getMapPoint();
                MovePanel.this.updateUnitsThatCanMoveOnRoute(MovePanel.this.m_selectedUnits, MovePanel.this.getRoute(MovePanel.this.getFirstSelectedTerritory(), t, MovePanel.this.m_selectedUnits));
                MovePanel.this.updateRouteAndMouseShadowUnits(MovePanel.this.getRoute(MovePanel.this.getFirstSelectedTerritory(), t, MovePanel.this.m_selectedUnits));
            }
        }

        private void selectWayPoint(Territory territory) {
            if (MovePanel.this.m_forced == null) {
                MovePanel.this.m_forced = new ArrayList();
            }
            if (!MovePanel.this.m_forced.contains(territory)) {
                MovePanel.this.m_forced.add(territory);
            }
            MovePanel.this.updateRouteAndMouseShadowUnits(MovePanel.this.getRoute(MovePanel.this.getFirstSelectedTerritory(), MovePanel.this.getFirstSelectedTerritory(), MovePanel.this.m_selectedUnits));
        }

        private CompositeMatch<Unit> getUnloadableMatch() {
            CompositeMatchAnd<Unit> unloadable = new CompositeMatchAnd<Unit>(new Match[0]);
            unloadable.add(Matches.unitIsOwnedBy(MovePanel.this.getCurrentPlayer()));
            unloadable.add(Matches.UnitIsLand);
            if (MovePanel.this.m_nonCombat) {
                unloadable.add(Matches.UnitCanNotMoveDuringCombatMove.invert());
            }
            return unloadable;
        }

        private void selectEndPoint(Territory territory) {
            Route route = MovePanel.this.getRoute(MovePanel.this.getFirstSelectedTerritory(), territory, MovePanel.this.m_selectedUnits);
            List units = MovePanel.this.m_unitsThatCanMoveOnRoute;
            MovePanel.this.setSelectedEndpointTerritory(territory);
            if (units.isEmpty() || route == null) {
                MovePanel.this.cancelMove();
                return;
            }
            ArrayList<Unit> transports = null;
            CompositeMatchAnd<Unit> paratroopNBombers = new CompositeMatchAnd<Unit>(new Match[0]);
            paratroopNBombers.add(Matches.UnitIsAirTransport);
            paratroopNBombers.add(Matches.UnitIsAirTransportable);
            boolean paratroopsLanding = Match.someMatch(units, paratroopNBombers);
            if (route.isLoad() && Match.someMatch(units, Matches.UnitIsLand)) {
                transports = MovePanel.this.getTransportsToLoad(route, units, false);
                if (transports.isEmpty()) {
                    MovePanel.this.cancelMove();
                    return;
                }
            } else if (route.isUnload() && Match.someMatch(units, Matches.UnitIsLand) || paratroopsLanding) {
                List<Unit> unloadAble = Match.getMatches(MovePanel.this.m_selectedUnits, this.getUnloadableMatch());
                ArrayList<Unit> canMove = new ArrayList<Unit>(MovePanel.this.getUnitsToUnload(route, unloadAble));
                canMove.addAll(Match.getMatches(MovePanel.this.m_selectedUnits, new InverseMatch<Unit>(this.getUnloadableMatch())));
                if (paratroopsLanding) {
                    transports = canMove;
                }
                if (canMove.isEmpty()) {
                    MovePanel.this.cancelMove();
                    return;
                }
                MovePanel.this.m_selectedUnits.clear();
                MovePanel.this.m_selectedUnits.addAll(canMove);
            } else {
                final IntegerMap<UnitType> maxMap = new IntegerMap<UnitType>();
                for (Unit unit : units) {
                    maxMap.add(unit.getType(), 1);
                }
                Match<Collection<Unit>> unitTypeCountMatch = new Match<Collection<Unit>>(){

                    @Override
                    public boolean match(Collection<Unit> units) {
                        IntegerMap<UnitType> currentMap = new IntegerMap<UnitType>();
                        for (Unit unit : units) {
                            currentMap.add(unit.getType(), 1);
                        }
                        return maxMap.greaterThanOrEqualTo(currentMap);
                    }
                };
                MovePanel.this.allowSpecificUnitSelection(units, route, false, unitTypeCountMatch);
                if (units.isEmpty()) {
                    MovePanel.this.cancelMove();
                    return;
                }
            }
            MoveDescription message = new MoveDescription(units, route, (Collection<Unit>)transports, s_dependentUnits);
            MovePanel.this.setMoveMessage(message);
            MovePanel.this.setFirstSelectedTerritory(null);
            MovePanel.this.setSelectedEndpointTerritory(null);
            MovePanel.this.m_mouseCurrentTerritory = null;
            MovePanel.this.m_forced = null;
            MovePanel.this.updateRouteAndMouseShadowUnits(null);
            MovePanel.this.release();
        }
    };
    private final MouseOverUnitListener m_MOUSE_OVER_UNIT_LISTENER = new MouseOverUnitListener(){

        @Override
        public void mouseEnter(List<Unit> units, Territory territory, MouseDetails me) {
            boolean isCorrectTerritory;
            if (!MovePanel.this.getListening()) {
                return;
            }
            PlayerID owner = MovePanel.this.getUnitOwner(MovePanel.this.m_selectedUnits);
            CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(owner));
            match.add(Matches.UnitCanMove);
            boolean someOwned = Match.someMatch(units, match);
            boolean bl = isCorrectTerritory = MovePanel.this.m_firstSelectedTerritory == null || MovePanel.this.m_firstSelectedTerritory == territory;
            if (someOwned && isCorrectTerritory) {
                HashMap<Territory, List<Unit>> highlight = new HashMap<Territory, List<Unit>>();
                highlight.put(territory, units);
                MovePanel.this.getMap().setUnitHighlight(highlight);
            } else {
                MovePanel.this.getMap().setUnitHighlight(null);
            }
        }
    };
    private final MapSelectionListener m_MAP_SELECTION_LISTENER = new DefaultMapSelectionListener(){

        public void territorySelected(Territory territory, MouseDetails me) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void mouseMoved(Territory territory, MouseDetails me) {
            if (!MovePanel.this.getListening()) {
                return;
            }
            if (MovePanel.access$400(MovePanel.this) != null && territory != null) {
                if (MovePanel.access$2100(MovePanel.this) == null || !MovePanel.access$2100(MovePanel.this).equals(territory) || MovePanel.access$600(MovePanel.this).equals(MovePanel.access$700(MovePanel.this))) {
                    route = MovePanel.access$800(MovePanel.this, MovePanel.access$400(MovePanel.this), territory, MovePanel.access$100(MovePanel.this));
                    MovePanel.this.getData().acquireReadLock();
                    try {
                        MovePanel.access$1300(MovePanel.this, MovePanel.access$100(MovePanel.this), route);
                        if (MovePanel.access$1700(MovePanel.this).size() >= MovePanel.access$100(MovePanel.this).size() || MovePanel.access$1700(MovePanel.this).size() != 0 && !Match.allMatch(MovePanel.access$1700(MovePanel.this), Matches.UnitIsAir) || (airUnits = Match.getMatches(MovePanel.access$100(MovePanel.this), Matches.UnitIsAir)).size() <= 0) ** GOTO lbl17
                        route = MovePanel.access$800(MovePanel.this, MovePanel.access$400(MovePanel.this), territory, airUnits);
                        MovePanel.access$1300(MovePanel.this, airUnits, route);
                    }
                    finally {
                        MovePanel.this.getData().releaseReadLock();
                    }
                } else {
                    route = MovePanel.access$2200(MovePanel.this);
                }
lbl17:
                // 3 sources

                MovePanel.access$602(MovePanel.this, me.getMapPoint());
                MovePanel.this.updateRouteAndMouseShadowUnits(route);
            }
            MovePanel.access$2102(MovePanel.this, territory);
        }
    };

    public MovePanel(GameData data, MapPanel map, TripleAFrame frame) {
        super(data, map, frame);
        this.m_undoableMovesPanel = new UndoableMovesPanel(data, this);
        this.m_mouseCurrentTerritory = null;
        this.m_unitsThatCanMoveOnRoute = Collections.emptyList();
        this.m_currentCursorImage = null;
    }

    private static Map<Unit, Collection<Unit>> getDependents() {
        return s_dependentUnits;
    }

    public static void clearDependents(Collection<Unit> units) {
        for (Unit unit : units) {
            if (!Matches.UnitIsAirTransport.match(unit)) continue;
            s_dependentUnits.remove(unit);
        }
    }

    @Override
    protected void clearDependencies() {
        s_dependentUnits.clear();
    }

    public void setMoveType(AbstractMoveDelegate.MoveType moveType) {
        this.m_moveType = moveType;
    }

    private PlayerID getUnitOwner(Collection<Unit> units) {
        if (BaseEditDelegate.getEditMode(this.getData()) && units != null && !units.isEmpty()) {
            return units.iterator().next().getOwner();
        }
        return this.getCurrentPlayer();
    }

    private void sortUnitsToMove(List<Unit> units, Route route) {
        if (units.isEmpty()) {
            return;
        }
        if (route.isUnload() && Match.someMatch(units, Matches.UnitIsLand)) {
            Collections.sort(units, UnitComparator.getUnloadableUnitsComparator(units, route, this.getUnitOwner(units), true));
        } else {
            Collections.sort(units, UnitComparator.getMovableUnitsComparator(units, route, this.getUnitOwner(units), true));
        }
    }

    private void sortTransportsToLoad(List<Unit> transports, Route route) {
        if (transports.isEmpty()) {
            return;
        }
        Collections.sort(transports, UnitComparator.getLoadableTransportsComparator(transports, route, this.getUnitOwner(transports), true));
    }

    private void sortTransportsToUnload(List<Unit> transports, Route route) {
        if (transports.isEmpty()) {
            return;
        }
        Collections.sort(transports, UnitComparator.getUnloadableTransportsComparator(transports, route, this.getUnitOwner(transports), true));
    }

    private Collection<Unit> getUnitsToUnload(Route route, final Collection<Unit> unitsToUnload) {
        Collection<Unit> allUnits = this.getFirstSelectedTerritory().getUnits().getUnits();
        List<Unit> candidateUnits = Match.getMatches(allUnits, this.getUnloadableMatch(route, unitsToUnload));
        if (unitsToUnload.size() == candidateUnits.size()) {
            return unitsToUnload;
        }
        List<Unit> candidateTransports = Match.getMatches(allUnits, Matches.unitIsTransportingSomeCategories(candidateUnits));
        List<Unit> incapableTransports = Match.getMatches(candidateTransports, Matches.transportCannotUnload(route.getEnd()));
        candidateTransports.removeAll(incapableTransports);
        if (candidateTransports.size() == 0) {
            return Collections.emptyList();
        }
        if (candidateTransports.size() == 1) {
            return unitsToUnload;
        }
        Set<UnitCategory> categories = UnitSeperator.categorize(candidateTransports, this.m_mustMoveWithDetails.getMustMoveWith(), true, false);
        if (categories.size() == 1) {
            return unitsToUnload;
        }
        this.sortTransportsToUnload(candidateTransports, route);
        Map<Unit, Unit> unitsToTransports = MoveDelegate.mapTransports(route, unitsToUnload, candidateTransports);
        HashSet<Unit> defaultSelections = new HashSet<Unit>(unitsToTransports.values());
        Match<Collection<Unit>> transportsToUnloadMatch = new Match<Collection<Unit>>(){

            @Override
            public boolean match(Collection<Unit> units) {
                List<Unit> sortedTransports = Match.getMatches(units, Matches.UnitIsTransport);
                ArrayList availableUnits = new ArrayList(unitsToUnload);
                IntegerMap<Unit> capacityMap = new IntegerMap<Unit>();
                for (Unit transport : sortedTransports) {
                    List<Unit> transporting = TripleAUnit.get(transport).getTransporting();
                    capacityMap.add(transport, MoveValidator.getTransportCost(transporting));
                }
                boolean hasChanged = false;
                Comparator<Unit> increasingCapacityComparator = UnitComparator.getIncreasingCapacityComparator(sortedTransports);
                do {
                    hasChanged = false;
                    Collections.sort(sortedTransports, increasingCapacityComparator);
                    Iterator<Unit> transportIter = sortedTransports.iterator();
                    block2: while (transportIter.hasNext()) {
                        Unit transport = transportIter.next();
                        List<Unit> transporting = TripleAUnit.get(transport).getTransporting();
                        if (transporting == null) continue;
                        Set<UnitCategory> transCategories = UnitSeperator.categorize(transporting);
                        Iterator unitIter = availableUnits.iterator();
                        while (unitIter.hasNext()) {
                            Unit unit = (Unit)unitIter.next();
                            Set<UnitCategory> unitCategory = UnitSeperator.categorize(Collections.singleton(unit));
                            if (!Util.someIntersect(transCategories, unitCategory)) continue;
                            hasChanged = true;
                            unitIter.remove();
                            transportIter.remove();
                            continue block2;
                        }
                    }
                } while (availableUnits.size() > 0 && hasChanged);
                return sortedTransports.size() == 0;
            }
        };
        UnitChooser chooser = new UnitChooser(candidateTransports, defaultSelections, this.m_mustMoveWithDetails.getMustMoveWith(), true, false, this.getGameData(), false, this.getMap().getUIContext(), transportsToUnloadMatch);
        chooser.setTitle("What transports do you want to unload");
        int option = JOptionPane.showOptionDialog(this.getTopLevelAncestor(), chooser, "What transports do you want to unload", 2, -1, null, null, null);
        if (option != 0) {
            return Collections.emptyList();
        }
        String title = "unload";
        String action = "unload";
        List<Unit> chosenUnits = this.UserChooseUnits(defaultSelections, transportsToUnloadMatch, candidateTransports, "unload", "unload");
        List<Unit> choosenTransports = Match.getMatches(chosenUnits, Matches.UnitIsTransport);
        ArrayList<Unit> allUnitsInSelectedTransports = new ArrayList<Unit>();
        for (Unit transport : choosenTransports) {
            List<Unit> transporting = TripleAUnit.get(transport).getTransporting();
            if (transporting == null) continue;
            allUnitsInSelectedTransports.addAll(transporting);
        }
        allUnitsInSelectedTransports.retainAll(candidateUnits);
        this.sortUnitsToMove(allUnitsInSelectedTransports, route);
        ArrayList<Unit> rVal = new ArrayList<Unit>();
        ArrayList<Unit> sortedTransports = new ArrayList<Unit>(choosenTransports);
        Collections.sort(sortedTransports, UnitComparator.getIncreasingCapacityComparator(sortedTransports));
        ArrayList<Unit> selectedUnits = new ArrayList<Unit>(unitsToUnload);
        block1: for (Unit transport : sortedTransports) {
            boolean hasChanged = false;
            Iterator selectedIter = selectedUnits.iterator();
            while (selectedIter.hasNext()) {
                Unit selected = (Unit)selectedIter.next();
                List<Unit> transporting = TripleAUnit.get(transport).getTransporting();
                for (Unit candidate : transporting) {
                    if (!selected.getType().equals(candidate.getType()) || !selected.getOwner().equals(candidate.getOwner()) || selected.getHits() != candidate.getHits()) continue;
                    hasChanged = true;
                    rVal.add(candidate);
                    allUnitsInSelectedTransports.remove(candidate);
                    selectedIter.remove();
                    break;
                }
                if (!hasChanged) continue;
                continue block1;
            }
        }
        block4: for (Unit selected : selectedUnits) {
            Iterator candidateIter = allUnitsInSelectedTransports.iterator();
            while (candidateIter.hasNext()) {
                Unit candidate = (Unit)candidateIter.next();
                if (!selected.getType().equals(candidate.getType()) || !selected.getOwner().equals(candidate.getOwner()) || selected.getHits() != candidate.getHits()) continue;
                rVal.add(candidate);
                candidateIter.remove();
                continue block4;
            }
        }
        return rVal;
    }

    private CompositeMatch<Unit> getUnloadableMatch(Route route, Collection<Unit> units) {
        CompositeMatchAnd<Unit> unloadable = new CompositeMatchAnd<Unit>(new Match[0]);
        unloadable.add(this.getMovableMatch(route, units));
        unloadable.add(Matches.UnitIsLand);
        return unloadable;
    }

    private CompositeMatch<Unit> getMovableMatch(final Route route, Collection<Unit> units) {
        CompositeMatchAnd<Unit> movable = new CompositeMatchAnd<Unit>(new Match[0]);
        if (!BaseEditDelegate.getEditMode(this.getData())) {
            movable.add(Matches.unitIsOwnedBy(this.getCurrentPlayer()));
        }
        if (!Properties.getSelectableZeroMovementUnits(this.getData())) {
            movable.add(Matches.UnitCanMove);
        }
        if (!this.m_nonCombat) {
            movable.add(Matches.UnitCanNotMoveDuringCombatMove.invert());
        }
        if (route != null) {
            Match<Unit> enoughMovement = new Match<Unit>(){

                @Override
                public boolean match(Unit u) {
                    if (BaseEditDelegate.getEditMode(MovePanel.this.getData())) {
                        return true;
                    }
                    return TripleAUnit.get(u).getMovementLeft() >= route.getMovementCost(u);
                }
            };
            if (route.isUnload()) {
                CompositeMatchOr<Unit> landOrCanMove = new CompositeMatchOr<Unit>(new Match[0]);
                landOrCanMove.add(Matches.UnitIsLand);
                CompositeMatchAnd<Unit> notLandAndCanMove = new CompositeMatchAnd<Unit>(new Match[0]);
                notLandAndCanMove.add(enoughMovement);
                notLandAndCanMove.add(Matches.UnitIsNotLand);
                landOrCanMove.add(notLandAndCanMove);
                movable.add(landOrCanMove);
            } else {
                movable.add(enoughMovement);
            }
        }
        if (route != null && route.getEnd() != null) {
            boolean water = route.getEnd().isWater();
            if (water && !route.isLoad()) {
                movable.add(Matches.UnitIsNotLand);
            }
            if (!water) {
                movable.add(Matches.UnitIsNotSea);
            }
        }
        if (units != null && !units.isEmpty()) {
            PlayerID owner = this.getUnitOwner(units);
            if (BaseEditDelegate.getEditMode(this.getData())) {
                movable.add(Matches.unitIsOwnedBy(owner));
            }
            CompositeMatchOr<Unit> rightUnitTypeMatch = new CompositeMatchOr<Unit>(new Match[0]);
            for (Unit unit : units) {
                if (!unit.getOwner().equals(owner)) continue;
                rightUnitTypeMatch.add(Matches.unitIsOfType(unit.getType()));
            }
            movable.add(rightUnitTypeMatch);
        }
        return movable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Route getRoute(Territory start, Territory end, Collection<Unit> selectedUnits) {
        this.getData().acquireReadLock();
        try {
            if (this.m_forced == null) {
                Route route = this.getRouteNonForced(start, end, selectedUnits);
                return route;
            }
            Route route = this.getRouteForced(start, end, selectedUnits);
            return route;
        }
        finally {
            this.getData().releaseReadLock();
        }
    }

    private Route getRouteForced(Territory start, Territory end, Collection<Unit> selectedUnits) {
        Route newTotal;
        Route add;
        if (this.m_forced == null || this.m_forced.size() == 0) {
            throw new IllegalStateException("No forced territories:" + this.m_forced + " end:" + end + " start:" + start);
        }
        Iterator<Territory> iter = this.m_forced.iterator();
        Territory last = this.getFirstSelectedTerritory();
        Territory current = null;
        Route total = new Route();
        total.setStart(last);
        while (iter.hasNext()) {
            current = iter.next();
            add = this.getData().getMap().getRoute(last, current);
            newTotal = Route.join(total, add);
            if (newTotal == null) {
                return total;
            }
            total = newTotal;
            last = current;
        }
        if (!end.equals(last) && (newTotal = Route.join(total, add = this.getRouteNonForced(last, end, selectedUnits))) != null) {
            total = newTotal;
        }
        return total;
    }

    private Route getRouteNonForced(Territory start, Territory end, Collection<Unit> selectedUnits) {
        PlayerID owner = this.getUnitOwner(selectedUnits);
        return MoveValidator.getBestRoute(start, end, this.getData(), owner, selectedUnits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUnitsThatCanMoveOnRoute(Collection<Unit> units, Route route) {
        MoveValidationResult allResults;
        if (route == null || route.hasNoSteps()) {
            this.clearStatusMessage();
            this.getMap().showMouseCursor();
            this.m_currentCursorImage = null;
            this.m_unitsThatCanMoveOnRoute = new ArrayList<Unit>(units);
            return;
        }
        this.getMap().hideMouseCursor();
        List<Unit> transportsToLoad = Collections.emptyList();
        if (MoveValidator.isLoad(units, s_dependentUnits, route, this.getData(), this.getCurrentPlayer())) {
            transportsToLoad = route.getEnd().getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.UnitIsTransport, Matches.alliedUnit(this.getCurrentPlayer(), this.getData())));
        }
        List<Unit> best = new ArrayList<Unit>(units);
        if (route.getStart().isWater() && route.getEnd() != null && route.getEnd().isWater() && !route.isLoad()) {
            best = Match.getMatches(best, new InverseMatch<Unit>(Matches.UnitIsLand));
        }
        this.sortUnitsToMove(best, route);
        Collections.reverse(best);
        List<Unit> bestWithDependents = this.addMustMoveWith(best);
        this.getData().acquireReadLock();
        try {
            allResults = AbstractMoveDelegate.validateMove(this.m_moveType, bestWithDependents, route, this.getCurrentPlayer(), transportsToLoad, s_dependentUnits, this.m_nonCombat, this.getUndoableMoves(), this.getData());
        }
        finally {
            this.getData().releaseReadLock();
        }
        MoveValidationResult lastResults = allResults;
        if (!allResults.isMoveValid()) {
            if (!this.m_nonCombat && route.isUnload() && Matches.isTerritoryEnemy(this.getCurrentPlayer(), this.getData()).match(route.getEnd())) {
                best = Match.getMatches(best, Matches.UnitCanInvade);
                bestWithDependents = this.addMustMoveWith(best);
                lastResults = AbstractMoveDelegate.validateMove(this.m_moveType, bestWithDependents, route, this.getCurrentPlayer(), transportsToLoad, s_dependentUnits, this.m_nonCombat, this.getUndoableMoves(), this.getData());
            }
            while (!best.isEmpty() && !lastResults.isMoveValid()) {
                best = best.subList(1, best.size());
                bestWithDependents = this.addMustMoveWith(best);
                lastResults = AbstractMoveDelegate.validateMove(this.m_moveType, bestWithDependents, route, this.getCurrentPlayer(), transportsToLoad, s_dependentUnits, this.m_nonCombat, this.getUndoableMoves(), this.getData());
            }
        }
        if (allResults.isMoveValid()) {
            if (bestWithDependents.containsAll(this.m_selectedUnits)) {
                this.clearStatusMessage();
                this.m_currentCursorImage = null;
            } else {
                this.setStatusWarningMessage("Not all units can move there");
                this.m_currentCursorImage = this.getMap().getWarningImage();
            }
        } else {
            String message = allResults.getError();
            if (message == null) {
                message = allResults.getDisallowedUnitWarning(0);
            }
            if (message == null) {
                message = allResults.getUnresolvedUnitWarning(0);
            }
            if (!lastResults.isMoveValid()) {
                this.setStatusErrorMessage(message);
                this.m_currentCursorImage = this.getMap().getErrorImage();
            } else {
                this.setStatusWarningMessage(message);
                this.m_currentCursorImage = this.getMap().getWarningImage();
            }
        }
        if (this.m_unitsThatCanMoveOnRoute.size() != new HashSet<Unit>(this.m_unitsThatCanMoveOnRoute).size()) {
            this.cancelMove();
            return;
        }
        this.m_unitsThatCanMoveOnRoute = new ArrayList<Unit>(bestWithDependents);
    }

    private List<Unit> addMustMoveWith(List<Unit> best) {
        ArrayList<Unit> bestWithDependents = new ArrayList<Unit>(best);
        for (Unit u : best) {
            Collection<Unit> mustMoveWith;
            if (!this.m_mustMoveWithDetails.getMustMoveWith().containsKey(u) || (mustMoveWith = this.m_mustMoveWithDetails.getMustMoveWith().get(u)) == null) continue;
            for (Unit m : mustMoveWith) {
                if (bestWithDependents.contains(m)) continue;
                bestWithDependents.addAll(mustMoveWith);
            }
        }
        return bestWithDependents;
    }

    final void updateRouteAndMouseShadowUnits(Route route) {
        this.m_routeCached = route;
        this.getMap().setRoute(route, this.m_mouseSelectedPoint, this.m_mouseCurrentPoint, this.m_currentCursorImage);
        if (route == null) {
            this.getMap().setMouseShadowUnits(null);
        } else {
            this.getMap().setMouseShadowUnits(this.m_unitsThatCanMoveOnRoute);
        }
    }

    private Collection<Unit> getTransportsToLoad(Route route, final Collection<Unit> unitsToLoad, boolean disablePrompts) {
        if (!route.isLoad()) {
            return Collections.emptyList();
        }
        if (Match.someMatch(unitsToLoad, Matches.UnitIsAir)) {
            return Collections.emptyList();
        }
        Collection<Unit> endOwnedUnits = route.getEnd().getUnits().getUnits();
        final PlayerID unitOwner = this.getUnitOwner(unitsToLoad);
        MustMoveWithDetails endMustMoveWith = MoveValidator.getMustMoveWith(route.getEnd(), endOwnedUnits, s_dependentUnits, this.getData(), unitOwner);
        int minTransportCost = 5;
        for (Unit unit : unitsToLoad) {
            minTransportCost = Math.min(minTransportCost, UnitAttachment.get(unit.getType()).getTransportCost());
        }
        CompositeMatchAnd<Unit> candidateTransportsMatch = new CompositeMatchAnd<Unit>(new Match[0]);
        candidateTransportsMatch.add(Matches.UnitIsTransport);
        candidateTransportsMatch.add(Matches.alliedUnit(unitOwner, this.getGameData()));
        final List<Unit> candidateTransports = Match.getMatches(endOwnedUnits, candidateTransportsMatch);
        Iterator<Unit> transportIter = candidateTransports.iterator();
        while (transportIter.hasNext()) {
            Unit transport = transportIter.next();
            int capacity = this.getTransportTracker().getAvailableCapacity(transport);
            if (capacity >= minTransportCost) continue;
            transportIter.remove();
        }
        if (candidateTransports.isEmpty()) {
            return Collections.emptyList();
        }
        this.sortTransportsToLoad(candidateTransports, route);
        ArrayList<Unit> availableUnits = new ArrayList<Unit>(unitsToLoad);
        IntegerMap<Unit> availableCapacityMap = new IntegerMap<Unit>();
        for (Unit transport : candidateTransports) {
            int capacity = this.getTransportTracker().getAvailableCapacity(transport);
            availableCapacityMap.put(transport, capacity);
        }
        HashSet<Unit> defaultSelections = new HashSet<Unit>();
        boolean useAlliedTransports = false;
        ArrayList<Unit> capableTransports = new ArrayList<Unit>(candidateTransports);
        List<Unit> incapableTransports = Match.getMatches(capableTransports, Matches.transportCannotUnload(route.getEnd()));
        capableTransports.removeAll(incapableTransports);
        Match<Unit> alliedMatch = new Match<Unit>(){

            @Override
            public boolean match(Unit transport) {
                return !transport.getOwner().equals(unitOwner);
            }
        };
        List<Unit> alliedTransports = Match.getMatches(capableTransports, alliedMatch);
        capableTransports.removeAll(alliedTransports);
        Map<Unit, Unit> unitsToCapableTransports = MoveDelegate.mapTransports(route, availableUnits, capableTransports);
        for (Unit unit : unitsToCapableTransports.keySet()) {
            Unit transport = unitsToCapableTransports.get(unit);
            int unitCost = UnitAttachment.get(unit.getType()).getTransportCost();
            availableCapacityMap.add(transport, -1 * unitCost);
            defaultSelections.add(transport);
        }
        availableUnits.removeAll(unitsToCapableTransports.keySet());
        Map<Unit, Unit> unitsToAlliedTransports = MoveDelegate.mapTransports(route, availableUnits, alliedTransports);
        for (Unit unit : unitsToAlliedTransports.keySet()) {
            Unit transport = unitsToAlliedTransports.get(unit);
            int unitCost = UnitAttachment.get(unit.getType()).getTransportCost();
            availableCapacityMap.add(transport, -1 * unitCost);
            defaultSelections.add(transport);
            useAlliedTransports = true;
        }
        availableUnits.removeAll(unitsToAlliedTransports.keySet());
        if (this.getSelectedEndpointTerritory() == null) {
            Map<Unit, Unit> unitsToIncapableTransports = MoveDelegate.mapTransports(route, availableUnits, incapableTransports);
            for (Unit unit : unitsToIncapableTransports.keySet()) {
                Unit transport = unitsToIncapableTransports.get(unit);
                int unitCost = UnitAttachment.get(unit.getType()).getTransportCost();
                availableCapacityMap.add(transport, -1 * unitCost);
                defaultSelections.add(transport);
            }
            availableUnits.removeAll(unitsToIncapableTransports.keySet());
        } else {
            candidateTransports.removeAll(incapableTransports);
        }
        if (disablePrompts) {
            return defaultSelections;
        }
        if (!useAlliedTransports) {
            if (candidateTransports.size() == 1) {
                return candidateTransports;
            }
            if (UnitSeperator.categorize(candidateTransports, endMustMoveWith.getMustMoveWith(), true, false).size() == 1 && unitsToLoad.size() == 1) {
                return candidateTransports;
            }
            if (defaultSelections.containsAll(candidateTransports)) {
                boolean spaceLeft = false;
                for (Unit transport : candidateTransports) {
                    int capacity = availableCapacityMap.getInt(transport);
                    if (capacity < minTransportCost) continue;
                    spaceLeft = true;
                    break;
                }
                if (!spaceLeft) {
                    return candidateTransports;
                }
            }
        }
        Match<Collection<Unit>> transportsToLoadMatch = new Match<Collection<Unit>>(){

            @Override
            public boolean match(Collection<Unit> units) {
                List<Unit> transports = Match.getMatches(units, Matches.UnitIsTransport);
                return transports.size() <= Math.min(unitsToLoad.size(), candidateTransports.size());
            }
        };
        UnitChooser chooser = new UnitChooser(candidateTransports, defaultSelections, endMustMoveWith.getMustMoveWith(), true, false, this.getGameData(), false, this.getMap().getUIContext(), transportsToLoadMatch);
        chooser.setTitle("What transports do you want to load");
        int option = JOptionPane.showOptionDialog(this.getTopLevelAncestor(), chooser, "What transports do you want to load", 2, -1, null, null, null);
        if (option != 0) {
            return Collections.emptyList();
        }
        return chooser.getSelected(false);
    }

    private TransportTracker getTransportTracker() {
        return this.m_transportTracker;
    }

    private boolean allowSpecificUnitSelection(Collection<Unit> units, Route route, boolean mustQueryUser, Match<Collection<Unit>> matchCriteria) {
        List<Unit> candidateUnits = this.getFirstSelectedTerritory().getUnits().getMatches(this.getMovableMatch(route, units));
        if (!mustQueryUser) {
            Set<UnitCategory> categories = UnitSeperator.categorize(candidateUnits, this.m_mustMoveWithDetails.getMustMoveWith(), true, false);
            for (UnitCategory category1 : categories) {
                if (category1.getMovement() == 0) continue;
                for (UnitCategory category2 : categories) {
                    if (category2.getMovement() == 0 || category1 == category2 || category1.getType() != category2.getType() || category1.equals(category2) || units.containsAll(category1.getUnits()) && units.containsAll(category2.getUnits()) || Util.intersection(category1.getUnits(), units).isEmpty() && Util.intersection(category2.getUnits(), units).isEmpty()) continue;
                    mustQueryUser = true;
                }
            }
        }
        if (mustQueryUser) {
            ArrayList<Unit> defaultSelections = new ArrayList<Unit>(units.size());
            if (route.isLoad()) {
                ArrayList<Unit> transportsToLoad = new ArrayList<Unit>(this.getTransportsToLoad(route, units, false));
                defaultSelections.addAll(MoveDelegate.mapTransports(route, units, transportsToLoad).keySet());
            } else {
                defaultSelections.addAll(units);
            }
            this.sortUnitsToMove(candidateUnits, route);
            UnitChooser chooser = new UnitChooser(candidateUnits, defaultSelections, this.m_mustMoveWithDetails.getMustMoveWith(), true, false, this.getGameData(), false, this.getMap().getUIContext(), matchCriteria);
            String text = "Select units to move from " + this.getFirstSelectedTerritory() + ".";
            int option = JOptionPane.showOptionDialog(this.getTopLevelAncestor(), chooser, text, 2, -1, null, null, null);
            if (option != 0) {
                units.clear();
                return false;
            }
            units.clear();
            units.addAll(chooser.getSelected(false));
        }
        ArrayList<Unit> unitsCopy = new ArrayList<Unit>(units);
        for (Unit unit : unitsCopy) {
            Collection<Unit> forced = this.m_mustMoveWithDetails.getMustMoveWith().get(unit);
            if (forced == null) continue;
            for (Unit dependent : forced) {
                if (unitsCopy.indexOf(dependent) != -1) continue;
                units.add(dependent);
            }
        }
        return true;
    }

    @Override
    public final String toString() {
        return "MovePanel";
    }

    final void setFirstSelectedTerritory(Territory firstSelectedTerritory) {
        if (firstSelectedTerritory == this.m_firstSelectedTerritory) {
            return;
        }
        this.m_firstSelectedTerritory = firstSelectedTerritory;
        this.m_mustMoveWithDetails = this.m_firstSelectedTerritory == null ? null : MoveValidator.getMustMoveWith(firstSelectedTerritory, firstSelectedTerritory.getUnits().getUnits(), s_dependentUnits, this.getData(), this.getCurrentPlayer());
    }

    private Territory getFirstSelectedTerritory() {
        return this.m_firstSelectedTerritory;
    }

    final void setSelectedEndpointTerritory(Territory selectedEndpointTerritory) {
        this.m_selectedEndpointTerritory = selectedEndpointTerritory;
    }

    private Territory getSelectedEndpointTerritory() {
        return this.m_selectedEndpointTerritory;
    }

    private static boolean isParatroopers(PlayerID player) {
        TechAttachment ta = (TechAttachment)player.getAttachment("techAttatchment");
        if (ta == null) {
            return false;
        }
        return ta.getParatroopers();
    }

    private static boolean IsParatroopersCanMoveDuringNonCombat(GameData data) {
        return Properties.getParatroopersCanMoveDuringNonCombat(data);
    }

    public final List<Unit> UserChooseUnits(Set<Unit> defaultSelections, Match<Collection<Unit>> unitsToLoadMatch, List<Unit> unitsToLoad, String title, String action) {
        UnitChooser chooser = new UnitChooser(unitsToLoad, defaultSelections, s_dependentUnits, false, true, this.getGameData(), false, this.getMap().getUIContext(), unitsToLoadMatch);
        chooser.setTitle(title);
        int option = JOptionPane.showOptionDialog(this.getTopLevelAncestor(), chooser, "What units do you want to " + action, 2, -1, null, null, null);
        if (option != 0) {
            return Collections.emptyList();
        }
        return chooser.getSelected(true);
    }

    @Override
    protected final void cleanUpSpecific() {
        this.getMap().removeMapSelectionListener(this.m_MAP_SELECTION_LISTENER);
        this.getMap().removeUnitSelectionListener(this.m_UNIT_SELECTION_LISTENER);
        this.getMap().removeMouseOverUnitListener(this.m_MOUSE_OVER_UNIT_LISTENER);
        this.getMap().setUnitHighlight(null);
        this.m_selectedUnits.clear();
        this.updateRouteAndMouseShadowUnits(null);
        this.m_forced = null;
    }

    @Override
    protected final void cancelMoveAction() {
        this.setFirstSelectedTerritory(null);
        this.setSelectedEndpointTerritory(null);
        this.m_mouseCurrentTerritory = null;
        this.m_forced = null;
        this.m_selectedUnits.clear();
        this.m_currentCursorImage = null;
        this.updateRouteAndMouseShadowUnits(null);
        this.getMap().showMouseCursor();
        this.getMap().setMouseShadowUnits(null);
    }

    @Override
    protected final void undoMoveSpecific() {
        this.getMap().setRoute(null);
    }

    public final void setNonCombat(boolean nonCombat) {
        this.m_nonCombat = nonCombat;
    }

    public final void setDisplayText(String displayText) {
        this.m_displayText = displayText;
    }

    @Override
    public final void display(PlayerID id) {
        this.m_transportTracker = new TransportTracker();
        super.display(id, this.m_displayText);
    }

    @Override
    protected final void setUpSpecific() {
        this.setFirstSelectedTerritory(null);
        this.m_forced = null;
        this.getMap().addMapSelectionListener(this.m_MAP_SELECTION_LISTENER);
        this.getMap().addUnitSelectionListener(this.m_UNIT_SELECTION_LISTENER);
        this.getMap().addMouseOverUnitListener(this.m_MOUSE_OVER_UNIT_LISTENER);
    }

    @Override
    protected boolean doneMoveAction() {
        if (this.m_undoableMovesPanel.getCountOfMovesMade() == 0) {
            int rVal = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(this), "Are you sure you dont want to move?", "End Move", 0);
            return rVal == 0;
        }
        return true;
    }

    @Override
    protected boolean setCancelButton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent e) {
        CompositeMatchAnd<Unit> moveableUnitOwnedByMe;
        ArrayList<Territory> allTerritories;
        super.keyPressed(e);
        int keyCode = e.getKeyCode();
        if (keyCode == 78) {
            int newFocusedIndex;
            this.getData().acquireReadLock();
            try {
                allTerritories = new ArrayList<Territory>(this.getData().getMap().getTerritories());
            }
            finally {
                this.getData().releaseReadLock();
            }
            moveableUnitOwnedByMe = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(this.getCurrentPlayer()), Matches.unitHasMovementLeft);
            if (!this.m_nonCombat) {
                moveableUnitOwnedByMe.add(Matches.UnitCanNotMoveDuringCombatMove.invert());
            }
            int size = allTerritories.size();
            int n = newFocusedIndex = this.m_lastFocusedTerritory == null ? 0 : allTerritories.indexOf(this.m_lastFocusedTerritory) + 1;
            if (newFocusedIndex >= size) {
                newFocusedIndex = 0;
            }
            Territory newFocusedTerritory = null;
            for (int i = 0; i < size; ++i) {
                Territory t = (Territory)allTerritories.get(newFocusedIndex);
                List<Unit> matchedUnits = t.getUnits().getMatches(moveableUnitOwnedByMe);
                if (matchedUnits.size() > 0) {
                    newFocusedTerritory = t;
                    HashMap<Territory, List<Unit>> highlight = new HashMap<Territory, List<Unit>>();
                    highlight.put(t, matchedUnits);
                    this.getMap().setUnitHighlight(highlight);
                    break;
                }
                if (newFocusedIndex + 1 >= size) {
                    newFocusedIndex = 0;
                    continue;
                }
                ++newFocusedIndex;
            }
            if (newFocusedTerritory != null) {
                this.m_lastFocusedTerritory = newFocusedTerritory;
                this.getMap().centerOn(newFocusedTerritory);
            }
        }
        if (keyCode == 70) {
            this.getData().acquireReadLock();
            try {
                allTerritories = new ArrayList<Territory>(this.getData().getMap().getTerritories());
            }
            finally {
                this.getData().releaseReadLock();
            }
            moveableUnitOwnedByMe = new CompositeMatchAnd(Matches.unitIsOwnedBy(this.getCurrentPlayer()), Matches.unitHasMovementLeft);
            if (!this.m_nonCombat) {
                moveableUnitOwnedByMe.add(Matches.UnitCanNotMoveDuringCombatMove.invert());
            }
            HashMap<Territory, List<Unit>> highlight = new HashMap<Territory, List<Unit>>();
            for (Territory t : allTerritories) {
                List<Unit> moveableUnits = t.getUnits().getMatches(moveableUnitOwnedByMe);
                if (moveableUnits.isEmpty()) continue;
                highlight.put(t, moveableUnits);
            }
            if (!highlight.isEmpty()) {
                this.getMap().setUnitHighlight(highlight);
            }
        }
    }

    static /* synthetic */ Territory access$2100(MovePanel x0) {
        return x0.m_mouseCurrentTerritory;
    }

    static /* synthetic */ Point access$700(MovePanel x0) {
        return x0.m_mouseLastUpdatePoint;
    }

    static /* synthetic */ Point access$600(MovePanel x0) {
        return x0.m_mouseCurrentPoint;
    }

    static /* synthetic */ Route access$2200(MovePanel x0) {
        return x0.m_routeCached;
    }
}

