/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.triplea.ResourceLoader;
import games.strategy.triplea.ui.AbstractUIContext;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Properties;

public class NotificationMessages {
    private static final String PROPERTY_FILE = "notifications.properties";
    private static NotificationMessages s_nm = null;
    private static long s_timestamp = 0L;
    private final Properties m_properties = new Properties();

    protected NotificationMessages() {
        ResourceLoader loader = AbstractUIContext.getResourceLoader();
        URL url = loader.getResource(PROPERTY_FILE);
        if (url != null) {
            try {
                this.m_properties.load(url.openStream());
            }
            catch (IOException e) {
                System.out.println("Error reading notifications.properties : " + e);
            }
        }
    }

    public static NotificationMessages getInstance() {
        if (s_nm == null || Calendar.getInstance().getTimeInMillis() > s_timestamp + 10000L) {
            s_nm = new NotificationMessages();
            s_timestamp = Calendar.getInstance().getTimeInMillis();
        }
        return s_nm;
    }

    public String getMessage(String notificationMessageKey) {
        return this.m_properties.getProperty(notificationMessageKey, notificationMessageKey);
    }
}

