/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.triplea.ResourceLoader;
import games.strategy.triplea.ui.AbstractUIContext;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ObjectiveProperties {
    private static final String PROPERTY_FILE = "objectives.properties";
    static final String GROUP_PROPERTY = "TABLEGROUP";
    static final String OBJECTIVES_PANEL_NAME = "Objectives.Panel.Name";
    private static ObjectiveProperties s_op = null;
    private static long s_timestamp = 0L;
    private final Properties m_properties = new Properties();

    protected ObjectiveProperties() {
        ResourceLoader loader = AbstractUIContext.getResourceLoader();
        URL url = loader.getResource(PROPERTY_FILE);
        if (url != null) {
            try {
                this.m_properties.load(url.openStream());
            }
            catch (IOException e) {
                System.out.println("Error reading objectives.properties : " + e);
            }
        }
    }

    public static ObjectiveProperties getInstance() {
        if (s_op == null || Calendar.getInstance().getTimeInMillis() > s_timestamp + 1000L) {
            s_op = new ObjectiveProperties();
            s_timestamp = Calendar.getInstance().getTimeInMillis();
        }
        return s_op;
    }

    public String getProperty(String objectiveKey) {
        return this.getProperty(objectiveKey, "Not Found In objectives.properties");
    }

    public String getProperty(String objectiveKey, String defaultValue) {
        return this.m_properties.getProperty(objectiveKey, defaultValue);
    }

    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.m_properties.entrySet();
    }
}

