/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipType;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.util.Triple;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoliticalStateOverview
extends JPanel {
    private static final long serialVersionUID = -8445782272897831080L;
    public static final String LABEL_SELF = "----";
    private final IUIContext m_uic;
    private final GameData m_data;
    private final boolean m_editable;
    private final Set<Triple<PlayerID, PlayerID, RelationshipType>> m_editChanges = new HashSet<Triple<PlayerID, PlayerID, RelationshipType>>();

    public PoliticalStateOverview(GameData data, IUIContext uiContext, boolean editable) {
        this.m_uic = uiContext;
        this.m_data = data;
        this.m_editable = editable;
        this.drawPoliticsUI();
    }

    private void drawPoliticsUI() {
        this.setLayout(new GridBagLayout());
        int currentCell = 1;
        Insets insets = new Insets(5, 2, 5, 2);
        for (PlayerID p : this.m_data.getPlayerList()) {
            this.add((Component)this.getPlayerLabel(p), new GridBagConstraints(currentCell++, 0, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        }
        currentCell = 1;
        for (PlayerID p : this.m_data.getPlayerList()) {
            this.add((Component)new JSeparator(), new GridBagConstraints(0, currentCell++, 20, 1, 0.1, 0.1, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.getPlayerLabel(p), new GridBagConstraints(0, currentCell++, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
        }
        int x = 1;
        int y = 2;
        for (PlayerID pVertical : this.m_data.getPlayerList()) {
            for (PlayerID pHorizontal : this.m_data.getPlayerList()) {
                if (pHorizontal.equals(pVertical)) {
                    this.add((Component)new JLabel(LABEL_SELF), new GridBagConstraints(x++, y, 1, 1, 1.0, 1.0, 10, 0, insets, 0, 0));
                    continue;
                }
                this.add((Component)this.getRelationshipLabel(pVertical, pHorizontal), new GridBagConstraints(x++, y, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
            }
            y += 2;
            x = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JPanel getRelationshipLabel(PlayerID player1, PlayerID player2) {
        RelationshipType relType = null;
        for (Triple<PlayerID, PlayerID, RelationshipType> changesSoFar : this.m_editChanges) {
            if ((!player1.equals(changesSoFar.getFirst()) || !player2.equals(changesSoFar.getSecond())) && (!player2.equals(changesSoFar.getFirst()) || !player1.equals(changesSoFar.getSecond()))) continue;
            relType = changesSoFar.getThird();
        }
        if (relType == null) {
            this.m_data.acquireReadLock();
            try {
                relType = this.m_data.getRelationshipTracker().getRelationshipType(player1, player2);
            }
            finally {
                this.m_data.releaseReadLock();
            }
        }
        JComponent relationshipLabel = this.getRelationshipComponent(player1, player2, relType);
        JPanel relationshipLabelPanel = new JPanel();
        relationshipLabelPanel.add(relationshipLabel);
        relationshipLabelPanel.setBackground(this.getRelationshipTypeColor(relType));
        return relationshipLabelPanel;
    }

    private JComponent getRelationshipComponent(final PlayerID player1, final PlayerID player2, final RelationshipType relType) {
        if (!this.m_editable) {
            return new JLabel(relType.getName());
        }
        JButton button = new JButton(new AbstractAction(relType.getName()){
            private static final long serialVersionUID = 629987410235293178L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                ArrayList<RelationshipType> types = new ArrayList<RelationshipType>(PoliticalStateOverview.this.m_data.getRelationshipTypeList().getAllRelationshipTypes());
                types.remove(PoliticalStateOverview.this.m_data.getRelationshipTypeList().getNullRelation());
                types.remove(PoliticalStateOverview.this.m_data.getRelationshipTypeList().getSelfRelation());
                Object[] possibilities = types.toArray();
                RelationshipType chosenRelationship = (RelationshipType)JOptionPane.showInputDialog(PoliticalStateOverview.this, "Change Current Relationship between " + player1.getName() + " and " + player2.getName(), "Change Current Relationship", -1, null, possibilities, relType);
                if (chosenRelationship != null) {
                    Iterator iter = PoliticalStateOverview.this.m_editChanges.iterator();
                    while (iter.hasNext()) {
                        Triple changesSoFar = (Triple)iter.next();
                        if ((!player1.equals(changesSoFar.getFirst()) || !player2.equals(changesSoFar.getSecond())) && (!player2.equals(changesSoFar.getFirst()) || !player1.equals(changesSoFar.getSecond()))) continue;
                        iter.remove();
                    }
                    RelationshipType actualRelationship = null;
                    PoliticalStateOverview.this.m_data.acquireReadLock();
                    try {
                        actualRelationship = PoliticalStateOverview.this.m_data.getRelationshipTracker().getRelationshipType(player1, player2);
                    }
                    finally {
                        PoliticalStateOverview.this.m_data.releaseReadLock();
                    }
                    if (!chosenRelationship.equals(actualRelationship)) {
                        PoliticalStateOverview.this.m_editChanges.add(new Triple<PlayerID, PlayerID, RelationshipType>(player1, player2, chosenRelationship));
                    }
                    PoliticalStateOverview.this.redrawPolitics();
                }
            }
        });
        button.setBackground(this.getRelationshipTypeColor(relType));
        return button;
    }

    private Color getRelationshipTypeColor(RelationshipType relType) {
        String archeType = relType.getRelationshipTypeAttachment().getArcheType();
        if (archeType.equals("allied")) {
            return Color.green;
        }
        if (archeType.equals("neutral")) {
            return Color.lightGray;
        }
        if (archeType.equals("war")) {
            return Color.red;
        }
        throw new IllegalStateException("PoliticsUI: RelationshipType: " + relType.getName() + " can only be of archeType Allied, Neutral or War");
    }

    protected JLabel getPlayerLabel(PlayerID player) {
        return new JLabel(player.getName(), new ImageIcon(this.m_uic.getFlagImageFactory().getFlag(player)), 2);
    }

    public void redrawPolitics() {
        this.removeAll();
        this.drawPoliticsUI();
        this.revalidate();
    }

    public Collection<Triple<PlayerID, PlayerID, RelationshipType>> getEditChanges() {
        if (!this.m_editable) {
            return null;
        }
        return this.m_editChanges;
    }
}

