/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.triplea.ResourceLoader;
import games.strategy.triplea.ui.AbstractUIContext;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Properties;

public class PoliticsText {
    private static final String PROPERTY_FILE = "politicstext.properties";
    private static PoliticsText s_pt = null;
    private static long s_timestamp = 0L;
    private final Properties m_properties = new Properties();
    private static final String BUTTON = "BUTTON";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String NOTIFICATION_SUCCESS = "NOTIFICATION_SUCCESS";
    private static final String OTHER_NOTIFICATION_SUCCESS = "OTHER_NOTIFICATION_SUCCESS";
    private static final String NOTIFICATION_FAILURE = "NOTIFICATION_FAILURE";
    private static final String OTHER_NOTIFICATION_FAILURE = "OTHER_NOTIFICATION_FAILURE";
    private static final String ACCEPT_QUESTION = "ACCEPT_QUESTION";

    protected PoliticsText() {
        ResourceLoader loader = AbstractUIContext.getResourceLoader();
        URL url = loader.getResource(PROPERTY_FILE);
        if (url != null) {
            try {
                this.m_properties.load(url.openStream());
            }
            catch (IOException e) {
                System.out.println("Error reading politicstext.properties : " + e);
            }
        }
    }

    public static PoliticsText getInstance() {
        if (s_pt == null || Calendar.getInstance().getTimeInMillis() > s_timestamp + 10000L) {
            s_pt = new PoliticsText();
            s_timestamp = Calendar.getInstance().getTimeInMillis();
        }
        return s_pt;
    }

    private String getString(String value) {
        return this.m_properties.getProperty(value, "NO: " + value + " set.");
    }

    private String getMessage(String politicsKey, String messageKey) {
        return this.getString(politicsKey + "." + messageKey);
    }

    public String getButtonText(String politicsKey) {
        return this.getMessage(politicsKey, BUTTON);
    }

    public String getDescription(String politicsKey) {
        return this.getMessage(politicsKey, DESCRIPTION);
    }

    public String getNotificationSucccess(String politicsKey) {
        return this.getMessage(politicsKey, NOTIFICATION_SUCCESS);
    }

    public String getNotificationSuccessOthers(String politicsKey) {
        return this.getMessage(politicsKey, OTHER_NOTIFICATION_SUCCESS);
    }

    public String getNotificationFailure(String politicsKey) {
        return this.getMessage(politicsKey, NOTIFICATION_FAILURE);
    }

    public String getNotificationFailureOthers(String politicsKey) {
        return this.getMessage(politicsKey, OTHER_NOTIFICATION_FAILURE);
    }

    public String getAcceptanceQuestion(String politicsKey) {
        return this.getMessage(politicsKey, ACCEPT_QUESTION);
    }
}

