/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.PlayerID;
import games.strategy.triplea.ResourceLoader;
import games.strategy.triplea.ui.AbstractUIContext;
import games.strategy.triplea.ui.ProductionPanel;
import games.strategy.util.Tuple;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductionTabsProperties {
    private static final String PROPERTY_FILE = "production_tabs";
    private static final String USE_DEFAULT_TABS = "production_tabs.use_default_tabs";
    private static final String NUMBER_OF_TABS = "production_tabs.number_of_tabs";
    private static final String TAB_NAME = "production_tabs.tab_name";
    private static final String TAB_UNITS = "production_tabs.tab_units";
    private static final String NUMBER_OF_ROWS = "production_tabs.rows";
    private static final String NUMBER_OF_COLUMNS = "production_tabs.columns";
    private final Properties m_properties = new Properties();
    private final List<ProductionPanel.Rule> m_rules;
    private List<Tuple<String, List<ProductionPanel.Rule>>> m_ruleLists;

    protected ProductionTabsProperties(PlayerID playerId, List<ProductionPanel.Rule> mRules) {
        this.m_rules = mRules;
        ResourceLoader loader = AbstractUIContext.getResourceLoader();
        String propertyFile = "production_tabs." + playerId.getName() + ".properties";
        URL url = loader.getResource(propertyFile);
        if (url == null && (url = loader.getResource(propertyFile = "production_tabs.properties")) != null) {
            try {
                this.m_properties.load(url.openStream());
            }
            catch (IOException e) {
                System.out.println("Error reading " + propertyFile + e);
            }
        }
    }

    public static ProductionTabsProperties getInstance(PlayerID playerId, List<ProductionPanel.Rule> mRules) {
        return new ProductionTabsProperties(playerId, mRules);
    }

    public List<Tuple<String, List<ProductionPanel.Rule>>> getRuleLists() {
        if (this.m_ruleLists != null) {
            return this.m_ruleLists;
        }
        this.m_ruleLists = new ArrayList<Tuple<String, List<ProductionPanel.Rule>>>();
        int iTabs = this.getNumberOfTabs();
        for (int i = 1; i <= iTabs; ++i) {
            String tabName = this.m_properties.getProperty("production_tabs.tab_name." + i);
            List<String> tabValues = Arrays.asList(this.m_properties.getProperty("production_tabs.tab_units." + i).split(":"));
            ArrayList<ProductionPanel.Rule> ruleList = new ArrayList<ProductionPanel.Rule>();
            for (ProductionPanel.Rule rule : this.m_rules) {
                if (!tabValues.contains(rule.getProductionRule().getResults().keySet().iterator().next().getName())) continue;
                ruleList.add(rule);
            }
            this.m_ruleLists.add(new Tuple(tabName, ruleList));
        }
        return this.m_ruleLists;
    }

    private int getNumberOfTabs() {
        return Integer.valueOf(this.m_properties.getProperty(NUMBER_OF_TABS, "0"));
    }

    public boolean useDefaultTabs() {
        return Boolean.valueOf(this.m_properties.getProperty(USE_DEFAULT_TABS, "true"));
    }

    public int getRows() {
        return Integer.valueOf(this.m_properties.getProperty(NUMBER_OF_ROWS, "0"));
    }

    public int getColumns() {
        return Integer.valueOf(this.m_properties.getProperty(NUMBER_OF_COLUMNS, "0"));
    }
}

