/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.ui.ActionPanel;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.ProductionPanel;
import games.strategy.triplea.ui.SimpleUnitPanel;
import games.strategy.triplea.ui.TabbedProductionPanel;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurchasePanel
extends ActionPanel {
    private static final long serialVersionUID = -6121756876868623355L;
    private final JLabel actionLabel = new JLabel();
    private IntegerMap<ProductionRule> m_purchase;
    private boolean m_bid;
    private final SimpleUnitPanel m_purchasedPreviousRoundsUnits;
    private final JLabel m_purchasedPreviousRoundsLabel;
    private final SimpleUnitPanel m_purhcasedUnits;
    private final JLabel m_purchasedLabel = new JLabel();
    private final JButton m_buyButton;
    private static boolean m_tabbedProduction = true;
    private final String BUY = "Buy...";
    private final String CHANGE = "Change...";
    private final AbstractAction PURCHASE_ACTION = new AbstractAction("Buy"){
        private static final long serialVersionUID = -2931438906267249990L;

        public void actionPerformed(ActionEvent e) {
            PlayerID player = PurchasePanel.this.getCurrentPlayer();
            GameData data = PurchasePanel.this.getData();
            if (PurchasePanel.isTabbedProduction()) {
                PurchasePanel.this.m_purchase = TabbedProductionPanel.getProduction(player, (JFrame)PurchasePanel.this.getTopLevelAncestor(), data, PurchasePanel.this.m_bid, PurchasePanel.this.m_purchase, PurchasePanel.this.getMap().getUIContext());
            } else {
                PurchasePanel.this.m_purchase = ProductionPanel.getProduction(player, (JFrame)PurchasePanel.this.getTopLevelAncestor(), data, PurchasePanel.this.m_bid, PurchasePanel.this.m_purchase, PurchasePanel.this.getMap().getUIContext());
            }
            PurchasePanel.this.m_purhcasedUnits.setUnitsFromProductionRuleMap(PurchasePanel.this.m_purchase, player, data);
            if (PurchasePanel.this.m_purchase.totalValues() == 0) {
                PurchasePanel.this.m_purchasedLabel.setText("");
                PurchasePanel.this.m_buyButton.setText("Buy...");
            } else {
                PurchasePanel.this.m_buyButton.setText("Change...");
                PurchasePanel.this.m_purchasedLabel.setText(PurchasePanel.this.totalUnitNumberPurchased(PurchasePanel.this.m_purchase) + MyFormatter.pluralize(" unit", PurchasePanel.this.totalUnitNumberPurchased(PurchasePanel.this.m_purchase)) + " to be produced:");
            }
        }
    };
    private final Action DoneAction = new AbstractAction("Done"){
        private static final long serialVersionUID = -209781523508962628L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent event) {
            int rVal;
            boolean hasPurchased;
            boolean bl = hasPurchased = PurchasePanel.this.m_purchase.totalValues() != 0;
            if (!hasPurchased && (rVal = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(PurchasePanel.this), "Are you sure you dont want to buy anything?", "End Purchase", 0)) != 0) {
                return;
            }
            if (PurchasePanel.this.isWW2V2() || PurchasePanel.this.isRestrictedPurchase() || PurchasePanel.this.isSBRAffectsUnitProduction()) {
                int totalProd = 0;
                PurchasePanel.this.getData().acquireReadLock();
                try {
                    for (Territory t : Match.getMatches(PurchasePanel.this.getData().getMap().getTerritories(), Matches.territoryHasOwnedIsFactoryOrCanProduceUnits(PurchasePanel.this.getData(), PurchasePanel.this.getCurrentPlayer()))) {
                        totalProd += TripleAUnit.getProductionPotentialOfTerritory(t.getUnits().getUnits(), t, PurchasePanel.this.getCurrentPlayer(), PurchasePanel.this.getData(), true, true);
                    }
                }
                finally {
                    PurchasePanel.this.getData().releaseReadLock();
                }
                int totalProduced = 0;
                for (ProductionRule rule : PurchasePanel.this.m_purchase.keySet()) {
                    if (Matches.UnitTypeIsConstruction.match((UnitType)rule.getResults().keySet().iterator().next())) continue;
                    totalProduced += PurchasePanel.this.m_purchase.getInt(rule) * rule.getResults().totalValues();
                }
                PlayerID player = PurchasePanel.this.getCurrentPlayer();
                List<Unit> unitsNeedingFactory = Match.getMatches(player.getUnits().getUnits(), Matches.UnitIsNotConstruction);
                if (!PurchasePanel.this.m_bid && totalProduced + unitsNeedingFactory.size() > totalProd && !PurchasePanel.this.isUnlimitedProduction(player)) {
                    String text = "You have purchased " + (totalProduced + unitsNeedingFactory.size()) + " units, and can only place " + totalProd + " of them. Continue with purchase?";
                    int rVal2 = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(PurchasePanel.this), text, "End Purchase", 0);
                    if (rVal2 != 0) {
                        return;
                    }
                }
            }
            PurchasePanel.this.release();
        }
    };

    public PurchasePanel(GameData data, MapPanel map) {
        super(data, map);
        this.m_purchasedPreviousRoundsUnits = new SimpleUnitPanel(map.getUIContext());
        this.m_purhcasedUnits = new SimpleUnitPanel(map.getUIContext());
        this.m_buyButton = new JButton("Buy...");
        this.m_buyButton.addActionListener(this.PURCHASE_ACTION);
        this.m_purchasedPreviousRoundsLabel = new JLabel("Unplaced from previous rounds");
    }

    @Override
    public void display(final PlayerID id) {
        super.display(id);
        this.m_purchase = new IntegerMap();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PurchasePanel.this.removeAll();
                PurchasePanel.this.actionLabel.setText(id.getName() + " production");
                PurchasePanel.this.m_buyButton.setText("Buy...");
                PurchasePanel.this.add(PurchasePanel.this.actionLabel);
                PurchasePanel.this.add(PurchasePanel.this.m_buyButton);
                PurchasePanel.this.add(new JButton(PurchasePanel.this.DoneAction));
                PurchasePanel.this.m_purchasedLabel.setText("");
                PurchasePanel.this.add(Box.createVerticalStrut(9));
                PurchasePanel.this.add(PurchasePanel.this.m_purchasedLabel);
                PurchasePanel.this.add(Box.createVerticalStrut(4));
                PurchasePanel.this.m_purhcasedUnits.setUnitsFromProductionRuleMap(new IntegerMap<ProductionRule>(), id, PurchasePanel.this.getData());
                PurchasePanel.this.add(PurchasePanel.this.m_purhcasedUnits);
                PurchasePanel.this.getData().acquireReadLock();
                try {
                    PurchasePanel.this.m_purchasedPreviousRoundsUnits.setUnitsFromCategories(UnitSeperator.categorize(id.getUnits().getUnits()), PurchasePanel.this.getData());
                    PurchasePanel.this.add(Box.createVerticalStrut(4));
                    if (!id.getUnits().isEmpty()) {
                        PurchasePanel.this.add(PurchasePanel.this.m_purchasedPreviousRoundsLabel);
                    }
                    PurchasePanel.this.add(PurchasePanel.this.m_purchasedPreviousRoundsUnits);
                }
                finally {
                    PurchasePanel.this.getData().releaseReadLock();
                }
                PurchasePanel.this.add(Box.createVerticalGlue());
                SwingUtilities.invokeLater(PurchasePanel.this.REFRESH);
            }
        });
    }

    private void refreshActionLabelText() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PurchasePanel.this.actionLabel.setText(PurchasePanel.this.getCurrentPlayer().getName() + " production " + (PurchasePanel.this.m_bid ? " for bid" : ""));
            }
        });
    }

    public IntegerMap<ProductionRule> waitForPurchase(boolean bid) {
        this.m_bid = bid;
        this.refreshActionLabelText();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PurchasePanel.this.PURCHASE_ACTION.actionPerformed(null);
            }
        });
        this.waitForRelease();
        return this.m_purchase;
    }

    private int totalUnitNumberPurchased(IntegerMap<ProductionRule> purchase) {
        int totalUnits = 0;
        Set<ProductionRule> rules = purchase.keySet();
        for (ProductionRule current : rules) {
            totalUnits += purchase.getInt(current) * current.getResults().totalValues();
        }
        return totalUnits;
    }

    private boolean isUnlimitedProduction(PlayerID player) {
        RulesAttachment ra = (RulesAttachment)player.getAttachment("rulesAttatchment");
        if (ra == null) {
            return false;
        }
        return ra.getUnlimitedProduction();
    }

    @Override
    public String toString() {
        return "PurchasePanel";
    }

    public static void setTabbedProduction(boolean tabbedProduction) {
        m_tabbedProduction = tabbedProduction;
    }

    public static boolean isTabbedProduction() {
        return m_tabbedProduction;
    }
}

