/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.UnitTypeComparator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.util.IntegerMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleUnitPanel
extends JPanel {
    private static final long serialVersionUID = -3768796793775300770L;
    private final IUIContext m_uiContext;
    Comparator<ProductionRule> productionRuleComparator = new Comparator<ProductionRule>(){
        UnitTypeComparator utc = new UnitTypeComparator();

        @Override
        public int compare(ProductionRule o1, ProductionRule o2) {
            UnitType u1 = (UnitType)o1.getResults().keySet().iterator().next();
            UnitType u2 = (UnitType)o2.getResults().keySet().iterator().next();
            return this.utc.compare(u1, u2);
        }
    };
    Comparator<RepairRule> repairRuleComparator = new Comparator<RepairRule>(){
        UnitTypeComparator utc = new UnitTypeComparator();

        @Override
        public int compare(RepairRule o1, RepairRule o2) {
            UnitType u1 = (UnitType)o1.getResults().keySet().iterator().next();
            UnitType u2 = (UnitType)o2.getResults().keySet().iterator().next();
            return this.utc.compare(u1, u2);
        }
    };

    public SimpleUnitPanel(IUIContext uiContext) {
        this.m_uiContext = uiContext;
        this.setLayout(new BoxLayout(this, 1));
    }

    public void setUnitsFromProductionRuleMap(IntegerMap<ProductionRule> units, PlayerID player, GameData data) {
        this.removeAll();
        TreeSet<ProductionRule> productionRules = new TreeSet<ProductionRule>(this.productionRuleComparator);
        productionRules.addAll(units.keySet());
        for (ProductionRule productionRule : productionRules) {
            int quantity = units.getInt(productionRule);
            UnitType unit = (UnitType)productionRule.getResults().keySet().iterator().next();
            this.addUnits(player, data, quantity, unit, false, false);
        }
    }

    public void setUnitsFromRepairRuleMap(HashMap<Unit, IntegerMap<RepairRule>> units, PlayerID player, GameData data) {
        this.removeAll();
        Set<Unit> entries = units.keySet();
        for (Unit unit : entries) {
            IntegerMap<RepairRule> rules = units.get(unit);
            TreeSet<RepairRule> repairRules = new TreeSet<RepairRule>(this.repairRuleComparator);
            repairRules.addAll(rules.keySet());
            for (RepairRule repairRule : repairRules) {
                int quantity = rules.getInt(repairRule);
                if (Properties.getSBRAffectsUnitProduction(data)) {
                    this.addUnits(player, data, quantity, unit.getType(), true, false);
                    continue;
                }
                if (!unit.getType().equals(repairRule.getResults().keySet().iterator().next())) continue;
                this.addUnits(player, data, quantity, unit.getType(), Matches.UnitHasSomeUnitDamage().match(unit), Matches.UnitIsDisabled().match(unit));
            }
        }
    }

    public void setUnitsFromCategories(Collection<UnitCategory> categories, GameData data) {
        this.removeAll();
        for (UnitCategory category : categories) {
            this.addUnits(category.getOwner(), data, category.getUnits().size(), category.getType(), category.getDamaged(), category.getDisabled());
        }
    }

    private void addUnits(PlayerID player, GameData data, int quantity, UnitType unit, boolean damaged, boolean disabled) {
        JLabel label = new JLabel();
        label.setText(" x " + quantity);
        label.setIcon(this.m_uiContext.getUnitImageFactory().getIcon(unit, player, data, damaged, disabled));
        this.add(label);
    }
}

