/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.triplea.delegate.Die;
import games.strategy.triplea.delegate.dataObjects.TechResults;
import games.strategy.triplea.ui.IUIContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TechResultsDisplay
extends JPanel {
    private static final long serialVersionUID = -8303376983862918107L;
    private final IUIContext m_uiContext;

    public TechResultsDisplay(TechResults msg, IUIContext uiContext, GameData data) {
        this.m_uiContext = uiContext;
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("You got " + msg.getHits() + " hit" + (msg.getHits() != 1 ? "s" : "") + "."), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        if (msg.getHits() != 0) {
            this.add((Component)new JLabel("Technologies discovered:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            JList<String> list = new JList<String>(new Vector<String>(msg.getAdvances()));
            this.add(list, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            list.setBackground(this.getBackground());
        }
        JPanel dice = new JPanel();
        dice.setLayout(new BoxLayout(dice, 0));
        int remainder = msg.getRemainder();
        for (int i = 0; i < msg.getRolls().length; ++i) {
            int roll = msg.getRolls()[i] + 1;
            JLabel die = remainder > 0 ? new JLabel(this.m_uiContext.getDiceImageFactory().getDieIcon(roll, roll <= remainder ? Die.DieType.HIT : Die.DieType.MISS)) : new JLabel(this.m_uiContext.getDiceImageFactory().getDieIcon(roll, roll == data.getDiceSides() ? Die.DieType.HIT : Die.DieType.MISS));
            dice.add(die);
            dice.add(Box.createHorizontalStrut(2));
            dice.setMaximumSize(new Dimension(200, (int)dice.getMaximumSize().getHeight()));
        }
        JScrollPane diceScroll = new JScrollPane(dice);
        diceScroll.setBorder(null);
        this.add((Component)diceScroll, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
    }
}

