/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.ResourceLoader;
import games.strategy.triplea.ui.AbstractUIContext;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Properties;

public class TooltipProperties {
    private static final String PROPERTY_FILE = "tooltips.properties";
    private static final String TOOLTIP = "tooltip";
    private static final String UNIT = "unit";
    private static TooltipProperties s_ttp = null;
    private static long s_timestamp = 0L;
    private final Properties m_properties = new Properties();

    protected TooltipProperties() {
        ResourceLoader loader = AbstractUIContext.getResourceLoader();
        URL url = loader.getResource(PROPERTY_FILE);
        if (url != null) {
            try {
                this.m_properties.load(url.openStream());
            }
            catch (IOException e) {
                System.out.println("Error reading tooltips.properties : " + e);
            }
        }
    }

    public static TooltipProperties getInstance() {
        if (s_ttp == null || Calendar.getInstance().getTimeInMillis() > s_timestamp + 5000L) {
            s_ttp = new TooltipProperties();
            s_timestamp = Calendar.getInstance().getTimeInMillis();
        }
        return s_ttp;
    }

    public String getToolTip(UnitType ut, PlayerID playerId) {
        String tooltip = this.m_properties.getProperty("tooltip.unit." + ut.getName() + "." + playerId.getName(), "");
        if (tooltip == null || tooltip.equals("")) {
            return this.m_properties.getProperty("tooltip.unit." + ut.getName(), "");
        }
        return tooltip;
    }
}

