/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.common.ui.BasicGameMenuBar;
import games.strategy.engine.EngineVersion;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.properties.AEditableProperty;
import games.strategy.engine.data.properties.ColorProperty;
import games.strategy.engine.data.properties.NumberProperty;
import games.strategy.engine.data.properties.PropertiesUI;
import games.strategy.engine.framework.ClientGame;
import games.strategy.engine.framework.GameDataUtils;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.Round;
import games.strategy.engine.history.Step;
import games.strategy.engine.random.IRandomStats;
import games.strategy.engine.random.RandomStatsDetails;
import games.strategy.engine.stats.IStat;
import games.strategy.sound.SoundOptions;
import games.strategy.sound.SoundPath;
import games.strategy.triplea.ai.Dynamix_AI.Dynamix_AI;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.EndRoundDelegate;
import games.strategy.triplea.image.MapImage;
import games.strategy.triplea.image.TileImageFactory;
import games.strategy.triplea.oddsCalculator.ta.OddsCalculatorDialog;
import games.strategy.triplea.printgenerator.SetupFrame;
import games.strategy.triplea.ui.AbstractUIContext;
import games.strategy.triplea.ui.BattleDisplay;
import games.strategy.triplea.ui.ExtendedStats;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.ui.PoliticalStateOverview;
import games.strategy.triplea.ui.PurchasePanel;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.triplea.ui.VerifiedRandomNumbersDialog;
import games.strategy.triplea.ui.screen.IDrawable;
import games.strategy.triplea.util.PlayerOrderComparator;
import games.strategy.ui.IntTextField;
import games.strategy.util.IllegalCharacterRemover;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripleaMenu
extends BasicGameMenuBar<TripleAFrame> {
    private static final long serialVersionUID = 987243661147503593L;
    private JCheckBoxMenuItem showMapDetails;
    private JCheckBoxMenuItem showMapBlends;

    TripleaMenu(TripleAFrame frame) {
        super(frame);
        this.setWidgetActivation();
    }

    private IUIContext getUIContext() {
        return ((TripleAFrame)this.m_frame).getUIContext();
    }

    @Override
    protected void addGameSpecificHelpMenus(JMenu helpMenu) {
        this.addMoveHelpMenu(helpMenu);
    }

    private void addMoveHelpMenu(JMenu parentMenu) {
        parentMenu.add(new AbstractAction("Movement/Selection help..."){
            private static final long serialVersionUID = 6388976622644695135L;

            public void actionPerformed(ActionEvent e) {
                String hints = "<b> Selecting Units</b><br>Left click on a unit stack to select 1 unit.<br>ALT-Left click on a unit stack to select 10 units of that type in the stack.<br>CTRL-Left click on a unit stack to select all units of that type in the stack.<br>Shift-Left click on a unit to select all units in the territory.<br>Left click on a territory but not on a unit to bring up a selection window for inputing the desired selection.<br><br><b> Deselecting Units</b><br>Right click somewhere not on a unit stack to unselect the last selected unit.<br>Right click on a unit stack to unselect one unit in the stack.<br>ALT-Right click on a unit stack to unselect 10 units of that type in the stack.<br>CTRL-Right click on a unit stack to unselect all units of that type in the stack.<br>CTRL-Right click somewhere not on a unit stack to unselect all units selected.<br><br><b> Moving Units to a new Territories</b><br>After selecting units Left click on a territory to move units there (do not Left click and Drag, instead select units, then move the mouse, then select the territory).<br>CTRL-Left click on a territory to select the territory as a way point (this will force the units to move through this territory on their way to the destination).<br><br><b> Moving the Map Screen</b><br>Right click and Drag the mouse to move your screen over the map.<br>Left click on the map (anywhere), then use the Arrow Keys (or WASD) to move your map around.<br>Left click in the Minimap at the top right of the screen, and Drag the mouse.<br>Move the mouse to the edge of the map window, and the screen will scroll in that direction.<br>Scrolling the mouse wheel will move the map up and down.<br><br><b> Zooming Out</b><br>Holding ALT while Scrolling the Mouse Wheel will zoom the map in and out.<br>Select 'Zoom' from the 'View' menu, and change to the desired level.<br><br><b> Turn off Art</b><br>Deselect 'Map Details' in the 'View' menu, to show a map without the artwork.<br>Select a new 'Map Skin' from the 'View' menu to show a different kind of artwork (not all maps have skins).<br><br><b> Other Things</b><br>Press 'N' to cycle through units with movement left (move phases only).<br>Press 'F' to highlight all units you own that have movement left (move phases only).<br>Press 'I' to popup info on whatever territory and unit your mouse is currently over.<br>";
                JEditorPane editorPane = new JEditorPane();
                editorPane.setEditable(false);
                editorPane.setContentType("text/html");
                editorPane.setText("<b> Selecting Units</b><br>Left click on a unit stack to select 1 unit.<br>ALT-Left click on a unit stack to select 10 units of that type in the stack.<br>CTRL-Left click on a unit stack to select all units of that type in the stack.<br>Shift-Left click on a unit to select all units in the territory.<br>Left click on a territory but not on a unit to bring up a selection window for inputing the desired selection.<br><br><b> Deselecting Units</b><br>Right click somewhere not on a unit stack to unselect the last selected unit.<br>Right click on a unit stack to unselect one unit in the stack.<br>ALT-Right click on a unit stack to unselect 10 units of that type in the stack.<br>CTRL-Right click on a unit stack to unselect all units of that type in the stack.<br>CTRL-Right click somewhere not on a unit stack to unselect all units selected.<br><br><b> Moving Units to a new Territories</b><br>After selecting units Left click on a territory to move units there (do not Left click and Drag, instead select units, then move the mouse, then select the territory).<br>CTRL-Left click on a territory to select the territory as a way point (this will force the units to move through this territory on their way to the destination).<br><br><b> Moving the Map Screen</b><br>Right click and Drag the mouse to move your screen over the map.<br>Left click on the map (anywhere), then use the Arrow Keys (or WASD) to move your map around.<br>Left click in the Minimap at the top right of the screen, and Drag the mouse.<br>Move the mouse to the edge of the map window, and the screen will scroll in that direction.<br>Scrolling the mouse wheel will move the map up and down.<br><br><b> Zooming Out</b><br>Holding ALT while Scrolling the Mouse Wheel will zoom the map in and out.<br>Select 'Zoom' from the 'View' menu, and change to the desired level.<br><br><b> Turn off Art</b><br>Deselect 'Map Details' in the 'View' menu, to show a map without the artwork.<br>Select a new 'Map Skin' from the 'View' menu to show a different kind of artwork (not all maps have skins).<br><br><b> Other Things</b><br>Press 'N' to cycle through units with movement left (move phases only).<br>Press 'F' to highlight all units you own that have movement left (move phases only).<br>Press 'I' to popup info on whatever territory and unit your mouse is currently over.<br>");
                JScrollPane scroll = new JScrollPane(editorPane);
                JOptionPane.showMessageDialog(TripleaMenu.this.m_frame, scroll, "Movement Help", -1);
            }
        }).setMnemonic(77);
    }

    @Override
    protected void createGameSpecificMenus(JMenuBar menuBar) {
        this.createViewMenu(menuBar);
        this.createGameMenu(menuBar);
        this.createExportMenu(menuBar);
    }

    private void createGameMenu(JMenuBar menuBar) {
        JMenu menuGame = new JMenu("Game");
        menuGame.setMnemonic(71);
        menuBar.add(menuGame);
        this.addEditMode(menuGame);
        menuGame.add(((TripleAFrame)this.m_frame).getShowGameAction()).setMnemonic(71);
        menuGame.add(((TripleAFrame)this.m_frame).getShowHistoryAction()).setMnemonic(72);
        menuGame.add(((TripleAFrame)this.m_frame).getShowMapOnlyAction()).setMnemonic(77);
        this.addShowVerifiedDice(menuGame);
        SoundOptions.addGlobalSoundSwitchMenu(menuGame);
        SoundOptions.addToMenu(menuGame, SoundPath.SoundType.TRIPLEA);
        menuGame.addSeparator();
        this.addGameOptionsMenu(menuGame);
        this.addPoliticsMenu(menuGame);
        this.addEndTurnReport(menuGame);
        this.addFocusOnCasualties(menuGame);
        this.addShowEnemyCasualties(menuGame);
        this.addShowAIBattles(menuGame);
        this.addChangeDynamixAISettings(menuGame);
        this.addAISleepDuration(menuGame);
        this.addShowDiceStats(menuGame);
        this.addRollDice(menuGame);
        this.addBattleCalculatorMenu(menuGame);
    }

    private void createExportMenu(JMenuBar menuBar) {
        JMenu menuGame = new JMenu("Export");
        menuGame.setMnemonic(69);
        menuBar.add(menuGame);
        this.addExportXML(menuGame);
        this.addExportStats(menuGame);
        this.addExportStatsFull(menuGame);
        this.addExportSetupCharts(menuGame);
        this.addSaveScreenshot(menuGame);
    }

    private void createViewMenu(JMenuBar menuBar) {
        JMenu menuView = new JMenu("View");
        menuView.setMnemonic(86);
        menuBar.add(menuView);
        this.addZoomMenu(menuView);
        this.addUnitSizeMenu(menuView);
        this.addLockMap(menuView);
        this.addShowUnits(menuView);
        if (this.getUIContext().getMapData().useTerritoryEffectMarkers()) {
            this.addShowTerritoryEffects(menuView);
        }
        this.addMapSkinsMenu(menuView);
        this.addShowMapDetails(menuView);
        this.addShowMapBlends(menuView);
        this.addDrawTerritoryBordersAgain(menuView);
        this.addMapFontAndColorEditorMenu(menuView);
        this.addChatTimeMenu(menuView);
        this.addShowCommentLog(menuView);
        this.addTabbedProduction(menuView);
        this.addShowGameUuid(menuView);
        this.addSetLookAndFeel(menuView);
    }

    private void addEditMode(JMenu parentMenu) {
        JCheckBoxMenuItem editMode = new JCheckBoxMenuItem("Enable Edit Mode");
        editMode.setModel(((TripleAFrame)this.m_frame).getEditModeButtonModel());
        parentMenu.add(editMode).setMnemonic(69);
    }

    private void addZoomMenu(JMenu menuGame) {
        AbstractAction mapZoom = new AbstractAction("Map Zoom..."){
            private static final long serialVersionUID = 1114072913279994047L;

            public void actionPerformed(ActionEvent arg0) {
                final SpinnerNumberModel model = new SpinnerNumberModel();
                model.setMaximum(Integer.valueOf(100));
                model.setMinimum(Integer.valueOf(15));
                model.setStepSize(1);
                model.setValue((int)(((TripleAFrame)TripleaMenu.this.m_frame).getMapPanel().getScale() * 100.0));
                JSpinner spinner = new JSpinner(model);
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                panel.add((Component)new JLabel("Choose Map Scale Percentage"), "North");
                panel.add((Component)spinner, "Center");
                JPanel buttons = new JPanel();
                JButton fitWidth = new JButton("Fit Width");
                buttons.add(fitWidth);
                JButton fitHeight = new JButton("Fit Height");
                buttons.add(fitHeight);
                JButton reset = new JButton("Reset");
                buttons.add(reset);
                panel.add((Component)buttons, "South");
                fitWidth.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        double screenWidth = ((TripleAFrame)TripleaMenu.this.m_frame).getMapPanel().getWidth();
                        double mapWidth = ((TripleAFrame)TripleaMenu.this.m_frame).getMapPanel().getImageWidth();
                        double ratio = screenWidth / mapWidth;
                        ratio = Math.max(0.15, ratio);
                        ratio = Math.min(1.0, ratio);
                        model.setValue((int)(ratio * 100.0));
                    }
                });
                fitHeight.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        double screenHeight = ((TripleAFrame)TripleaMenu.this.m_frame).getMapPanel().getHeight();
                        double mapHeight = ((TripleAFrame)TripleaMenu.this.m_frame).getMapPanel().getImageHeight();
                        double ratio = screenHeight / mapHeight;
                        ratio = Math.max(0.15, ratio);
                        model.setValue((int)(ratio * 100.0));
                    }
                });
                reset.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        model.setValue(100);
                    }
                });
                int result = JOptionPane.showOptionDialog(TripleaMenu.this.m_frame, panel, "Choose Map Scale", 2, -1, null, new String[]{"OK", "Cancel"}, 0);
                if (result != 0) {
                    return;
                }
                Number value = (Number)model.getValue();
                ((TripleAFrame)TripleaMenu.this.m_frame).setScale(value.doubleValue());
            }
        };
        menuGame.add(mapZoom).setMnemonic(90);
    }

    private void addShowVerifiedDice(JMenu parentMenu) {
        AbstractAction showVerifiedDice = new AbstractAction("Show Verified Dice.."){
            private static final long serialVersionUID = -2753073276162734526L;

            public void actionPerformed(ActionEvent e) {
                new VerifiedRandomNumbersDialog(((TripleAFrame)TripleaMenu.this.m_frame).getRootPane()).setVisible(true);
            }
        };
        if (this.getGame() instanceof ClientGame) {
            parentMenu.add(showVerifiedDice).setMnemonic(86);
        }
    }

    private void addSaveScreenshot(JMenu parentMenu) {
        parentMenu.add(((TripleAFrame)this.m_frame).getSaveScreenshotAction()).setMnemonic(69);
    }

    private void addShowCommentLog(JMenu parentMenu) {
        JCheckBoxMenuItem showCommentLog = new JCheckBoxMenuItem("Show Comment Log");
        showCommentLog.setModel(((TripleAFrame)this.m_frame).getShowCommentLogButtonModel());
        parentMenu.add(showCommentLog).setMnemonic(76);
    }

    private void addShowEnemyCasualties(JMenu parentMenu) {
        final JCheckBoxMenuItem showEnemyCasualties = new JCheckBoxMenuItem("Confirm Enemy Casualties");
        showEnemyCasualties.setMnemonic(69);
        showEnemyCasualties.setSelected(BattleDisplay.getShowEnemyCasualtyNotification());
        showEnemyCasualties.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -7445092411530581715L;

            public void actionPerformed(ActionEvent e) {
                BattleDisplay.setShowEnemyCasualtyNotification(showEnemyCasualties.isSelected());
            }
        });
        parentMenu.add(showEnemyCasualties);
    }

    private void addFocusOnCasualties(JMenu parentMenu) {
        final JCheckBoxMenuItem focusOnCasualties = new JCheckBoxMenuItem("Focus On Own Casualties");
        focusOnCasualties.setSelected(BattleDisplay.getFocusOnOwnCasualtiesNotification());
        focusOnCasualties.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 6176484225385360649L;

            public void actionPerformed(ActionEvent e) {
                BattleDisplay.setFocusOnOwnCasualtiesNotification(focusOnCasualties.isSelected());
            }
        });
        parentMenu.add(focusOnCasualties);
    }

    private void addTabbedProduction(JMenu parentMenu) {
        final JCheckBoxMenuItem tabbedProduction = new JCheckBoxMenuItem("Show Production Tabs");
        tabbedProduction.setMnemonic(80);
        tabbedProduction.setSelected(PurchasePanel.isTabbedProduction());
        tabbedProduction.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -352890957050498753L;

            public void actionPerformed(ActionEvent e) {
                PurchasePanel.setTabbedProduction(tabbedProduction.isSelected());
            }
        });
        parentMenu.add(tabbedProduction);
    }

    private void addPoliticsMenu(JMenu menuGame) {
        AbstractAction politicsAction = new AbstractAction("Show Politics Panel"){
            private static final long serialVersionUID = 7880136597816371478L;

            public void actionPerformed(ActionEvent e) {
                PoliticalStateOverview ui = new PoliticalStateOverview(TripleaMenu.this.getData(), TripleaMenu.this.getUIContext(), false);
                JScrollPane scroll = new JScrollPane(ui);
                scroll.setBorder(BorderFactory.createEmptyBorder());
                Dimension screenResolution = Toolkit.getDefaultToolkit().getScreenSize();
                int availHeight = screenResolution.height - 120;
                int availWidth = screenResolution.width - 40;
                scroll.setPreferredSize(new Dimension(scroll.getPreferredSize().width > availWidth ? availWidth : scroll.getPreferredSize().width, scroll.getPreferredSize().height > availHeight ? availHeight : scroll.getPreferredSize().height));
                JOptionPane.showMessageDialog(TripleaMenu.this.m_frame, scroll, "Politics Panel", -1);
            }
        };
        menuGame.add(politicsAction).setMnemonic(80);
    }

    private void addShowUnits(JMenu parentMenu) {
        final JCheckBoxMenuItem showUnitsBox = new JCheckBoxMenuItem("Show Units");
        showUnitsBox.setMnemonic(85);
        showUnitsBox.setSelected(true);
        showUnitsBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean tfselected = showUnitsBox.isSelected();
                TripleaMenu.this.getUIContext().setShowUnits(tfselected);
                ((TripleAFrame)TripleaMenu.this.m_frame).getMapPanel().resetMap();
            }
        });
        parentMenu.add(showUnitsBox);
    }

    private void addDrawTerritoryBordersAgain(JMenu parentMenu) {
        JMenu drawBordersMenu = new JMenu();
        drawBordersMenu.setMnemonic(79);
        drawBordersMenu.setText("Draw Borders On Top");
        final JRadioButton noneButton = new JRadioButton("Low");
        noneButton.setMnemonic(76);
        final JRadioButton mediumButton = new JRadioButton("Medium");
        mediumButton.setMnemonic(77);
        final JRadioButton highButton = new JRadioButton("High");
        highButton.setMnemonic(72);
        ButtonGroup group = new ButtonGroup();
        group.add(noneButton);
        group.add(mediumButton);
        group.add(highButton);
        drawBordersMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                IDrawable.OptionalExtraBorderLevel current = TripleaMenu.this.getUIContext().getDrawTerritoryBordersAgain();
                if (current == IDrawable.OptionalExtraBorderLevel.LOW) {
                    noneButton.setSelected(true);
                } else if (current == IDrawable.OptionalExtraBorderLevel.MEDIUM) {
                    mediumButton.setSelected(true);
                } else if (current == IDrawable.OptionalExtraBorderLevel.HIGH) {
                    highButton.setSelected(true);
                }
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        noneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (noneButton.isSelected() && TripleaMenu.this.getUIContext().getDrawTerritoryBordersAgain() != IDrawable.OptionalExtraBorderLevel.LOW) {
                    TripleaMenu.this.getUIContext().setDrawTerritoryBordersAgain(IDrawable.OptionalExtraBorderLevel.LOW);
                    ((TripleAFrame)TripleaMenu.this.m_frame).getMapPanel().resetMap();
                }
            }
        });
        mediumButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (mediumButton.isSelected() && TripleaMenu.this.getUIContext().getDrawTerritoryBordersAgain() != IDrawable.OptionalExtraBorderLevel.MEDIUM) {
                    TripleaMenu.this.getUIContext().setDrawTerritoryBordersAgain(IDrawable.OptionalExtraBorderLevel.MEDIUM);
                    ((TripleAFrame)TripleaMenu.this.m_frame).getMapPanel().resetMap();
                }
            }
        });
        highButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (highButton.isSelected() && TripleaMenu.this.getUIContext().getDrawTerritoryBordersAgain() != IDrawable.OptionalExtraBorderLevel.HIGH) {
                    TripleaMenu.this.getUIContext().setDrawTerritoryBordersAgain(IDrawable.OptionalExtraBorderLevel.HIGH);
                    ((TripleAFrame)TripleaMenu.this.m_frame).getMapPanel().resetMap();
                }
            }
        });
        drawBordersMenu.add(noneButton);
        drawBordersMenu.add(mediumButton);
        drawBordersMenu.add(highButton);
        parentMenu.add(drawBordersMenu);
    }

    private void addMapFontAndColorEditorMenu(JMenu parentMenu) {
        AbstractAction mapFontOptions = new AbstractAction("Edit Map Font and Color..."){
            private static final long serialVersionUID = 2788608972531414309L;

            public void actionPerformed(ActionEvent arg0) {
                ArrayList<AEditableProperty> properties = new ArrayList<AEditableProperty>();
                NumberProperty fontsize = new NumberProperty("Font Size", null, 60, 0, MapImage.getPropertyMapFont().getSize());
                ColorProperty territoryNameColor = new ColorProperty("Territory Name and PU Color", null, MapImage.getPropertyTerritoryNameAndPUAndCommentcolor());
                ColorProperty unitCountColor = new ColorProperty("Unit Count Color", null, MapImage.getPropertyUnitCountColor());
                ColorProperty factoryDamageColor = new ColorProperty("Factory Damage Color", null, MapImage.getPropertyUnitFactoryDamageColor());
                properties.add(fontsize);
                properties.add(territoryNameColor);
                properties.add(unitCountColor);
                properties.add(factoryDamageColor);
                PropertiesUI pui = new PropertiesUI(properties, true);
                JPanel ui = new JPanel();
                ui.setLayout(new BorderLayout());
                ui.add((Component)pui, "Center");
                ui.add((Component)new JLabel("<html>Change the font and color of 'text' (not pictures) on the map. <br /><em>(Some people encounter problems with the color picker, and this <br />is a bug outside of triplea, located in the 'look and feel' that <br />you are using. If you have an error come up, try switching to the <br />basic 'look and feel', then setting the color, then switching back.)</em></html>"), "North");
                Object[] options = new Object[]{"Set Properties", "Reset To Default", "Cancel"};
                int result = JOptionPane.showOptionDialog(TripleaMenu.this.m_frame, ui, "Edit Map Font and Color", 1, -1, null, options, 2);
                if (result == 2) {
                    return;
                }
                if (result == 1) {
                    MapImage.resetPropertyMapFont();
                    MapImage.resetPropertyTerritoryNameAndPUAndCommentcolor();
                    MapImage.resetPropertyUnitCountColor();
                    MapImage.resetPropertyUnitFactoryDamageColor();
                    ((TripleAFrame)TripleaMenu.this.m_frame).getMapPanel().resetMap();
                } else if (result == 0) {
                    MapImage.setPropertyMapFont(new Font("Ariel", 1, fontsize.getValue()));
                    MapImage.setPropertyTerritoryNameAndPUAndCommentcolor((Color)territoryNameColor.getValue());
                    MapImage.setPropertyUnitCountColor((Color)unitCountColor.getValue());
                    MapImage.setPropertyUnitFactoryDamageColor((Color)factoryDamageColor.getValue());
                    ((TripleAFrame)TripleaMenu.this.m_frame).getMapPanel().resetMap();
                }
            }
        };
        parentMenu.add(mapFontOptions).setMnemonic(67);
    }

    private void addShowTerritoryEffects(JMenu parentMenu) {
        final JCheckBoxMenuItem territoryEffectsBox = new JCheckBoxMenuItem("Show TerritoryEffects");
        territoryEffectsBox.setMnemonic(84);
        territoryEffectsBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean tfselected = territoryEffectsBox.isSelected();
                TripleaMenu.this.getUIContext().setShowTerritoryEffects(tfselected);
                ((TripleAFrame)TripleaMenu.this.m_frame).getMapPanel().resetMap();
            }
        });
        parentMenu.add(territoryEffectsBox);
        territoryEffectsBox.setSelected(true);
    }

    private void addLockMap(JMenu parentMenu) {
        final JCheckBoxMenuItem lockMapBox = new JCheckBoxMenuItem("Lock Map");
        lockMapBox.setMnemonic(77);
        lockMapBox.setSelected(this.getUIContext().getLockMap());
        lockMapBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TripleaMenu.this.getUIContext().setLockMap(lockMapBox.isSelected());
            }
        });
        parentMenu.add(lockMapBox);
    }

    private void addEndTurnReport(JMenu parentMenu) {
        final JCheckBoxMenuItem showEndOfTurnReport = new JCheckBoxMenuItem("Show End of Turn Report");
        showEndOfTurnReport.setMnemonic(84);
        showEndOfTurnReport.setSelected(this.getUIContext().getShowEndOfTurnReport());
        showEndOfTurnReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TripleaMenu.this.getUIContext().setShowEndOfTurnReport(showEndOfTurnReport.isSelected());
            }
        });
        parentMenu.add(showEndOfTurnReport);
    }

    private void addShowAIBattles(JMenu parentMenu) {
        final JCheckBoxMenuItem showAIBattlesBox = new JCheckBoxMenuItem("Show Battles Between AIs");
        showAIBattlesBox.setMnemonic(65);
        showAIBattlesBox.setSelected(this.getUIContext().getShowBattlesBetweenAIs());
        showAIBattlesBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TripleaMenu.this.getUIContext().setShowBattlesBetweenAIs(showAIBattlesBox.isSelected());
            }
        });
        parentMenu.add(showAIBattlesBox);
    }

    private void addChangeDynamixAISettings(JMenu parentMenu) {
        boolean areThereDynamixAIs = false;
        Set<IGamePlayer> players = ((TripleAFrame)this.m_frame).getLocalPlayers().getLocalPlayers();
        for (IGamePlayer player : players) {
            if (!(player instanceof Dynamix_AI)) continue;
            areThereDynamixAIs = true;
        }
        if (areThereDynamixAIs) {
            Dynamix_AI.ClearAIInstancesMemory();
            Dynamix_AI.Initialize((TripleAFrame)this.m_frame);
            for (IGamePlayer player : players) {
                if (!(player instanceof Dynamix_AI)) continue;
                Dynamix_AI.AddDynamixAIIntoAIInstancesMemory((Dynamix_AI)player);
            }
            parentMenu.addSeparator();
            parentMenu.add(new AbstractAction("Change Dynamix AI Settings"){
                private static final long serialVersionUID = 2257295609477283292L;

                public void actionPerformed(ActionEvent e) {
                    Dynamix_AI.ShowSettingsWindow();
                }
            }).setMnemonic(67);
            parentMenu.addSeparator();
        }
    }

    private void addShowDiceStats(JMenu parentMenu) {
        AbstractAction showDiceStats = new AbstractAction("Show Dice Stats..."){
            private static final long serialVersionUID = 5530880208301800861L;

            public void actionPerformed(ActionEvent e) {
                IRandomStats randomStats = (IRandomStats)TripleaMenu.this.getGame().getRemoteMessenger().getRemote(IRandomStats.RANDOM_STATS_REMOTE_NAME);
                RandomStatsDetails stats = randomStats.getRandomStats(TripleaMenu.this.getData().getDiceSides());
                JOptionPane.showMessageDialog(TripleaMenu.this.m_frame, new JScrollPane(stats.getAllStats()), "Random Stats", 1);
            }
        };
        parentMenu.add(showDiceStats).setMnemonic(68);
    }

    private void addRollDice(JMenu parentMenu) {
        JMenuItem RollDiceBox = new JMenuItem("Roll Dice...");
        RollDiceBox.setMnemonic(82);
        RollDiceBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IntTextField numberOfText = new IntTextField(0, 100);
                IntTextField diceSidesText = new IntTextField(1, 200);
                numberOfText.setText(String.valueOf(0));
                diceSidesText.setText(String.valueOf(TripleaMenu.this.getGame().getData().getDiceSides()));
                JPanel panel = new JPanel();
                panel.setLayout(new GridBagLayout());
                panel.add((Component)new JLabel("Number of Dice to Roll: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 20), 0, 0));
                panel.add((Component)new JLabel("Sides on the Dice: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 20, 0, 10), 0, 0));
                panel.add((Component)numberOfText, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 20), 0, 0));
                panel.add((Component)diceSidesText, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 20, 0, 10), 0, 0));
                JOptionPane.showOptionDialog(JOptionPane.getFrameForComponent(TripleaMenu.this), panel, "Roll Dice", 0, 1, null, new String[]{"OK"}, "OK");
                try {
                    int numberOfDice = Integer.parseInt(numberOfText.getText());
                    if (numberOfDice > 0) {
                        int diceSides = Integer.parseInt(diceSidesText.getText());
                        int[] dice = TripleaMenu.this.getGame().getRandomSource().getRandom(diceSides, numberOfDice, "Rolling Dice, no effect on game.");
                        JPanel panelDice = new JPanel();
                        BoxLayout layout = new BoxLayout(panelDice, 1);
                        panelDice.setLayout(layout);
                        JLabel label = new JLabel("Rolls (no effect on game): ");
                        panelDice.add(label);
                        String diceString = "";
                        for (int i = 0; i < dice.length; ++i) {
                            diceString = diceString + String.valueOf(dice[i] + 1) + (i == dice.length - 1 ? "" : ", ");
                        }
                        JTextField diceList = new JTextField(diceString);
                        diceList.setEditable(false);
                        panelDice.add(diceList);
                        JOptionPane.showMessageDialog(TripleaMenu.this.m_frame, panelDice, "Dice Rolled", 1);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        });
        parentMenu.add(RollDiceBox);
    }

    private void addBattleCalculatorMenu(JMenu menuGame) {
        AbstractAction showBattleMenu = new AbstractAction("Battle Calculator..."){
            private static final long serialVersionUID = 6211814774301020553L;

            public void actionPerformed(ActionEvent arg0) {
                OddsCalculatorDialog.show((TripleAFrame)TripleaMenu.this.m_frame, null);
            }
        };
        JMenuItem showBattleMenuItem = menuGame.add(showBattleMenu);
        showBattleMenuItem.setMnemonic(66);
        showBattleMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    private void addExportStatsFull(JMenu parentMenu) {
        AbstractAction showDiceStats = new AbstractAction("Export Full Game Stats..."){
            private static final long serialVersionUID = -1732417863580400806L;

            public void actionPerformed(ActionEvent e) {
                TripleaMenu.this.createAndSaveStats(true);
            }
        };
        parentMenu.add(showDiceStats).setMnemonic(70);
    }

    private void addExportStats(JMenu parentMenu) {
        AbstractAction showDiceStats = new AbstractAction("Export Short Game Stats..."){
            private static final long serialVersionUID = 8196345604657706754L;

            public void actionPerformed(ActionEvent e) {
                TripleaMenu.this.createAndSaveStats(false);
            }
        };
        parentMenu.add(showDiceStats).setMnemonic(83);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndSaveStats(boolean showPhaseStats) {
        ExtendedStats statPanel = new ExtendedStats(this.getData(), this.getUIContext());
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        File rootDir = new File(System.getProperties().getProperty("user.dir"));
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy_MM_dd");
        int currentRound = 0;
        try {
            this.getData().acquireReadLock();
            currentRound = this.getData().getSequence().getRound();
        }
        finally {
            this.getData().releaseReadLock();
        }
        String defaultFileName = "stats_" + formatDate.format(new Date()) + "_" + this.getData().getGameName() + "_round_" + currentRound + (showPhaseStats ? "_full" : "_short");
        defaultFileName = IllegalCharacterRemover.removeIllegalCharacter(defaultFileName);
        defaultFileName = defaultFileName + ".csv";
        chooser.setSelectedFile(new File(rootDir, defaultFileName));
        if (chooser.showSaveDialog(this.m_frame) != 0) {
            return;
        }
        StringBuilder text = new StringBuilder(1000);
        try {
            int i;
            this.getData().acquireReadLock();
            GameData clone = GameDataUtils.cloneGameData(this.getData());
            IStat[] stats = statPanel.getStats();
            IStat[] statsExtended = statPanel.getStatsExtended(this.getData());
            String[] alliances = statPanel.getAlliances().toArray(new String[statPanel.getAlliances().size()]);
            PlayerID[] players = statPanel.getPlayers().toArray(new PlayerID[statPanel.getPlayers().size()]);
            for (int i2 = 0; i2 < players.length; ++i2) {
                players[i2] = clone.getPlayerList().getPlayerID(players[i2].getName());
            }
            text.append(defaultFileName + ",");
            text.append("\n");
            text.append("TripleA Engine Version: ,");
            text.append(EngineVersion.VERSION.toString() + ",");
            text.append("\n");
            text.append("Game Name: ,");
            text.append(this.getData().getGameName() + ",");
            text.append("\n");
            text.append("Game Version: ,");
            text.append(this.getData().getGameVersion() + ",");
            text.append("\n");
            text.append("\n");
            text.append("Current Round: ,");
            text.append(currentRound + ",");
            text.append("\n");
            text.append("Number of Players: ,");
            text.append(statPanel.getPlayers().size() + ",");
            text.append("\n");
            text.append("Number of Alliances: ,");
            text.append(statPanel.getAlliances().size() + ",");
            text.append("\n");
            text.append("\n");
            text.append("Turn Order: ,");
            text.append("\n");
            ArrayList<PlayerID> playerOrderList = new ArrayList<PlayerID>();
            playerOrderList.addAll(this.getData().getPlayerList().getPlayers());
            Collections.sort(playerOrderList, new PlayerOrderComparator(this.getData()));
            LinkedHashSet playerOrderSetNoDuplicates = new LinkedHashSet(playerOrderList);
            for (PlayerID currentPlayerID : playerOrderSetNoDuplicates) {
                text.append(currentPlayerID.getName() + ",");
                Iterator<String> allianceName = this.getData().getAllianceTracker().getAlliancesPlayerIsIn(currentPlayerID).iterator();
                while (allianceName.hasNext()) {
                    text.append(allianceName.next() + ",");
                }
                text.append("\n");
            }
            text.append("\n");
            text.append("Winners: ,");
            EndRoundDelegate delegateEndRound = (EndRoundDelegate)this.getData().getDelegateList().getDelegate("endRound");
            if (delegateEndRound != null && delegateEndRound.getWinners() != null) {
                for (PlayerID p : delegateEndRound.getWinners()) {
                    text.append(p.getName() + ",");
                }
            } else {
                text.append("none yet; game not over,");
            }
            text.append("\n");
            text.append("\n");
            text.append("Resource Chart: ,");
            text.append("\n");
            Iterator<Resource> resourceIterator = this.getData().getResourceList().getResources().iterator();
            while (resourceIterator.hasNext()) {
                text.append(resourceIterator.next().getName() + ",");
                text.append("\n");
            }
            if (showPhaseStats) {
                text.append("\n");
                text.append("Production Rules: ,");
                text.append("\n");
                text.append("Name,Result,Quantity,Cost,Resource,\n");
                for (ProductionRule pr : this.getData().getProductionRuleList().getProductionRules()) {
                    String costString = pr.toStringCosts().replaceAll("; ", ",");
                    costString = costString.replaceAll(" ", ",");
                    text.append(pr.getName() + "," + pr.getResults().keySet().iterator().next().getName() + "," + pr.getResults().getInt(pr.getResults().keySet().iterator().next()) + "," + costString + ",");
                    text.append("\n");
                }
                text.append("\n");
                text.append("Unit Types: ,");
                text.append("\n");
                text.append("Name,Listed Abilities\n");
                Iterator<UnitType> allUnitsIterator = this.getData().getUnitTypeList().iterator();
                while (allUnitsIterator.hasNext()) {
                    UnitAttachment ua = UnitAttachment.get(allUnitsIterator.next());
                    if (ua == null) continue;
                    String toModify = ua.allUnitStatsForExporter();
                    toModify = toModify.replaceFirst("UnitType called ", "").replaceFirst(" with:", "").replaceAll("games.strategy.engine.data.", "").replaceAll("\n", ";").replaceAll(",", ";");
                    toModify = toModify.replaceAll("  ", ",");
                    toModify = toModify.replaceAll(", ", ",").replaceAll(" ,", ",");
                    text.append(toModify);
                    text.append("\n");
                }
            }
            text.append("\n");
            text.append(showPhaseStats ? "Full Stats (includes each phase that had activity)," : "Short Stats (only shows first phase with activity per player per round),");
            text.append("\n");
            text.append("Turn Stats: ,");
            text.append("\n");
            text.append("Round,Player Turn,Phase Name,");
            for (i = 0; i < stats.length; ++i) {
                int j;
                for (j = 0; j < players.length; ++j) {
                    text.append(stats[i].getName()).append(" ");
                    text.append(players[j].getName());
                    text.append(",");
                }
                for (j = 0; j < alliances.length; ++j) {
                    text.append(stats[i].getName()).append(" ");
                    text.append(alliances[j]);
                    text.append(",");
                }
            }
            for (i = 0; i < statsExtended.length; ++i) {
                int j;
                for (j = 0; j < players.length; ++j) {
                    text.append(statsExtended[i].getName()).append(" ");
                    text.append(players[j].getName());
                    text.append(",");
                }
                for (j = 0; j < alliances.length; ++j) {
                    text.append(statsExtended[i].getName()).append(" ");
                    text.append(alliances[j]);
                    text.append(",");
                }
            }
            text.append("\n");
            clone.getHistory().gotoNode(clone.getHistory().getLastNode());
            Enumeration<TreeNode> nodes = ((DefaultMutableTreeNode)clone.getHistory().getRoot()).preorderEnumeration();
            PlayerID currentPlayer = null;
            int round = 0;
            while (nodes.hasMoreElements()) {
                int j;
                int i3;
                Step step;
                HistoryNode element = (HistoryNode)nodes.nextElement();
                if (element instanceof Round) {
                    ++round;
                }
                if (!(element instanceof Step) || (step = (Step)element).getPlayerID() == null || step.getPlayerID().isNull() || !showPhaseStats && step.getPlayerID() == currentPlayer) continue;
                currentPlayer = step.getPlayerID();
                clone.getHistory().gotoNode(element);
                String playerName = step.getPlayerID() == null ? "" : step.getPlayerID().getName() + ": ";
                String stepName = step.getStepName();
                stepName = stepName.endsWith("Bid") ? "Bid" : (stepName.endsWith("Tech") ? "Tech" : (stepName.endsWith("TechActivation") ? "TechActivation" : (stepName.endsWith("Purchase") ? "Purchase" : (stepName.endsWith("NonCombatMove") ? "NonCombatMove" : (stepName.endsWith("Move") ? "Move" : (stepName.endsWith("Battle") ? "Battle" : (stepName.endsWith("BidPlace") ? "BidPlace" : (stepName.endsWith("Place") ? "Place" : (stepName.endsWith("Politics") ? "Politics" : (stepName.endsWith("EndTurn") ? "EndTurn" : ""))))))))));
                text.append(round).append(",").append(playerName).append(",").append(stepName).append(",");
                for (i3 = 0; i3 < stats.length; ++i3) {
                    for (j = 0; j < players.length; ++j) {
                        text.append(stats[i3].getFormatter().format(stats[i3].getValue(players[j], clone)));
                        text.append(",");
                    }
                    for (j = 0; j < alliances.length; ++j) {
                        text.append(stats[i3].getFormatter().format(stats[i3].getValue(alliances[j], clone)));
                        text.append(",");
                    }
                }
                for (i3 = 0; i3 < statsExtended.length; ++i3) {
                    for (j = 0; j < players.length; ++j) {
                        text.append(statsExtended[i3].getFormatter().format(statsExtended[i3].getValue(players[j], clone)));
                        text.append(",");
                    }
                    for (j = 0; j < alliances.length; ++j) {
                        text.append(statsExtended[i3].getFormatter().format(statsExtended[i3].getValue(alliances[j], clone)));
                        text.append(",");
                    }
                }
                text.append("\n");
            }
        }
        finally {
            this.getData().releaseReadLock();
        }
        try {
            FileWriter writer = new FileWriter(chooser.getSelectedFile());
            try {
                writer.write(text.toString());
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void setWidgetActivation() {
        this.showMapDetails.setEnabled(this.getUIContext().getMapData().getHasRelief());
    }

    private void addShowMapDetails(JMenu menuGame) {
        this.showMapDetails = new JCheckBoxMenuItem("Show Map Details");
        this.showMapDetails.setMnemonic(68);
        this.showMapDetails.setSelected(TileImageFactory.getShowReliefImages());
        this.showMapDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TileImageFactory.getShowReliefImages() == TripleaMenu.this.showMapDetails.isSelected()) {
                    return;
                }
                TileImageFactory.setShowReliefImages(TripleaMenu.this.showMapDetails.isSelected());
                Thread t = new Thread("Triplea : Show map details thread"){

                    public void run() {
                        1.yield();
                        ((TripleAFrame)TripleaMenu.this.m_frame).getMapPanel().updateCountries(TripleaMenu.this.getData().getMap().getTerritories());
                    }
                };
                t.start();
            }
        });
        menuGame.add(this.showMapDetails);
    }

    private void addShowMapBlends(JMenu menuGame) {
        this.showMapBlends = new JCheckBoxMenuItem("Show Map Blends");
        this.showMapBlends.setMnemonic(66);
        if (this.getUIContext().getMapData().getHasRelief() && this.showMapDetails.isEnabled() && this.showMapDetails.isSelected()) {
            this.showMapBlends.setEnabled(true);
            this.showMapBlends.setSelected(TileImageFactory.getShowMapBlends());
        } else {
            this.showMapBlends.setSelected(false);
            this.showMapBlends.setEnabled(false);
        }
        this.showMapBlends.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TileImageFactory.getShowMapBlends() == TripleaMenu.this.showMapBlends.isSelected()) {
                    return;
                }
                TileImageFactory.setShowMapBlends(TripleaMenu.this.showMapBlends.isSelected());
                TileImageFactory.setShowMapBlendMode(((TripleAFrame)TripleaMenu.this.m_frame).getUIContext().getMapData().getMapBlendMode());
                TileImageFactory.setShowMapBlendAlpha(((TripleAFrame)TripleaMenu.this.m_frame).getUIContext().getMapData().getMapBlendAlpha());
                Thread t = new Thread("Triplea : Show map Blends thread"){

                    public void run() {
                        ((TripleAFrame)TripleaMenu.this.m_frame).setScale(((TripleAFrame)TripleaMenu.this.m_frame).getUIContext().getScale() * 100.0);
                        1.yield();
                        ((TripleAFrame)TripleaMenu.this.m_frame).getMapPanel().updateCountries(TripleaMenu.this.getData().getMap().getTerritories());
                    }
                };
                t.start();
            }
        });
        menuGame.add(this.showMapBlends);
    }

    private void addMapSkinsMenu(JMenu menuGame) {
        JMenu mapSubMenu = new JMenu("Map Skins");
        mapSubMenu.setMnemonic(75);
        ButtonGroup mapButtonGroup = new ButtonGroup();
        menuGame.add(mapSubMenu);
        final Map<String, String> skins = AbstractUIContext.getSkins(((TripleAFrame)this.m_frame).getGame().getData());
        for (final String key : skins.keySet()) {
            JRadioButtonMenuItem mapMenuItem = new JRadioButtonMenuItem(key);
            mapButtonGroup.add(mapMenuItem);
            mapSubMenu.add(mapMenuItem);
            mapSubMenu.setEnabled(skins.size() > 1);
            if (skins.get(key).equals(AbstractUIContext.getMapDir())) {
                mapMenuItem.setSelected(true);
            }
            mapMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        ((TripleAFrame)TripleaMenu.this.m_frame).updateMap((String)skins.get(key));
                        if (((TripleAFrame)TripleaMenu.this.m_frame).getUIContext().getMapData().getHasRelief()) {
                            TripleaMenu.this.showMapDetails.setSelected(true);
                        }
                        TripleaMenu.this.setWidgetActivation();
                    }
                    catch (Exception se) {
                        se.printStackTrace();
                        JOptionPane.showMessageDialog(TripleaMenu.this.m_frame, se.getMessage(), "Error Changing Map Skin2", 0);
                    }
                }
            });
        }
    }

    private void addExportSetupCharts(JMenu parentMenu) {
        JMenuItem menuFileExport = new JMenuItem(new AbstractAction("Export Setup Charts..."){
            private static final long serialVersionUID = 1596267069546601864L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                GameData clonedGameData;
                JFrame frame = new JFrame("Export Setup Files");
                frame.setDefaultCloseOperation(2);
                GameData data = ((TripleAFrame)TripleaMenu.this.m_frame).getGame().getData();
                data.acquireReadLock();
                try {
                    clonedGameData = GameDataUtils.cloneGameData(data);
                }
                finally {
                    data.releaseReadLock();
                }
                SetupFrame newContentPane = new SetupFrame(clonedGameData);
                newContentPane.setOpaque(true);
                frame.setContentPane(newContentPane);
                frame.pack();
                frame.setLocationRelativeTo(TripleaMenu.this.m_frame);
                frame.setVisible(true);
                ((TripleAFrame)TripleaMenu.this.m_frame).getUIContext().addShutdownWindow(frame);
            }
        });
        menuFileExport.setMnemonic(67);
        parentMenu.add(menuFileExport);
    }

    private void addUnitSizeMenu(JMenu parentMenu) {
        final DecimalFormat s_decimalFormat = new DecimalFormat("00.##");
        JMenu unitSizeMenu = new JMenu();
        unitSizeMenu.setMnemonic(83);
        unitSizeMenu.setText("Unit Size");
        ButtonGroup unitSizeGroup = new ButtonGroup();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UnitSizeAction
        extends AbstractAction {
            private static final long serialVersionUID = -6280511505686687867L;
            private final double m_scaleFactor;

            public UnitSizeAction(double scaleFactor) {
                this.m_scaleFactor = scaleFactor;
                this.putValue("Name", s_decimalFormat.format(this.m_scaleFactor * 100.0) + "%");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                TripleaMenu.this.getUIContext().setUnitScaleFactor(this.m_scaleFactor);
                ((TripleAFrame)TripleaMenu.this.m_frame).getMapPanel().resetMap();
            }
        }
        JRadioButtonMenuItem radioItem125 = new JRadioButtonMenuItem(new UnitSizeAction(1.25));
        JRadioButtonMenuItem radioItem100 = new JRadioButtonMenuItem(new UnitSizeAction(1.0));
        radioItem100.setMnemonic(49);
        JRadioButtonMenuItem radioItem87 = new JRadioButtonMenuItem(new UnitSizeAction(0.875));
        JRadioButtonMenuItem radioItem83 = new JRadioButtonMenuItem(new UnitSizeAction(0.8333));
        radioItem83.setMnemonic(56);
        JRadioButtonMenuItem radioItem75 = new JRadioButtonMenuItem(new UnitSizeAction(0.75));
        radioItem75.setMnemonic(55);
        JRadioButtonMenuItem radioItem66 = new JRadioButtonMenuItem(new UnitSizeAction(0.6666));
        radioItem66.setMnemonic(54);
        JRadioButtonMenuItem radioItem56 = new JRadioButtonMenuItem(new UnitSizeAction(0.5625));
        JRadioButtonMenuItem radioItem50 = new JRadioButtonMenuItem(new UnitSizeAction(0.5));
        radioItem50.setMnemonic(53);
        unitSizeGroup.add(radioItem125);
        unitSizeGroup.add(radioItem100);
        unitSizeGroup.add(radioItem87);
        unitSizeGroup.add(radioItem83);
        unitSizeGroup.add(radioItem75);
        unitSizeGroup.add(radioItem66);
        unitSizeGroup.add(radioItem56);
        unitSizeGroup.add(radioItem50);
        radioItem100.setSelected(true);
        Enumeration<AbstractButton> enum1 = unitSizeGroup.getElements();
        boolean matchFound = false;
        while (enum1.hasMoreElements()) {
            JRadioButtonMenuItem menuItem = (JRadioButtonMenuItem)enum1.nextElement();
            UnitSizeAction action = (UnitSizeAction)menuItem.getAction();
            if (!(Math.abs(action.m_scaleFactor - this.getUIContext().getUnitImageFactory().getScaleFactor()) < 0.01)) continue;
            menuItem.setSelected(true);
            matchFound = true;
            break;
        }
        if (!matchFound) {
            System.err.println("default unit size does not match any menu item");
        }
        unitSizeMenu.add(radioItem125);
        unitSizeMenu.add(radioItem100);
        unitSizeMenu.add(radioItem87);
        unitSizeMenu.add(radioItem83);
        unitSizeMenu.add(radioItem75);
        unitSizeMenu.add(radioItem66);
        unitSizeMenu.add(radioItem56);
        unitSizeMenu.add(radioItem50);
        parentMenu.add(unitSizeMenu);
    }
}

