/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.sound.ClipPlayer;
import games.strategy.sound.SoundPath;
import games.strategy.triplea.ResourceLoader;
import games.strategy.triplea.image.DiceImageFactory;
import games.strategy.triplea.image.FlagIconImageFactory;
import games.strategy.triplea.image.MapImage;
import games.strategy.triplea.image.PUImageFactory;
import games.strategy.triplea.image.TileImageFactory;
import games.strategy.triplea.image.UnitImageFactory;
import games.strategy.triplea.ui.AbstractUIContext;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.ui.MapData;
import games.strategy.triplea.ui.screen.IDrawable;
import games.strategy.triplea.util.Stopwatch;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;

public class UIContext
extends AbstractUIContext
implements IUIContext {
    protected MapData m_mapData;
    protected final TileImageFactory m_tileImageFactory = new TileImageFactory();
    protected final UnitImageFactory m_unitImageFactory = new UnitImageFactory();
    protected final MapImage m_mapImage;
    protected final FlagIconImageFactory m_flagIconImageFactory = new FlagIconImageFactory();
    protected DiceImageFactory m_diceImageFactory;
    protected final PUImageFactory m_PUImageFactory = new PUImageFactory();
    protected boolean m_drawUnits = true;
    protected boolean m_drawTerritoryEffects = false;
    protected boolean m_drawMapOnly = false;
    protected IDrawable.OptionalExtraBorderLevel m_extraTerritoryBorderLevel = IDrawable.OptionalExtraBorderLevel.LOW;
    protected Cursor m_cursor = Cursor.getDefaultCursor();

    public UIContext() {
        this.m_mapImage = new MapImage();
    }

    public Cursor getCursor() {
        return this.m_cursor;
    }

    public void setScale(double scale) {
        super.setScale(scale);
        this.m_tileImageFactory.setScale(scale);
    }

    protected void internalSetMapDir(String dir, final GameData data) {
        Stopwatch stopWatch = new Stopwatch(s_logger, Level.FINE, "Loading UI Context");
        m_resourceLoader = ResourceLoader.getMapResourceLoader(dir, false);
        if (this.m_mapData != null) {
            this.m_mapData.close();
        }
        this.m_mapData = new MapData(m_resourceLoader);
        this.m_diceImageFactory = new DiceImageFactory(m_resourceLoader, data.getDiceSides());
        double unitScale = UIContext.getPreferencesMapOrSkin(dir).getDouble("UnitScale", this.m_mapData.getDefaultUnitScale());
        this.m_scale = UIContext.getPreferencesMapOrSkin(dir).getDouble("MapScale", 1.0);
        if (this.m_scale < 1.0) {
            this.setDrawTerritoryBordersAgainToMedium();
        }
        this.m_unitImageFactory.setResourceLoader(m_resourceLoader, unitScale, this.m_mapData.getDefaultUnitWidth(), this.m_mapData.getDefaultUnitHeight(), this.m_mapData.getDefaultUnitCounterOffsetWidth(), this.m_mapData.getDefaultUnitCounterOffsetHeight());
        this.m_flagIconImageFactory.setResourceLoader(m_resourceLoader);
        this.m_PUImageFactory.setResourceLoader(m_resourceLoader);
        this.m_tileImageFactory.setMapDir(m_resourceLoader);
        this.m_tileImageFactory.setScale(this.m_scale);
        this.m_mapImage.loadMaps(m_resourceLoader);
        m_mapDir = dir;
        this.m_drawTerritoryEffects = this.m_mapData.useTerritoryEffectMarkers();
        Runnable loadSounds = new Runnable(){

            public void run() {
                ClipPlayer.getInstance(AbstractUIContext.m_resourceLoader, data);
                SoundPath.preLoadSounds(SoundPath.SoundType.TRIPLEA);
            }
        };
        new Thread(loadSounds, "Triplea sound loader").start();
        this.m_cursor = Cursor.getDefaultCursor();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        URL cursorURL = m_resourceLoader.getResource("misc/cursor.gif");
        if (cursorURL != null) {
            try {
                BufferedImage image = ImageIO.read(cursorURL);
                if (image != null) {
                    Point hotSpot = new Point(this.m_mapData.getMapCursorHotspotX(), this.m_mapData.getMapCursorHotspotY());
                    this.m_cursor = toolkit.createCustomCursor(image, hotSpot, data.getGameName() + " Cursor");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        stopWatch.done();
    }

    public MapData getMapData() {
        return this.m_mapData;
    }

    public TileImageFactory getTileImageFactory() {
        return this.m_tileImageFactory;
    }

    public UnitImageFactory getUnitImageFactory() {
        return this.m_unitImageFactory;
    }

    public MapImage getMapImage() {
        return this.m_mapImage;
    }

    public FlagIconImageFactory getFlagImageFactory() {
        return this.m_flagIconImageFactory;
    }

    public PUImageFactory getPUImageFactory() {
        return this.m_PUImageFactory;
    }

    public DiceImageFactory getDiceImageFactory() {
        return this.m_diceImageFactory;
    }

    public void shutDown() {
        super.shutDown();
        this.m_mapData.close();
    }

    public boolean getShowUnits() {
        return this.m_drawUnits;
    }

    public void setShowUnits(boolean aBool) {
        this.m_drawUnits = aBool;
    }

    public IDrawable.OptionalExtraBorderLevel getDrawTerritoryBordersAgain() {
        return this.m_extraTerritoryBorderLevel;
    }

    public void setDrawTerritoryBordersAgain(IDrawable.OptionalExtraBorderLevel level) {
        this.m_extraTerritoryBorderLevel = level;
    }

    public void resetDrawTerritoryBordersAgain() {
        this.m_extraTerritoryBorderLevel = IDrawable.OptionalExtraBorderLevel.LOW;
    }

    public void setDrawTerritoryBordersAgainToMedium() {
        this.m_extraTerritoryBorderLevel = IDrawable.OptionalExtraBorderLevel.MEDIUM;
    }

    public void setShowTerritoryEffects(boolean aBool) {
        this.m_drawTerritoryEffects = aBool;
    }

    public boolean getShowTerritoryEffects() {
        return this.m_drawTerritoryEffects;
    }

    public boolean getShowMapOnly() {
        return this.m_drawMapOnly;
    }

    public void setShowMapOnly(boolean aBool) {
        this.m_drawMapOnly = aBool;
    }

    public void setUnitScaleFactor(double scaleFactor) {
        this.m_unitImageFactory.setScaleFactor(scaleFactor);
        Preferences prefs = UIContext.getPreferencesMapOrSkin(UIContext.getMapDir());
        prefs.putDouble("UnitScale", scaleFactor);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

