/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.sound.DefaultSoundChannel;
import games.strategy.triplea.attatchments.UserActionAttachment;
import games.strategy.triplea.delegate.remote.IUserActionDelegate;
import games.strategy.triplea.ui.ActionPanel;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.triplea.ui.UserActionComparator;
import games.strategy.triplea.ui.UserActionText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class UserActionPanel
extends ActionPanel {
    private static final long serialVersionUID = -2735582890226625860L;
    private final JLabel m_actionLabel = new JLabel();
    private JButton m_selectUserActionButton = null;
    private JButton m_doneButton = null;
    private UserActionAttachment m_choice = null;
    private final TripleAFrame m_parent;
    private boolean m_firstRun = true;
    protected List<UserActionAttachment> m_validUserActions = null;
    private final Action SelectUserActionAction = new AbstractAction("Take Action..."){
        private static final long serialVersionUID = 2389485901611958851L;

        public void actionPerformed(ActionEvent event) {
            Dimension screenResolution = Toolkit.getDefaultToolkit().getScreenSize();
            int availHeight = screenResolution.height - 96;
            int availWidth = screenResolution.width - 30;
            int availHeightOverview = (int)((float)availHeight * 2.0f / 3.0f);
            int availHeightChoice = (int)((float)availHeight / 3.0f);
            final JDialog userChoiceDialog = new JDialog(UserActionPanel.this.m_parent, "Actions and Operations", true);
            Insets insets = new Insets(1, 1, 1, 1);
            int row = 0;
            JPanel userChoicePanel = new JPanel();
            userChoicePanel.setLayout(new GridBagLayout());
            JPanel overview = new JPanel();
            overview.setLayout(new GridBagLayout());
            overview.add((Component)new JLabel("You have the following Actions and Operations at your disposal:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(25, 10, 25, 30), 0, 0));
            JScrollPane overviewScroll = new JScrollPane(overview);
            overviewScroll.setBorder(BorderFactory.createEmptyBorder());
            overviewScroll.setPreferredSize(new Dimension(overviewScroll.getPreferredSize().width > availWidth ? availWidth : overviewScroll.getPreferredSize().width + (overviewScroll.getPreferredSize().height > availHeightOverview ? 20 : 0), overviewScroll.getPreferredSize().height > availHeightOverview ? availHeightOverview : overviewScroll.getPreferredSize().height + (UserActionPanel.this.m_validUserActions.isEmpty() ? 26 : 0) + (overviewScroll.getPreferredSize().width > availWidth ? 20 : 0)));
            JScrollPane choiceScroll = new JScrollPane(UserActionPanel.this.getUserActionButtonPanel(userChoiceDialog));
            choiceScroll.setBorder(BorderFactory.createEtchedBorder());
            choiceScroll.setPreferredSize(new Dimension(choiceScroll.getPreferredSize().width > availWidth ? availWidth : choiceScroll.getPreferredSize().width + (choiceScroll.getPreferredSize().height > availHeightChoice ? 20 : 0), choiceScroll.getPreferredSize().height > availHeightChoice ? availHeightChoice : choiceScroll.getPreferredSize().height + (choiceScroll.getPreferredSize().width > availWidth ? 20 : 0)));
            JSplitPane splitPane = new JSplitPane(0, overviewScroll, choiceScroll);
            splitPane.setOneTouchExpandable(false);
            splitPane.setDividerSize(8);
            userChoicePanel.add((Component)splitPane, new GridBagConstraints(0, row++, 1, 1, 100.0, 100.0, 10, 1, insets, 0, 0));
            final JButton noActionButton = new JButton(new AbstractAction("No Actions"){
                private static final long serialVersionUID = -807175594221278068L;

                public void actionPerformed(ActionEvent arg0) {
                    userChoiceDialog.setVisible(false);
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    noActionButton.requestFocusInWindow();
                }
            });
            userChoicePanel.add((Component)noActionButton, new GridBagConstraints(0, row, 20, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
            userChoiceDialog.setMinimumSize(new Dimension(600, 300));
            userChoiceDialog.add(userChoicePanel);
            userChoiceDialog.pack();
            userChoiceDialog.setLocationRelativeTo(UserActionPanel.this.m_parent);
            userChoiceDialog.setVisible(true);
            userChoiceDialog.dispose();
        }
    };
    private final Action DontBotherAction = new AbstractAction("Done"){
        private static final long serialVersionUID = 2835948679299520899L;

        public void actionPerformed(ActionEvent event) {
            if (!UserActionPanel.this.m_firstRun || this.youSureDoNothing()) {
                UserActionPanel.this.m_choice = null;
                UserActionPanel.this.release();
            }
        }

        private boolean youSureDoNothing() {
            int rVal = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(UserActionPanel.this), "Are you sure you dont want to do anything?", "End Actions", 0);
            return rVal == 0;
        }
    };

    public UserActionPanel(GameData data, MapPanel map, TripleAFrame parent) {
        super(data, map);
        this.m_parent = parent;
    }

    public String toString() {
        return "Actions and Operations Panel";
    }

    public void display(final PlayerID id) {
        super.display(id);
        this.m_choice = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UserActionPanel.this.removeAll();
                UserActionPanel.this.m_actionLabel.setText(id.getName() + " Actions and Operations");
                UserActionPanel.this.add(UserActionPanel.this.m_actionLabel);
                UserActionPanel.this.m_selectUserActionButton = new JButton(UserActionPanel.this.SelectUserActionAction);
                UserActionPanel.this.m_selectUserActionButton.setEnabled(false);
                UserActionPanel.this.add(UserActionPanel.this.m_selectUserActionButton);
                UserActionPanel.this.m_doneButton = new JButton(UserActionPanel.this.DontBotherAction);
                UserActionPanel.this.m_doneButton.setEnabled(false);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        UserActionPanel.this.m_doneButton.requestFocusInWindow();
                    }
                });
                UserActionPanel.this.add(UserActionPanel.this.m_doneButton);
            }
        });
    }

    public UserActionAttachment waitForUserActionAction(boolean firstRun, IUserActionDelegate iUserActionsDelegate) {
        this.m_firstRun = firstRun;
        this.m_validUserActions = new ArrayList<UserActionAttachment>(iUserActionsDelegate.getValidActions());
        Collections.sort(this.m_validUserActions, new UserActionComparator(this.getCurrentPlayer(), this.getData()));
        if (this.m_validUserActions.isEmpty()) {
            return null;
        }
        if (this.m_firstRun) {
            DefaultSoundChannel.playSoundOnLocalMachine("phase_user_actions", this.getCurrentPlayer().getName());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UserActionPanel.this.m_selectUserActionButton.setEnabled(true);
                UserActionPanel.this.m_doneButton.setEnabled(true);
                UserActionPanel.this.SelectUserActionAction.actionPerformed(null);
            }
        });
        this.waitForRelease();
        return this.m_choice;
    }

    private JPanel getUserActionButtonPanel(final JDialog parent) {
        JPanel userActionButtonPanel = new JPanel();
        userActionButtonPanel.setLayout(new GridBagLayout());
        int row = 0;
        Insets insets = new Insets(1, 1, 1, 1);
        for (final UserActionAttachment uaa : this.m_validUserActions) {
            userActionButtonPanel.add((Component)this.getOtherPlayerFlags(uaa), new GridBagConstraints(0, row, 1, 1, 1.0, 1.0, 17, 2, insets, 0, 0));
            JButton button = new JButton(this.getActionButtonText(uaa));
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    UserActionPanel.this.m_selectUserActionButton.setEnabled(false);
                    UserActionPanel.this.m_doneButton.setEnabled(false);
                    UserActionPanel.this.m_validUserActions = null;
                    UserActionPanel.this.m_choice = uaa;
                    parent.setVisible(false);
                    UserActionPanel.this.release();
                }
            });
            userActionButtonPanel.add((Component)button, new GridBagConstraints(1, row, 1, 1, 1.0, 1.0, 17, 2, insets, 0, 0));
            userActionButtonPanel.add((Component)this.getActionDescriptionLabel(uaa), new GridBagConstraints(2, row, 1, 1, 5.0, 1.0, 17, 2, insets, 0, 0));
            ++row;
        }
        return userActionButtonPanel;
    }

    private JPanel getOtherPlayerFlags(UserActionAttachment uaa) {
        JPanel panel = new JPanel();
        for (PlayerID p : uaa.getOtherPlayers()) {
            panel.add(new JLabel(new ImageIcon(this.getMap().getUIContext().getFlagImageFactory().getFlag(p))));
        }
        return panel;
    }

    private String getActionButtonText(UserActionAttachment paa) {
        String costString = paa.getCostPU() == 0 ? "" : "[" + paa.getCostPU() + " PU] ";
        return costString + UserActionText.getInstance().getButtonText(paa.getText());
    }

    private JLabel getActionDescriptionLabel(UserActionAttachment paa) {
        String chanceString = paa.getChanceToHit() >= paa.getChanceDiceSides() ? "" : "[" + paa.getChanceToHit() + "/" + paa.getChanceDiceSides() + "] ";
        return new JLabel(chanceString + UserActionText.getInstance().getDescription(paa.getText()));
    }
}

