/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.history;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.history.Step;
import games.strategy.triplea.ui.IUIContext;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class HistoryTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -72258573320689596L;
    private final ImageIcon icon = new ImageIcon();
    private final IUIContext m_uiContext;

    public HistoryTreeCellRenderer(IUIContext uiContext) {
        this.m_uiContext = uiContext;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean haveFocus) {
        if (value instanceof Step) {
            PlayerID player = ((Step)value).getPlayerID();
            if (player != null) {
                if (this.m_uiContext != null) {
                    super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, haveFocus);
                    this.icon.setImage(this.m_uiContext.getFlagImageFactory().getSmallFlag(player));
                    this.setIcon(this.icon);
                } else {
                    String text = ((Step)value).toString() + " (" + player.getName() + ")";
                    super.getTreeCellRendererComponent(tree, text, sel, expanded, leaf, row, haveFocus);
                }
            } else {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, haveFocus);
            }
        } else {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, haveFocus);
        }
        return this;
    }
}

