/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.screen;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.ui.MapData;
import games.strategy.triplea.ui.screen.IDrawable;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;

class CapitolMarkerDrawable
implements IDrawable {
    private final String m_player;
    private final String m_location;
    private final IUIContext m_uiContext;

    public CapitolMarkerDrawable(PlayerID player, Territory location, IUIContext uiContext) {
        if (player == null) {
            throw new IllegalStateException("no player for capitol:" + location);
        }
        this.m_player = player.getName();
        this.m_location = location.getName();
        this.m_uiContext = uiContext;
    }

    public void draw(Rectangle bounds, GameData data, Graphics2D graphics, MapData mapData, AffineTransform unscaled, AffineTransform scaled) {
        Image img = this.m_uiContext.getFlagImageFactory().getLargeFlag(data.getPlayerList().getPlayerID(this.m_player));
        Point point = mapData.getCapitolMarkerLocation(data.getMap().getTerritory(this.m_location));
        graphics.drawImage(img, point.x - bounds.x, point.y - bounds.y, null);
    }

    public int getLevel() {
        return 8;
    }
}

