/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.screen;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.ui.MapData;
import games.strategy.triplea.ui.screen.IDrawable;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;

class KamikazeZoneDrawable
implements IDrawable {
    private final String m_location;
    private final IUIContext m_uiContext;

    public KamikazeZoneDrawable(PlayerID player, Territory location, IUIContext uiContext2) {
        this.m_location = location.getName();
        this.m_uiContext = uiContext2;
    }

    public void draw(Rectangle bounds, GameData data, Graphics2D graphics, MapData mapData, AffineTransform unscaled, AffineTransform scaled) {
        Territory terr = data.getMap().getTerritory(this.m_location);
        TerritoryAttachment ta = TerritoryAttachment.get(terr);
        PlayerID owner = null;
        if (Properties.getKamikazeSuicideAttacksDoneByCurrentTerritoryOwner(data)) {
            owner = terr.getOwner();
            if (owner == null) {
                owner = PlayerID.NULL_PLAYERID;
            }
        } else if (ta == null) {
            owner = PlayerID.NULL_PLAYERID;
        } else {
            owner = ta.getOriginalOwner();
            if (owner == null) {
                owner = PlayerID.NULL_PLAYERID;
            }
        }
        Image img = this.m_uiContext.getFlagImageFactory().getFadedFlag(owner);
        Point point = mapData.getKamikazeMarkerLocation(data.getMap().getTerritory(this.m_location));
        graphics.drawImage(img, point.x - bounds.x, point.y - bounds.y, null);
    }

    public int getLevel() {
        return 8;
    }
}

