/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.screen;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.ui.MapData;
import games.strategy.triplea.ui.screen.IDrawable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.List;

public class TerritoryOverLayDrawable
implements IDrawable {
    private final String m_territoryName;
    private final Color m_color;
    private final OP m_op;

    public TerritoryOverLayDrawable(Color color, String name, OP op) {
        this.m_color = color;
        this.m_territoryName = name;
        this.m_op = op;
    }

    public TerritoryOverLayDrawable(Color color, String name, int alpha, OP op) {
        this.m_color = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        this.m_territoryName = name;
        this.m_op = op;
    }

    public void draw(Rectangle bounds, GameData data, Graphics2D graphics, MapData mapData, AffineTransform unscaled, AffineTransform scaled) {
        Territory territory = data.getMap().getTerritory(this.m_territoryName);
        List<Polygon> polys = mapData.getPolygons(territory);
        graphics.setColor(this.m_color);
        for (Polygon polygon : polys) {
            if (!polygon.intersects(bounds) && !polygon.contains(bounds)) continue;
            polygon = new Polygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
            polygon.translate(-bounds.x, -bounds.y);
            if (this.m_op == OP.FILL) {
                graphics.fillPolygon(polygon);
                continue;
            }
            graphics.drawPolygon(polygon);
        }
    }

    public int getLevel() {
        return 16;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OP {
        FILL,
        DRAW;

    }
}

