/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.screen;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.image.MapImage;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.ui.MapData;
import games.strategy.triplea.ui.screen.IDrawable;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitsDrawer
implements IDrawable {
    private final int m_count;
    private final String m_unitType;
    private final String m_playerName;
    private final Point m_placementPoint;
    private final boolean m_damaged;
    private final boolean m_disabled;
    private final boolean m_overflow;
    private final String m_territoryName;
    private final IUIContext m_uiContext;

    public UnitsDrawer(int count, String unitType, String playerName, Point placementPoint, boolean damaged, boolean disabled, boolean overflow, String territoryName, IUIContext uiContext2) {
        this.m_count = count;
        this.m_unitType = unitType;
        this.m_playerName = playerName;
        this.m_placementPoint = placementPoint;
        this.m_damaged = damaged;
        this.m_disabled = disabled;
        this.m_overflow = overflow;
        this.m_territoryName = territoryName;
        this.m_uiContext = uiContext2;
    }

    public void prepare() {
    }

    public Point getPlacementPoint() {
        return this.m_placementPoint;
    }

    public String getPlayer() {
        return this.m_playerName;
    }

    @Override
    public void draw(Rectangle bounds, GameData data, Graphics2D graphics, MapData mapData, AffineTransform unscaled, AffineTransform scaled) {
        List<Unit> units;
        UnitType type;
        if (this.m_overflow) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(this.m_placementPoint.x - bounds.x - 2, this.m_placementPoint.y - bounds.y + this.m_uiContext.getUnitImageFactory().getUnitImageHeight(), this.m_uiContext.getUnitImageFactory().getUnitImageWidth() + 2, 3);
        }
        if ((type = data.getUnitTypeList().getUnitType(this.m_unitType)) == null) {
            throw new IllegalStateException("Type not found:" + this.m_unitType);
        }
        PlayerID owner = data.getPlayerList().getPlayerID(this.m_playerName);
        Image img = this.m_uiContext.getUnitImageFactory().getImage(type, owner, data, this.m_damaged, this.m_disabled);
        if (Matches.UnitTypeCanBeDamaged.match(type) && this.isDamageFromBombingDoneToUnitsInsteadOfTerritories(data)) {
            if (this.m_territoryName.length() != 0) {
                units = Match.getMatches(data.getMap().getTerritory(this.m_territoryName).getUnits().getUnits(), Matches.unitIsOfType(type));
                for (Unit current : units) {
                    if (!Matches.UnitIsDisabled().match(current)) continue;
                    img = this.m_uiContext.getUnitImageFactory().getImage(type, owner, data, this.m_damaged, true);
                }
            } else {
                img = this.m_uiContext.getUnitImageFactory().getImage(type, owner, data, this.m_damaged, this.m_disabled);
            }
        }
        if (!this.m_damaged && Matches.UnitTypeCanBeDamaged.match(type) && (this.isSBRAffectsUnitProduction(data) || this.isDamageFromBombingDoneToUnitsInsteadOfTerritories(data))) {
            if (this.m_territoryName.length() != 0) {
                if (this.isSBRAffectsUnitProduction(data)) {
                    TerritoryAttachment ta = TerritoryAttachment.get(data.getMap().getTerritory(this.m_territoryName));
                    int prod = ta.getProduction();
                    int unitProd = ta.getUnitProduction();
                    if (unitProd < prod) {
                        img = this.m_uiContext.getUnitImageFactory().getImage(type, owner, data, true, this.m_disabled);
                    }
                } else if (this.isDamageFromBombingDoneToUnitsInsteadOfTerritories(data)) {
                    units = Match.getMatches(data.getMap().getTerritory(this.m_territoryName).getUnits().getUnits(), Matches.unitIsOfType(type));
                    for (Unit current : units) {
                        if (!Matches.UnitHasSomeUnitDamage().match(current)) continue;
                        img = this.m_uiContext.getUnitImageFactory().getImage(type, owner, data, true, this.m_disabled);
                    }
                }
            } else {
                img = this.m_uiContext.getUnitImageFactory().getImage(type, owner, data, this.m_damaged, this.m_disabled);
            }
        } else {
            img = this.m_uiContext.getUnitImageFactory().getImage(type, owner, data, this.m_damaged, this.m_disabled);
        }
        graphics.drawImage(img, this.m_placementPoint.x - bounds.x, this.m_placementPoint.y - bounds.y, null);
        if (this.m_count != 1) {
            int stackSize = mapData.getDefaultUnitsStackSize();
            if (stackSize > 0) {
                Font font;
                for (int i = 1; i < this.m_count && i < stackSize; ++i) {
                    graphics.drawImage(img, this.m_placementPoint.x + 2 * i - bounds.x, this.m_placementPoint.y - 2 * i - bounds.y, null);
                }
                if (this.m_count > stackSize && (font = MapImage.getPropertyMapFont()).getSize() > 0) {
                    graphics.setColor(MapImage.getPropertyUnitCountColor());
                    graphics.setFont(font);
                    graphics.drawString(String.valueOf(this.m_count), this.m_placementPoint.x - bounds.x + 2 * stackSize + this.m_uiContext.getUnitImageFactory().getUnitImageWidth() * 6 / 10, this.m_placementPoint.y - 2 * stackSize - bounds.y + this.m_uiContext.getUnitImageFactory().getUnitImageHeight() * 1 / 3);
                }
            } else {
                Font font = MapImage.getPropertyMapFont();
                if (font.getSize() > 0) {
                    graphics.setColor(MapImage.getPropertyUnitCountColor());
                    graphics.setFont(font);
                    graphics.drawString(String.valueOf(this.m_count), this.m_placementPoint.x - bounds.x + this.m_uiContext.getUnitImageFactory().getUnitCounterOffsetWidth(), this.m_placementPoint.y - bounds.y + this.m_uiContext.getUnitImageFactory().getUnitCounterOffsetHeight());
                }
            }
        }
        if ((this.isSBRAffectsUnitProduction(data) || this.isDamageFromBombingDoneToUnitsInsteadOfTerritories(data)) && Matches.UnitTypeCanBeDamaged.match(type)) {
            this.displayFactoryDamage(bounds, data, graphics, type, img);
        }
    }

    private void displayFactoryDamage(Rectangle bounds, GameData data, Graphics2D graphics, UnitType type, Image img) {
        Font font = MapImage.getPropertyMapFont();
        if (this.m_territoryName.length() != 0 && font.getSize() > 0) {
            graphics.setColor(MapImage.getPropertyUnitFactoryDamageColor());
            graphics.setFont(font);
            if (this.isSBRAffectsUnitProduction(data)) {
                TerritoryAttachment ta = TerritoryAttachment.get(data.getMap().getTerritory(this.m_territoryName));
                int damageCount = ta.getProduction() - ta.getUnitProduction();
                if (damageCount > 0) {
                    graphics.drawString(String.valueOf(damageCount), this.m_placementPoint.x - bounds.x + this.m_uiContext.getUnitImageFactory().getUnitImageWidth() / 4, this.m_placementPoint.y - bounds.y + this.m_uiContext.getUnitImageFactory().getUnitImageHeight() / 4);
                }
            } else if (this.isDamageFromBombingDoneToUnitsInsteadOfTerritories(data)) {
                List<Unit> units = Match.getMatches(data.getMap().getTerritory(this.m_territoryName).getUnits().getUnits(), Matches.unitIsOfType(type));
                for (Unit current : units) {
                    TripleAUnit taUnit = (TripleAUnit)current;
                    if (taUnit.getUnitDamage() <= 0) continue;
                    graphics.drawString(String.valueOf(taUnit.getUnitDamage()), this.m_placementPoint.x - bounds.x + this.m_uiContext.getUnitImageFactory().getUnitImageWidth() / 4, this.m_placementPoint.y - bounds.y + this.m_uiContext.getUnitImageFactory().getUnitImageHeight() / 4);
                }
            }
        }
    }

    public Tuple<Territory, List<Unit>> getUnits(GameData data) {
        Territory t = data.getMap().getTerritory(this.m_territoryName);
        UnitType type = data.getUnitTypeList().getUnitType(this.m_unitType);
        CompositeMatchAnd<Unit> selectedUnits = new CompositeMatchAnd<Unit>(new Match[0]);
        selectedUnits.add(Matches.unitIsOfType(type));
        selectedUnits.add(Matches.unitIsOwnedBy(data.getPlayerList().getPlayerID(this.m_playerName)));
        if (this.m_damaged) {
            selectedUnits.add(Matches.UnitIsDamaged);
        } else {
            selectedUnits.add(Matches.UnitIsNotDamaged);
        }
        List<Unit> rVal = t.getUnits().getMatches(selectedUnits);
        return new Tuple<Territory, List<Unit>>(t, rVal);
    }

    @Override
    public int getLevel() {
        return 15;
    }

    public String toString() {
        return "UnitsDrawer for " + this.m_count + " " + MyFormatter.pluralize(this.m_unitType) + " in  " + this.m_territoryName;
    }

    private boolean isSBRAffectsUnitProduction(GameData data) {
        return Properties.getSBRAffectsUnitProduction(data);
    }

    private boolean isDamageFromBombingDoneToUnitsInsteadOfTerritories(GameData data) {
        return Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data);
    }
}

