/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.util;

import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class LoggingOutputStream
extends ByteArrayOutputStream {
    private final Object m_lock = new Object();
    private final Logger m_logger;
    private final Level m_level;

    public LoggingOutputStream(String name, Level level) {
        this.m_logger = Logger.getLogger(name);
        this.m_level = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) {
        Object object = this.m_lock;
        synchronized (object) {
            super.write(b);
            this.dump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) {
        Object object = this.m_lock;
        synchronized (object) {
            super.write(b, off, len);
            this.dump();
        }
    }

    private void dump() {
        String content = this.toString();
        if (content.indexOf("\n") != -1) {
            this.reset();
            this.m_logger.log(this.m_level, content);
        }
    }
}

