/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.ui;

import java.awt.Dimension;
import java.util.Observable;

public class ImageScrollModel
extends Observable {
    private int m_x;
    private int m_y;
    private int m_boxWidth = 5;
    private int m_boxHeight = 5;
    private int m_maxWidth;
    private int m_maxHeight;
    private boolean m_scrollX;
    private boolean m_scrollY;

    public void setMaxBounds(int maxWidth, int maxHeight) {
        this.m_maxWidth = maxWidth;
        this.m_maxHeight = maxHeight;
        this.enforceBounds();
        this.updateListeners();
    }

    public void setMaxBounds(Dimension mapDimensions) {
        this.setMaxBounds(mapDimensions.width, mapDimensions.height);
    }

    public void setBoxDimensions(int maxX, int maxy) {
        this.m_boxWidth = maxX;
        this.m_boxHeight = maxy;
        this.enforceBounds();
        this.updateListeners();
    }

    private void updateListeners() {
        super.setChanged();
        super.notifyObservers();
    }

    public void setScrollX(boolean aBool) {
        this.m_scrollX = aBool;
        this.enforceBounds();
        this.updateListeners();
    }

    public void setScrollY(boolean aBool) {
        this.m_scrollY = aBool;
        this.enforceBounds();
        this.updateListeners();
    }

    private void enforceBounds() {
        if (!this.m_scrollY) {
            if (this.m_y < 0) {
                this.m_y = 0;
            }
            if (this.m_y + this.m_boxHeight > this.m_maxHeight) {
                this.m_y = this.m_maxHeight - this.m_boxHeight;
            }
        } else {
            while (this.m_y > this.m_maxHeight) {
                this.m_y -= this.m_maxHeight;
            }
            while (this.m_y < -this.m_maxHeight) {
                this.m_y += this.m_maxHeight;
            }
        }
        if (this.m_boxHeight > this.m_maxHeight) {
            this.m_y = 0;
        }
        if (!this.m_scrollX) {
            if (this.m_x < 0) {
                this.m_x = 0;
            }
            if (this.m_x + this.m_boxWidth > this.m_maxWidth) {
                this.m_x = this.m_maxWidth - this.m_boxWidth;
            }
        } else {
            while (this.m_x > this.m_maxWidth) {
                this.m_x -= this.m_maxWidth;
            }
            while (this.m_x < -this.m_maxWidth) {
                this.m_x += this.m_maxWidth;
            }
        }
        if (this.m_boxWidth > this.m_maxWidth) {
            this.m_x = 0;
        }
    }

    public boolean getScrollX() {
        return this.m_scrollX;
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public int getBoxWidth() {
        return this.m_boxWidth;
    }

    public int getBoxHeight() {
        return this.m_boxHeight;
    }

    public int getMaxWidth() {
        return this.m_maxWidth;
    }

    public int getMaxHeight() {
        return this.m_maxHeight;
    }

    public void set(int x, int y) {
        this.m_x = x;
        this.m_y = y;
        this.enforceBounds();
        this.updateListeners();
    }
}

