/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.ui;

import games.strategy.engine.framework.GameRunner;
import games.strategy.ui.IntTextField;
import games.strategy.ui.IntTextFieldChangeListener;
import games.strategy.ui.ScrollableTextFieldListener;
import games.strategy.util.ListenerList;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ScrollableTextField
extends JPanel {
    private static final long serialVersionUID = 6940592988573672224L;
    private static boolean s_imagesLoaded;
    private static Icon s_up;
    private static Icon s_down;
    private static Icon s_max;
    private static Icon s_min;
    private final IntTextField m_text;
    private final JButton m_up;
    private final JButton m_down;
    private final JButton m_max;
    private final JButton m_min;
    private final ListenerList<ScrollableTextFieldListener> m_listeners = new ListenerList();
    private final Action m_incrementAction = new AbstractAction("inc"){
        private static final long serialVersionUID = 2125871167112459475L;

        public void actionPerformed(ActionEvent e) {
            if (ScrollableTextField.this.m_text.isEnabled()) {
                ScrollableTextField.this.m_text.setValue(ScrollableTextField.this.m_text.getValue() + 1);
                ScrollableTextField.this.setWidgetActivation();
            }
        }
    };
    private final Action m_decrementAction = new AbstractAction("dec"){
        private static final long serialVersionUID = 787758939168986726L;

        public void actionPerformed(ActionEvent e) {
            if (ScrollableTextField.this.m_text.isEnabled()) {
                ScrollableTextField.this.m_text.setValue(ScrollableTextField.this.m_text.getValue() - 1);
                ScrollableTextField.this.setWidgetActivation();
            }
        }
    };
    private final Action m_maxAction = new AbstractAction("max"){
        private static final long serialVersionUID = -3899827439573519512L;

        public void actionPerformed(ActionEvent e) {
            if (ScrollableTextField.this.m_text.isEnabled()) {
                ScrollableTextField.this.m_text.setValue(ScrollableTextField.this.m_text.getMax());
                ScrollableTextField.this.setWidgetActivation();
            }
        }
    };
    private final Action m_minAction = new AbstractAction("min"){
        private static final long serialVersionUID = 5785321239855254848L;

        public void actionPerformed(ActionEvent e) {
            if (ScrollableTextField.this.m_text.isEnabled()) {
                ScrollableTextField.this.m_text.setValue(ScrollableTextField.this.m_text.getMin());
                ScrollableTextField.this.setWidgetActivation();
            }
        }
    };
    private final IntTextFieldChangeListener m_textListener = new IntTextFieldChangeListener(){

        public void changedValue(IntTextField field) {
            ScrollableTextField.this.notifyListeners();
        }
    };

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(new JLabel("10 - 20"));
        frame.getContentPane().add(new ScrollableTextField(10, 20));
        frame.getContentPane().add(new JLabel("-10 - 10"));
        frame.getContentPane().add(new ScrollableTextField(-10, 10));
        ScrollableTextField field = new ScrollableTextField(0, 100);
        field.addChangeListener(new ScrollableTextFieldListener(){

            public void changedValue(ScrollableTextField aField) {
                System.out.println(aField.getValue());
            }
        });
        frame.getContentPane().add(new JLabel("0-100, listened to"));
        frame.getContentPane().add(field);
        frame.setSize(400, 140);
        frame.setVisible(true);
    }

    private static synchronized void loadImages(ScrollableTextField field) {
        if (s_imagesLoaded) {
            return;
        }
        s_up = new ImageIcon(ScrollableTextField.class.getResource("images/up.gif"));
        s_down = new ImageIcon(ScrollableTextField.class.getResource("images/down.gif"));
        s_max = new ImageIcon(ScrollableTextField.class.getResource("images/max.gif"));
        s_min = new ImageIcon(ScrollableTextField.class.getResource("images/min.gif"));
        s_imagesLoaded = true;
    }

    public ScrollableTextField(int minVal, int maxVal) {
        ScrollableTextField.loadImages(this);
        this.m_text = new IntTextField(minVal, maxVal);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.m_text);
        Insets inset = new Insets(0, 0, 0, 0);
        if (GameRunner.isMac()) {
            inset = new Insets(2, 0, 2, 0);
        }
        this.m_up = new JButton(s_up);
        this.m_up.addActionListener(this.m_incrementAction);
        this.m_up.setMargin(inset);
        this.m_down = new JButton(s_down);
        this.m_down.setMargin(inset);
        this.m_down.addActionListener(this.m_decrementAction);
        this.m_max = new JButton(s_max);
        this.m_max.setMargin(inset);
        this.m_max.addActionListener(this.m_maxAction);
        this.m_min = new JButton(s_min);
        this.m_min.setMargin(inset);
        this.m_min.addActionListener(this.m_minAction);
        JPanel upDown = new JPanel();
        upDown.setLayout(new BoxLayout(upDown, 1));
        upDown.add(this.m_up);
        upDown.add(this.m_down);
        JPanel maxMin = new JPanel();
        maxMin.setLayout(new BoxLayout(maxMin, 1));
        maxMin.add(this.m_max);
        maxMin.add(this.m_min);
        this.add(upDown);
        this.add(maxMin);
        this.m_text.addChangeListener(this.m_textListener);
        this.setWidgetActivation();
    }

    public void setMax(int max) {
        this.m_text.setMax(max);
        this.setWidgetActivation();
    }

    public void setTerr(String terr) {
        this.m_text.setTerr(terr);
    }

    public void setShowMaxAndMin(boolean aBool) {
        this.m_max.setVisible(aBool);
        this.m_min.setVisible(aBool);
    }

    public int getMax() {
        return this.m_text.getMax();
    }

    public String getTerr() {
        return this.m_text.getTerr();
    }

    public void setMin(int min) {
        this.m_text.setMin(min);
        this.setWidgetActivation();
    }

    private void setWidgetActivation() {
        if (this.m_text.isEnabled()) {
            int max;
            int value = this.m_text.getValue();
            boolean enableUp = value != (max = this.m_text.getMax());
            this.m_up.setEnabled(enableUp);
            this.m_max.setEnabled(enableUp);
            int min = this.m_text.getMin();
            boolean enableDown = value != min;
            this.m_down.setEnabled(enableDown);
            this.m_min.setEnabled(enableDown);
        } else {
            this.m_up.setEnabled(false);
            this.m_down.setEnabled(false);
            this.m_max.setEnabled(false);
            this.m_min.setEnabled(false);
        }
    }

    public int getValue() {
        return this.m_text.getValue();
    }

    public void setValue(int value) {
        this.m_text.setValue(value);
        this.setWidgetActivation();
    }

    public void addChangeListener(ScrollableTextFieldListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeChangeListener(ScrollableTextFieldListener listener) {
        this.m_listeners.remove(listener);
    }

    private void notifyListeners() {
        for (ScrollableTextFieldListener listener : this.m_listeners) {
            listener.changedValue(this);
        }
    }

    public void setEnabled(boolean enabled) {
        this.m_text.setEnabled(enabled);
        this.setWidgetActivation();
    }
}

