/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class CountDownLatchHandler {
    private final List<CountDownLatch> m_latchesToCloseOnShutdown = new ArrayList<CountDownLatch>();
    private boolean m_isShutDown;
    private boolean m_shutDownOnInterrupt = false;

    public CountDownLatchHandler(boolean releaseLatchOnInterrupt) {
        this.m_shutDownOnInterrupt = releaseLatchOnInterrupt;
    }

    public void interruptAll() {
        if (this.m_shutDownOnInterrupt) {
            this.shutDown();
        }
    }

    public void interruptLatch(CountDownLatch latch) {
        if (this.m_shutDownOnInterrupt) {
            this.releaseLatch(latch);
        }
    }

    public boolean isShutDown() {
        return this.m_isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        CountDownLatchHandler countDownLatchHandler = this;
        synchronized (countDownLatchHandler) {
            if (this.m_isShutDown) {
                return;
            }
            this.m_isShutDown = true;
        }
        for (CountDownLatch latch : this.m_latchesToCloseOnShutdown) {
            this.releaseLatch(latch);
        }
        this.m_latchesToCloseOnShutdown.clear();
    }

    private void releaseLatch(CountDownLatch latch) {
        if (latch == null) {
            return;
        }
        while (latch.getCount() > 0L) {
            latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownLatch(CountDownLatch latch) {
        CountDownLatchHandler countDownLatchHandler = this;
        synchronized (countDownLatchHandler) {
            if (this.m_isShutDown) {
                this.releaseLatch(latch);
                return;
            }
            this.m_latchesToCloseOnShutdown.add(latch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShutdownLatch(CountDownLatch latch) {
        CountDownLatchHandler countDownLatchHandler = this;
        synchronized (countDownLatchHandler) {
            this.releaseLatch(latch);
            this.m_latchesToCloseOnShutdown.remove(latch);
        }
    }
}

