/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.util;

import games.strategy.util.InverseMatch;
import games.strategy.util.Match;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerMap<T>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6856531659284300930L;
    private final HashMap<T, Integer> m_values;

    public IntegerMap() {
        this.m_values = new HashMap();
    }

    public IntegerMap(int size) {
        this.m_values = new HashMap(size);
    }

    public IntegerMap(int size, float loadFactor) {
        this.m_values = new HashMap(size, loadFactor);
    }

    public IntegerMap(Collection<T> objects, int value) {
        this(objects.size());
        this.addAll(objects, value);
    }

    public IntegerMap(IntegerMap<T> integerMap) {
        this.m_values = new HashMap(integerMap.size());
        for (T t : integerMap.keySet()) {
            this.m_values.put(t, integerMap.getInt(t));
        }
    }

    public int size() {
        return this.m_values.size();
    }

    public void put(T key, Integer value) {
        this.m_values.put(key, value);
    }

    public void put(T key, int value) {
        Integer obj = value;
        this.m_values.put(key, obj);
    }

    public void putAll(Collection<T> keys, int value) {
        Integer obj = value;
        Iterator<T> iter = keys.iterator();
        while (iter.hasNext()) {
            this.put(iter.next(), obj);
        }
    }

    public void addAll(Collection<T> keys, int value) {
        Iterator<T> iter = keys.iterator();
        while (iter.hasNext()) {
            this.add(iter.next(), value);
        }
    }

    public int getInt(T key) {
        Integer val = this.m_values.get(key);
        if (val == null) {
            return 0;
        }
        return val;
    }

    public void add(T key, Integer value) {
        this.add(key, (int)value);
    }

    public void add(T key, int value) {
        if (this.m_values.get(key) == null) {
            this.put(key, value);
        } else {
            Integer oldVal = this.m_values.get(key);
            int newVal = oldVal + value;
            this.put(key, newVal);
        }
    }

    public void multiplyAllValuesBy(double multiplyBy, int RoundType) {
        for (T t : this.keySet()) {
            double val = this.m_values.get(t).intValue();
            switch (RoundType) {
                case 1: {
                    val = Math.floor(val * multiplyBy);
                    break;
                }
                case 2: {
                    val = Math.round(val * multiplyBy);
                    break;
                }
                case 3: {
                    val = Math.ceil(val * multiplyBy);
                    break;
                }
                default: {
                    val *= multiplyBy;
                }
            }
            this.put(t, (int)val);
        }
    }

    public void clear() {
        this.m_values.clear();
    }

    public Set<T> keySet() {
        return this.m_values.keySet();
    }

    public Collection<Integer> values() {
        return this.m_values.values();
    }

    public boolean allValuesAreSame() {
        if (this.m_values.isEmpty()) {
            return false;
        }
        int first = this.m_values.values().iterator().next();
        for (int value : this.m_values.values()) {
            if (first == value) continue;
            return false;
        }
        return true;
    }

    public int highestValue() {
        if (this.m_values.isEmpty()) {
            return 0;
        }
        int max = Integer.MIN_VALUE;
        for (int value : this.m_values.values()) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public int lowestValue() {
        if (this.m_values.isEmpty()) {
            return 0;
        }
        int min = Integer.MAX_VALUE;
        for (int value : this.m_values.values()) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public T highestKey() {
        if (this.m_values.isEmpty()) {
            return null;
        }
        int max = Integer.MIN_VALUE;
        T rVal = null;
        for (Map.Entry<T, Integer> entry : this.m_values.entrySet()) {
            if (entry.getValue() <= max) continue;
            max = entry.getValue();
            rVal = entry.getKey();
        }
        return rVal;
    }

    public T lowestKey() {
        if (this.m_values.isEmpty()) {
            return null;
        }
        int min = Integer.MAX_VALUE;
        T rVal = null;
        for (Map.Entry<T, Integer> entry : this.m_values.entrySet()) {
            if (entry.getValue() >= min) continue;
            min = entry.getValue();
            rVal = entry.getKey();
        }
        return rVal;
    }

    public int totalValues() {
        int sum = 0;
        for (Integer value : this.m_values.values()) {
            sum += value.intValue();
        }
        return sum;
    }

    public void add(IntegerMap<T> map) {
        for (T key : map.keySet()) {
            this.add(key, map.getInt(key));
        }
    }

    public void subtract(IntegerMap<T> map) {
        for (T key : map.keySet()) {
            this.add(key, -map.getInt(key));
        }
    }

    public boolean greaterThanOrEqualTo(IntegerMap<T> map) {
        for (T key : map.keySet()) {
            if (this.getInt(key) >= map.getInt(key)) continue;
            return false;
        }
        return true;
    }

    public boolean isPositive() {
        for (T key : this.m_values.keySet()) {
            if (this.getInt(key) >= 0) continue;
            return false;
        }
        return true;
    }

    public IntegerMap<T> copy() {
        IntegerMap<T> copy = new IntegerMap<T>();
        copy.add(this);
        return copy;
    }

    public Object clone() {
        return this.copy();
    }

    public void addMultiple(IntegerMap<T> map, int multiple) {
        for (T key : map.keySet()) {
            this.add(key, map.getInt(key) * multiple);
        }
    }

    public boolean someKeysMatch(Match<T> matcher) {
        for (T obj : this.m_values.keySet()) {
            if (!matcher.match(obj)) continue;
            return true;
        }
        return false;
    }

    public boolean allKeysMatch(Match<T> matcher) {
        for (T obj : this.m_values.keySet()) {
            if (matcher.match(obj)) continue;
            return false;
        }
        return true;
    }

    public Collection<T> getKeyMatches(Match<T> matcher) {
        ArrayList<T> values = new ArrayList<T>();
        for (T obj : this.m_values.keySet()) {
            if (!matcher.match(obj)) continue;
            values.add(obj);
        }
        return values;
    }

    public int sumMatches(Match<T> matcher) {
        int sum = 0;
        for (T obj : this.m_values.keySet()) {
            if (!matcher.match(obj)) continue;
            sum += this.getInt(obj);
        }
        return sum;
    }

    public void removeNonMatchingKeys(Match<T> aMatch) {
        InverseMatch<T> match = new InverseMatch<T>(aMatch);
        this.removeMatchingKeys(match);
    }

    public void removeMatchingKeys(Match<T> aMatch) {
        Collection<T> badKeys = this.getKeyMatches(aMatch);
        this.removeKeys(badKeys);
    }

    public void removeKey(T key) {
        this.m_values.remove(key);
    }

    private void removeKeys(Collection<T> keys) {
        for (T key : keys) {
            this.removeKey(key);
        }
    }

    public boolean containsKey(T key) {
        return this.m_values.containsKey(key);
    }

    public boolean isEmpty() {
        return this.m_values.isEmpty();
    }

    public Set<Map.Entry<T, Integer>> entrySet() {
        return this.m_values.entrySet();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("IntegerMap:\n");
        Iterator<T> iter = this.m_values.keySet().iterator();
        if (!iter.hasNext()) {
            buf.append("empty\n");
        }
        while (iter.hasNext()) {
            T current = iter.next();
            buf.append(current).append(" -> ").append(this.getInt(current)).append("\n");
        }
        return buf.toString();
    }

    public int hashCode() {
        return this.m_values.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof IntegerMap)) {
            return false;
        }
        IntegerMap map = (IntegerMap)o;
        if (!map.keySet().equals(this.keySet())) {
            return false;
        }
        if (!map.m_values.equals(this.m_values)) {
            return false;
        }
        for (T key : map.keySet()) {
            if (this.getInt(key) == map.getInt(key)) continue;
            return false;
        }
        return true;
    }
}

