/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.util;

import java.awt.Point;
import java.awt.Polygon;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointFileReaderWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Point> readOneToOne(InputStream stream) throws IOException {
        if (stream == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Point> mapping = new HashMap<String, Point>();
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new InputStreamReader(stream));
            String current = ((LineNumberReader)reader).readLine();
            while (current != null) {
                if (current.trim().length() != 0) {
                    PointFileReaderWriter.readSingle(current, mapping);
                }
                current = ((LineNumberReader)reader).readLine();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Point> readOneToOneCenters(InputStream stream) throws IOException {
        HashMap<String, Point> mapping = new HashMap<String, Point>();
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new InputStreamReader(stream));
            String current = ((LineNumberReader)reader).readLine();
            while (current != null) {
                if (current.trim().length() != 0) {
                    PointFileReaderWriter.readSingle(current, mapping);
                }
                current = ((LineNumberReader)reader).readLine();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return mapping;
    }

    private static void readSingle(String aLine, Map<String, Point> mapping) throws IOException {
        StringTokenizer tokens = new StringTokenizer(aLine, "", false);
        String name = tokens.nextToken("(").trim();
        if (mapping.containsKey(name)) {
            throw new IOException("name found twice:" + name);
        }
        int x = Integer.parseInt(tokens.nextToken("(, "));
        int y = Integer.parseInt(tokens.nextToken(",) "));
        Point p = new Point(x, y);
        mapping.put(name, p);
    }

    public static void writeOneToOne(OutputStream sink, Map<String, Point> mapping) throws Exception {
        StringBuilder out = new StringBuilder();
        Iterator<String> keyIter = mapping.keySet().iterator();
        while (keyIter.hasNext()) {
            String name = keyIter.next();
            out.append(name).append(" ");
            Point point = mapping.get(name);
            out.append(" (").append(point.x).append(",").append(point.y).append(")");
            if (!keyIter.hasNext()) continue;
            out.append("\r\n");
        }
        PointFileReaderWriter.write(out, sink);
    }

    public static void writeOneToManyPolygons(OutputStream sink, Map<String, List<Polygon>> mapping) throws Exception {
        StringBuilder out = new StringBuilder();
        Iterator<String> keyIter = mapping.keySet().iterator();
        while (keyIter.hasNext()) {
            String name = keyIter.next();
            out.append(name).append(" ");
            List<Polygon> points = mapping.get(name);
            Iterator<Polygon> polygonIter = points.iterator();
            while (polygonIter.hasNext()) {
                out.append(" < ");
                Polygon polygon = polygonIter.next();
                for (int i = 0; i < polygon.npoints; ++i) {
                    out.append(" (").append(polygon.xpoints[i]).append(",").append(polygon.ypoints[i]).append(")");
                }
                out.append(" > ");
            }
            if (!keyIter.hasNext()) continue;
            out.append("\r\n");
        }
        PointFileReaderWriter.write(out, sink);
    }

    private static void write(StringBuilder buf, OutputStream sink) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(sink);
        out.write(buf.toString());
        out.flush();
    }

    public static void writeOneToMany(OutputStream sink, Map mapping) throws Exception {
        StringBuilder out = new StringBuilder();
        if (mapping == null) {
            mapping = new HashMap();
        }
        Iterator keyIter = mapping.keySet().iterator();
        while (keyIter.hasNext()) {
            String name = (String)keyIter.next();
            out.append(name).append(" ");
            Collection points = (Collection)mapping.get(name);
            Iterator pointIter = points.iterator();
            while (pointIter.hasNext()) {
                Point point = (Point)pointIter.next();
                out.append(" (").append(point.x).append(",").append(point.y).append(")");
                if (!pointIter.hasNext()) continue;
                out.append(" ");
            }
            if (!keyIter.hasNext()) continue;
            out.append("\r\n");
        }
        PointFileReaderWriter.write(out, sink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<Point>> readOneToMany(InputStream stream) throws IOException {
        HashMap<String, List<Point>> mapping = new HashMap<String, List<Point>>();
        BufferedReader reader = null;
        try {
            if (stream == null) {
                Map<String, List<Point>> map = Collections.emptyMap();
                return map;
            }
            reader = new LineNumberReader(new InputStreamReader(stream));
            String current = ((LineNumberReader)reader).readLine();
            while (current != null) {
                if (current.trim().length() != 0) {
                    PointFileReaderWriter.readMultiple(current, mapping);
                }
                current = ((LineNumberReader)reader).readLine();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(0);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<Polygon>> readOneToManyPolygons(InputStream stream) throws IOException {
        HashMap<String, List<Polygon>> mapping = new HashMap<String, List<Polygon>>();
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new InputStreamReader(stream));
            String current = ((LineNumberReader)reader).readLine();
            while (current != null) {
                if (current.trim().length() != 0) {
                    PointFileReaderWriter.readMultiplePolygons(current, mapping);
                }
                current = ((LineNumberReader)reader).readLine();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(0);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return mapping;
    }

    private static void readMultiplePolygons(String line, HashMap<String, List<Polygon>> mapping) throws IOException {
        try {
            String name = line.substring(0, line.indexOf(60)).trim();
            ArrayList<Polygon> polygons = new ArrayList<Polygon>(64);
            ArrayList<Point> points = new ArrayList<Point>();
            int length = line.length();
            for (int index = name.length(); index < length; ++index) {
                char current = line.charAt(index);
                if (current != '<') continue;
                int x = 0;
                int y = 0;
                int base = 0;
                do {
                    current = line.charAt(++index);
                    switch (current) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            base *= 10;
                            base += current - 48;
                            break;
                        }
                        case ',': {
                            x = base;
                            base = 0;
                            break;
                        }
                        case ')': {
                            y = base;
                            base = 0;
                            points.add(new Point(x, y));
                            break;
                        }
                    }
                } while (current != '>');
                PointFileReaderWriter.createPolygonFromPoints(polygons, points);
                points.clear();
            }
            if (mapping.containsKey(name)) {
                throw new IOException("name found twice:" + name);
            }
            mapping.put(name, polygons);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalStateException("Invalid line:" + line, e);
        }
    }

    private static void createPolygonFromPoints(Collection<Polygon> polygons, ArrayList<Point> points) {
        int[] xPoints = new int[points.size()];
        int[] yPoints = new int[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            Point p = points.get(i);
            xPoints[i] = p.x;
            yPoints[i] = p.y;
        }
        polygons.add(new Polygon(xPoints, yPoints, xPoints.length));
    }

    private static void readMultiple(String line, HashMap<String, List<Point>> mapping) throws IOException {
        StringTokenizer tokens = new StringTokenizer(line, "");
        String name = tokens.nextToken("(").trim();
        if (mapping.containsKey(name)) {
            throw new IOException("name found twice:" + name);
        }
        ArrayList<Point> points = new ArrayList<Point>();
        while (tokens.hasMoreTokens()) {
            String xString = tokens.nextToken(",(), ");
            if (!tokens.hasMoreTokens()) continue;
            String yString = tokens.nextToken(",() ");
            int x = Integer.parseInt(xString);
            int y = Integer.parseInt(yString);
            points.add(new Point(x, y));
        }
        mapping.put(name, points);
    }
}

