/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.util;

import games.strategy.util.TALogFormatter;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;

public class RotatingLogFileHandlerForHeadlessGameServer
extends FileHandler {
    private static final String LOG_FILE_SIZE_PROP = "triplea.log.file.size";
    private static final String DEFAULT_SIZE = "2000000";
    private static final String logFile;

    public RotatingLogFileHandlerForHeadlessGameServer() throws IOException, SecurityException {
        super(logFile, Integer.parseInt(System.getProperty(LOG_FILE_SIZE_PROP, DEFAULT_SIZE)), 10, true);
        TALogFormatter logFormatter = new TALogFormatter();
        logFormatter.setShowDates(true);
        this.setFormatter(logFormatter);
    }

    static {
        File rootDir = new File(System.getProperty("triplea.server.root.dir", "."));
        if (!rootDir.exists()) {
            throw new IllegalStateException("no dir called:" + rootDir.getAbsolutePath());
        }
        File logDir = new File(rootDir, "logs");
        if (!logDir.exists()) {
            logDir.mkdir();
        }
        String serverInstanceName = System.getProperty("triplea.name", System.getProperty("triplea.lobby.game.hostedBy", ""));
        logFile = new File(logDir, "headless-game-server-" + serverInstanceName + "-log%g.txt").getAbsolutePath();
        System.out.print("logging to :" + logFile);
    }
}

