/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.devices;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import net.sbbi.upnp.XMLUtil;
import net.sbbi.upnp.devices.Device;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RootDevice
extends Device {
    public final int specVersionMajor;
    public final int specVersionMinor;
    private long validityTime;
    private long creationTime;
    public final URL deviceDefLoc;
    private String deviceDefLocData;
    public final String vendorFirmware;
    public final String discoveryUSN;
    public final String discoveryUDN;

    public static void main(String[] args) throws MalformedURLException {
        RootDevice root = RootDevice.build(new URL("http://homepages.inf.ed.ac.uk/rmcnally/upnp.xml"), "10", "vendor", "usn", "udn");
        System.out.println(root);
    }

    public static RootDevice build(URL deviceDef, String maxAge, String vendorFirmware, String discoveryUSN, String discoveryUDN) {
        Document xml = XMLUtil.getXML(deviceDef);
        URL baseURL = null;
        try {
            String base = XMLUtil.xpath.evaluate("/root/URLBase", xml);
            try {
                if (base != null && base.trim().length() > 0) {
                    baseURL = new URL(base);
                }
            }
            catch (MalformedURLException malformedEx) {
                malformedEx.printStackTrace();
            }
            if (baseURL == null) {
                int lastSlash;
                String URL2 = deviceDef.getProtocol() + "://" + deviceDef.getHost() + ":" + deviceDef.getPort();
                String path = deviceDef.getPath();
                if (path != null && (lastSlash = path.lastIndexOf(47)) != -1) {
                    URL2 = URL2 + path.substring(0, lastSlash);
                }
                try {
                    baseURL = new URL(URL2);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            return new RootDevice(xml, baseURL, maxAge, deviceDef, vendorFirmware, discoveryUSN, discoveryUDN);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public RootDevice(Document doc, URL urlBase, String maxAge, URL deviceDefinition, String vendorFirmware, String discoveryUSN, String discoveryUDN) throws IllegalStateException, XPathExpressionException {
        super((Node)XMLUtil.xpath.evaluate("root/device", doc, XPathConstants.NODE), null, urlBase);
        this.deviceDefLoc = deviceDefinition;
        this.validityTime = Integer.parseInt(maxAge) * 1000;
        this.creationTime = System.currentTimeMillis();
        this.vendorFirmware = vendorFirmware;
        this.discoveryUSN = discoveryUSN;
        this.discoveryUDN = discoveryUDN;
        int svmaj = 0;
        int svmin = 0;
        try {
            svmaj = Integer.parseInt(XMLUtil.xpath.evaluate("root/specVersion/major", doc));
            svmin = Integer.parseInt(XMLUtil.xpath.evaluate("root/specVersion/minor", doc));
            if (svmaj != 1 || svmin != 0) {
                throw new IllegalStateException("Unsupported device version (" + svmaj + "." + svmin + ")");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.specVersionMajor = svmaj;
        this.specVersionMinor = svmin;
    }

    public long getValidityTime() {
        long elapsed = System.currentTimeMillis() - this.creationTime;
        return this.validityTime - elapsed;
    }

    public void resetValidityTime(String newMaxAge) {
        this.validityTime = Integer.parseInt(newMaxAge) * 1000;
        this.creationTime = System.currentTimeMillis();
    }

    public String getDeviceDefinitionXML() {
        if (this.deviceDefLocData == null) {
            try {
                InputStream in = this.deviceDefLoc.openConnection().getInputStream();
                int readen = 0;
                byte[] buff = new byte[512];
                StringBuilder strBuff = new StringBuilder();
                while ((readen = in.read(buff)) != -1) {
                    strBuff.append(new String(buff, 0, readen));
                }
                in.close();
                this.deviceDefLocData = strBuff.toString();
            }
            catch (IOException ioEx) {
                return null;
            }
        }
        return this.deviceDefLocData;
    }
}

