/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.messages;

import net.sbbi.upnp.messages.ActionMessage;
import net.sbbi.upnp.messages.StateVariableMessage;
import net.sbbi.upnp.services.Action;
import net.sbbi.upnp.services.Service;
import net.sbbi.upnp.services.StateVariable;

public class UPNPMessageFactory {
    public final Service service;

    public UPNPMessageFactory(Service service) {
        this.service = service;
    }

    public ActionMessage getMessage(String serviceActionName) {
        Action serviceAction = this.service.getUPNPServiceAction(serviceActionName);
        if (serviceAction != null) {
            return new ActionMessage(this.service, serviceAction);
        }
        return null;
    }

    public StateVariableMessage getStateVariableMessage(String serviceStateVariable) {
        StateVariable stateVar = this.service.getUPNPServiceStateVariable(serviceStateVariable);
        if (stateVar != null) {
            return new StateVariableMessage(this.service, stateVar);
        }
        return null;
    }
}

