/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.services;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class ISO8601Date {
    private static boolean check(StringTokenizer st, String token) throws NumberFormatException {
        try {
            if (st.nextToken().equals(token)) {
                return true;
            }
            throw new NumberFormatException("Missing [" + token + "]");
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Calendar getCalendar(String isodate) throws NumberFormatException {
        boolean isADate;
        boolean isATime = isodate.indexOf(58) != -1;
        boolean bl = isADate = isodate.indexOf(45) != -1 || isodate.length() == 4 && !isATime;
        if (isATime && !isADate && !isodate.toUpperCase().startsWith("T")) {
            isodate = "T" + isodate;
        }
        StringTokenizer st = new StringTokenizer(isodate, "-T:.+Z", true);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        if (isADate) {
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            int year = Integer.parseInt(st.nextToken());
            calendar.set(1, year);
            if (!ISO8601Date.check(st, "-") || !st.hasMoreTokens()) {
                return calendar;
            }
            int month = Integer.parseInt(st.nextToken()) - 1;
            calendar.set(2, month);
            if (!ISO8601Date.check(st, "-") || !st.hasMoreTokens()) return calendar;
            int day = Integer.parseInt(st.nextToken());
            calendar.set(5, day);
        }
        if (!ISO8601Date.check(st, "T") || !st.hasMoreTokens()) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar;
        }
        int hour = Integer.parseInt(st.nextToken());
        calendar.set(11, hour);
        if (!ISO8601Date.check(st, ":") || !st.hasMoreTokens()) {
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar;
        }
        int minutes = Integer.parseInt(st.nextToken());
        calendar.set(12, minutes);
        if (!st.hasMoreTokens()) {
            return calendar;
        }
        String tok = st.nextToken();
        if (tok.equals(":")) {
            if (!st.hasMoreTokens()) throw new NumberFormatException("No secondes specified");
            int secondes = Integer.parseInt(st.nextToken());
            calendar.set(13, secondes);
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            tok = st.nextToken();
            if (tok.equals(".")) {
                String nt = st.nextToken();
                while (nt.length() < 3) {
                    nt = nt + "0";
                }
                nt = nt.substring(0, 3);
                int millisec = Integer.parseInt(nt);
                calendar.set(14, millisec);
                if (!st.hasMoreTokens()) {
                    return calendar;
                }
                tok = st.nextToken();
            } else {
                calendar.set(14, 0);
            }
        } else {
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        if (tok.equals("Z")) return calendar;
        if (!tok.equals("+") && !tok.equals("-")) {
            throw new NumberFormatException("only Z, + or - allowed");
        }
        boolean plus = tok.equals("+");
        if (!st.hasMoreTokens()) {
            throw new NumberFormatException("Missing hour field");
        }
        int tzhour = Integer.parseInt(st.nextToken());
        int tzmin = 0;
        if (!ISO8601Date.check(st, ":") || !st.hasMoreTokens()) {
            throw new NumberFormatException("Missing minute field");
        }
        tzmin = Integer.parseInt(st.nextToken());
        if (plus) {
            ((Calendar)calendar).add(10, -tzhour);
            ((Calendar)calendar).add(12, -tzmin);
            return calendar;
        } else {
            ((Calendar)calendar).add(10, tzhour);
            ((Calendar)calendar).add(12, tzmin);
        }
        return calendar;
    }

    public static Date parse(String isodate) throws NumberFormatException {
        Calendar calendar = ISO8601Date.getCalendar(isodate);
        return calendar.getTime();
    }

    private static String twoDigit(int i) {
        if (i >= 0 && i < 10) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }

    public static String getIsoDate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        StringBuilder buffer = new StringBuilder();
        buffer.append(calendar.get(1));
        buffer.append("-");
        buffer.append(ISO8601Date.twoDigit(calendar.get(2) + 1));
        buffer.append("-");
        buffer.append(ISO8601Date.twoDigit(calendar.get(5)));
        return buffer.toString();
    }

    public static String getIsoDateTime(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        StringBuilder buffer = new StringBuilder();
        buffer.append(calendar.get(1));
        buffer.append("-");
        buffer.append(ISO8601Date.twoDigit(calendar.get(2) + 1));
        buffer.append("-");
        buffer.append(ISO8601Date.twoDigit(calendar.get(5)));
        buffer.append("T");
        buffer.append(ISO8601Date.twoDigit(calendar.get(11)));
        buffer.append(":");
        buffer.append(ISO8601Date.twoDigit(calendar.get(12)));
        buffer.append(":");
        buffer.append(ISO8601Date.twoDigit(calendar.get(13)));
        buffer.append(".");
        buffer.append(ISO8601Date.twoDigit(calendar.get(14) / 10));
        return buffer.toString();
    }

    public static String getIsoDateTimeZone(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        StringBuilder buffer = new StringBuilder();
        buffer.append(calendar.get(1));
        buffer.append("-");
        buffer.append(ISO8601Date.twoDigit(calendar.get(2) + 1));
        buffer.append("-");
        buffer.append(ISO8601Date.twoDigit(calendar.get(5)));
        buffer.append("T");
        buffer.append(ISO8601Date.twoDigit(calendar.get(11)));
        buffer.append(":");
        buffer.append(ISO8601Date.twoDigit(calendar.get(12)));
        buffer.append(":");
        buffer.append(ISO8601Date.twoDigit(calendar.get(13)));
        buffer.append(".");
        buffer.append(ISO8601Date.twoDigit(calendar.get(14) / 10));
        buffer.append("Z");
        return buffer.toString();
    }

    public static String getIsoTime(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        StringBuilder buffer = new StringBuilder();
        buffer.append(ISO8601Date.twoDigit(calendar.get(11)));
        buffer.append(":");
        buffer.append(ISO8601Date.twoDigit(calendar.get(12)));
        buffer.append(":");
        buffer.append(ISO8601Date.twoDigit(calendar.get(13)));
        buffer.append(".");
        buffer.append(ISO8601Date.twoDigit(calendar.get(14) / 10));
        return buffer.toString();
    }

    public static String getIsoTimeZone(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        StringBuilder buffer = new StringBuilder();
        buffer.append(ISO8601Date.twoDigit(calendar.get(11)));
        buffer.append(":");
        buffer.append(ISO8601Date.twoDigit(calendar.get(12)));
        buffer.append(":");
        buffer.append(ISO8601Date.twoDigit(calendar.get(13)));
        buffer.append(".");
        buffer.append(ISO8601Date.twoDigit(calendar.get(14) / 10));
        buffer.append("Z");
        return buffer.toString();
    }
}

