/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.painter.utils.BackgroundPaintingUtils;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceTextUtilities;

public class SubstanceLabelUI
extends BasicLabelUI {
    protected Set lafWidgets;
    protected PropertyChangeListener substancePropertyChangeListener;

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__jvnet__substance__SubstanceLabelUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    protected void __org__jvnet__substance__SubstanceLabelUI__installComponents(JLabel jLabel) {
        super.installComponents(jLabel);
    }

    @Override
    protected void installComponents(JLabel jLabel) {
        this.__org__jvnet__substance__SubstanceLabelUI__installComponents(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void __org__jvnet__substance__SubstanceLabelUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceLabelUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceLabelUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceLabelUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void installListeners(JLabel jLabel) {
        this.__org__jvnet__substance__SubstanceLabelUI__installListeners(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    protected void __org__jvnet__substance__SubstanceLabelUI__installDefaults(JLabel jLabel) {
        super.installDefaults(jLabel);
    }

    @Override
    protected void installDefaults(JLabel jLabel) {
        this.__org__jvnet__substance__SubstanceLabelUI__installDefaults(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    protected void __org__jvnet__substance__SubstanceLabelUI__uninstallComponents(JLabel jLabel) {
        super.uninstallComponents(jLabel);
    }

    @Override
    protected void uninstallComponents(JLabel jLabel) {
        this.__org__jvnet__substance__SubstanceLabelUI__uninstallComponents(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    @Override
    protected void uninstallListeners(JLabel jLabel) {
        this.__org__jvnet__substance__SubstanceLabelUI__uninstallListeners(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void __org__jvnet__substance__SubstanceLabelUI__uninstallDefaults(JLabel jLabel) {
        super.uninstallDefaults(jLabel);
    }

    @Override
    protected void uninstallDefaults(JLabel jLabel) {
        this.__org__jvnet__substance__SubstanceLabelUI__uninstallDefaults(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceLabelUI();
    }

    protected void __org__jvnet__substance__SubstanceLabelUI__installListeners(final JLabel c) {
        super.installListeners(c);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("opaque".equals(evt.getPropertyName()) && !Boolean.TRUE.equals(c.getClientProperty("substancelaf.lockopacity"))) {
                    c.putClientProperty("substancelaf.buttonopacityoriginal", evt.getNewValue());
                }
            }
        };
        c.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void __org__jvnet__substance__SubstanceLabelUI__uninstallListeners(JLabel c) {
        c.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon = null;
        if (label.isEnabled()) {
            icon = label.getIcon();
            if (icon != null && SubstanceCoreUtilities.useThemedDefaultIcon()) {
                icon = SubstanceCoreUtilities.getThemedIcon(label, icon);
            }
        } else {
            icon = label.getDisabledIcon();
        }
        if (icon == null && text == null) {
            return;
        }
        Rectangle paintIconR = new Rectangle();
        Rectangle paintTextR = new Rectangle();
        Rectangle paintViewR = new Rectangle();
        Insets paintViewInsets = new Insets(0, 0, 0, 0);
        Insets insets = label.getInsets(paintViewInsets);
        paintViewR.x = insets.left;
        paintViewR.y = insets.top;
        paintViewR.width = c.getWidth() - (insets.left + insets.right);
        paintViewR.height = c.getHeight() - (insets.top + insets.bottom);
        paintIconR.height = 0;
        paintIconR.width = 0;
        paintIconR.y = 0;
        paintIconR.x = 0;
        paintTextR.height = 0;
        paintTextR.width = 0;
        paintTextR.y = 0;
        paintTextR.x = 0;
        String clippedText = SwingUtilities.layoutCompoundLabel(label, g.getFontMetrics(), text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), paintViewR, paintIconR, paintTextR, label.getIconTextGap());
        Graphics2D g2d = (Graphics2D)g.create();
        BackgroundPaintingUtils.updateIfOpaque(g2d, c);
        if (icon != null) {
            icon.paintIcon(c, g2d, paintIconR.x, paintIconR.y);
        }
        ComponentState labelState = label.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
        float labelAlpha = SubstanceColorSchemeUtilities.getAlpha(label, labelState);
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g2d, paintTextR);
            } else {
                SubstanceTextUtilities.paintText(g, (JComponent)label, paintTextR, clippedText, label.getDisplayedMnemonicIndex(), labelState, labelState, labelAlpha);
            }
        }
        g2d.dispose();
    }

    public void __org__jvnet__substance__SubstanceLabelUI__update(Graphics g, JComponent c) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        this.paint(g, c);
    }
}

