/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import games.strategy.util.AlphanumComparator;
import games.strategy.util.PointFileReaderWriter;
import java.awt.Dimension;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import util.image.FileOpen;
import util.image.FileSave;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFinder {
    private static File s_mapFolderLocation = null;
    private static final String TRIPLEA_MAP_FOLDER = "triplea.map.folder";
    private static final String LINE_THICKNESS = "triplea.map.lineThickness";
    private static final String SCALE_PIXELS = "triplea.map.scalePixels";
    private static final String MIN_OVERLAP = "triplea.map.minOverlap";
    private static boolean dimensionsSet = false;
    private static StringBuffer territoryDefinitions = null;
    public static int scalePixels = 8;
    public static double minOverlap = 32.0;

    public static void main(String[] args) {
        ConnectionFinder.handleCommandLineArgs(args);
        JOptionPane.showMessageDialog(null, new JLabel("<html>This is the ConnectionFinder. <br>It will create a file containing the connections between territories, and optionally the territory definitions as well. <br>Copy and paste everything from this file into your game xml file (the 'map' section). <br>The connections file can and Should Be Deleted when finished, because it is Not Needed and not read by the engine. </html>"));
        System.out.println("Select polygons.txt");
        File polyFile = null;
        if (s_mapFolderLocation != null && s_mapFolderLocation.exists()) {
            polyFile = new File(s_mapFolderLocation, "polygons.txt");
        }
        if (polyFile == null || !polyFile.exists() || JOptionPane.showConfirmDialog(null, "A polygons.txt file was found in the map's folder, do you want to use it?", "File Suggestion", 1) != 0) {
            polyFile = new FileOpen("Select The polygons.txt file", s_mapFolderLocation, ".txt").getFile();
        }
        if (polyFile == null || !polyFile.exists()) {
            System.out.println("No polygons.txt Selected. Shutting down.");
            System.exit(0);
        }
        if (s_mapFolderLocation == null && polyFile != null) {
            s_mapFolderLocation = polyFile.getParentFile();
        }
        HashMap territoryAreas = new HashMap();
        Map<String, List<Polygon>> mapOfPolygons = null;
        try {
            FileInputStream in = new FileInputStream(polyFile);
            mapOfPolygons = PointFileReaderWriter.readOneToManyPolygons(in);
            for (String territoryName : mapOfPolygons.keySet()) {
                List<Polygon> listOfPolygons = mapOfPolygons.get(territoryName);
                ArrayList<Area> listOfAreas = new ArrayList<Area>();
                for (Polygon p : listOfPolygons) {
                    listOfAreas.add(new Area(p));
                }
                territoryAreas.put(territoryName, listOfAreas);
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (!dimensionsSet) {
            String lineWidth = JOptionPane.showInputDialog(null, (Object)"Enter the width of territory border lines on your map? \r\n(eg: 1, or 2, etc.)");
            try {
                int lineThickness = Integer.parseInt(lineWidth);
                scalePixels = lineThickness * 4;
                minOverlap = scalePixels * 4;
                dimensionsSet = true;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (JOptionPane.showConfirmDialog(null, "Scale set to " + scalePixels + " pixels larger, and minimum overlap set to " + minOverlap + " pixels. \r\n" + "Do you wish to continue with this? \r\nSelect Yes to continue, Select No to override and change the size.", "Scale and Overlap Size", 0) == 1) {
            String scale = JOptionPane.showInputDialog(null, (Object)"Enter the number of pixels larger each territory should become? \r\n(Normally 4x bigger than the border line width. eg: 4, or 8, etc)");
            try {
                scalePixels = Integer.parseInt(scale);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            String overlap = JOptionPane.showInputDialog(null, (Object)"Enter the minimum number of overlapping pixels for a connection? \r\n(Normally 16x bigger than the border line width. eg: 16, or 32, etc.)");
            try {
                minOverlap = Integer.parseInt(overlap);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        HashMap<String, Collection<String>> connections = new HashMap<String, Collection<String>>();
        System.out.println("Now Scanning for Connections");
        ArrayList<String> allTerritories = new ArrayList<String>(mapOfPolygons.keySet());
        Collections.sort(allTerritories, new AlphanumComparator());
        ArrayList allAreas = new ArrayList(territoryAreas.keySet());
        Collections.sort(allAreas, new AlphanumComparator());
        for (String territory : allTerritories) {
            LinkedHashSet<String> thisTerritoryConnections = new LinkedHashSet<String>();
            List<Polygon> currentPolygons = mapOfPolygons.get(territory);
            for (Polygon currentPolygon : currentPolygons) {
                Shape scaledShape = ConnectionFinder.scale(currentPolygon, scalePixels);
                for (String otherTerritory : allAreas) {
                    if (otherTerritory.equals(territory) || thisTerritoryConnections.contains(otherTerritory) || connections.get(otherTerritory) != null && ((Collection)connections.get(otherTerritory)).contains(territory)) continue;
                    for (Area otherArea : (List)territoryAreas.get(otherTerritory)) {
                        Area testArea = new Area(scaledShape);
                        testArea.intersect(otherArea);
                        if (!testArea.isEmpty() && ConnectionFinder.sizeOfArea(testArea) > minOverlap) {
                            thisTerritoryConnections.add(otherTerritory);
                            continue;
                        }
                        if (testArea.isEmpty()) continue;
                    }
                }
                connections.put(territory, thisTerritoryConnections);
            }
        }
        if (JOptionPane.showConfirmDialog(null, "Do you also want to create the Territory Definitions?", "Territory Definitions", 1) == 0) {
            String waterString = JOptionPane.showInputDialog(null, "Enter a string or regex that determines if the territory is Water? \r\n(eg: Sea Zone)", "Sea Zone");
            territoryDefinitions = ConnectionFinder.doTerritoryDefinitions(allTerritories, waterString);
        }
        try {
            String fileName = new FileSave("Where To Save connections.txt ? (cancel to print to console)", "connections.txt", s_mapFolderLocation).getPathString();
            StringBuffer connectionsString = ConnectionFinder.convertToXML(connections);
            if (fileName == null) {
                System.out.println();
                if (territoryDefinitions != null) {
                    System.out.println(territoryDefinitions.toString());
                }
                System.out.println(connectionsString.toString());
            } else {
                FileOutputStream out = new FileOutputStream(fileName);
                if (territoryDefinitions != null) {
                    out.write(String.valueOf(territoryDefinitions).getBytes());
                }
                out.write(String.valueOf(connectionsString).getBytes());
                out.flush();
                out.close();
                System.out.println("Data written to :" + new File(fileName).getCanonicalPath());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static StringBuffer doTerritoryDefinitions(List<String> allTerritoryNames, String waterString) {
        Collections.sort(allTerritoryNames, new AlphanumComparator());
        StringBuffer output = new StringBuffer();
        output.append("<!-- Territory Definitions -->\r\n");
        Pattern waterPattern = Pattern.compile(waterString);
        for (String t : allTerritoryNames) {
            Matcher matcher = waterPattern.matcher(t);
            if (matcher.find()) {
                output.append("<territory name=\"" + t + "\" water=\"true\"/>\r\n");
                continue;
            }
            output.append("<territory name=\"" + t + "\"/>\r\n");
        }
        output.append("\r\n");
        return output;
    }

    private static StringBuffer convertToXML(Map<String, Collection<String>> connections) {
        StringBuffer output = new StringBuffer();
        output.append("<!-- Territory Connections -->\r\n");
        ArrayList<String> allTerritories = new ArrayList<String>(connections.keySet());
        Collections.sort(allTerritories, new AlphanumComparator());
        for (String t1 : allTerritories) {
            for (String t2 : connections.get(t1)) {
                output.append("<connection t1=\"" + t1 + "\" t2=\"" + t2 + "\"/>\r\n");
            }
        }
        return output;
    }

    private static double sizeOfArea(Area area) {
        Dimension d = area.getBounds().getSize();
        return d.getHeight() * d.getWidth();
    }

    private static double calcSignedPolygonArea(Point2D[] pointArray) {
        int N = pointArray.length;
        double area = 0.0;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            area += pointArray[i].getX() * pointArray[j].getY();
            area -= pointArray[i].getY() * pointArray[j].getX();
        }
        return area /= 2.0;
    }

    private static Point2D calcCenterOfMass(Point2D[] pointArray) {
        int N = pointArray.length;
        double cx = 0.0;
        double cy = 0.0;
        double area = ConnectionFinder.calcSignedPolygonArea(pointArray);
        Point2D.Double centroid = new Point2D.Double();
        double factor = 0.0;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            factor = pointArray[i].getX() * pointArray[j].getY() - pointArray[j].getX() * pointArray[i].getY();
            cx += (pointArray[i].getX() + pointArray[j].getX()) * factor;
            cy += (pointArray[i].getY() + pointArray[j].getY()) * factor;
        }
        factor = 1.0 / (area *= 6.0);
        ((Point2D)centroid).setLocation(cx *= factor, cy *= factor);
        return centroid;
    }

    private static Point2D getCentroid(Shape currentShape) {
        ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>(32);
        PathIterator pathIterator = currentShape.getPathIterator(null);
        int lastMoveToIndex = -1;
        while (!pathIterator.isDone()) {
            double[] coordinates = new double[6];
            switch (pathIterator.currentSegment(coordinates)) {
                case 0: {
                    pointList.add(new Point2D.Double(coordinates[0], coordinates[1]));
                    ++lastMoveToIndex;
                    break;
                }
                case 1: {
                    pointList.add(new Point2D.Double(coordinates[0], coordinates[1]));
                    break;
                }
                case 2: {
                    pointList.add(new Point2D.Double(coordinates[0], coordinates[1]));
                    pointList.add(new Point2D.Double(coordinates[2], coordinates[3]));
                    break;
                }
                case 3: {
                    pointList.add(new Point2D.Double(coordinates[0], coordinates[1]));
                    pointList.add(new Point2D.Double(coordinates[2], coordinates[3]));
                    pointList.add(new Point2D.Double(coordinates[4], coordinates[5]));
                    break;
                }
                case 4: {
                    if (lastMoveToIndex < 0) break;
                    pointList.add((Point2D.Double)pointList.get(lastMoveToIndex));
                }
            }
            pathIterator.next();
        }
        Point2D[] pointArray = new Point2D[pointList.size()];
        pointList.toArray(pointArray);
        return ConnectionFinder.calcCenterOfMass(pointArray);
    }

    private static Shape scale(Shape currentShape, int pixels) {
        Dimension d = currentShape.getBounds().getSize();
        double scalefactorX = 1.0 + 1.0 / (double)d.width * (double)pixels;
        double scalefactorY = 1.0 + 1.0 / (double)d.height * (double)pixels;
        return ConnectionFinder.scale(currentShape, scalefactorX, scalefactorY);
    }

    private static Shape scale(Shape currentPolygon, double xScaleFactor, double yScaleFactor) {
        Point2D centroid = ConnectionFinder.getCentroid(currentPolygon);
        AffineTransform transform = AffineTransform.getTranslateInstance((1.0 - xScaleFactor) * centroid.getX(), (1.0 - yScaleFactor) * centroid.getY());
        transform.scale(xScaleFactor, yScaleFactor);
        Shape shape = transform.createTransformedShape(currentPolygon);
        return shape;
    }

    private static void handleCommandLineArgs(String[] args) {
        String value;
        for (String arg : args) {
            String value2 = ConnectionFinder.getValue(arg);
            if (arg.startsWith(TRIPLEA_MAP_FOLDER)) {
                File mapFolder = new File(value2);
                if (mapFolder.exists()) {
                    s_mapFolderLocation = mapFolder;
                } else {
                    System.out.println("Could not find directory: " + value2);
                }
            }
            if (arg.startsWith(LINE_THICKNESS)) {
                int lineThickness = new Integer(value2);
                scalePixels = lineThickness * 4;
                minOverlap = scalePixels * 4;
                dimensionsSet = true;
            }
            if (arg.startsWith(MIN_OVERLAP)) {
                minOverlap = new Integer(value2).intValue();
            }
            if (!arg.startsWith(SCALE_PIXELS)) continue;
            scalePixels = new Integer(value2);
        }
        if ((s_mapFolderLocation == null || s_mapFolderLocation.length() < 1L) && (value = System.getProperty(TRIPLEA_MAP_FOLDER)) != null && value.length() > 0) {
            File mapFolder = new File(value = value.replaceAll("\\(", " "));
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + value);
            }
        }
        if ((value = System.getProperty(LINE_THICKNESS)) != null && value.length() > 0) {
            int lineThickness = new Integer(value);
            scalePixels = lineThickness * 4;
            minOverlap = scalePixels * 4;
            dimensionsSet = true;
        }
        if ((value = System.getProperty(MIN_OVERLAP)) != null && value.length() > 0) {
            minOverlap = new Integer(value).intValue();
        }
        if ((value = System.getProperty(SCALE_PIXELS)) != null && value.length() > 0) {
            scalePixels = new Integer(value);
        }
    }

    private static String getValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            return "";
        }
        return arg.substring(index + 1);
    }
}

