/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import games.strategy.engine.framework.GameRunner2;
import games.strategy.triplea.ResourceLoader;
import games.strategy.ui.Util;
import games.strategy.util.PointFileReaderWriter;
import games.strategy.util.Triple;
import games.strategy.util.Tuple;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import util.image.FileOpen;
import util.image.FileSave;
import util.image.ImagePointType;

public class DecorationPlacer
extends JFrame {
    private static final long serialVersionUID = 6385408390173085656L;
    private Image m_image;
    private Map<String, List<Point>> m_currentPoints = new HashMap<String, List<Point>>();
    private Map<String, Point> m_centers = new HashMap<String, Point>();
    private Map<String, List<Polygon>> m_polygons = new HashMap<String, List<Polygon>>();
    private final JLabel m_location = new JLabel();
    private static File s_mapFolderLocation = null;
    private static final String TRIPLEA_MAP_FOLDER = "triplea.map.folder";
    private static File s_currentImageFolderLocation = null;
    private static File s_currentImagePointsTextFile = null;
    private Point m_currentMousePoint = new Point(0, 0);
    private Triple<String, Image, Point> m_currentSelectedImage = null;
    private Map<String, Tuple<Image, List<Point>>> m_currentImagePoints = new HashMap<String, Tuple<Image, List<Point>>>();
    private static boolean s_highlightAll = false;
    private static boolean s_createNewImageOnRightClick = false;
    private static Image s_staticImageForPlacing = null;
    private static boolean s_showFromTopLeft = true;
    private static ImagePointType s_imagePointType = ImagePointType.decorations;
    private static boolean s_cheapMutex = false;
    private static boolean s_showPointNames = false;

    public static void main(String[] args) {
        DecorationPlacer.handleCommandLineArgs(args);
        System.out.println("Select the map");
        FileOpen mapSelection = new FileOpen("Select The Map", s_mapFolderLocation, ".gif", ".png");
        String mapName = mapSelection.getPathString();
        if (s_mapFolderLocation == null && mapSelection.getFile() != null) {
            s_mapFolderLocation = mapSelection.getFile().getParentFile();
        }
        if (mapName != null) {
            System.out.println("Map : " + mapName);
            DecorationPlacer picker = new DecorationPlacer(mapName);
            picker.setSize(800, 600);
            picker.setLocationRelativeTo(null);
            picker.setVisible(true);
            JOptionPane.showMessageDialog(picker, new JLabel("<html>This is the DecorationPlacer, it will create a text file for you containing the points to place images at. <br><br>In order to begin this, you must already have the map file, as well as the centers.txt and polygons.txt finished. <br>To start, load you map image. Then you will be asked which kind of Image Point File you are creating. <br><br>There are basically 2 different kinds of image point files, and with each of those are 2 different sub-types. <br>The 1st type is a folder full of many different images, that after being placed on the map will never be changed. <br>Examples of this are the decorations.txt file [misc folder] and the name_place.txt file [territoryNames folder]. <br>In these files the 'point' string directly corresponds to exact name of an image file in the folder, with the only <br>exception being whether the point string needs the .png extension or not (decorations do, name_place does not). <br><br>The 2nd type is single image, or small set of images, where the chosen image is determined by something in the xml file. <br>Examples of this are the pu_place.txt file [PUs folder] and the capitols.txt file [flags folder]. <br>In these files, the 'point' string is the exact name of a territory, while the image file has a different name, <br>and is chosen by the engine based on the game data.  For things like the pu_place you may want the decoration placer <br>to generate placements for all territories, while others like capitols are more rare and you may want to individually <br>select which territories you need a placement point for.<br><br>After selecting the point file type you want to make, the program will choose the default selections for you, <br>but it will still confirm with you by asking you the questions. Just hit 'enter' a lot if you do not know the answers. <br><br>Any images that this program can not find the point for, will start in the upper left corner of the map, <br>and you may click on them to move them to their appropriate place.<br><br>Do not forget to save the points when finished. To save and continue with another set of images, choose the <br>option to 'Save Current And Keep On Map And Load New'.  To reset all currently image points, use 'Load Image Points'.</html>"));
            picker.loadImagesAndPoints();
        } else {
            System.out.println("No Image Map Selected. Shutting down.");
            System.exit(0);
        }
    }

    public DecorationPlacer(String mapName) {
        super("Decoration Placer");
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        s_highlightAll = false;
        File fileCenters = null;
        if (s_mapFolderLocation != null && s_mapFolderLocation.exists()) {
            fileCenters = new File(s_mapFolderLocation, "centers.txt");
        }
        if (fileCenters == null || !fileCenters.exists()) {
            fileCenters = new File(new File(mapName).getParent() + File.separator + "centers.txt");
        }
        if (fileCenters.exists() && JOptionPane.showConfirmDialog(new JPanel(), "A centers.txt file was found in the map's folder, do you want to use the file to supply the territories centers?", "File Suggestion", 1) == 0) {
            try {
                System.out.println("Centers : " + fileCenters.getPath());
                this.m_centers = PointFileReaderWriter.readOneToOne(new FileInputStream(fileCenters.getPath()));
            }
            catch (IOException ex1) {
                System.out.println("Something wrong with Centers file");
                ex1.printStackTrace();
                System.exit(0);
            }
        } else {
            try {
                System.out.println("Select the Centers file");
                String centerPath = new FileOpen("Select A Center File", s_mapFolderLocation, ".txt").getPathString();
                if (centerPath != null) {
                    System.out.println("Centers : " + centerPath);
                    this.m_centers = PointFileReaderWriter.readOneToOne(new FileInputStream(centerPath));
                } else {
                    System.out.println("You must specify a centers file.");
                    System.out.println("Shutting down.");
                    System.exit(0);
                }
            }
            catch (IOException ex1) {
                System.out.println("Something wrong with Centers file");
                ex1.printStackTrace();
                System.exit(0);
            }
        }
        File filePoly = null;
        if (s_mapFolderLocation != null && s_mapFolderLocation.exists()) {
            filePoly = new File(s_mapFolderLocation, "polygons.txt");
        }
        if (filePoly == null || !filePoly.exists()) {
            filePoly = new File(new File(mapName).getParent() + File.separator + "polygons.txt");
        }
        if (filePoly.exists() && JOptionPane.showConfirmDialog(new JPanel(), "A polygons.txt file was found in the map's folder, do you want to use the file to supply the territories polygons?", "File Suggestion", 1) == 0) {
            try {
                System.out.println("Polygons : " + filePoly.getPath());
                this.m_polygons = PointFileReaderWriter.readOneToManyPolygons(new FileInputStream(filePoly.getPath()));
            }
            catch (IOException ex1) {
                System.out.println("Something wrong with your Polygons file");
                ex1.printStackTrace();
                System.exit(0);
            }
        } else {
            try {
                System.out.println("Select the Polygons file");
                String polyPath = new FileOpen("Select A Polygon File", s_mapFolderLocation, ".txt").getPathString();
                if (polyPath != null) {
                    System.out.println("Polygons : " + polyPath);
                    this.m_polygons = PointFileReaderWriter.readOneToManyPolygons(new FileInputStream(polyPath));
                } else {
                    System.out.println("You must specify a Polgyon file.");
                    System.out.println("Shutting down.");
                    System.exit(0);
                }
            }
            catch (IOException ex1) {
                System.out.println("Something wrong with your Polygons file");
                ex1.printStackTrace();
                System.exit(0);
            }
        }
        this.m_image = this.createImage(mapName);
        JPanel imagePanel = this.createMainPanel();
        imagePanel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                DecorationPlacer.this.m_location.setText((DecorationPlacer.this.m_currentSelectedImage == null ? "" : (String)DecorationPlacer.this.m_currentSelectedImage.getFirst()) + "    x:" + e.getX() + " y:" + e.getY());
                DecorationPlacer.this.m_currentMousePoint = new Point(e.getPoint());
                DecorationPlacer.this.repaint();
            }
        });
        this.m_location.setFont(new Font("Ariel", 1, 16));
        imagePanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DecorationPlacer.this.mouseEvent(e.getPoint(), e.isControlDown() || e.isShiftDown(), SwingUtilities.isRightMouseButton(e));
            }
        });
        imagePanel.setMinimumSize(new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this)));
        imagePanel.setPreferredSize(new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this)));
        imagePanel.setMaximumSize(new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this)));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(imagePanel), "Center");
        this.getContentPane().add((Component)this.m_location, "South");
        AbstractAction openAction = new AbstractAction("Load Image Locations"){
            private static final long serialVersionUID = 2712234474452114083L;

            public void actionPerformed(ActionEvent event) {
                DecorationPlacer.this.loadImagesAndPoints();
            }
        };
        openAction.putValue("ShortDescription", "Load An Existing Image Points File");
        AbstractAction saveAction = new AbstractAction("Save Image Locations"){
            private static final long serialVersionUID = -4519036149978621171L;

            public void actionPerformed(ActionEvent event) {
                DecorationPlacer.this.saveImagePoints();
            }
        };
        saveAction.putValue("ShortDescription", "Save The Image Points To File");
        AbstractAction keepGoingAction = new AbstractAction("Save Current and Keep Them On Map and Load New File"){
            private static final long serialVersionUID = -7217861953409073730L;

            public void actionPerformed(ActionEvent event) {
                DecorationPlacer.this.saveImagePoints();
                DecorationPlacer.this.saveCurrentToMapPicture();
                DecorationPlacer.this.loadImagesAndPoints();
            }
        };
        keepGoingAction.putValue("ShortDescription", "Save current points to a file, then draw the images onto the map, then load a new points file.");
        AbstractAction exitAction = new AbstractAction("Exit"){
            private static final long serialVersionUID = -5631457890653630218L;

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        };
        exitAction.putValue("ShortDescription", "Exit The Program");
        JMenuItem openItem = new JMenuItem(openAction);
        openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        JMenuItem saveItem = new JMenuItem(saveAction);
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        JMenuItem exitItem = new JMenuItem(exitAction);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        fileMenu.add(openItem);
        fileMenu.add(saveItem);
        fileMenu.add(keepGoingAction);
        fileMenu.addSeparator();
        fileMenu.add(exitItem);
        final JCheckBoxMenuItem highlightAllModeItem = new JCheckBoxMenuItem("Highlight All", false);
        highlightAllModeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                s_highlightAll = highlightAllModeItem.getState();
                DecorationPlacer.this.repaint();
            }
        });
        final JCheckBoxMenuItem showNamesModeItem = new JCheckBoxMenuItem("Show Point Names", false);
        showNamesModeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                s_showPointNames = showNamesModeItem.getState();
                DecorationPlacer.this.repaint();
            }
        });
        AbstractAction clearAction = new AbstractAction("Clear all current points."){
            private static final long serialVersionUID = -7217861953409073730L;

            public void actionPerformed(ActionEvent event) {
                DecorationPlacer.this.m_currentImagePoints.clear();
            }
        };
        clearAction.putValue("ShortDescription", "Delete all points.");
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        editMenu.add(highlightAllModeItem);
        editMenu.add(showNamesModeItem);
        editMenu.addSeparator();
        editMenu.add(clearAction);
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
    }

    private Image createImage(String mapName) {
        Image image = Toolkit.getDefaultToolkit().createImage(mapName);
        try {
            Util.ensureImageLoaded(image);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return image;
    }

    private JPanel createMainPanel() {
        JPanel imagePanel = new JPanel(){
            private static final long serialVersionUID = -7130828419508975924L;

            public void paint(Graphics g) {
                DecorationPlacer.this.paintToG(g);
            }
        };
        return imagePanel;
    }

    private void paintToG(Graphics g) {
        if (s_cheapMutex) {
            return;
        }
        g.drawImage(this.m_image, 0, 0, this);
        g.setColor(Color.red);
        for (Map.Entry<String, Tuple<Image, List<Point>>> entry : this.m_currentImagePoints.entrySet()) {
            for (Point p : entry.getValue().getSecond()) {
                g.drawImage(entry.getValue().getFirst(), p.x, p.y - (s_showFromTopLeft ? 0 : entry.getValue().getFirst().getHeight(null)), null);
                if (this.m_currentSelectedImage != null && this.m_currentSelectedImage.getThird().equals(p)) {
                    g.setColor(Color.green);
                    g.drawRect(p.x, p.y - (s_showFromTopLeft ? 0 : entry.getValue().getFirst().getHeight(null)), entry.getValue().getFirst().getWidth(null), entry.getValue().getFirst().getHeight(null));
                    g.setColor(Color.red);
                } else if (s_highlightAll) {
                    g.drawRect(p.x, p.y - (s_showFromTopLeft ? 0 : entry.getValue().getFirst().getHeight(null)), entry.getValue().getFirst().getWidth(null), entry.getValue().getFirst().getHeight(null));
                }
                if (!s_showPointNames) continue;
                g.drawString(entry.getKey(), p.x, p.y - (s_showFromTopLeft ? 0 : entry.getValue().getFirst().getHeight(null)));
            }
        }
        if (this.m_currentSelectedImage != null) {
            g.setColor(Color.green);
            g.drawImage((Image)this.m_currentSelectedImage.getSecond(), this.m_currentMousePoint.x, this.m_currentMousePoint.y - (s_showFromTopLeft ? 0 : ((Image)this.m_currentSelectedImage.getSecond()).getHeight(null)), null);
            if (s_highlightAll) {
                g.drawRect(this.m_currentMousePoint.x, this.m_currentMousePoint.y - (s_showFromTopLeft ? 0 : ((Image)this.m_currentSelectedImage.getSecond()).getHeight(null)), ((Image)this.m_currentSelectedImage.getSecond()).getWidth(null), ((Image)this.m_currentSelectedImage.getSecond()).getHeight(null));
            }
            if (s_showPointNames) {
                g.drawString((String)this.m_currentSelectedImage.getFirst(), this.m_currentMousePoint.x, this.m_currentMousePoint.y - (s_showFromTopLeft ? 0 : ((Image)this.m_currentSelectedImage.getSecond()).getHeight(null)));
            }
        }
    }

    private void saveCurrentToMapPicture() {
        BufferedImage bufferedImage = new BufferedImage(this.m_image.getWidth(null), this.m_image.getHeight(null), 2);
        Graphics g = bufferedImage.getGraphics();
        boolean saveHighlight = s_highlightAll;
        boolean saveNames = s_showPointNames;
        s_highlightAll = false;
        s_showPointNames = false;
        this.paintToG(g);
        g.dispose();
        s_highlightAll = saveHighlight;
        s_showPointNames = saveNames;
        this.m_image = bufferedImage;
    }

    private void saveImagePoints() {
        this.m_currentPoints = new HashMap<String, List<Point>>();
        for (Map.Entry<String, Tuple<Image, List<Point>>> entry : this.m_currentImagePoints.entrySet()) {
            LinkedHashSet pointSet = new LinkedHashSet();
            pointSet.addAll(entry.getValue().getSecond());
            entry.getValue().getSecond().clear();
            entry.getValue().getSecond().addAll(pointSet);
            this.m_currentPoints.put(entry.getKey(), entry.getValue().getSecond());
        }
        try {
            String fileName = new FileSave("Where To Save Image Points Text File?", 0, s_currentImagePointsTextFile, s_mapFolderLocation).getPathString();
            if (fileName == null) {
                return;
            }
            FileOutputStream out = new FileOutputStream(fileName);
            PointFileReaderWriter.writeOneToMany(out, this.m_currentPoints);
            out.flush();
            out.close();
            System.out.println("Data written to :" + new File(fileName).getCanonicalPath());
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (HeadlessException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("");
    }

    private void selectImagePointType() {
        System.out.println("Select Which type of image points file are we making?");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel("Which type of image points file are we making?"));
        ButtonGroup group = new ButtonGroup();
        for (ImagePointType type : ImagePointType.getTypes()) {
            JRadioButton button = new JRadioButton(type.toString() + "      :      " + type.getDescription());
            button.setActionCommand(type.toString());
            if (s_imagePointType == type) {
                button.setSelected(true);
            } else {
                button.setSelected(false);
            }
            group.add(button);
            panel.add(button);
        }
        JOptionPane.showMessageDialog(this, panel, "Which type of image points file are we making?", 3);
        ButtonModel selected = group.getSelection();
        String choice = selected.getActionCommand();
        for (ImagePointType type : ImagePointType.getTypes()) {
            if (!type.toString().equals(choice)) continue;
            s_imagePointType = type;
            System.out.println("Selected Type: " + choice);
            break;
        }
    }

    private void topLeftOrBottomLeft() {
        Object[] showFromTopLeft = new Object[]{"Point is Top Left", "Point is Bottom Left"};
        System.out.println("Select Show images from top left or bottom left point?");
        s_showFromTopLeft = JOptionPane.showOptionDialog(this, "Are the images shown from the top left, or from the bottom left point? \r\nAll images are shown from the top left, except for 'name_place.txt', 'pu_place.txt', and 'comments.txt'. \r\nFor these 3 files, whether they are top left or bottom left is determined by the \r\n'map.properties' property: 'map.drawNamesFromTopLeft', which defaults to false if not specified [meaning bottom left]. \r\nDo NOT change this from whatever the default has choosen, unless you know exactly what you are doing!", "Show images from top left or bottom left point?", 0, 3, null, showFromTopLeft, showFromTopLeft[s_imagePointType.isCanUseBottomLeftPoint() ? 1 : 0]) != 1;
    }

    private void loadImagesAndPoints() {
        s_cheapMutex = true;
        this.m_currentImagePoints = new HashMap<String, Tuple<Image, List<Point>>>();
        this.m_currentSelectedImage = null;
        this.selectImagePointType();
        Object[] miscOrNamesOptions = new Object[]{"Folder Full of Images", "Text File Full of Points"};
        Object[] pointsAreNamesOptions = new Object[]{"Points end in .png", "Points do NOT end in .png"};
        Object[] fillAllOptions = new Object[]{"Fill In All Territories", "Let Me Select Territories"};
        System.out.println("Select Folder full of images OR Text file full of points?");
        if (JOptionPane.showOptionDialog(this, "Are you doing a folder full of different images (decorations.txt [misc] and name_place.txt [territoryNames]) \r\nOr are we doing a per territory static or dynamic image based on game data (pu_place.txt [PUs], capitols.txt [flags], etc, basically all others) ?", "Folder full of images OR Text file full of points?", 0, 3, null, miscOrNamesOptions, miscOrNamesOptions[s_imagePointType.isUseFolder() ? 0 : 1]) != 1) {
            this.loadImageFolder();
            if (s_currentImageFolderLocation == null) {
                return;
            }
            this.loadImagePointTextFile();
            this.topLeftOrBottomLeft();
            System.out.println("Points end in .png OR they do not?");
            this.fillCurrentImagePointsBasedOnImageFolder(JOptionPane.showOptionDialog(this, "Does the text file use the exact image file name, including the .png extension (decorations.txt) \r\nOr does the text file not use the full file name with no extension, just a territory name (name_place.txt) ?", "Points end in .png OR they do not?", 0, 3, null, pointsAreNamesOptions, pointsAreNamesOptions[s_imagePointType.isEndInPNG() ? 0 : 1]) == 1);
            s_createNewImageOnRightClick = false;
            s_staticImageForPlacing = null;
        } else {
            this.loadImagePointTextFile();
            this.topLeftOrBottomLeft();
            System.out.println("Select Fill in all territories OR let you select them?");
            this.fillCurrentImagePointsBasedOnTextFile(JOptionPane.showOptionDialog(this, "Are you going to do a point for every single territory (pu_place.txt) \r\nOr are you going to do just a few territories (capitols.txt, convoy.txt, vc.txt, etc, most others) ? \r\n(If you choose the later option, you must Right Click on a territory to create an image for that territory.)", "Fill in all territories OR let you select them?", 0, 3, null, fillAllOptions, fillAllOptions[s_imagePointType.isFillAll() ? 0 : 1]) != 1);
        }
        s_cheapMutex = false;
        System.out.println("");
        this.repaint();
        JOptionPane.showMessageDialog(this, new JLabel(s_imagePointType.getInstructions()));
    }

    private void loadImageFolder() {
        FileSave imageFolder;
        System.out.println("Load an image folder (eg: 'misc' or 'territoryNames', etc)");
        File folder = new File(s_mapFolderLocation, s_imagePointType.getFolderName());
        if (folder == null || !folder.exists()) {
            folder = s_mapFolderLocation;
        }
        s_currentImageFolderLocation = (imageFolder = new FileSave("Load an Image Folder", null, folder)) == null || imageFolder.getPathString() == null || imageFolder.getFile() == null || !imageFolder.getFile().exists() ? null : imageFolder.getFile();
    }

    private void loadImagePointTextFile() {
        try {
            System.out.println("Load the points text file (eg: decorations.txt or pu_place.txt, etc)");
            FileOpen centerName = new FileOpen("Load an Image Points Text File", s_mapFolderLocation, new File(s_mapFolderLocation, s_imagePointType.getFileName()), ".txt");
            s_currentImagePointsTextFile = centerName.getFile();
            if (centerName != null && centerName.getFile() != null && centerName.getFile().exists() && centerName.getPathString() != null) {
                FileInputStream in = new FileInputStream(centerName.getPathString());
                this.m_currentPoints = PointFileReaderWriter.readOneToMany(in);
            } else {
                this.m_currentPoints = new HashMap<String, List<Point>>();
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (HeadlessException ex) {
            ex.printStackTrace();
        }
    }

    private void fillCurrentImagePointsBasedOnTextFile(boolean fillInAllTerritories) {
        int addY;
        s_staticImageForPlacing = null;
        File image = new File(s_mapFolderLocation + File.separator + s_imagePointType.getFolderName(), s_imagePointType.getImageName());
        if (image == null || !image.exists()) {
            image = new File(GameRunner2.getRootFolder() + File.separator + ResourceLoader.RESOURCE_FOLDER + File.separator + s_imagePointType.getFolderName(), s_imagePointType.getImageName());
        }
        if (image == null || !image.exists()) {
            image = null;
        }
        while (s_staticImageForPlacing == null) {
            FileOpen imageSelection = new FileOpen("Select Example Image To Use", image == null ? s_mapFolderLocation : new File(image.getParent()), image, ".gif", ".png");
            if (imageSelection == null || imageSelection.getFile() == null || !imageSelection.getFile().exists()) continue;
            s_staticImageForPlacing = this.createImage(imageSelection.getPathString());
        }
        int width = s_staticImageForPlacing.getWidth(null);
        int height = s_staticImageForPlacing.getHeight(null);
        int n = s_imagePointType == ImagePointType.comments ? -32 : (addY = s_imagePointType == ImagePointType.pu_place ? 32 : 0);
        if (fillInAllTerritories) {
            for (Map.Entry<String, Point> entry : this.m_centers.entrySet()) {
                List<Point> points = this.m_currentPoints.get(entry.getKey());
                if (points == null) {
                    System.out.println("Did NOT find point for: " + entry.getKey());
                    points = new ArrayList<Point>();
                    Point p = new Point(entry.getValue().x - width / 2, entry.getValue().y + addY + (s_showFromTopLeft ? -1 : 1) * (height / 2));
                    points.add(p);
                } else {
                    System.out.println("Found point for: " + entry.getKey());
                }
                this.m_currentImagePoints.put(entry.getKey(), new Tuple<Image, List<Point>>(s_staticImageForPlacing, points));
            }
        } else {
            for (Map.Entry<String, List<Point>> entry : this.m_currentPoints.entrySet()) {
                this.m_currentImagePoints.put(entry.getKey(), new Tuple<Image, List<Point>>(s_staticImageForPlacing, entry.getValue()));
            }
        }
        s_createNewImageOnRightClick = true;
    }

    private void fillCurrentImagePointsBasedOnImageFolder(boolean pointsAreExactlyTerritoryNames) {
        int addY = s_imagePointType == ImagePointType.comments ? -32 : (s_imagePointType == ImagePointType.pu_place ? 32 : 0);
        ArrayList<String> allTerritories = new ArrayList<String>(this.m_centers.keySet());
        for (File file : s_currentImageFolderLocation.listFiles()) {
            List<Point> points;
            if (!file.getPath().endsWith(".png") && !file.getPath().endsWith(".gif")) continue;
            String imageName = file.getName();
            String possibleTerritoryName = imageName.substring(0, imageName.length() - 4);
            Image image = this.createImage(file.getPath());
            List<Point> list = this.m_currentPoints != null ? this.m_currentPoints.get(pointsAreExactlyTerritoryNames ? possibleTerritoryName : imageName) : (points = null);
            if (points == null) {
                points = new ArrayList<Point>();
                Point p = this.m_centers.get(possibleTerritoryName);
                if (p == null) {
                    System.out.println("Did NOT find point for: " + possibleTerritoryName);
                    points.add(new Point(50, 50));
                } else {
                    p = new Point(p.x - image.getWidth(null) / 2, p.y + addY + (s_showFromTopLeft ? -1 : 1) * (image.getHeight(null) / 2));
                    points.add(p);
                    allTerritories.remove(possibleTerritoryName);
                    System.out.println("Found point for: " + possibleTerritoryName);
                }
            } else {
                allTerritories.remove(possibleTerritoryName);
            }
            this.m_currentImagePoints.put(pointsAreExactlyTerritoryNames ? possibleTerritoryName : imageName, new Tuple<Image, List<Point>>(image, points));
        }
        if (!allTerritories.isEmpty() && s_imagePointType == ImagePointType.name_place) {
            JOptionPane.showMessageDialog(this, new JLabel("Territory images not found in folder: " + allTerritories));
            System.out.println(allTerritories);
        }
    }

    private String findTerritoryName(Point p) {
        String seaName = null;
        for (String name : this.m_polygons.keySet()) {
            Collection polygons = this.m_polygons.get(name);
            for (Polygon poly : polygons) {
                if (!poly.contains(p)) continue;
                if (name.endsWith("Sea Zone") || name.startsWith("Sea Zone")) {
                    seaName = name;
                    continue;
                }
                return name;
            }
        }
        return seaName;
    }

    private void mouseEvent(Point point, boolean ctrlDown, boolean rightMouse) {
        if (s_cheapMutex) {
            return;
        }
        if (!rightMouse && !ctrlDown && this.m_currentSelectedImage == null) {
            Point testPoint = null;
            for (Map.Entry<String, Tuple<Image, List<Point>>> entry : this.m_currentImagePoints.entrySet()) {
                for (Point p : entry.getValue().getSecond()) {
                    if (testPoint != null && !(p.distance(this.m_currentMousePoint) < testPoint.distance(this.m_currentMousePoint))) continue;
                    testPoint = p;
                    this.m_currentSelectedImage = new Triple<String, Image, Point>(entry.getKey(), entry.getValue().getFirst(), p);
                }
            }
        } else if (!rightMouse && !ctrlDown && this.m_currentSelectedImage != null) {
            Tuple<Image, List<Point>> imagePoints = this.m_currentImagePoints.get(this.m_currentSelectedImage.getFirst());
            List<Point> points = imagePoints.getSecond();
            points.remove(this.m_currentSelectedImage.getThird());
            points.add(new Point(this.m_currentMousePoint));
            this.m_currentImagePoints.put(new String((String)this.m_currentSelectedImage.getFirst()), new Tuple(this.m_currentSelectedImage.getSecond(), points));
            this.m_currentSelectedImage = null;
        } else if (rightMouse && !ctrlDown && s_createNewImageOnRightClick && s_staticImageForPlacing != null && this.m_currentSelectedImage == null) {
            String territoryName = this.findTerritoryName(this.m_currentMousePoint);
            if (territoryName != null) {
                ArrayList<Point> points = new ArrayList<Point>();
                points.add(new Point(this.m_currentMousePoint));
                this.m_currentImagePoints.put(territoryName, new Tuple(s_staticImageForPlacing, points));
            }
        } else if (rightMouse && !ctrlDown && s_imagePointType.isCanHaveMultiplePoints()) {
            if (this.m_currentSelectedImage == null) {
                Point testPoint = null;
                for (Map.Entry<String, Tuple<Image, List<Point>>> entry : this.m_currentImagePoints.entrySet()) {
                    for (Point p : entry.getValue().getSecond()) {
                        if (testPoint != null && !(p.distance(this.m_currentMousePoint) < testPoint.distance(this.m_currentMousePoint))) continue;
                        testPoint = p;
                        this.m_currentSelectedImage = new Triple<String, Image, Object>(entry.getKey(), entry.getValue().getFirst(), null);
                    }
                }
            } else {
                this.m_currentSelectedImage = new Triple(this.m_currentSelectedImage.getFirst(), this.m_currentSelectedImage.getSecond(), null);
            }
            Tuple<Image, List<Point>> imagePoints = this.m_currentImagePoints.get(this.m_currentSelectedImage.getFirst());
            List<Point> points = imagePoints.getSecond();
            points.remove(this.m_currentSelectedImage.getThird());
            points.add(new Point(this.m_currentMousePoint));
            this.m_currentImagePoints.put(new String((String)this.m_currentSelectedImage.getFirst()), new Tuple(this.m_currentSelectedImage.getSecond(), points));
            this.m_currentSelectedImage = null;
        } else if (rightMouse && ctrlDown) {
            if (this.m_currentSelectedImage == null) {
                return;
            }
            Tuple<Image, List<Point>> current = this.m_currentImagePoints.get(this.m_currentSelectedImage.getFirst());
            List<Point> points = current.getSecond();
            points.remove(this.m_currentSelectedImage.getThird());
            if (points.isEmpty()) {
                this.m_currentImagePoints.remove(this.m_currentSelectedImage.getFirst());
            }
            this.m_currentSelectedImage = null;
        }
        this.repaint();
    }

    private static String getValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static void handleCommandLineArgs(String[] args) {
        File mapFolder;
        String value;
        if (args.length == 1) {
            value = args[0].startsWith(TRIPLEA_MAP_FOLDER) ? DecorationPlacer.getValue(args[0]) : args[0];
            mapFolder = new File(value);
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + value);
            }
        } else if (args.length > 1) {
            System.out.println("Only argument allowed is the map directory.");
        }
        if ((s_mapFolderLocation == null || s_mapFolderLocation.length() < 1L) && (value = System.getProperty(TRIPLEA_MAP_FOLDER)) != null && value.length() > 0) {
            mapFolder = new File(value = value.replaceAll("\\(", " "));
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + value);
            }
        }
    }
}

